/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.components.ContainedFormFactory;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.StateRequest;
import com.jeta.forms.store.properties.IconProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.open.registry.JETARegistry;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class TabProperty
extends JETAProperty {
    static final long serialVersionUID = 2375434406561274626L;
    public static final int VERSION = 1;
    private String m_title;
    private IconProperty m_icon_property;
    private transient FormComponent m_form;
    private FormMemento m_memento;
    public static final String PROPERTY_ID = "tab";

    public TabProperty() {
        super(PROPERTY_ID);
    }

    public TabProperty(String string) {
        super(PROPERTY_ID);
        this.m_title = string;
    }

    public FormComponent getForm() throws FormException {
        if (this.m_form == null) {
            ContainedFormFactory containedFormFactory = (ContainedFormFactory)JETARegistry.lookup("contained.form.factory");
            FormUtils.safeAssert(containedFormFactory != null);
            this.m_form = containedFormFactory.createContainedForm(JTabbedPane.class, this.m_memento);
        }
        return this.m_form;
    }

    public FormMemento getFormMemento() throws FormException {
        if (this.m_form != null) {
            return this.m_form.getExternalState(StateRequest.DEEP_COPY);
        }
        return this.m_memento;
    }

    public String getTitle() {
        return this.m_title;
    }

    public IconProperty getIconProperty() {
        return this.m_icon_property;
    }

    public Icon icon() {
        return this.m_icon_property;
    }

    public void setIconProperty(IconProperty iconProperty) {
        if (this.m_icon_property == null) {
            this.m_icon_property = new IconProperty();
        }
        this.m_icon_property.setValue(iconProperty);
    }

    public void setValue(Object object) {
        if (object instanceof TabProperty) {
            TabProperty tabProperty = (TabProperty)object;
            this.m_title = tabProperty.m_title;
            this.m_form = tabProperty.m_form;
            this.m_memento = tabProperty.m_memento;
            if (this.m_icon_property == null) {
                this.m_icon_property = new IconProperty();
            }
            this.m_icon_property.setValue(tabProperty.m_icon_property);
        }
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public void updateBean(JETABean jETABean) {
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_title = (String)jETAObjectInput.readObject("title");
        this.m_icon_property = (IconProperty)jETAObjectInput.readObject("icon");
        this.m_memento = (FormMemento)jETAObjectInput.readObject("form");
        this.m_form = null;
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(JETAProperty.class));
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeObject("title", this.m_title);
        jETAObjectOutput.writeObject("icon", this.m_icon_property);
        StateRequest stateRequest = StateRequest.SHALLOW_COPY;
        Object object = JETARegistry.lookup("state.request");
        if (object instanceof StateRequest) {
            stateRequest = (StateRequest)object;
        }
        try {
            this.getForm();
            if (this.m_form != null) {
                jETAObjectOutput.writeObject("form", this.m_form.getExternalState(stateRequest));
            } else {
                jETAObjectOutput.writeObject("form", null);
            }
        }
        catch (Exception exception) {
            FormsLogger.severe(exception);
            jETAObjectOutput.writeObject("form", null);
        }
    }
}

