// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package label

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *Label) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 9

	if t.CID == nil {
		fieldCount--
	}

	if t.ExpiresAt == nil {
		fieldCount--
	}

	if t.Negated == nil {
		fieldCount--
	}

	if t.Sig == nil {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.CID (string) (string)
	if t.CID != nil {

		if len("cid") > 1000000 {
			return xerrors.Errorf("Value in field \"cid\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cid"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("cid")); err != nil {
			return err
		}

		if t.CID == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.CID) > 1000000 {
				return xerrors.Errorf("Value in field t.CID was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.CID))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.CID)); err != nil {
				return err
			}
		}
	}

	// t.CreatedAt (string) (string)
	if len("cts") > 1000000 {
		return xerrors.Errorf("Value in field \"cts\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cts"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("cts")); err != nil {
		return err
	}

	if len(t.CreatedAt) > 1000000 {
		return xerrors.Errorf("Value in field t.CreatedAt was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CreatedAt))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CreatedAt)); err != nil {
		return err
	}

	// t.ExpiresAt (string) (string)
	if t.ExpiresAt != nil {

		if len("exp") > 1000000 {
			return xerrors.Errorf("Value in field \"exp\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("exp"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("exp")); err != nil {
			return err
		}

		if t.ExpiresAt == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.ExpiresAt) > 1000000 {
				return xerrors.Errorf("Value in field t.ExpiresAt was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.ExpiresAt))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.ExpiresAt)); err != nil {
				return err
			}
		}
	}

	// t.Negated (bool) (bool)
	if t.Negated != nil {

		if len("neg") > 1000000 {
			return xerrors.Errorf("Value in field \"neg\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("neg"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("neg")); err != nil {
			return err
		}

		if t.Negated == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if err := cbg.WriteBool(w, *t.Negated); err != nil {
				return err
			}
		}
	}

	// t.Sig (data.Bytes) (slice)
	if t.Sig != nil {

		if len("sig") > 1000000 {
			return xerrors.Errorf("Value in field \"sig\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("sig"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("sig")); err != nil {
			return err
		}

		if len(t.Sig) > 2097152 {
			return xerrors.Errorf("Byte array in field t.Sig was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Sig))); err != nil {
			return err
		}

		if _, err := cw.Write(t.Sig); err != nil {
			return err
		}

	}

	// t.SourceDID (string) (string)
	if len("src") > 1000000 {
		return xerrors.Errorf("Value in field \"src\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("src"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("src")); err != nil {
		return err
	}

	if len(t.SourceDID) > 1000000 {
		return xerrors.Errorf("Value in field t.SourceDID was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.SourceDID))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.SourceDID)); err != nil {
		return err
	}

	// t.URI (string) (string)
	if len("uri") > 1000000 {
		return xerrors.Errorf("Value in field \"uri\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("uri"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("uri")); err != nil {
		return err
	}

	if len(t.URI) > 1000000 {
		return xerrors.Errorf("Value in field t.URI was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.URI))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.URI)); err != nil {
		return err
	}

	// t.Val (string) (string)
	if len("val") > 1000000 {
		return xerrors.Errorf("Value in field \"val\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("val"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("val")); err != nil {
		return err
	}

	if len(t.Val) > 1000000 {
		return xerrors.Errorf("Value in field t.Val was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Val))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Val)); err != nil {
		return err
	}

	// t.Version (int64) (int64)
	if len("ver") > 1000000 {
		return xerrors.Errorf("Value in field \"ver\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ver"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("ver")); err != nil {
		return err
	}

	if t.Version >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Version)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Version-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *Label) UnmarshalCBOR(r io.Reader) (err error) {
	*t = Label{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("Label: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 3)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.CID (string) (string)
		case "cid":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.CID = (*string)(&sval)
				}
			}
			// t.CreatedAt (string) (string)
		case "cts":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.CreatedAt = string(sval)
			}
			// t.ExpiresAt (string) (string)
		case "exp":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 1000000)
					if err != nil {
						return err
					}

					t.ExpiresAt = (*string)(&sval)
				}
			}
			// t.Negated (bool) (bool)
		case "neg":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}
					if maj != cbg.MajOther {
						return fmt.Errorf("booleans must be major type 7")
					}

					var val bool
					switch extra {
					case 20:
						val = false
					case 21:
						val = true
					default:
						return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
					}
					t.Negated = &val
				}
			}
			// t.Sig (data.Bytes) (slice)
		case "sig":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.Sig: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.Sig = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.Sig); err != nil {
				return err
			}

			// t.SourceDID (string) (string)
		case "src":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.SourceDID = string(sval)
			}
			// t.URI (string) (string)
		case "uri":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.URI = string(sval)
			}
			// t.Val (string) (string)
		case "val":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Val = string(sval)
			}
			// t.Version (int64) (int64)
		case "ver":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Version = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
