/* Create source for inclusion into icont for OS/2 header
*/
#include "..\\h\\gsupport.h"
#include <stdlib.h>

typedef unsigned char uchar;
typedef unsigned long ulong;

#define RDBUFSIZE    32768
#define PutByt(fp, byt) { \
                          if (nBytWritten++ % 16 == 0) \
                            fputs("\n", (fp)); \
                          fprintf((fp), "0x%.2x,", (byt)); \
                        }

static uchar buffer[RDBUFSIZE];
int nBytWritten;


int main(int argc, char *argv[])
{
   char infile[256] = "header.exe",
        outfile[256] = "hdr.h";
   FILE *ifp, *ofp;
   int numread, i;
   ulong totread = 0;
   uchar *ptr;

   if (argc > 3) {
     fputs("usage: os2newhdr [header.exe] [newhdr.h]\n", stderr); 
     exit(1);
     } /* End of if - too many args */
   argv++; argc--;
   if (argc > 0)
      strcpy(infile, *argv);
   argv++; argc--;
   if (argc > 0)
      strcpy(outfile, *argv);
   if (!(ifp = fopen(infile, "rb"))) {
      fputs("os2newhdr: cannot open input file.\n", stderr);
      exit(1);
      } /* End of if - cannot open the input file */
   if (!(ofp = fopen(outfile, "w"))) {
      fputs("os2newhdr: cannot open output file.\n", stderr);
      fclose(ifp);
      exit(1);
      } /* End of if - cannot open the output file */
   fputs("static unsigned char iconxhdr[MaxHdr+1] = {", ofp);
   nBytWritten = 0;
   while ((numread = fread(buffer, 1, RDBUFSIZE, ifp)) > 0) {
      totread += numread;
      for (ptr = buffer, i = 0; i < numread; i++, ptr++) 
         PutByt(ofp, *ptr);
      } /* End of while - still reading */

   /* pad the rest out */
   while (totread < MaxHdr) { PutByt(ofp, 0); totread++; }
   /* the last one */
   fputs(" 0x00};\n", ofp);
   /* check to make sure we didn't make an array too large */
   if (totread > MaxHdr)
      fprintf(stderr,
              "os2newhdr: Warning - MaxHdr is only %d, but file size is %d\n",
              MaxHdr, totread);
   /* close the input and output files */
   fclose(ifp); fclose(ofp);
} /* End of main */

