/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.FileChannelUtil;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    private static final Logger LOG = Logger.getInstance(ReadWriteDirectBufferWrapper.class);
    private final boolean myReadOnly;

    ReadWriteDirectBufferWrapper(Path file2, long offset2, long length, boolean readOnly) {
        super(file2, offset2, length);
        assert (length <= Integer.MAX_VALUE) : length;
        this.myReadOnly = readOnly;
    }

    @Override
    protected ByteBuffer create() throws IOException {
        try (FileContext context2 = new FileContext(this.myFile, this.myReadOnly);){
            FileChannel channel = context2.myFile;
            assert (channel != null);
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
            channel.read(buffer, this.myPosition);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    FileContext flushWithContext(@Nullable FileContext fileContext) {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try {
                if (fileContext == null) {
                    fileContext = new FileContext(this.myFile, this.myReadOnly);
                }
                this.doFlush(fileContext, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        return fileContext;
    }

    private void doFlush(FileContext fileContext, ByteBuffer buffer) throws IOException {
        FileChannel channel = fileContext.myFile;
        assert (channel != null);
        buffer.rewind();
        channel.write(buffer, this.myPosition);
        this.myDirty = false;
    }

    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try (FileContext context2 = new FileContext(this.myFile, this.myReadOnly);){
                this.doFlush(context2, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    static class FileContext
    implements AutoCloseable {
        private final FileChannel myFile;
        private final boolean myReadOnly;

        FileContext(final Path path2, boolean readOnly) throws IOException {
            this.myReadOnly = readOnly;
            this.myFile = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<FileChannel, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public FileChannel execute(boolean finalAttempt) throws IOException {
                    try {
                        EnumSet<StandardOpenOption> options = myReadOnly ? EnumSet.of(StandardOpenOption.READ) : EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                        return FileChannelUtil.unInterruptible(FileChannel.open(path2, options, new FileAttribute[0]));
                    }
                    catch (NoSuchFileException ex) {
                        Path parentFile = path2.getParent();
                        if (!Files.exists(parentFile, new LinkOption[0])) {
                            if (!this.parentWasCreated) {
                                FileUtil.createDirectory(parentFile.toFile());
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent directory still doesn't exist: " + path2);
                            }
                        }
                        if (!finalAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
        }

        @Override
        public void close() {
            IOUtil.closeSafe(LOG, this.myFile);
        }
    }
}

