/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"excludeDeclarationsFromCodegen", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.wasm"})
public final class ExcludeDeclarationsFromCodegenKt {
    public static final void excludeDeclarationsFromCodegen(@NotNull WasmBackendContext context2, @NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(module2, "module");
        for (IrFile file2 : module2.getFiles()) {
            Iterator<IrDeclaration> it = file2.getDeclarations().iterator();
            while (it.hasNext()) {
                IrDeclarationWithName d;
                IrDeclaration irDeclaration2 = it.next();
                IrDeclarationWithName irDeclarationWithName = irDeclaration2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)irDeclaration2 : null;
                if (irDeclarationWithName == null || !ExcludeDeclarationsFromCodegenKt.excludeDeclarationsFromCodegen$isExcluded(d = irDeclarationWithName)) continue;
                it.remove();
                IrUtilsKt.addChild(context2.getExcludedPackageFragment(file2.getFqName()), d);
            }
        }
    }

    private static final boolean excludeDeclarationsFromCodegen$isExcluded(IrDeclaration declaration2) {
        IrFile parentFile;
        if (AnnotationsKt.hasExcludedFromCodegenAnnotation(declaration2)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        IrFile irFile = parentFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        return irFile != null ? AnnotationsKt.hasExcludedFromCodegenAnnotation(irFile) : false;
    }
}

