/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmAnnotationHelperKt;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.FirJvmHelperKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.java.JvmDefaultModeContainerKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirInterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findContainingMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkers.jvm"})
public final class FirInterfaceDefaultMethodCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirInterfaceDefaultMethodCallChecker INSTANCE = new FirInterfaceDefaultMethodCallChecker();

    private FirInterfaceDefaultMethodCallChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirElement firElement;
        boolean $i$f$isInterface;
        FirRegularClassSymbol typeSymbol;
        boolean supportsDefaults;
        FirCallableSymbol<?> classId;
        FirCallableSymbol<?> symbol2;
        block18: {
            Object $this$isInterface$iv;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            symbol2 = FirExpressionUtilKt.toResolvedCallableSymbol(expression2.getCalleeReference());
            FirCallableSymbol<?> firCallableSymbol = symbol2;
            if (firCallableSymbol == null || (firCallableSymbol = firCallableSymbol.getCallableId()) == null || (firCallableSymbol = ((CallableId)((Object)firCallableSymbol)).getClassId()) == null) {
                return;
            }
            classId = firCallableSymbol;
            if (((ClassId)((Object)classId)).isLocal()) {
                return;
            }
            supportsDefaults = !FirJvmHelperKt.isJvm6(context2);
            typeSymbol = null;
            if (!supportsDefaults && FirCallableSymbolKt.isStatic(symbol2)) {
                FirRegularClassSymbol firRegularClassSymbol = FirInterfaceDefaultMethodCallChecker.check$getTypeSymbol(context2, (ClassId)((Object)classId));
                if (firRegularClassSymbol == null) {
                    return;
                }
                typeSymbol = firRegularClassSymbol;
                $this$isInterface$iv = typeSymbol;
                boolean $i$f$isInterface2 = false;
                ClassKind $this$isInterface$iv$iv = ((FirClassSymbol)$this$isInterface$iv).getClassKind();
                $i$f$isInterface = false;
                boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                if (bl && Intrinsics.areEqual(typeSymbol.getOrigin(), FirDeclarationOrigin.Java.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getINTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            FirExpression $this$safeAs$iv = expression2.getExplicitReceiver();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv;
            if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
                firExpression2 = null;
            }
            FirReference $this$safeAs$iv2 = ($this$isInterface$iv = (FirQualifiedAccessExpression)firExpression2) != null ? ((FirQualifiedAccessExpression)$this$isInterface$iv).getCalleeReference() : null;
            boolean $i$f$safeAs2 = false;
            FirReference firReference = $this$safeAs$iv2;
            if (!(firReference instanceof FirSuperReference)) {
                firReference = null;
            }
            if ((FirSuperReference)firReference == null) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirRegularClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirRegularClass)firDeclaration)) == null) continue;
                FirElement it = firElement2 = firElement;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block18;
            }
            firElement = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firElement;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass containingDeclaration = firRegularClass;
        if (typeSymbol == null) {
            FirRegularClassSymbol firRegularClassSymbol = FirInterfaceDefaultMethodCallChecker.check$getTypeSymbol(context2, (ClassId)((Object)classId));
            if (firRegularClassSymbol == null) {
                return;
            }
            typeSymbol = firRegularClassSymbol;
        }
        JvmDefaultMode jvmDefaultMode2 = JvmDefaultModeContainerKt.getJvmDefaultModeState(context2.getSession());
        Object $this$isInterface$iv = typeSymbol;
        $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = ((FirClassSymbol)$this$isInterface$iv).getClassKind();
        boolean $i$f$isInterface3 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl && (Intrinsics.areEqual(typeSymbol.getOrigin(), FirDeclarationOrigin.Java.INSTANCE) || FirJvmAnnotationHelperKt.isCompiledToJvmDefault((FirBasedSymbol)symbol2, jvmDefaultMode2))) {
            $this$isInterface$iv = containingDeclaration;
            $i$f$isInterface = false;
            $this$isInterface$iv$iv = ((FirClass)$this$isInterface$iv).getClassKind();
            $i$f$isInterface3 = false;
            boolean bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl2) {
                FirCallableSymbol<? extends FirCallableDeclaration> containingMember;
                FirCallableDeclaration firCallableDeclaration = this.findContainingMember(context2);
                FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol = containingMember = firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null;
                boolean bl3 = firCallableSymbol != null ? !FirJvmAnnotationHelperKt.isCompiledToJvmDefault((FirBasedSymbol)firCallableSymbol, jvmDefaultMode2) : false;
                if (bl3) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getINTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
            }
            if (!supportsDefaults) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getDEFAULT_METHOD_CALL_FROM_JAVA6_TARGET(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final FirCallableDeclaration findContainingMember(CheckerContext $this$findContainingMember) {
        FirElement firElement;
        block3: {
            CheckerContext $this$findClosest$iv = $this$findContainingMember;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirCallableDeclaration)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirCallableDeclaration)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirCallableDeclaration it = (FirCallableDeclaration)firElement2;
                boolean bl = false;
                firElement = it instanceof FirSimpleFunction && !Intrinsics.areEqual(((FirSimpleFunction)it).getSymbol().getCallableId().getClassId(), FirClassLikeSymbolKt.getANONYMOUS_CLASS_ID()) || it instanceof FirProperty ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block3;
            }
            firElement = null;
        }
        return (FirCallableDeclaration)firElement;
    }

    private static final FirRegularClassSymbol check$getTypeSymbol(CheckerContext $context, ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($context.getSession()).getClassLikeSymbolByClassId(classId);
        return firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
    }
}

