-file("/Users/rv/.asdf/installs/erlang/27.1/lib/parsetools-2.6/include/leexinc.hrl", 0).
%% The source of this file is part of leex distribution, as such it
%% has the same Copyright as the other files in the leex
%% distribution. The Copyright is defined in the accompanying file
%% COPYRIGHT. However, the resultant scanner generated by leex is the
%% property of the creator of the scanner and is not covered by that
%% Copyright.

-module(luerl_scan).

-export([string/1,string/2,token/2,token/3,tokens/2,tokens/3]).
-export([format_error/1]).

%% User code. This is placed here to allow extra attributes.
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 139).

-export([is_keyword/1]).
-export([string_chars/1,chars/1]).

%% name_token(Chars, Line) ->
%%     {token,{'NAME',Line,Symbol}} | {Name,Line} | {error,E}.
%%  Build a name from list of legal characters, else error.

name_token(Cs, L) ->
    case catch {ok,list_to_binary(Cs)} of
	{ok,Name} ->
	    case is_keyword(Name) of
		true -> {token,{name_string(Name),L}};
		false -> {token,{'NAME',L,Name}}
	    end;
	_ -> {error,"illegal name"}
    end.

name_string(Name) ->
    binary_to_atom(Name, latin1).		%Only latin1 in Lua

%% hex_float_token(TokenChars, TokenLine) ->
%%     {token,{'NUMERAL',TokenLine,Float}} | {error,E}.
%%  Build a float form a hex float string.

hex_float_token(TokenChars, TokenLine) ->
    Tcs = string:substr(TokenChars, 3),
    case lists:splitwith(fun (C) -> (C =/= $p) and (C =/= $P) end, Tcs) of
	{Mcs,[]} when Mcs /= [] ->
	    hex_float(Mcs, [], TokenLine);
	{Mcs,[_P|Ecs]} when Ecs /= [] ->
	    hex_float(Mcs, Ecs, TokenLine);
	_Other -> {error,"malformed number"}
    end.

%% hex_float(Mantissa, Exponent) -> {token,{'NUMERAL',Line,Float}} | {error,E}.
%% hex_mantissa(Chars) -> {float,Float} | error.
%% hex_fraction(Chars, Pow, SoFar) -> Fraction.

hex_float(Mcs, [], Line) ->
    case hex_mantissa(Mcs) of
	{float,M} -> {token,{'NUMERAL',Line,M}};
	error -> {error,"malformed number"}
    end;
hex_float(Mcs, Ecs, Line) ->
    case hex_mantissa(Mcs) of
	{float,M} ->
	    case catch list_to_integer(Ecs, 10) of
		{'EXIT',_} -> {error,"malformed number"};
		E -> {token,{'NUMERAL',Line,M * math:pow(2, E)}}
	    end;
	error -> {error,"malformed number"}
    end.

hex_mantissa(Mcs) ->
    case lists:splitwith(fun (C) -> C =/= $. end, Mcs) of
	{[],[]} -> error;			%Nothing at all
	{[],[$.]} -> error;			%Only a '.'
	{[],[$.|Fcs]} -> {float,hex_fraction(Fcs, 16.0, 0.0)};
	{Hcs,[]} -> {float,float(list_to_integer(Hcs, 16))};
	{Hcs,[$.|Fcs]} ->
	    H = float(list_to_integer(Hcs, 16)),
	    {float,hex_fraction(Fcs, 16.0, H)}
    end.

hex_fraction([C|Cs], Pow, SoFar) when C >= $0, C =< $9 ->
    hex_fraction(Cs, Pow*16, SoFar + (C - $0)/Pow);
hex_fraction([C|Cs], Pow, SoFar) when C >= $a, C =< $f ->
    hex_fraction(Cs, Pow*16, SoFar + (C - $a + 10)/Pow);
hex_fraction([C|Cs], Pow, SoFar) when C >= $A, C =< $F ->
    hex_fraction(Cs, Pow*16, SoFar + (C - $A + 10)/Pow);
hex_fraction([], _Pow, SoFar) -> SoFar.

%% string_token(InputChars, Length, Line) ->
%%     {token,{'LITERALSTRING',Line,Cs}} | {error,Error}.
%%  Convert an input string into the corresponding string characters.
%%  We know that the input string is correct.

string_token(Cs0, Len, L) ->
    Cs1 = string:substr(Cs0, 2, Len - 2),       %Strip quotes
    try
        Bytes = string_chars(Cs1),
        String = unicode:characters_to_binary(Bytes, utf8, utf8),
        %% String = iolist_to_binary(Bytes),
        {token,{'LITERALSTRING',L,String}}
    catch
        _:_ ->
            {error,"illegal string"}
    end.

%% string_chars(Chars)
%% chars(Chars)
%%  Return a list of UTF-8 encoded binaries and one byte unencoded
%%  characters. chars/1 is for external backwards compatibilty.

chars(Cs) ->
    string_chars(Cs).

string_chars(Cs) ->
    string_chars(Cs, []).

string_chars([$\\ | Cs], []) ->                 %Nothing here to worry about
    bq_chars(Cs);
string_chars([$\\ | Cs], Acc) ->
    [lists:reverse(Acc) | bq_chars(Cs)];
string_chars([$\n | _], _Acc) -> throw(string_error);
string_chars([C | Cs], Acc) -> string_chars(Cs, [C|Acc]);
string_chars([], []) -> [];
string_chars([], Acc) ->
    [lists:reverse(Acc)].

%% long_string_token(InputChars, Length, BracketLength, Line) ->
%%     {token,{'LITERALSTRING',Line,Cs}} | {error,Error}.

long_string_token(Cs0, Len, BrLen, Line) ->
    %% Strip the brackets and remove first char if a newline.
    %% Note we export Cs1 here, :-)
    case string:substr(Cs0, BrLen+1, Len - 2*BrLen) of
	[$\n | Cs1] -> Cs1;
	Cs1 -> Cs1
    end,
    try
	String = unicode:characters_to_binary(Cs1, utf8, utf8),
	{token,{'LITERALSTRING',Line,String}}
    catch
	_:_ ->
	    {error,"illegal string"}
    end.

%% bq_chars(Chars)
%%  Handle the backquotes characters. These always fit directly into
%%  one byte and are never UTF-8 encoded.

bq_chars([C1|Cs0]) when C1 >= $0, C1 =< $9 ->   %1-3 decimal digits
    I1 = C1 - $0,
    case Cs0 of
        [C2|Cs1] when C2 >= $0, C2 =< $9 ->
            I2 = C2 - $0,
            case Cs1 of
                [C3|Cs2] when C3 >= $0, C3 =< $9 ->
                    I3 = C3 - $0,
                    Byte = 100*I1 + 10*I2 + I3,
                    %% Must fit into one byte!
                    (Byte =< 255) orelse throw(string_error),
                    [Byte | string_chars(Cs2, [])];
                _ ->
                    Byte = 10*I1 + I2,
                    [Byte | string_chars(Cs1, [])]
            end;
        _ -> [I1 | string_chars(Cs0, [])]
    end;
bq_chars([$x,C1,C2|Cs]) ->                      %2 hex digits
    case hex_char(C1) and hex_char(C2) of
        true ->
            Byte = hex_val(C1)*16 + hex_val(C2),
            [Byte | string_chars(Cs, [])];
        false -> throw(string_error)
    end;
bq_chars([$z|Cs]) ->                            %Skip blanks
    string_chars(skip_space(Cs), []);
bq_chars([C|Cs]) -> [escape_char(C)|string_chars(Cs, [])];
bq_chars([]) ->
    [].

skip_space([C|Cs]) when C >= 0, C =< $\s -> skip_space(Cs);
skip_space(Cs) -> Cs.

hex_char(C) when C >= $0, C =< $9 -> true;
hex_char(C) when C >= $a, C =< $f -> true;
hex_char(C) when C >= $A, C =< $F -> true;
hex_char(_) -> false.

hex_val(C) when C >= $0, C =< $9 -> C - $0;
hex_val(C) when C >= $a, C =< $f -> C - $a + 10;
hex_val(C) when C >= $A, C =< $F -> C - $A + 10.

escape_char($n) -> $\n;				%\n = LF
escape_char($r) -> $\r;				%\r = CR
escape_char($t) -> $\t;				%\t = TAB
escape_char($v) -> $\v;				%\v = VT
escape_char($b) -> $\b;				%\b = BS
escape_char($f) -> $\f;				%\f = FF
escape_char($e) -> $\e;				%\e = ESC
escape_char($s) -> $\s;				%\s = SPC
escape_char($d) -> $\d;				%\d = DEL
escape_char(C) -> C.

%% is_keyword(Name) -> boolean().
%%  Test if the name is a keyword.

is_keyword(<<"and">>) -> true;
is_keyword(<<"break">>) -> true;
is_keyword(<<"do">>) -> true;
is_keyword(<<"else">>) -> true;
is_keyword(<<"elseif">>) -> true;
is_keyword(<<"end">>) -> true;
is_keyword(<<"false">>) -> true;
is_keyword(<<"for">>) -> true;
is_keyword(<<"function">>) -> true;
is_keyword(<<"goto">>) -> true;
is_keyword(<<"if">>) -> true;
is_keyword(<<"in">>) -> true;
is_keyword(<<"local">>) -> true;
is_keyword(<<"nil">>) -> true;
is_keyword(<<"not">>) -> true;
is_keyword(<<"or">>) -> true;
is_keyword(<<"repeat">>) -> true;
is_keyword(<<"return">>) -> true;
is_keyword(<<"then">>) -> true;
is_keyword(<<"true">>) -> true;
is_keyword(<<"until">>) -> true;
is_keyword(<<"while">>) -> true;
is_keyword(_) -> false.

-file("/Users/rv/.asdf/installs/erlang/27.1/lib/parsetools-2.6/include/leexinc.hrl", 14).

format_error({illegal,S}) -> ["illegal characters ",io_lib:write_string(S)];
format_error({user,S}) -> S.

%% string(InChars) ->
%% string(InChars, Loc) ->
%% {ok,Tokens,EndLoc} | {error,ErrorInfo,EndLoc}.
%% Loc is the starting location of the token, while EndLoc is the first not scanned
%% location. Location is either Line or {Line,Column}, depending on the "error_location" option.

string(Ics) -> 
    string(Ics,1).
string(Ics,L0) -> 
    string(Ics, L0, 1, Ics, []).
string(Ics, L0, C0, Tcs, Ts) -> 
    case do_string(Ics, L0, C0, Tcs, Ts) of
        {ok, T, {L,_}} -> {ok, T, L};
        {error, {{EL,_},M,D}, {L,_}} ->
            EI = {EL,M,D},
            {error, EI, L}
    end.

do_string([], L, C, [], Ts) ->                     % No partial tokens!
    {ok,yyrev(Ts),{L,C}};
do_string(Ics0, L0, C0, Tcs, Ts) ->
    case yystate(yystate(), Ics0, L0, C0, 0, reject, 0) of
        {A,Alen,Ics1,L1,_C1} ->                  % Accepting end state
            C2 = adjust_col(Tcs, Alen, C0),
            string_cont(Ics1, L1, C2, yyaction(A, Alen, Tcs, L0, C0), Ts);
        {A,Alen,Ics1,L1,_C1,_S1} ->              % Accepting transition state
            C2 = adjust_col(Tcs, Alen, C0),
            string_cont(Ics1, L1, C2, yyaction(A, Alen, Tcs, L0, C0), Ts);
        {reject,_Alen,Tlen,_Ics1,_L1,_C1,_S1} ->  % After a non-accepting state
            {error,{{L0, C0} ,?MODULE,{illegal,yypre(Tcs, Tlen+1)}},{L0, C0}};
        {A,Alen,Tlen,_Ics1,L1, C1,_S1}->
            Tcs1 = yysuf(Tcs, Alen),
            L2 = adjust_line(Tlen, Alen, Tcs1, L1),
            C2 = adjust_col(Tcs, Alen, C1),
            string_cont(Tcs1, L2, C2, yyaction(A, Alen, Tcs, L0,C0), Ts)
    end.

%% string_cont(RestChars, Line, Col, Token, Tokens)
%% Test for and remove the end token wrapper. Push back characters
%% are prepended to RestChars.

-dialyzer({nowarn_function, string_cont/5}).

string_cont(Rest, Line, Col, {token,T}, Ts) ->
    do_string(Rest, Line, Col, Rest, [T|Ts]);
string_cont(Rest, Line, Col, {token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    do_string(NewRest, Line, Col, NewRest, [T|Ts]);
string_cont(Rest, Line, Col, {end_token,T}, Ts) ->
    do_string(Rest, Line, Col, Rest, [T|Ts]);
string_cont(Rest, Line, Col, {end_token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    do_string(NewRest, Line, Col, NewRest, [T|Ts]);
string_cont(Rest, Line, Col, skip_token, Ts) ->
    do_string(Rest, Line, Col, Rest, Ts);
string_cont(Rest, Line, Col, {skip_token,Push}, Ts) ->
    NewRest = Push ++ Rest,
    do_string(NewRest, Line, Col, NewRest, Ts);
string_cont(_Rest, Line, Col, {error,S}, _Ts) ->
    {error,{{Line, Col},?MODULE,{user,S}},{Line,Col}}.

%% token(Continuation, Chars) ->
%% token(Continuation, Chars, Loc) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% Must be careful when re-entering to append the latest characters to the
%% after characters in an accept. The continuation is:
%% {token,State,CurrLine,CurrCol,TokenChars,TokenLen,TokenLine,TokenCol,AccAction,AccLen}

token(Cont,Chars) -> 
    token(Cont,Chars,1).
token(Cont, Chars, Line) -> 
    case do_token(Cont,Chars,Line,1) of
        {more, _} = C -> C;
        {done, Ret0, R} ->
            Ret1 = case Ret0 of
                {ok, T, {L,_}} -> {ok, T, L};
                {eof, {L,_}} -> {eof, L};
                {error, {{EL,_},M,D},{L,_}} -> {error, {EL,M,D},L}
            end,
            {done, Ret1, R}
    end.

do_token([], Chars, Line, Col) ->
    token(yystate(), Chars, Line, Col, Chars, 0, Line, Col, reject, 0);
do_token({token,State,Line,Col,Tcs,Tlen,Tline,Tcol,Action,Alen}, Chars, _, _) ->
    token(State, Chars, Line, Col, Tcs ++ Chars, Tlen, Tline, Tcol, Action, Alen).

%% token(State, InChars, Line, Col, TokenChars, TokenLen, TokenLine, TokenCol
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% The argument order is chosen to be more efficient.

token(S0, Ics0, L0, C0, Tcs, Tlen0, Tline, Tcol, A0, Alen0) ->
    case yystate(S0, Ics0, L0, C0, Tlen0, A0, Alen0) of
        %% Accepting end state, we have a token.
        {A1,Alen1,Ics1,L1,C1} ->
            C2 = adjust_col(Tcs, Alen1, C1),
            token_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline,Tcol));
        %% Accepting transition state, can take more chars.
        {A1,Alen1,[],L1,C1,S1} ->                  % Need more chars to check
            {more,{token,S1,L1,C1,Tcs,Alen1,Tline,Tcol,A1,Alen1}};
        {A1,Alen1,Ics1,L1,C1,_S1} ->               % Take what we got
            C2 = adjust_col(Tcs, Alen1, C1),
            token_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline,Tcol));
        %% After a non-accepting state, maybe reach accept state later.
        {A1,Alen1,Tlen1,[],L1,C1,S1} ->            % Need more chars to check
            {more,{token,S1,L1,C1,Tcs,Tlen1,Tline,Tcol,A1,Alen1}};
        {reject,_Alen1,Tlen1,eof,L1,C1,_S1} ->     % No token match
            %% Check for partial token which is error.
            Ret = if Tlen1 > 0 -> {error,{{Tline,Tcol},?MODULE,
                                          %% Skip eof tail in Tcs.
                                          {illegal,yypre(Tcs, Tlen1)}},{L1,C1}};
                     true -> {eof,{L1,C1}}
                  end,
            {done,Ret,eof};
        {reject,_Alen1,Tlen1,Ics1,_L1,_C1,_S1} ->    % No token match
            Error = {{Tline,Tcol},?MODULE,{illegal,yypre(Tcs, Tlen1+1)}},
            {done,{error,Error,{Tline,Tcol}},Ics1};
        {A1,Alen1,Tlen1,_Ics1,L1,_C1,_S1} ->       % Use last accept match
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            C2 = C0 + Alen1,
            token_cont(Tcs1, L2, C2, yyaction(A1, Alen1, Tcs, Tline, Tcol))
    end.

%% token_cont(RestChars, Line, Col, Token)
%% If we have a token or error then return done, else if we have a
%% skip_token then continue.

-dialyzer({nowarn_function, token_cont/4}).

token_cont(Rest, Line, Col, {token,T}) ->
    {done,{ok,T,{Line,Col}},Rest};
token_cont(Rest, Line, Col, {token,T,Push}) ->
    NewRest = Push ++ Rest,
    {done,{ok,T,{Line,Col}},NewRest};
token_cont(Rest, Line, Col, {end_token,T}) ->
    {done,{ok,T,{Line,Col}},Rest};
token_cont(Rest, Line, Col, {end_token,T,Push}) ->
    NewRest = Push ++ Rest,
    {done,{ok,T,{Line,Col}},NewRest};
token_cont(Rest, Line, Col, skip_token) ->
    token(yystate(), Rest, Line, Col, Rest, 0, Line, Col, reject, 0);
token_cont(Rest, Line, Col, {skip_token,Push}) ->
    NewRest = Push ++ Rest,
    token(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, reject, 0);
token_cont(Rest, Line, Col, {error,S}) ->
    {done,{error,{{Line, Col},?MODULE,{user,S}},{Line, Col}},Rest}.

%% tokens(Continuation, Chars) ->
%% tokens(Continuation, Chars, Loc) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% Must be careful when re-entering to append the latest characters to the
%% after characters in an accept. The continuation is:
%% {tokens,State,CurrLine,CurrCol,TokenChars,TokenLen,TokenLine,TokenCur,Tokens,AccAction,AccLen}
%% {skip_tokens,State,CurrLine,CurrCol,TokenChars,TokenLen,TokenLine,TokenCur,Error,AccAction,AccLen}

tokens(Cont,Chars) -> 
    tokens(Cont,Chars,1).
tokens(Cont, Chars, Line) -> 
    case do_tokens(Cont,Chars,Line,1) of
        {more, _} = C -> C;
        {done, Ret0, R} ->
            Ret1 = case Ret0 of
                {ok, T, {L,_}} -> {ok, T, L};
                {eof, {L,_}} -> {eof, L};
                {error, {{EL,_},M,D},{L,_}} -> {error, {EL,M,D},L}
            end,
            {done, Ret1, R}
    end.

do_tokens([], Chars, Line, Col) ->
    tokens(yystate(), Chars, Line, Col, Chars, 0, Line, Col, [], reject, 0);
do_tokens({tokens,State,Line,Col,Tcs,Tlen,Tline,Tcol,Ts,Action,Alen}, Chars, _,_) ->
    tokens(State, Chars, Line, Col, Tcs ++ Chars, Tlen, Tline, Tcol, Ts, Action, Alen);
do_tokens({skip_tokens,State,Line, Col, Tcs,Tlen,Tline,Tcol,Error,Action,Alen}, Chars, _,_) ->
    skip_tokens(State, Chars, Line, Col, Tcs ++ Chars, Tlen, Tline, Tcol, Error, Action, Alen).

%% tokens(State, InChars, Line, Col, TokenChars, TokenLen, TokenLine, TokenCol,Tokens,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.

tokens(S0, Ics0, L0, C0, Tcs, Tlen0, Tline, Tcol, Ts, A0, Alen0) ->
    case yystate(S0, Ics0, L0, C0, Tlen0, A0, Alen0) of
        %% Accepting end state, we have a token.
        {A1,Alen1,Ics1,L1,C1} ->
            C2 = adjust_col(Tcs, Alen1, C1),
            tokens_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline, Tcol), Ts);
        %% Accepting transition state, can take more chars.
        {A1,Alen1,[],L1,C1,S1} ->                  % Need more chars to check
            {more,{tokens,S1,L1,C1,Tcs,Alen1,Tline,Tcol,Ts,A1,Alen1}};
        {A1,Alen1,Ics1,L1,C1,_S1} ->               % Take what we got
            C2 = adjust_col(Tcs, Alen1, C1),
            tokens_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline,Tcol), Ts);
        %% After a non-accepting state, maybe reach accept state later.
        {A1,Alen1,Tlen1,[],L1,C1,S1} ->            % Need more chars to check
            {more,{tokens,S1,L1,C1,Tcs,Tlen1,Tline,Tcol,Ts,A1,Alen1}};
        {reject,_Alen1,Tlen1,eof,L1,C1,_S1} ->     % No token match
            %% Check for partial token which is error, no need to skip here.
            Ret = if Tlen1 > 0 -> {error,{{Tline,Tcol},?MODULE,
                                          %% Skip eof tail in Tcs.
                                          {illegal,yypre(Tcs, Tlen1)}},{L1,C1}};
                     Ts == [] -> {eof,{L1,C1}};
                     true -> {ok,yyrev(Ts),{L1,C1}}
                  end,
            {done,Ret,eof};
        {reject,_Alen1,Tlen1,_Ics1,L1,C1,_S1} ->
            %% Skip rest of tokens.
            Error = {{L1,C1},?MODULE,{illegal,yypre(Tcs, Tlen1+1)}},
            skip_tokens(yysuf(Tcs, Tlen1+1), L1, C1, Error);
        {A1,Alen1,Tlen1,_Ics1,L1,_C1,_S1} ->
            Token = yyaction(A1, Alen1, Tcs, Tline,Tcol),
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            C2 = C0 + Alen1,
            tokens_cont(Tcs1, L2, C2, Token, Ts)
    end.

%% tokens_cont(RestChars, Line, Column, Token, Tokens)
%% If we have an end_token or error then return done, else if we have
%% a token then save it and continue, else if we have a skip_token
%% just continue.

-dialyzer({nowarn_function, tokens_cont/5}).

tokens_cont(Rest, Line, Col, {token,T}, Ts) ->
    tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, [T|Ts], reject, 0);
tokens_cont(Rest, Line, Col, {token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, [T|Ts], reject, 0);
tokens_cont(Rest, Line, Col, {end_token,T}, Ts) ->
    {done,{ok,yyrev(Ts, [T]),{Line,Col}},Rest};
tokens_cont(Rest, Line, Col, {end_token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    {done,{ok,yyrev(Ts, [T]),{Line, Col}},NewRest};
tokens_cont(Rest, Line, Col, skip_token, Ts) ->
    tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Ts, reject, 0);
tokens_cont(Rest, Line, Col, {skip_token,Push}, Ts) ->
    NewRest = Push ++ Rest,
    tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, Ts, reject, 0);
tokens_cont(Rest, Line, Col, {error,S}, _Ts) ->
    skip_tokens(Rest, Line, Col, {{Line,Col},?MODULE,{user,S}}).

%% skip_tokens(InChars, Line, Col, Error) -> {done,{error,Error,{Line,Col}},Ics}.
%% Skip tokens until an end token, junk everything and return the error.

skip_tokens(Ics, Line, Col, Error) ->
    skip_tokens(yystate(), Ics, Line, Col, Ics, 0, Line, Col, Error, reject, 0).

%% skip_tokens(State, InChars, Line, Col, TokenChars, TokenLen, TokenLine, TokenCol, Tokens,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.

skip_tokens(S0, Ics0, L0, C0, Tcs, Tlen0, Tline, Tcol, Error, A0, Alen0) ->
    case yystate(S0, Ics0, L0, C0, Tlen0, A0, Alen0) of
        {A1,Alen1,Ics1,L1, C1} ->                  % Accepting end state
            skip_cont(Ics1, L1, C1, yyaction(A1, Alen1, Tcs, Tline, Tcol), Error);
        {A1,Alen1,[],L1,C1, S1} ->                 % After an accepting state
            {more,{skip_tokens,S1,L1,C1,Tcs,Alen1,Tline,Tcol,Error,A1,Alen1}};
        {A1,Alen1,Ics1,L1,C1,_S1} ->
            skip_cont(Ics1, L1, C1, yyaction(A1, Alen1, Tcs, Tline, Tcol), Error);
        {A1,Alen1,Tlen1,[],L1,C1,S1} ->           % After a non-accepting state
            {more,{skip_tokens,S1,L1,C1,Tcs,Tlen1,Tline,Tcol,Error,A1,Alen1}};
        {reject,_Alen1,_Tlen1,eof,L1,C1,_S1} ->
            {done,{error,Error,{L1,C1}},eof};
        {reject,_Alen1,Tlen1,_Ics1,L1,C1,_S1} ->
            skip_tokens(yysuf(Tcs, Tlen1+1), L1, C1,Error);
        {A1,Alen1,Tlen1,_Ics1,L1,C1,_S1} ->
            Token = yyaction(A1, Alen1, Tcs, Tline, Tcol),
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            skip_cont(Tcs1, L2, C1, Token, Error)
    end.

%% skip_cont(RestChars, Line, Col, Token, Error)
%% Skip tokens until we have an end_token or error then return done
%% with the original rror.

-dialyzer({nowarn_function, skip_cont/5}).

skip_cont(Rest, Line, Col, {token,_T}, Error) ->
    skip_tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {token,_T,Push}, Error) ->
    NewRest = Push ++ Rest,
    skip_tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {end_token,_T}, Error) ->
    {done,{error,Error,{Line,Col}},Rest};
skip_cont(Rest, Line, Col, {end_token,_T,Push}, Error) ->
    NewRest = Push ++ Rest,
    {done,{error,Error,{Line,Col}},NewRest};
skip_cont(Rest, Line, Col, skip_token, Error) ->
    skip_tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {skip_token,Push}, Error) ->
    NewRest = Push ++ Rest,
    skip_tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {error,_S}, Error) ->
    skip_tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Error, reject, 0).

-compile({nowarn_unused_function, [yyrev/1, yyrev/2, yypre/2, yysuf/2]}).

yyrev(List) -> lists:reverse(List).
yyrev(List, Tail) -> lists:reverse(List, Tail).
yypre(List, N) -> lists:sublist(List, N).
yysuf(List, N) -> lists:nthtail(N, List).

%% adjust_line(TokenLength, AcceptLength, Chars, Line) -> NewLine
%% Make sure that newlines in Chars are not counted twice.
%% Line has been updated with respect to newlines in the prefix of
%% Chars consisting of (TokenLength - AcceptLength) characters.

-compile({nowarn_unused_function, adjust_line/4}).

adjust_line(N, N, _Cs, L) -> L;
adjust_line(T, A, [$\n|Cs], L) ->
    adjust_line(T-1, A, Cs, L-1);
adjust_line(T, A, [_|Cs], L) ->
    adjust_line(T-1, A, Cs, L).

%% adjust_col(Chars, AcceptLength, Col) -> NewCol
%% Handle newlines, tabs and unicode chars.
adjust_col(_, 0, Col) ->
    Col;
adjust_col([$\n | R], L, _) ->
    adjust_col(R, L-1, 1);
adjust_col([$\t | R], L, Col) ->
    adjust_col(R, L-1, tab_forward(Col)+1);
adjust_col([C | R], L, Col) when C>=0 andalso C=< 16#7F ->
    adjust_col(R, L-1, Col+1);
adjust_col([C | R], L, Col) when C>= 16#80 andalso C=< 16#7FF ->
    adjust_col(R, L-1, Col+2);
adjust_col([C | R], L, Col) when C>= 16#800 andalso C=< 16#FFFF ->
    adjust_col(R, L-1, Col+3);
adjust_col([C | R], L, Col) when C>= 16#10000 andalso C=< 16#10FFFF ->
    adjust_col(R, L-1, Col+4).

tab_forward(C) ->
    D = C rem tab_size(),
    A = tab_size()-D,
    C+A.

tab_size() -> 8.

%% yystate() -> InitialState.
%% yystate(State, InChars, Line, Col, CurrTokLen, AcceptAction, AcceptLen) ->
%% {Action, AcceptLen, RestChars, Line, Col} |
%% {Action, AcceptLen, RestChars, Line, Col, State} |
%% {reject, AcceptLen, CurrTokLen, RestChars, Line, Col, State} |
%% {Action, AcceptLen, CurrTokLen, RestChars, Line, Col, State}.
%% Generated state transition functions. The non-accepting end state
%% return signal either an unrecognised character or end of current
%% input.

-file("/Users/rv/luerl/luerl/src/luerl_scan.erl", 552).
yystate() -> 91.

yystate(94, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(86, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(94, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(86, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(94, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(90, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(94, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,94};
yystate(93, [160|Ics], Line, Col, Tlen, _, _) ->
    yystate(93, Ics, Line, Col, Tlen+1, 47, Tlen);
yystate(93, [32|Ics], Line, Col, Tlen, _, _) ->
    yystate(93, Ics, Line, Col, Tlen+1, 47, Tlen);
yystate(93, [9|Ics], Line, Col, Tlen, _, _) ->
    yystate(93, Ics, Line, Col, Tlen+1, 47, Tlen);
yystate(93, [10|Ics], Line, _, Tlen, _, _) ->
    yystate(93, Ics, Line+1, 1, Tlen+1, 47, Tlen);
yystate(93, [C|Ics], Line, Col, Tlen, _, _) when C >= 11, C =< 13 ->
    yystate(93, Ics, Line, Col, Tlen+1, 47, Tlen);
yystate(93, Ics, Line, Col, Tlen, _, _) ->
    {47,Tlen,Ics,Line,Col,93};
yystate(92, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(94, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(92, [69|Ics], Line, Col, Tlen, _, _) ->
    yystate(94, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(92, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(92, Ics, Line, Col, Tlen, _, _) ->
    {5,Tlen,Ics,Line,Col,92};
yystate(91, [160|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [126|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(87, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [125|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(79, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [124|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(75, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [123|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(71, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [95|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(67, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [94|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(63, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(59, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(55, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(32, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(44, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [60|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(52, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [59|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(64, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [58|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(68, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [48|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(66, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [47|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(38, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(30, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(2, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [44|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(37, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(41, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [42|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(45, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [41|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(49, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [40|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(53, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [39|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [38|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(69, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [37|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(73, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [35|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(77, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [32|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [9|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(93, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(91, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 13 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 49, C =< 57 ->
    yystate(76, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 65, C =< 90 ->
    yystate(67, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 97, C =< 122 ->
    yystate(67, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(91, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,91};
yystate(90, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(90, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(90, Ics, Line, Col, Tlen, _, _) ->
    {5,Tlen,Ics,Line,Col,90};
yystate(89, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(81, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(89, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(85, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(89, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(89, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(89, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(89, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(89, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(89, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(89, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,89};
yystate(88, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(84, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(88, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,88};
yystate(87, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 23, Tlen);
yystate(87, Ics, Line, Col, Tlen, _, _) ->
    {23,Tlen,Ics,Line,Col,87};
yystate(86, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(90, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(86, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,86};
yystate(85, Ics, Line, Col, Tlen, _, _) ->
    {8,Tlen,Ics,Line,Col};
yystate(84, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(84, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(84, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col,84};
yystate(83, Ics, Line, Col, Tlen, _, _) ->
    {28,Tlen,Ics,Line,Col};
yystate(82, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(78, Ics, Line, Col, Tlen+1, 3, Tlen);
yystate(82, [69|Ics], Line, Col, Tlen, _, _) ->
    yystate(78, Ics, Line, Col, Tlen+1, 3, Tlen);
yystate(82, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Col, Tlen+1, 3, Tlen);
yystate(82, Ics, Line, Col, Tlen, _, _) ->
    {3,Tlen,Ics,Line,Col,82};
yystate(81, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(89, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(81, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(81, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11 ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(81, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,81};
yystate(80, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(88, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(80, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(88, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(80, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(84, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(80, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,80};
yystate(79, Ics, Line, Col, Tlen, _, _) ->
    {37,Tlen,Ics,Line,Col};
yystate(78, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(70, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(70, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(74, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,78};
yystate(77, Ics, Line, Col, Tlen, _, _) ->
    {26,Tlen,Ics,Line,Col};
yystate(76, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(80, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(76, [69|Ics], Line, Col, Tlen, _, _) ->
    yystate(80, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(76, [46|Ics], Line, Col, Tlen, _, _) ->
    yystate(92, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(76, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(76, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(76, Ics, Line, Col, Tlen, _, _) ->
    {1,Tlen,Ics,Line,Col,76};
yystate(75, Ics, Line, Col, Tlen, _, _) ->
    {22,Tlen,Ics,Line,Col};
yystate(74, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(74, Ics, Line, Col, Tlen+1, 3, Tlen);
yystate(74, Ics, Line, Col, Tlen, _, _) ->
    {3,Tlen,Ics,Line,Col,74};
yystate(73, Ics, Line, Col, Tlen, _, _) ->
    {19,Tlen,Ics,Line,Col};
yystate(72, Ics, Line, Col, Tlen, _, _) ->
    {40,Tlen,Ics,Line,Col};
yystate(71, Ics, Line, Col, Tlen, _, _) ->
    {36,Tlen,Ics,Line,Col};
yystate(70, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(74, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(70, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,70};
yystate(69, Ics, Line, Col, Tlen, _, _) ->
    {21,Tlen,Ics,Line,Col};
yystate(68, [58|Ics], Line, Col, Tlen, _, _) ->
    yystate(72, Ics, Line, Col, Tlen+1, 42, Tlen);
yystate(68, Ics, Line, Col, Tlen, _, _) ->
    {42,Tlen,Ics,Line,Col,68};
yystate(67, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(67, Ics, Line, Col, Tlen+1, 0, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(67, Ics, Line, Col, Tlen+1, 0, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(67, Ics, Line, Col, Tlen+1, 0, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(67, Ics, Line, Col, Tlen+1, 0, Tlen);
yystate(67, Ics, Line, Col, Tlen, _, _) ->
    {0,Tlen,Ics,Line,Col,67};
yystate(66, [120|Ics], Line, Col, Tlen, _, _) ->
    yystate(62, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(66, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(80, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(66, [88|Ics], Line, Col, Tlen, _, _) ->
    yystate(62, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(66, [69|Ics], Line, Col, Tlen, _, _) ->
    yystate(80, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(66, [46|Ics], Line, Col, Tlen, _, _) ->
    yystate(92, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(66, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(76, Ics, Line, Col, Tlen+1, 1, Tlen);
yystate(66, Ics, Line, Col, Tlen, _, _) ->
    {1,Tlen,Ics,Line,Col,66};
yystate(65, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(57, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(65, [39|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(61, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(65, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(65, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(65, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(65, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 38 ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(65, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 40, C =< 91 ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(65, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(65, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,65};
yystate(64, Ics, Line, Col, Tlen, _, _) ->
    {41,Tlen,Ics,Line,Col};
yystate(63, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col};
yystate(62, [112|Ics], Line, Col, Tlen, _, _) ->
    yystate(58, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(62, [80|Ics], Line, Col, Tlen, _, _) ->
    yystate(58, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(62, [46|Ics], Line, Col, Tlen, _, _) ->
    yystate(42, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(62, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(46, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(62, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 70 ->
    yystate(46, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(62, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(46, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(62, Ics, Line, Col, Tlen, _, _) ->
    {7,Tlen,Ics,Line,Col,62};
yystate(61, Ics, Line, Col, Tlen, _, _) ->
    {9,Tlen,Ics,Line,Col};
yystate(60, Ics, Line, Col, Tlen, _, _) ->
    {25,Tlen,Ics,Line,Col};
yystate(59, Ics, Line, Col, Tlen, _, _) ->
    {39,Tlen,Ics,Line,Col};
yystate(58, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(50, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(58, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(50, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(58, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(54, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(58, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,58};
yystate(57, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(65, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(57, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(57, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11 ->
    yystate(65, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(57, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,57};
yystate(56, Ics, Line, Col, Tlen, _, _) ->
    {29,Tlen,Ics,Line,Col};
yystate(55, [91|Ics], Line, Col, Tlen, _, _) ->
    yystate(51, Ics, Line, Col, Tlen+1, 38, Tlen);
yystate(55, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(39, Ics, Line, Col, Tlen+1, 38, Tlen);
yystate(55, Ics, Line, Col, Tlen, _, _) ->
    {38,Tlen,Ics,Line,Col,55};
yystate(54, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(54, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(54, Ics, Line, Col, Tlen, _, _) ->
    {7,Tlen,Ics,Line,Col,54};
yystate(53, Ics, Line, Col, Tlen, _, _) ->
    {34,Tlen,Ics,Line,Col};
yystate(52, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(56, Ics, Line, Col, Tlen+1, 31, Tlen);
yystate(52, [60|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 31, Tlen);
yystate(52, Ics, Line, Col, Tlen, _, _) ->
    {31,Tlen,Ics,Line,Col,52};
yystate(51, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(47, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(51, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(51, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(51, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(51, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(51, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(51, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(51, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(51, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(51, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,51};
yystate(50, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(54, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(50, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,50};
yystate(49, Ics, Line, Col, Tlen, _, _) ->
    {35,Tlen,Ics,Line,Col};
yystate(48, Ics, Line, Col, Tlen, _, _) ->
    {27,Tlen,Ics,Line,Col};
yystate(47, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(43, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(47, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(51, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(47, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(51, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(47, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(51, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(47, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(51, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(47, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,47};
yystate(46, [112|Ics], Line, Col, Tlen, _, _) ->
    yystate(58, Ics, Line, Col, Tlen+1, 2, Tlen);
yystate(46, [80|Ics], Line, Col, Tlen, _, _) ->
    yystate(58, Ics, Line, Col, Tlen+1, 2, Tlen);
yystate(46, [46|Ics], Line, Col, Tlen, _, _) ->
    yystate(42, Ics, Line, Col, Tlen+1, 2, Tlen);
yystate(46, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(46, Ics, Line, Col, Tlen+1, 2, Tlen);
yystate(46, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 70 ->
    yystate(46, Ics, Line, Col, Tlen+1, 2, Tlen);
yystate(46, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(46, Ics, Line, Col, Tlen+1, 2, Tlen);
yystate(46, Ics, Line, Col, Tlen, _, _) ->
    {2,Tlen,Ics,Line,Col,46};
yystate(45, Ics, Line, Col, Tlen, _, _) ->
    {16,Tlen,Ics,Line,Col};
yystate(44, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(48, Ics, Line, Col, Tlen+1, 33, Tlen);
yystate(44, Ics, Line, Col, Tlen, _, _) ->
    {33,Tlen,Ics,Line,Col,44};
yystate(43, Ics, Line, Col, Tlen, _, _) ->
    {10,Tlen,Ics,Line,Col};
yystate(42, [112|Ics], Line, Col, Tlen, _, _) ->
    yystate(58, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(42, [80|Ics], Line, Col, Tlen, _, _) ->
    yystate(58, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(42, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(42, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(42, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 70 ->
    yystate(42, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(42, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(42, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(42, Ics, Line, Col, Tlen, _, _) ->
    {7,Tlen,Ics,Line,Col,42};
yystate(41, Ics, Line, Col, Tlen, _, _) ->
    {14,Tlen,Ics,Line,Col};
yystate(40, Ics, Line, Col, Tlen, _, _) ->
    {30,Tlen,Ics,Line,Col};
yystate(39, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(39, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(19, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(39, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,39};
yystate(38, [47|Ics], Line, Col, Tlen, _, _) ->
    yystate(34, Ics, Line, Col, Tlen+1, 17, Tlen);
yystate(38, Ics, Line, Col, Tlen, _, _) ->
    {17,Tlen,Ics,Line,Col,38};
yystate(37, Ics, Line, Col, Tlen, _, _) ->
    {43,Tlen,Ics,Line,Col};
yystate(36, Ics, Line, Col, Tlen, _, _) ->
    {24,Tlen,Ics,Line,Col};
yystate(35, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(31, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(35, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(35, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(35, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(35, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(35, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(35, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,35};
yystate(34, Ics, Line, Col, Tlen, _, _) ->
    {18,Tlen,Ics,Line,Col};
yystate(33, [C|Ics], Line, Col, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(33, Ics, Line, Col, Tlen+1, 49, Tlen);
yystate(33, [C|Ics], Line, Col, Tlen, _, _) when C >= 11 ->
    yystate(33, Ics, Line, Col, Tlen+1, 49, Tlen);
yystate(33, Ics, Line, Col, Tlen, _, _) ->
    {49,Tlen,Ics,Line,Col,33};
yystate(32, [62|Ics], Line, Col, Tlen, _, _) ->
    yystate(36, Ics, Line, Col, Tlen+1, 32, Tlen);
yystate(32, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(40, Ics, Line, Col, Tlen+1, 32, Tlen);
yystate(32, Ics, Line, Col, Tlen, _, _) ->
    {32,Tlen,Ics,Line,Col,32};
yystate(31, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(27, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(31, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(35, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(31, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(31, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 60 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(31, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 62 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(31, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,31};
yystate(30, [46|Ics], Line, Col, Tlen, _, _) ->
    yystate(10, Ics, Line, Col, Tlen+1, 44, Tlen);
yystate(30, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(26, Ics, Line, Col, Tlen+1, 44, Tlen);
yystate(30, Ics, Line, Col, Tlen, _, _) ->
    {44,Tlen,Ics,Line,Col,30};
yystate(29, Ics, Line, Col, Tlen, _, _) ->
    {48,Tlen,Ics,Line,Col};
yystate(28, Ics, Line, Col, Tlen, _, _) ->
    {13,Tlen,Ics,Line,Col};
yystate(27, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(23, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(27, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(35, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(27, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(27, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(27, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(35, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(27, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,27};
yystate(26, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(22, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(26, [69|Ics], Line, Col, Tlen, _, _) ->
    yystate(22, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(26, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(26, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(26, Ics, Line, Col, Tlen, _, _) ->
    {6,Tlen,Ics,Line,Col,26};
yystate(25, [C|Ics], Line, Col, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(25, Ics, Line, Col, Tlen+1, 51, Tlen);
yystate(25, [C|Ics], Line, Col, Tlen, _, _) when C >= 11 ->
    yystate(25, Ics, Line, Col, Tlen+1, 51, Tlen);
yystate(25, Ics, Line, Col, Tlen, _, _) ->
    {51,Tlen,Ics,Line,Col,25};
yystate(24, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(28, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(24, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(8, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(24, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,24};
yystate(23, Ics, Line, Col, Tlen, _, _) ->
    {11,Tlen,Ics,Line,Col};
yystate(22, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(14, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(22, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(14, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(22, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(18, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(22, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,22};
yystate(21, Ics, Line, Col, Tlen, _, _) ->
    {50,Tlen,Ics,Line,Col};
yystate(20, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(24, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(20, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(8, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(20, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(20, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 60 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(20, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 62 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(20, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,20};
yystate(19, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(19, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(4, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(19, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,19};
yystate(18, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(18, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(18, Ics, Line, Col, Tlen, _, _) ->
    {6,Tlen,Ics,Line,Col,18};
yystate(17, [93|Ics], Line, Col, Tlen, _, _) ->
    yystate(9, Ics, Line, Col, Tlen+1, 53, Tlen);
yystate(17, [10|Ics], Line, _, Tlen, _, _) ->
    yystate(17, Ics, Line+1, 1, Tlen+1, 53, Tlen);
yystate(17, [C|Ics], Line, Col, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(17, Ics, Line, Col, Tlen+1, 53, Tlen);
yystate(17, [C|Ics], Line, Col, Tlen, _, _) when C >= 11, C =< 92 ->
    yystate(17, Ics, Line, Col, Tlen+1, 53, Tlen);
yystate(17, [C|Ics], Line, Col, Tlen, _, _) when C >= 94 ->
    yystate(17, Ics, Line, Col, Tlen+1, 53, Tlen);
yystate(17, Ics, Line, Col, Tlen, _, _) ->
    {53,Tlen,Ics,Line,Col,17};
yystate(16, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(20, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(16, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(8, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(16, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(16, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 60 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(16, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 62 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(16, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,16};
yystate(15, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(11, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(15, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(15, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(15, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(15, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(15, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(15, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,15};
yystate(14, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(18, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(14, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,14};
yystate(13, Ics, Line, Col, Tlen, _, _) ->
    {52,Tlen,Ics,Line,Col};
yystate(12, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(16, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(12, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(8, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(12, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(12, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 60 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(12, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 62 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(12, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,12};
yystate(11, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(7, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(11, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(15, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(11, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(11, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 60 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(11, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 62 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(11, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,11};
yystate(10, [46|Ics], Line, Col, Tlen, _, _) ->
    yystate(6, Ics, Line, Col, Tlen+1, 45, Tlen);
yystate(10, Ics, Line, Col, Tlen, _, _) ->
    {45,Tlen,Ics,Line,Col,10};
yystate(9, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(13, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(9, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(17, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(9, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(17, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(9, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(17, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(9, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(17, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(9, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,9};
yystate(8, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(12, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(8, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(8, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(8, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(8, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(8, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(8, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,8};
yystate(7, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(3, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(7, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(15, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(7, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(7, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 60 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(7, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 62 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(7, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,7};
yystate(6, Ics, Line, Col, Tlen, _, _) ->
    {46,Tlen,Ics,Line,Col};
yystate(5, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(17, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(5, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(21, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(5, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(25, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(5, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 90 ->
    yystate(25, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(5, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 92 ->
    yystate(25, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(5, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,5};
yystate(4, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(8, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(4, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,4};
yystate(3, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(0, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(3, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(15, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(3, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(3, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 92 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(3, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 94 ->
    yystate(15, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(3, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,3};
yystate(2, [45|Ics], Line, Col, Tlen, _, _) ->
    yystate(1, Ics, Line, Col, Tlen+1, 15, Tlen);
yystate(2, Ics, Line, Col, Tlen, _, _) ->
    {15,Tlen,Ics,Line,Col,2};
yystate(1, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(5, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(1, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(29, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(1, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(33, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(1, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 90 ->
    yystate(33, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(1, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 92 ->
    yystate(33, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(1, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,1};
yystate(0, Ics, Line, Col, Tlen, _, _) ->
    {12,Tlen,Ics,Line,Col};
yystate(S, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,S}.

%% yyaction(Action, TokenLength, TokenChars, TokenLine, TokenCol) ->
%% {token,Token} | {end_token, Token} | skip_token | {error,String}.
%% Generated action function.

yyaction(0, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_0(TokenChars, TokenLine);
yyaction(1, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_1(TokenChars, TokenLine);
yyaction(2, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_2(TokenChars, TokenLine);
yyaction(3, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_3(TokenChars, TokenLine);
yyaction(4, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_4(TokenChars, TokenLine);
yyaction(5, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_5(TokenChars, TokenLine);
yyaction(6, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_6(TokenChars, TokenLine);
yyaction(7, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_7(TokenChars, TokenLine);
yyaction(8, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_8(TokenChars, TokenLen, TokenLine);
yyaction(9, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_9(TokenChars, TokenLen, TokenLine);
yyaction(10, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_10(TokenChars, TokenLen, TokenLine);
yyaction(11, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_11(TokenChars, TokenLen, TokenLine);
yyaction(12, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_12(TokenChars, TokenLen, TokenLine);
yyaction(13, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_13(TokenChars, TokenLen, TokenLine);
yyaction(14, _, _, TokenLine, _) ->
    yyaction_14(TokenLine);
yyaction(15, _, _, TokenLine, _) ->
    yyaction_15(TokenLine);
yyaction(16, _, _, TokenLine, _) ->
    yyaction_16(TokenLine);
yyaction(17, _, _, TokenLine, _) ->
    yyaction_17(TokenLine);
yyaction(18, _, _, TokenLine, _) ->
    yyaction_18(TokenLine);
yyaction(19, _, _, TokenLine, _) ->
    yyaction_19(TokenLine);
yyaction(20, _, _, TokenLine, _) ->
    yyaction_20(TokenLine);
yyaction(21, _, _, TokenLine, _) ->
    yyaction_21(TokenLine);
yyaction(22, _, _, TokenLine, _) ->
    yyaction_22(TokenLine);
yyaction(23, _, _, TokenLine, _) ->
    yyaction_23(TokenLine);
yyaction(24, _, _, TokenLine, _) ->
    yyaction_24(TokenLine);
yyaction(25, _, _, TokenLine, _) ->
    yyaction_25(TokenLine);
yyaction(26, _, _, TokenLine, _) ->
    yyaction_26(TokenLine);
yyaction(27, _, _, TokenLine, _) ->
    yyaction_27(TokenLine);
yyaction(28, _, _, TokenLine, _) ->
    yyaction_28(TokenLine);
yyaction(29, _, _, TokenLine, _) ->
    yyaction_29(TokenLine);
yyaction(30, _, _, TokenLine, _) ->
    yyaction_30(TokenLine);
yyaction(31, _, _, TokenLine, _) ->
    yyaction_31(TokenLine);
yyaction(32, _, _, TokenLine, _) ->
    yyaction_32(TokenLine);
yyaction(33, _, _, TokenLine, _) ->
    yyaction_33(TokenLine);
yyaction(34, _, _, TokenLine, _) ->
    yyaction_34(TokenLine);
yyaction(35, _, _, TokenLine, _) ->
    yyaction_35(TokenLine);
yyaction(36, _, _, TokenLine, _) ->
    yyaction_36(TokenLine);
yyaction(37, _, _, TokenLine, _) ->
    yyaction_37(TokenLine);
yyaction(38, _, _, TokenLine, _) ->
    yyaction_38(TokenLine);
yyaction(39, _, _, TokenLine, _) ->
    yyaction_39(TokenLine);
yyaction(40, _, _, TokenLine, _) ->
    yyaction_40(TokenLine);
yyaction(41, _, _, TokenLine, _) ->
    yyaction_41(TokenLine);
yyaction(42, _, _, TokenLine, _) ->
    yyaction_42(TokenLine);
yyaction(43, _, _, TokenLine, _) ->
    yyaction_43(TokenLine);
yyaction(44, _, _, TokenLine, _) ->
    yyaction_44(TokenLine);
yyaction(45, _, _, TokenLine, _) ->
    yyaction_45(TokenLine);
yyaction(46, _, _, TokenLine, _) ->
    yyaction_46(TokenLine);
yyaction(47, _, _, _, _) ->
    yyaction_47();
yyaction(48, _, _, _, _) ->
    yyaction_48();
yyaction(49, _, _, _, _) ->
    yyaction_49();
yyaction(50, _, _, _, _) ->
    yyaction_50();
yyaction(51, _, _, _, _) ->
    yyaction_51();
yyaction(52, _, _, _, _) ->
    yyaction_52();
yyaction(53, _, _, _, _) ->
    yyaction_53();
yyaction(_, _, _, _, _) -> error.

-compile({inline,yyaction_0/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 28).
yyaction_0(TokenChars, TokenLine) ->
     name_token (TokenChars, TokenLine) .

-compile({inline,yyaction_1/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 32).
yyaction_1(TokenChars, TokenLine) ->
     case catch { ok, list_to_integer (TokenChars) } of
     { ok, I } -> { token, { 'NUMERAL', TokenLine, I } } ;
     _ -> { error, "illegal number" }
     end .

-compile({inline,yyaction_2/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 37).
yyaction_2(TokenChars, TokenLine) ->
     Int = list_to_integer (string : substr (TokenChars, 3), 16),
     { token, { 'NUMERAL', TokenLine, Int } } .

-compile({inline,yyaction_3/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 42).
yyaction_3(TokenChars, TokenLine) ->
     case catch { ok, list_to_float (TokenChars) } of
     { ok, F } -> { token, { 'NUMERAL', TokenLine, F } } ;
     _ -> { error, "illegal number" }
     end .

-compile({inline,yyaction_4/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 47).
yyaction_4(TokenChars, TokenLine) ->
     [M, E ] = string : tokens (TokenChars, "eE"),
     case catch { ok, list_to_float (M ++ ".0e" ++ E) } of
     { ok, F } -> { token, { 'NUMERAL', TokenLine, F } } ;
     _ -> { error, "illegal number" }
     end .

-compile({inline,yyaction_5/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 53).
yyaction_5(TokenChars, TokenLine) ->
     [M | E ] = string : tokens (TokenChars, "."),
     case catch { ok, list_to_float (lists : append ([M, ".0" | E ])) } of
     { ok, F } -> { token, { 'NUMERAL', TokenLine, F } } ;
     _ -> { error, "illegal number" }
     end .

-compile({inline,yyaction_6/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 59).
yyaction_6(TokenChars, TokenLine) ->
     case catch { ok, list_to_float ("0" ++ TokenChars) } of
     { ok, F } -> { token, { 'NUMERAL', TokenLine, F } } ;
     _ -> { error, "illegal number" }
     end .

-compile({inline,yyaction_7/2}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 68).
yyaction_7(TokenChars, TokenLine) ->
     hex_float_token (TokenChars, TokenLine) .

-compile({inline,yyaction_8/3}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 73).
yyaction_8(TokenChars, TokenLen, TokenLine) ->
     string_token (TokenChars, TokenLen, TokenLine) .

-compile({inline,yyaction_9/3}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 75).
yyaction_9(TokenChars, TokenLen, TokenLine) ->
     string_token (TokenChars, TokenLen, TokenLine) .

-compile({inline,yyaction_10/3}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 79).
yyaction_10(TokenChars, TokenLen, TokenLine) ->
     long_string_token (TokenChars, TokenLen, 2, TokenLine) .

-compile({inline,yyaction_11/3}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 81).
yyaction_11(TokenChars, TokenLen, TokenLine) ->
     long_string_token (TokenChars, TokenLen, 3, TokenLine) .

-compile({inline,yyaction_12/3}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 83).
yyaction_12(TokenChars, TokenLen, TokenLine) ->
     long_string_token (TokenChars, TokenLen, 4, TokenLine) .

-compile({inline,yyaction_13/3}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 85).
yyaction_13(TokenChars, TokenLen, TokenLine) ->
     long_string_token (TokenChars, TokenLen, 5, TokenLine) .

-compile({inline,yyaction_14/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 90).
yyaction_14(TokenLine) ->
     { token, { '+', TokenLine } } .

-compile({inline,yyaction_15/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 91).
yyaction_15(TokenLine) ->
     { token, { '-', TokenLine } } .

-compile({inline,yyaction_16/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 92).
yyaction_16(TokenLine) ->
     { token, { '*', TokenLine } } .

-compile({inline,yyaction_17/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 93).
yyaction_17(TokenLine) ->
     { token, { '/', TokenLine } } .

-compile({inline,yyaction_18/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 94).
yyaction_18(TokenLine) ->
     { token, { '//', TokenLine } } .

-compile({inline,yyaction_19/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 95).
yyaction_19(TokenLine) ->
     { token, { '%', TokenLine } } .

-compile({inline,yyaction_20/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 96).
yyaction_20(TokenLine) ->
     { token, { '^', TokenLine } } .

-compile({inline,yyaction_21/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 97).
yyaction_21(TokenLine) ->
     { token, { '&', TokenLine } } .

-compile({inline,yyaction_22/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 98).
yyaction_22(TokenLine) ->
     { token, { '|', TokenLine } } .

-compile({inline,yyaction_23/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 99).
yyaction_23(TokenLine) ->
     { token, { '~', TokenLine } } .

-compile({inline,yyaction_24/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 100).
yyaction_24(TokenLine) ->
     { token, { '>>', TokenLine } } .

-compile({inline,yyaction_25/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 101).
yyaction_25(TokenLine) ->
     { token, { '<<', TokenLine } } .

-compile({inline,yyaction_26/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 102).
yyaction_26(TokenLine) ->
     { token, { '#', TokenLine } } .

-compile({inline,yyaction_27/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 103).
yyaction_27(TokenLine) ->
     { token, { '==', TokenLine } } .

-compile({inline,yyaction_28/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 104).
yyaction_28(TokenLine) ->
     { token, { '~=', TokenLine } } .

-compile({inline,yyaction_29/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 105).
yyaction_29(TokenLine) ->
     { token, { '<=', TokenLine } } .

-compile({inline,yyaction_30/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 106).
yyaction_30(TokenLine) ->
     { token, { '>=', TokenLine } } .

-compile({inline,yyaction_31/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 107).
yyaction_31(TokenLine) ->
     { token, { '<', TokenLine } } .

-compile({inline,yyaction_32/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 108).
yyaction_32(TokenLine) ->
     { token, { '>', TokenLine } } .

-compile({inline,yyaction_33/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 109).
yyaction_33(TokenLine) ->
     { token, { '=', TokenLine } } .

-compile({inline,yyaction_34/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 110).
yyaction_34(TokenLine) ->
     { token, { '(', TokenLine } } .

-compile({inline,yyaction_35/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 111).
yyaction_35(TokenLine) ->
     { token, { ')', TokenLine } } .

-compile({inline,yyaction_36/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 112).
yyaction_36(TokenLine) ->
     { token, { '{', TokenLine } } .

-compile({inline,yyaction_37/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 113).
yyaction_37(TokenLine) ->
     { token, { '}', TokenLine } } .

-compile({inline,yyaction_38/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 114).
yyaction_38(TokenLine) ->
     { token, { '[', TokenLine } } .

-compile({inline,yyaction_39/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 115).
yyaction_39(TokenLine) ->
     { token, { ']', TokenLine } } .

-compile({inline,yyaction_40/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 116).
yyaction_40(TokenLine) ->
     { token, { '::', TokenLine } } .

-compile({inline,yyaction_41/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 117).
yyaction_41(TokenLine) ->
     { token, { ';', TokenLine } } .

-compile({inline,yyaction_42/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 118).
yyaction_42(TokenLine) ->
     { token, { ':', TokenLine } } .

-compile({inline,yyaction_43/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 119).
yyaction_43(TokenLine) ->
     { token, { ',', TokenLine } } .

-compile({inline,yyaction_44/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 120).
yyaction_44(TokenLine) ->
     { token, { '.', TokenLine } } .

-compile({inline,yyaction_45/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 121).
yyaction_45(TokenLine) ->
     { token, { '..', TokenLine } } .

-compile({inline,yyaction_46/1}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 122).
yyaction_46(TokenLine) ->
     { token, { '...', TokenLine } } .

-compile({inline,yyaction_47/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 124).
yyaction_47() ->
     skip_token .

-compile({inline,yyaction_48/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 128).
yyaction_48() ->
     skip_token .

-compile({inline,yyaction_49/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 129).
yyaction_49() ->
     skip_token .

-compile({inline,yyaction_50/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 130).
yyaction_50() ->
     skip_token .

-compile({inline,yyaction_51/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 131).
yyaction_51() ->
     skip_token .

-compile({inline,yyaction_52/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 134).
yyaction_52() ->
     skip_token .

-compile({inline,yyaction_53/0}).
-file("/Users/rv/luerl/luerl/src/luerl_scan.xrl", 135).
yyaction_53() ->
     { error, "unfinished long comment" } .
-file("/Users/rv/.asdf/installs/erlang/27.1/lib/parsetools-2.6/include/leexinc.hrl", 344).
