// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/redis/v1/cluster.proto

package redis

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/redis/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// Cluster is in unknown state (we have no data)
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well (all hosts are alive)
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable (it cannot perform any of its essential functions)
	Cluster_DEAD Cluster_Health = 2
	// Cluster is partially alive (it can perform some of its essential functions)
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster status is unknown
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running
	Cluster_RUNNING Cluster_Status = 2
	// Cluster failed
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Cluster_PersistenceMode int32

const (
	Cluster_ON          Cluster_PersistenceMode = 0 // cluster persistence mode on
	Cluster_OFF         Cluster_PersistenceMode = 1 // cluster persistence mode off
	Cluster_ON_REPLICAS Cluster_PersistenceMode = 2 // cluster persistence on replicas only
)

// Enum value maps for Cluster_PersistenceMode.
var (
	Cluster_PersistenceMode_name = map[int32]string{
		0: "ON",
		1: "OFF",
		2: "ON_REPLICAS",
	}
	Cluster_PersistenceMode_value = map[string]int32{
		"ON":          0,
		"OFF":         1,
		"ON_REPLICAS": 2,
	}
)

func (x Cluster_PersistenceMode) Enum() *Cluster_PersistenceMode {
	p := new(Cluster_PersistenceMode)
	*p = x
	return p
}

func (x Cluster_PersistenceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_PersistenceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Cluster_PersistenceMode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[3]
}

func (x Cluster_PersistenceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_PersistenceMode.Descriptor instead.
func (Cluster_PersistenceMode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{0, 3}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown. Default value.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the master Redis server in the cluster.
	Host_MASTER Host_Role = 1
	// Host is a replica (standby) Redis server in the cluster.
	Host_REPLICA Host_Role = 2
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNKNOWN",
		1: "MASTER",
		2: "REPLICA",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNKNOWN": 0,
		"MASTER":       1,
		"REPLICA":      2,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[4]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{4, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown. Default value.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[5]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{4, 1}
}

type Service_Type int32

const (
	// Service type of the host is unspecified. Default value.
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a Redis server.
	Service_REDIS Service_Type = 1
	// The host provides a Sentinel-only service (a quorum node).
	Service_ARBITER Service_Type = 2
	// The host is a Redis Cluster node.
	Service_REDIS_CLUSTER Service_Type = 3
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "REDIS",
		2: "ARBITER",
		3: "REDIS_CLUSTER",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"REDIS":            1,
		"ARBITER":          2,
		"REDIS_CLUSTER":    3,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[6].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[6]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{5, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown. Default value.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
	}
	Service_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[7].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes[7]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{5, 1}
}

// Description of a Redis cluster. For more information, see
// the Managed Service for Redis [documentation](/docs/managed-redis/concepts/).
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Redis cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Redis cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Redis cluster.
	// The name is unique within the folder. 3-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Redis cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the Redis cluster as `key:value` pairs.
	// Maximum 64 per cluster.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Deployment environment of the Redis cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the Redis cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the Redis cluster.
	Config    *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	NetworkId string         `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_Health" json:"health,omitempty"`
	// Cluster status.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_Status" json:"status,omitempty"`
	// Redis cluster mode on/off.
	Sharded bool `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	// Maintenance window for the cluster.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,14,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Planned maintenance operation to be started for the cluster within the nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,15,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,16,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// TLS port and functionality on\off
	TlsEnabled bool `protobuf:"varint,17,opt,name=tls_enabled,json=tlsEnabled,proto3" json:"tls_enabled,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,18,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Persistence mode
	PersistenceMode Cluster_PersistenceMode `protobuf:"varint,19,opt,name=persistence_mode,json=persistenceMode,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_PersistenceMode" json:"persistence_mode,omitempty"`
	// Enable FQDN instead of ip
	AnnounceHostnames bool `protobuf:"varint,20,opt,name=announce_hostnames,json=announceHostnames,proto3" json:"announce_hostnames,omitempty"`
	// Allows to use ACL users to auth in sentinel
	AuthSentinel bool `protobuf:"varint,21,opt,name=auth_sentinel,json=authSentinel,proto3" json:"auth_sentinel,omitempty"`
	// ID of the key to encrypt cluster disks.
	DiskEncryptionKeyId *wrapperspb.StringValue `protobuf:"bytes,22,opt,name=disk_encryption_key_id,json=diskEncryptionKeyId,proto3" json:"disk_encryption_key_id,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSharded() bool {
	if x != nil {
		return x.Sharded
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetTlsEnabled() bool {
	if x != nil {
		return x.TlsEnabled
	}
	return false
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetPersistenceMode() Cluster_PersistenceMode {
	if x != nil {
		return x.PersistenceMode
	}
	return Cluster_ON
}

func (x *Cluster) GetAnnounceHostnames() bool {
	if x != nil {
		return x.AnnounceHostnames
	}
	return false
}

func (x *Cluster) GetAuthSentinel() bool {
	if x != nil {
		return x.AuthSentinel
	}
	return false
}

func (x *Cluster) GetDiskEncryptionKeyId() *wrapperspb.StringValue {
	if x != nil {
		return x.DiskEncryptionKeyId
	}
	return nil
}

type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the Redis cluster.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of Redis server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for Redis servers in the cluster.
	//
	// Types that are valid to be assigned to RedisConfig:
	//
	//	*ClusterConfig_RedisConfig_5_0
	//	*ClusterConfig_RedisConfig_6_0
	//	*ClusterConfig_RedisConfig_6_2
	//	*ClusterConfig_RedisConfig_7_0
	RedisConfig isClusterConfig_RedisConfig `protobuf_oneof:"redis_config"`
	// Resources allocated to Redis hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access *Access `protobuf:"bytes,5,opt,name=access,proto3" json:"access,omitempty"`
	// Unified configuration of a Redis cluster.
	Redis *config.RedisConfigSet `protobuf:"bytes,9,opt,name=redis,proto3" json:"redis,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,10,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	// Retain period of automatically created backup in days
	BackupRetainPeriodDays *wrapperspb.Int64Value `protobuf:"bytes,13,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClusterConfig) GetRedisConfig() isClusterConfig_RedisConfig {
	if x != nil {
		return x.RedisConfig
	}
	return nil
}

func (x *ClusterConfig) GetRedisConfig_5_0() *config.RedisConfigSet5_0 {
	if x != nil {
		if x, ok := x.RedisConfig.(*ClusterConfig_RedisConfig_5_0); ok {
			return x.RedisConfig_5_0
		}
	}
	return nil
}

func (x *ClusterConfig) GetRedisConfig_6_0() *config.RedisConfigSet6_0 {
	if x != nil {
		if x, ok := x.RedisConfig.(*ClusterConfig_RedisConfig_6_0); ok {
			return x.RedisConfig_6_0
		}
	}
	return nil
}

func (x *ClusterConfig) GetRedisConfig_6_2() *config.RedisConfigSet6_2 {
	if x != nil {
		if x, ok := x.RedisConfig.(*ClusterConfig_RedisConfig_6_2); ok {
			return x.RedisConfig_6_2
		}
	}
	return nil
}

func (x *ClusterConfig) GetRedisConfig_7_0() *config.RedisConfigSet7_0 {
	if x != nil {
		if x, ok := x.RedisConfig.(*ClusterConfig_RedisConfig_7_0); ok {
			return x.RedisConfig_7_0
		}
	}
	return nil
}

func (x *ClusterConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ClusterConfig) GetRedis() *config.RedisConfigSet {
	if x != nil {
		return x.Redis
	}
	return nil
}

func (x *ClusterConfig) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

func (x *ClusterConfig) GetBackupRetainPeriodDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

type isClusterConfig_RedisConfig interface {
	isClusterConfig_RedisConfig()
}

type ClusterConfig_RedisConfig_5_0 struct {
	// Configuration of a Redis 5.0 server.
	RedisConfig_5_0 *config.RedisConfigSet5_0 `protobuf:"bytes,2,opt,name=redis_config_5_0,json=redisConfig_5_0,proto3,oneof"`
}

type ClusterConfig_RedisConfig_6_0 struct {
	// Configuration of a Redis 6.0 server.
	RedisConfig_6_0 *config.RedisConfigSet6_0 `protobuf:"bytes,6,opt,name=redis_config_6_0,json=redisConfig_6_0,proto3,oneof"`
}

type ClusterConfig_RedisConfig_6_2 struct {
	// Configuration of a Redis 6.2 server.
	RedisConfig_6_2 *config.RedisConfigSet6_2 `protobuf:"bytes,7,opt,name=redis_config_6_2,json=redisConfig_6_2,proto3,oneof"`
}

type ClusterConfig_RedisConfig_7_0 struct {
	// Configuration of a Redis 7.0 server.
	RedisConfig_7_0 *config.RedisConfigSet7_0 `protobuf:"bytes,8,opt,name=redis_config_7_0,json=redisConfig_7_0,proto3,oneof"`
}

func (*ClusterConfig_RedisConfig_5_0) isClusterConfig_RedisConfig() {}

func (*ClusterConfig_RedisConfig_6_0) isClusterConfig_RedisConfig() {}

func (*ClusterConfig_RedisConfig_6_2) isClusterConfig_RedisConfig() {}

func (*ClusterConfig_RedisConfig_7_0) isClusterConfig_RedisConfig() {}

type Shard struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the Redis shard. The shard name is assigned by user at creation time, and cannot be changed.
	// 1-63 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the Redis cluster the shard belongs to. The ID is assigned by MDB at creation time.
	ClusterId     string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Shard) Reset() {
	*x = Shard{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Shard) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Shard) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

type Host struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the Redis host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the Redis cluster. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the Redis host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,4,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Resources allocated to the Redis host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster. If the field has default value, it is not returned in the response.
	Role Host_Role `protobuf:"varint,6,opt,name=role,proto3,enum=yandex.cloud.mdb.redis.v1.Host_Role" json:"role,omitempty"`
	// Aggregated health of the host. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,7,opt,name=health,proto3,enum=yandex.cloud.mdb.redis.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services  []*Service `protobuf:"bytes,8,rep,name=services,proto3" json:"services,omitempty"`
	ShardName string     `protobuf:"bytes,9,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// A replica with a low priority number is considered better for promotion.
	// A replica with priority of 0 will never be selected by Redis Sentinel for promotion.
	// Works only for non-sharded clusters. Default value is 100.
	ReplicaPriority *wrapperspb.Int64Value `protobuf:"bytes,10,opt,name=replica_priority,json=replicaPriority,proto3" json:"replica_priority,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,11,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Host) Reset() {
	*x = Host{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNKNOWN
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

func (x *Host) GetReplicaPriority() *wrapperspb.Int64Value {
	if x != nil {
		return x.ReplicaPriority
	}
	return nil
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

type Service struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the service provided by the host. If the field has default value, it is not returned in the response.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.redis.v1.Service_Type" json:"type,omitempty"`
	// Aggregated health of the service. If the field has default value, it is not returned in the response.
	Health        Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.redis.v1.Service_Health" json:"health,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-redis/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-ssd - network SSD drive,
	// * local-ssd - local SSD storage.
	DiskTypeId    string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resources) Reset() {
	*x = Resources{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

type Access struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allow access for DataLens
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allow access for Web SQL.
	WebSql        bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Access) Reset() {
	*x = Access{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

func (x *Access) GetWebSql() bool {
	if x != nil {
		return x.WebSql
	}
	return false
}

type DiskSizeAutoscaling struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Amount of used storage for automatic disk scaling in the maintenance window, 0 means disabled, in percent.
	PlannedUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Amount of used storage for immediately  automatic disk scaling, 0 means disabled, in percent.
	EmergencyUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// Limit on how large the storage for database instances can automatically grow, in bytes.
	DiskSizeLimit *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.DiskSizeLimit
	}
	return nil
}

var File_yandex_cloud_mdb_redis_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDesc = "" +
	"\n" +
	"'yandex/cloud/mdb/redis/v1/cluster.proto\x12\x19yandex.cloud.mdb.redis.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1bgoogle/type/timeofday.proto\x1a\x1dyandex/cloud/validation.proto\x1a,yandex/cloud/mdb/redis/v1/config/redis.proto\x1a/yandex/cloud/mdb/redis/v1/config/redis5_0.proto\x1a/yandex/cloud/mdb/redis/v1/config/redis6_0.proto\x1a/yandex/cloud/mdb/redis/v1/config/redis6_2.proto\x1a/yandex/cloud/mdb/redis/v1/config/redis7_0.proto\x1a+yandex/cloud/mdb/redis/v1/maintenance.proto\"\xc1\f\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12F\n" +
	"\x06labels\x18\x06 \x03(\v2..yandex.cloud.mdb.redis.v1.Cluster.LabelsEntryR\x06labels\x12P\n" +
	"\venvironment\x18\a \x01(\x0e2..yandex.cloud.mdb.redis.v1.Cluster.EnvironmentR\venvironment\x12E\n" +
	"\n" +
	"monitoring\x18\b \x03(\v2%.yandex.cloud.mdb.redis.v1.MonitoringR\n" +
	"monitoring\x12@\n" +
	"\x06config\x18\t \x01(\v2(.yandex.cloud.mdb.redis.v1.ClusterConfigR\x06config\x12\x1d\n" +
	"\n" +
	"network_id\x18\n" +
	" \x01(\tR\tnetworkId\x12A\n" +
	"\x06health\x18\v \x01(\x0e2).yandex.cloud.mdb.redis.v1.Cluster.HealthR\x06health\x12A\n" +
	"\x06status\x18\f \x01(\x0e2).yandex.cloud.mdb.redis.v1.Cluster.StatusR\x06status\x12\x18\n" +
	"\asharded\x18\r \x01(\bR\asharded\x12[\n" +
	"\x12maintenance_window\x18\x0e \x01(\v2,.yandex.cloud.mdb.redis.v1.MaintenanceWindowR\x11maintenanceWindow\x12\\\n" +
	"\x11planned_operation\x18\x0f \x01(\v2/.yandex.cloud.mdb.redis.v1.MaintenanceOperationR\x10plannedOperation\x12,\n" +
	"\x12security_group_ids\x18\x10 \x03(\tR\x10securityGroupIds\x12\x1f\n" +
	"\vtls_enabled\x18\x11 \x01(\bR\n" +
	"tlsEnabled\x12/\n" +
	"\x13deletion_protection\x18\x12 \x01(\bR\x12deletionProtection\x12]\n" +
	"\x10persistence_mode\x18\x13 \x01(\x0e22.yandex.cloud.mdb.redis.v1.Cluster.PersistenceModeR\x0fpersistenceMode\x12-\n" +
	"\x12announce_hostnames\x18\x14 \x01(\bR\x11announceHostnames\x12#\n" +
	"\rauth_sentinel\x18\x15 \x01(\bR\fauthSentinel\x12Q\n" +
	"\x16disk_encryption_key_id\x18\x16 \x01(\v2\x1c.google.protobuf.StringValueR\x13diskEncryptionKeyId\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"I\n" +
	"\vEnvironment\x12\x1b\n" +
	"\x17ENVIRONMENT_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"PRODUCTION\x10\x01\x12\r\n" +
	"\tPRESTABLE\x10\x02\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bUPDATING\x10\x04\x12\f\n" +
	"\bSTOPPING\x10\x05\x12\v\n" +
	"\aSTOPPED\x10\x06\x12\f\n" +
	"\bSTARTING\x10\a\"3\n" +
	"\x0fPersistenceMode\x12\x06\n" +
	"\x02ON\x10\x00\x12\a\n" +
	"\x03OFF\x10\x01\x12\x0f\n" +
	"\vON_REPLICAS\x10\x02\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\x98\a\n" +
	"\rClusterConfig\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12`\n" +
	"\x10redis_config_5_0\x18\x02 \x01(\v23.yandex.cloud.mdb.redis.v1.config.RedisConfigSet5_0H\x00R\x0fredisConfig_5_0\x12`\n" +
	"\x10redis_config_6_0\x18\x06 \x01(\v23.yandex.cloud.mdb.redis.v1.config.RedisConfigSet6_0H\x00R\x0fredisConfig_6_0\x12`\n" +
	"\x10redis_config_6_2\x18\a \x01(\v23.yandex.cloud.mdb.redis.v1.config.RedisConfigSet6_2H\x00R\x0fredisConfig_6_2\x12`\n" +
	"\x10redis_config_7_0\x18\b \x01(\v23.yandex.cloud.mdb.redis.v1.config.RedisConfigSet7_0H\x00R\x0fredisConfig_7_0\x12B\n" +
	"\tresources\x18\x03 \x01(\v2$.yandex.cloud.mdb.redis.v1.ResourcesR\tresources\x12F\n" +
	"\x13backup_window_start\x18\x04 \x01(\v2\x16.google.type.TimeOfDayR\x11backupWindowStart\x129\n" +
	"\x06access\x18\x05 \x01(\v2!.yandex.cloud.mdb.redis.v1.AccessR\x06access\x12F\n" +
	"\x05redis\x18\t \x01(\v20.yandex.cloud.mdb.redis.v1.config.RedisConfigSetR\x05redis\x12b\n" +
	"\x15disk_size_autoscaling\x18\n" +
	" \x01(\v2..yandex.cloud.mdb.redis.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x12V\n" +
	"\x19backup_retain_period_days\x18\r \x01(\v2\x1b.google.protobuf.Int64ValueR\x16backupRetainPeriodDaysB\x0e\n" +
	"\fredis_configJ\x04\b\v\x10\fJ\x04\b\f\x10\r\":\n" +
	"\x05Shard\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\"\xf2\x04\n" +
	"\x04Host\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12\x17\n" +
	"\azone_id\x18\x03 \x01(\tR\x06zoneId\x12\x1b\n" +
	"\tsubnet_id\x18\x04 \x01(\tR\bsubnetId\x12B\n" +
	"\tresources\x18\x05 \x01(\v2$.yandex.cloud.mdb.redis.v1.ResourcesR\tresources\x128\n" +
	"\x04role\x18\x06 \x01(\x0e2$.yandex.cloud.mdb.redis.v1.Host.RoleR\x04role\x12>\n" +
	"\x06health\x18\a \x01(\x0e2&.yandex.cloud.mdb.redis.v1.Host.HealthR\x06health\x12>\n" +
	"\bservices\x18\b \x03(\v2\".yandex.cloud.mdb.redis.v1.ServiceR\bservices\x12\x1d\n" +
	"\n" +
	"shard_name\x18\t \x01(\tR\tshardName\x12F\n" +
	"\x10replica_priority\x18\n" +
	" \x01(\v2\x1b.google.protobuf.Int64ValueR\x0freplicaPriority\x12(\n" +
	"\x10assign_public_ip\x18\v \x01(\bR\x0eassignPublicIp\"1\n" +
	"\x04Role\x12\x10\n" +
	"\fROLE_UNKNOWN\x10\x00\x12\n" +
	"\n" +
	"\x06MASTER\x10\x01\x12\v\n" +
	"\aREPLICA\x10\x02\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"\x85\x02\n" +
	"\aService\x12;\n" +
	"\x04type\x18\x01 \x01(\x0e2'.yandex.cloud.mdb.redis.v1.Service.TypeR\x04type\x12A\n" +
	"\x06health\x18\x02 \x01(\x0e2).yandex.cloud.mdb.redis.v1.Service.HealthR\x06health\"G\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\t\n" +
	"\x05REDIS\x10\x01\x12\v\n" +
	"\aARBITER\x10\x02\x12\x11\n" +
	"\rREDIS_CLUSTER\x10\x03\"1\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\"x\n" +
	"\tResources\x12,\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tR\x10resourcePresetId\x12\x1b\n" +
	"\tdisk_size\x18\x02 \x01(\x03R\bdiskSize\x12 \n" +
	"\fdisk_type_id\x18\x03 \x01(\tR\n" +
	"diskTypeId\">\n" +
	"\x06Access\x12\x1b\n" +
	"\tdata_lens\x18\x01 \x01(\bR\bdataLens\x12\x17\n" +
	"\aweb_sql\x18\x02 \x01(\bR\x06webSql\"\xa6\x02\n" +
	"\x13DiskSizeAutoscaling\x12b\n" +
	"\x17planned_usage_threshold\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueB\r\xe8\xc71\x00\xfa\xc71\x050-100R\x15plannedUsageThreshold\x12f\n" +
	"\x19emergency_usage_threshold\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueB\r\xe8\xc71\x00\xfa\xc71\x050-100R\x17emergencyUsageThreshold\x12C\n" +
	"\x0fdisk_size_limit\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\rdiskSizeLimitBd\n" +
	"\x1dyandex.cloud.api.mdb.redis.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/redis/v1;redisb\x06proto3"

var (
	file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_yandex_cloud_mdb_redis_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),         // 0: yandex.cloud.mdb.redis.v1.Cluster.Environment
	(Cluster_Health)(0),              // 1: yandex.cloud.mdb.redis.v1.Cluster.Health
	(Cluster_Status)(0),              // 2: yandex.cloud.mdb.redis.v1.Cluster.Status
	(Cluster_PersistenceMode)(0),     // 3: yandex.cloud.mdb.redis.v1.Cluster.PersistenceMode
	(Host_Role)(0),                   // 4: yandex.cloud.mdb.redis.v1.Host.Role
	(Host_Health)(0),                 // 5: yandex.cloud.mdb.redis.v1.Host.Health
	(Service_Type)(0),                // 6: yandex.cloud.mdb.redis.v1.Service.Type
	(Service_Health)(0),              // 7: yandex.cloud.mdb.redis.v1.Service.Health
	(*Cluster)(nil),                  // 8: yandex.cloud.mdb.redis.v1.Cluster
	(*Monitoring)(nil),               // 9: yandex.cloud.mdb.redis.v1.Monitoring
	(*ClusterConfig)(nil),            // 10: yandex.cloud.mdb.redis.v1.ClusterConfig
	(*Shard)(nil),                    // 11: yandex.cloud.mdb.redis.v1.Shard
	(*Host)(nil),                     // 12: yandex.cloud.mdb.redis.v1.Host
	(*Service)(nil),                  // 13: yandex.cloud.mdb.redis.v1.Service
	(*Resources)(nil),                // 14: yandex.cloud.mdb.redis.v1.Resources
	(*Access)(nil),                   // 15: yandex.cloud.mdb.redis.v1.Access
	(*DiskSizeAutoscaling)(nil),      // 16: yandex.cloud.mdb.redis.v1.DiskSizeAutoscaling
	nil,                              // 17: yandex.cloud.mdb.redis.v1.Cluster.LabelsEntry
	(*timestamppb.Timestamp)(nil),    // 18: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),        // 19: yandex.cloud.mdb.redis.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),     // 20: yandex.cloud.mdb.redis.v1.MaintenanceOperation
	(*wrapperspb.StringValue)(nil),   // 21: google.protobuf.StringValue
	(*config.RedisConfigSet5_0)(nil), // 22: yandex.cloud.mdb.redis.v1.config.RedisConfigSet5_0
	(*config.RedisConfigSet6_0)(nil), // 23: yandex.cloud.mdb.redis.v1.config.RedisConfigSet6_0
	(*config.RedisConfigSet6_2)(nil), // 24: yandex.cloud.mdb.redis.v1.config.RedisConfigSet6_2
	(*config.RedisConfigSet7_0)(nil), // 25: yandex.cloud.mdb.redis.v1.config.RedisConfigSet7_0
	(*timeofday.TimeOfDay)(nil),      // 26: google.type.TimeOfDay
	(*config.RedisConfigSet)(nil),    // 27: yandex.cloud.mdb.redis.v1.config.RedisConfigSet
	(*wrapperspb.Int64Value)(nil),    // 28: google.protobuf.Int64Value
}
var file_yandex_cloud_mdb_redis_v1_cluster_proto_depIdxs = []int32{
	18, // 0: yandex.cloud.mdb.redis.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	17, // 1: yandex.cloud.mdb.redis.v1.Cluster.labels:type_name -> yandex.cloud.mdb.redis.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.redis.v1.Cluster.environment:type_name -> yandex.cloud.mdb.redis.v1.Cluster.Environment
	9,  // 3: yandex.cloud.mdb.redis.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.redis.v1.Monitoring
	10, // 4: yandex.cloud.mdb.redis.v1.Cluster.config:type_name -> yandex.cloud.mdb.redis.v1.ClusterConfig
	1,  // 5: yandex.cloud.mdb.redis.v1.Cluster.health:type_name -> yandex.cloud.mdb.redis.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.redis.v1.Cluster.status:type_name -> yandex.cloud.mdb.redis.v1.Cluster.Status
	19, // 7: yandex.cloud.mdb.redis.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.redis.v1.MaintenanceWindow
	20, // 8: yandex.cloud.mdb.redis.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.redis.v1.MaintenanceOperation
	3,  // 9: yandex.cloud.mdb.redis.v1.Cluster.persistence_mode:type_name -> yandex.cloud.mdb.redis.v1.Cluster.PersistenceMode
	21, // 10: yandex.cloud.mdb.redis.v1.Cluster.disk_encryption_key_id:type_name -> google.protobuf.StringValue
	22, // 11: yandex.cloud.mdb.redis.v1.ClusterConfig.redis_config_5_0:type_name -> yandex.cloud.mdb.redis.v1.config.RedisConfigSet5_0
	23, // 12: yandex.cloud.mdb.redis.v1.ClusterConfig.redis_config_6_0:type_name -> yandex.cloud.mdb.redis.v1.config.RedisConfigSet6_0
	24, // 13: yandex.cloud.mdb.redis.v1.ClusterConfig.redis_config_6_2:type_name -> yandex.cloud.mdb.redis.v1.config.RedisConfigSet6_2
	25, // 14: yandex.cloud.mdb.redis.v1.ClusterConfig.redis_config_7_0:type_name -> yandex.cloud.mdb.redis.v1.config.RedisConfigSet7_0
	14, // 15: yandex.cloud.mdb.redis.v1.ClusterConfig.resources:type_name -> yandex.cloud.mdb.redis.v1.Resources
	26, // 16: yandex.cloud.mdb.redis.v1.ClusterConfig.backup_window_start:type_name -> google.type.TimeOfDay
	15, // 17: yandex.cloud.mdb.redis.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.redis.v1.Access
	27, // 18: yandex.cloud.mdb.redis.v1.ClusterConfig.redis:type_name -> yandex.cloud.mdb.redis.v1.config.RedisConfigSet
	16, // 19: yandex.cloud.mdb.redis.v1.ClusterConfig.disk_size_autoscaling:type_name -> yandex.cloud.mdb.redis.v1.DiskSizeAutoscaling
	28, // 20: yandex.cloud.mdb.redis.v1.ClusterConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	14, // 21: yandex.cloud.mdb.redis.v1.Host.resources:type_name -> yandex.cloud.mdb.redis.v1.Resources
	4,  // 22: yandex.cloud.mdb.redis.v1.Host.role:type_name -> yandex.cloud.mdb.redis.v1.Host.Role
	5,  // 23: yandex.cloud.mdb.redis.v1.Host.health:type_name -> yandex.cloud.mdb.redis.v1.Host.Health
	13, // 24: yandex.cloud.mdb.redis.v1.Host.services:type_name -> yandex.cloud.mdb.redis.v1.Service
	28, // 25: yandex.cloud.mdb.redis.v1.Host.replica_priority:type_name -> google.protobuf.Int64Value
	6,  // 26: yandex.cloud.mdb.redis.v1.Service.type:type_name -> yandex.cloud.mdb.redis.v1.Service.Type
	7,  // 27: yandex.cloud.mdb.redis.v1.Service.health:type_name -> yandex.cloud.mdb.redis.v1.Service.Health
	28, // 28: yandex.cloud.mdb.redis.v1.DiskSizeAutoscaling.planned_usage_threshold:type_name -> google.protobuf.Int64Value
	28, // 29: yandex.cloud.mdb.redis.v1.DiskSizeAutoscaling.emergency_usage_threshold:type_name -> google.protobuf.Int64Value
	28, // 30: yandex.cloud.mdb.redis.v1.DiskSizeAutoscaling.disk_size_limit:type_name -> google.protobuf.Int64Value
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_redis_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_redis_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_redis_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_redis_v1_maintenance_proto_init()
	file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes[2].OneofWrappers = []any{
		(*ClusterConfig_RedisConfig_5_0)(nil),
		(*ClusterConfig_RedisConfig_6_0)(nil),
		(*ClusterConfig_RedisConfig_6_2)(nil),
		(*ClusterConfig_RedisConfig_7_0)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_redis_v1_cluster_proto_rawDesc)),
			NumEnums:      8,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_redis_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_redis_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_redis_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_redis_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_redis_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_redis_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_redis_v1_cluster_proto_depIdxs = nil
}
