// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/resourcemanager/v1/folder_service.proto

package resourcemanager

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetFolderRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Folder resource to return.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId      string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFolderRequest) Reset() {
	*x = GetFolderRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFolderRequest) ProtoMessage() {}

func (x *GetFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFolderRequest.ProtoReflect.Descriptor instead.
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetFolderRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

type ListFoldersRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud to list folders in.
	// To get the cloud ID, use a [yandex.cloud.resourcemanager.v1.CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListFoldersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListFoldersResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Folder.name] field.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	Filter        string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFoldersRequest) Reset() {
	*x = ListFoldersRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFoldersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFoldersRequest) ProtoMessage() {}

func (x *ListFoldersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFoldersRequest.ProtoReflect.Descriptor instead.
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListFoldersRequest) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *ListFoldersRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFoldersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFoldersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListFoldersResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of Folder resources.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListFoldersRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListFoldersRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFoldersResponse) Reset() {
	*x = ListFoldersResponse{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFoldersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFoldersResponse) ProtoMessage() {}

func (x *ListFoldersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFoldersResponse.ProtoReflect.Descriptor instead.
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListFoldersResponse) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *ListFoldersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateFolderRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud to create a folder in.
	// To get the cloud ID, use a [yandex.cloud.resourcemanager.v1.CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// Name of the folder.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the folder.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as “ key:value “ pairs.
	Labels        map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateFolderRequest) Reset() {
	*x = CreateFolderRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFolderRequest) ProtoMessage() {}

func (x *CreateFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFolderRequest.ProtoReflect.Descriptor instead.
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateFolderRequest) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *CreateFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateFolderRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateFolderRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type CreateFolderMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder that is being created.
	FolderId      string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateFolderMetadata) Reset() {
	*x = CreateFolderMetadata{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFolderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFolderMetadata) ProtoMessage() {}

func (x *CreateFolderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFolderMetadata.ProtoReflect.Descriptor instead.
func (*CreateFolderMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateFolderMetadata) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

type UpdateFolderRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Folder resource to update.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Field mask that specifies which fields of the Folder resource are going to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the folder.
	// The name must be unique within the cloud.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the folder.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as “ key:value “ pairs.
	Labels        map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateFolderRequest) Reset() {
	*x = UpdateFolderRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFolderRequest) ProtoMessage() {}

func (x *UpdateFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFolderRequest.ProtoReflect.Descriptor instead.
func (*UpdateFolderRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateFolderRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *UpdateFolderRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateFolderRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateFolderRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type UpdateFolderMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Folder resource that is being updated.
	FolderId      string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateFolderMetadata) Reset() {
	*x = UpdateFolderMetadata{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFolderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFolderMetadata) ProtoMessage() {}

func (x *UpdateFolderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFolderMetadata.ProtoReflect.Descriptor instead.
func (*UpdateFolderMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateFolderMetadata) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

type DeleteFolderRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to delete.
	// To get the folder ID, use a [FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The timestamp after which the process of deleting the folder should begin.
	// Until this timestamp, the folder goes into the [Folder.Status.PENDING_DELETION] state and all resources in this
	// folder are stopped. In this state, it is possible to cancel the delete operation without any loss.
	// After this timestamp, the status of the folder will become [Folder.Status.DELETING] and the process of deleting
	// all the resources  of the folder will be started. If [delete_after] is not specified it will be
	// (now + 24 hours). To initiate an immediate deletion [delete_after] must be <= now.
	DeleteAfter   *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=delete_after,json=deleteAfter,proto3" json:"delete_after,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteFolderRequest) Reset() {
	*x = DeleteFolderRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFolderRequest) ProtoMessage() {}

func (x *DeleteFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFolderRequest.ProtoReflect.Descriptor instead.
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteFolderRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *DeleteFolderRequest) GetDeleteAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteAfter
	}
	return nil
}

type DeleteFolderMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder that is being deleted.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The timestamp after which the process of deleting the folder should begin.
	DeleteAfter *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=delete_after,json=deleteAfter,proto3" json:"delete_after,omitempty"`
	// Information about operation cancellation
	CancelledBy   string                 `protobuf:"bytes,3,opt,name=cancelled_by,json=cancelledBy,proto3" json:"cancelled_by,omitempty"`
	CancelledAt   *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=cancelled_at,json=cancelledAt,proto3" json:"cancelled_at,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteFolderMetadata) Reset() {
	*x = DeleteFolderMetadata{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFolderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFolderMetadata) ProtoMessage() {}

func (x *DeleteFolderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFolderMetadata.ProtoReflect.Descriptor instead.
func (*DeleteFolderMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteFolderMetadata) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *DeleteFolderMetadata) GetDeleteAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteAfter
	}
	return nil
}

func (x *DeleteFolderMetadata) GetCancelledBy() string {
	if x != nil {
		return x.CancelledBy
	}
	return ""
}

func (x *DeleteFolderMetadata) GetCancelledAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelledAt
	}
	return nil
}

type ListFolderOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Folder resource to list operations for.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListFolderOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListFolderOperationsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFolderOperationsRequest) Reset() {
	*x = ListFolderOperationsRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFolderOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFolderOperationsRequest) ProtoMessage() {}

func (x *ListFolderOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFolderOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListFolderOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListFolderOperationsRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListFolderOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFolderOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListFolderOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified folder.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListFolderOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListFolderOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListFolderOperationsResponse) Reset() {
	*x = ListFolderOperationsResponse{}
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFolderOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFolderOperationsResponse) ProtoMessage() {}

func (x *ListFolderOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFolderOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListFolderOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListFolderOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListFolderOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_resourcemanager_v1_folder_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDesc = "" +
	"\n" +
	"4yandex/cloud/resourcemanager/v1/folder_service.proto\x12\x1fyandex.cloud.resourcemanager.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a yandex/cloud/api/operation.proto\x1a,yandex/cloud/resourcemanager/v1/folder.proto\x1a yandex/cloud/access/access.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\"=\n" +
	"\x10GetFolderRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\"\xb5\x01\n" +
	"\x12ListFoldersRequest\x12'\n" +
	"\bcloud_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\acloudId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12)\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\n" +
	"\x8a\xc81\x06<=2000R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\"\x80\x01\n" +
	"\x13ListFoldersResponse\x12A\n" +
	"\afolders\x18\x01 \x03(\v2'.yandex.cloud.resourcemanager.v1.FolderR\afolders\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xf9\x02\n" +
	"\x13CreateFolderRequest\x12'\n" +
	"\bcloud_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\acloudId\x129\n" +
	"\x04name\x18\x02 \x01(\tB%\xe8\xc71\x01\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x95\x01\n" +
	"\x06labels\x18\x04 \x03(\v2@.yandex.cloud.resourcemanager.v1.CreateFolderRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"3\n" +
	"\x14CreateFolderMetadata\x12\x1b\n" +
	"\tfolder_id\x18\x01 \x01(\tR\bfolderId\"\xb8\x03\n" +
	"\x13UpdateFolderRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x129\n" +
	"\x04name\x18\x03 \x01(\tB%\xe8\xc71\x01\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x95\x01\n" +
	"\x06labels\x18\x05 \x03(\v2@.yandex.cloud.resourcemanager.v1.UpdateFolderRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"3\n" +
	"\x14UpdateFolderMetadata\x12\x1b\n" +
	"\tfolder_id\x18\x01 \x01(\tR\bfolderId\"\x7f\n" +
	"\x13DeleteFolderRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12=\n" +
	"\fdelete_after\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\vdeleteAfter\"\xd4\x01\n" +
	"\x14DeleteFolderMetadata\x12\x1b\n" +
	"\tfolder_id\x18\x01 \x01(\tR\bfolderId\x12=\n" +
	"\fdelete_after\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\vdeleteAfter\x12!\n" +
	"\fcancelled_by\x18\x03 \x01(\tR\vcancelledBy\x12=\n" +
	"\fcancelled_at\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\vcancelledAt\"\x9c\x01\n" +
	"\x1bListFolderOperationsRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12)\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\n" +
	"\x8a\xc81\x06<=2000R\tpageToken\"\x89\x01\n" +
	"\x1cListFolderOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\x84\x0e\n" +
	"\rFolderService\x12\x93\x01\n" +
	"\x03Get\x121.yandex.cloud.resourcemanager.v1.GetFolderRequest\x1a'.yandex.cloud.resourcemanager.v1.Folder\"0\x82\xd3\xe4\x93\x02*\x12(/resource-manager/v1/folders/{folder_id}\x12\x97\x01\n" +
	"\x04List\x123.yandex.cloud.resourcemanager.v1.ListFoldersRequest\x1a4.yandex.cloud.resourcemanager.v1.ListFoldersResponse\"$\x82\xd3\xe4\x93\x02\x1e\x12\x1c/resource-manager/v1/folders\x12\xac\x01\n" +
	"\x06Create\x124.yandex.cloud.resourcemanager.v1.CreateFolderRequest\x1a!.yandex.cloud.operation.Operation\"I\xb2\xd2*\x1e\n" +
	"\x14CreateFolderMetadata\x12\x06Folder\x82\xd3\xe4\x93\x02!:\x01*\"\x1c/resource-manager/v1/folders\x12\xb8\x01\n" +
	"\x06Update\x124.yandex.cloud.resourcemanager.v1.UpdateFolderRequest\x1a!.yandex.cloud.operation.Operation\"U\xb2\xd2*\x1e\n" +
	"\x14UpdateFolderMetadata\x12\x06Folder\x82\xd3\xe4\x93\x02-:\x01*2(/resource-manager/v1/folders/{folder_id}\x12\xc4\x01\n" +
	"\x06Delete\x124.yandex.cloud.resourcemanager.v1.DeleteFolderRequest\x1a!.yandex.cloud.operation.Operation\"a\xb2\xd2*-\n" +
	"\x14DeleteFolderMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02**(/resource-manager/v1/folders/{folder_id}\x12\xca\x01\n" +
	"\x0eListOperations\x12<.yandex.cloud.resourcemanager.v1.ListFolderOperationsRequest\x1a=.yandex.cloud.resourcemanager.v1.ListFolderOperationsResponse\";\x82\xd3\xe4\x93\x025\x123/resource-manager/v1/folders/{folder_id}/operations\x12\xbc\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\"E\x82\xd3\xe4\x93\x02?\x12=/resource-manager/v1/folders/{resource_id}:listAccessBindings\x12\xfb\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x93\x01\xb2\xd2*H\n" +
	" access.SetAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02A:\x01*\"</resource-manager/v1/folders/{resource_id}:setAccessBindings\x12\x87\x02\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x99\x01\xb2\xd2*K\n" +
	"#access.UpdateAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02D:\x01*\"?/resource-manager/v1/folders/{resource_id}:updateAccessBindingsBz\n" +
	"#yandex.cloud.api.resourcemanager.v1ZSgithub.com/yandex-cloud/go-genproto/yandex/cloud/resourcemanager/v1;resourcemanagerb\x06proto3"

var (
	file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescData []byte
)

func file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDesc), len(file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDesc)))
	})
	return file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDescData
}

var file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_resourcemanager_v1_folder_service_proto_goTypes = []any{
	(*GetFolderRequest)(nil),                   // 0: yandex.cloud.resourcemanager.v1.GetFolderRequest
	(*ListFoldersRequest)(nil),                 // 1: yandex.cloud.resourcemanager.v1.ListFoldersRequest
	(*ListFoldersResponse)(nil),                // 2: yandex.cloud.resourcemanager.v1.ListFoldersResponse
	(*CreateFolderRequest)(nil),                // 3: yandex.cloud.resourcemanager.v1.CreateFolderRequest
	(*CreateFolderMetadata)(nil),               // 4: yandex.cloud.resourcemanager.v1.CreateFolderMetadata
	(*UpdateFolderRequest)(nil),                // 5: yandex.cloud.resourcemanager.v1.UpdateFolderRequest
	(*UpdateFolderMetadata)(nil),               // 6: yandex.cloud.resourcemanager.v1.UpdateFolderMetadata
	(*DeleteFolderRequest)(nil),                // 7: yandex.cloud.resourcemanager.v1.DeleteFolderRequest
	(*DeleteFolderMetadata)(nil),               // 8: yandex.cloud.resourcemanager.v1.DeleteFolderMetadata
	(*ListFolderOperationsRequest)(nil),        // 9: yandex.cloud.resourcemanager.v1.ListFolderOperationsRequest
	(*ListFolderOperationsResponse)(nil),       // 10: yandex.cloud.resourcemanager.v1.ListFolderOperationsResponse
	nil,                                        // 11: yandex.cloud.resourcemanager.v1.CreateFolderRequest.LabelsEntry
	nil,                                        // 12: yandex.cloud.resourcemanager.v1.UpdateFolderRequest.LabelsEntry
	(*Folder)(nil),                             // 13: yandex.cloud.resourcemanager.v1.Folder
	(*fieldmaskpb.FieldMask)(nil),              // 14: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),              // 15: google.protobuf.Timestamp
	(*operation.Operation)(nil),                // 16: yandex.cloud.operation.Operation
	(*access.ListAccessBindingsRequest)(nil),   // 17: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),    // 18: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil), // 19: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessBindingsResponse)(nil),  // 20: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_resourcemanager_v1_folder_service_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.resourcemanager.v1.ListFoldersResponse.folders:type_name -> yandex.cloud.resourcemanager.v1.Folder
	11, // 1: yandex.cloud.resourcemanager.v1.CreateFolderRequest.labels:type_name -> yandex.cloud.resourcemanager.v1.CreateFolderRequest.LabelsEntry
	14, // 2: yandex.cloud.resourcemanager.v1.UpdateFolderRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 3: yandex.cloud.resourcemanager.v1.UpdateFolderRequest.labels:type_name -> yandex.cloud.resourcemanager.v1.UpdateFolderRequest.LabelsEntry
	15, // 4: yandex.cloud.resourcemanager.v1.DeleteFolderRequest.delete_after:type_name -> google.protobuf.Timestamp
	15, // 5: yandex.cloud.resourcemanager.v1.DeleteFolderMetadata.delete_after:type_name -> google.protobuf.Timestamp
	15, // 6: yandex.cloud.resourcemanager.v1.DeleteFolderMetadata.cancelled_at:type_name -> google.protobuf.Timestamp
	16, // 7: yandex.cloud.resourcemanager.v1.ListFolderOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	0,  // 8: yandex.cloud.resourcemanager.v1.FolderService.Get:input_type -> yandex.cloud.resourcemanager.v1.GetFolderRequest
	1,  // 9: yandex.cloud.resourcemanager.v1.FolderService.List:input_type -> yandex.cloud.resourcemanager.v1.ListFoldersRequest
	3,  // 10: yandex.cloud.resourcemanager.v1.FolderService.Create:input_type -> yandex.cloud.resourcemanager.v1.CreateFolderRequest
	5,  // 11: yandex.cloud.resourcemanager.v1.FolderService.Update:input_type -> yandex.cloud.resourcemanager.v1.UpdateFolderRequest
	7,  // 12: yandex.cloud.resourcemanager.v1.FolderService.Delete:input_type -> yandex.cloud.resourcemanager.v1.DeleteFolderRequest
	9,  // 13: yandex.cloud.resourcemanager.v1.FolderService.ListOperations:input_type -> yandex.cloud.resourcemanager.v1.ListFolderOperationsRequest
	17, // 14: yandex.cloud.resourcemanager.v1.FolderService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	18, // 15: yandex.cloud.resourcemanager.v1.FolderService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	19, // 16: yandex.cloud.resourcemanager.v1.FolderService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	13, // 17: yandex.cloud.resourcemanager.v1.FolderService.Get:output_type -> yandex.cloud.resourcemanager.v1.Folder
	2,  // 18: yandex.cloud.resourcemanager.v1.FolderService.List:output_type -> yandex.cloud.resourcemanager.v1.ListFoldersResponse
	16, // 19: yandex.cloud.resourcemanager.v1.FolderService.Create:output_type -> yandex.cloud.operation.Operation
	16, // 20: yandex.cloud.resourcemanager.v1.FolderService.Update:output_type -> yandex.cloud.operation.Operation
	16, // 21: yandex.cloud.resourcemanager.v1.FolderService.Delete:output_type -> yandex.cloud.operation.Operation
	10, // 22: yandex.cloud.resourcemanager.v1.FolderService.ListOperations:output_type -> yandex.cloud.resourcemanager.v1.ListFolderOperationsResponse
	20, // 23: yandex.cloud.resourcemanager.v1.FolderService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	16, // 24: yandex.cloud.resourcemanager.v1.FolderService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	16, // 25: yandex.cloud.resourcemanager.v1.FolderService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	17, // [17:26] is the sub-list for method output_type
	8,  // [8:17] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_yandex_cloud_resourcemanager_v1_folder_service_proto_init() }
func file_yandex_cloud_resourcemanager_v1_folder_service_proto_init() {
	if File_yandex_cloud_resourcemanager_v1_folder_service_proto != nil {
		return
	}
	file_yandex_cloud_resourcemanager_v1_folder_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDesc), len(file_yandex_cloud_resourcemanager_v1_folder_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_resourcemanager_v1_folder_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_resourcemanager_v1_folder_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_resourcemanager_v1_folder_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_resourcemanager_v1_folder_service_proto = out.File
	file_yandex_cloud_resourcemanager_v1_folder_service_proto_goTypes = nil
	file_yandex_cloud_resourcemanager_v1_folder_service_proto_depIdxs = nil
}
