/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.state.ExecutingTest;

public final class RecordPhase
extends TestOnlyPhase {
    RecordPhase(@Nonnull RecordAndReplayExecution recordAndReplay) {
        super(recordAndReplay);
    }

    void addResult(@Nullable Object result) {
        if (this.currentExpectation != null) {
            this.currentExpectation.addResult(result);
        }
    }

    public void addSequenceOfReturnValues(@Nonnull Object[] values) {
        if (this.currentExpectation != null) {
            this.currentExpectation.addSequenceOfReturnValues(values);
        }
    }

    @Override
    @Nullable
    Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) {
        mock = this.configureMatchingOnMockInstanceIfSpecified(mock);
        ExpectedInvocation invocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, this.matchInstance, genericSignature, args);
        boolean nonStrictInvocation = false;
        if (!this.matchInstance && invocation.isConstructor()) {
            Map<Object, Object> replacementMap = this.getReplacementMap();
            replacementMap.put(mock, mock);
        } else {
            nonStrictInvocation = ExecutingTest.isInstanceMethodWithStandardBehavior(mock, mockNameAndDesc);
        }
        this.currentExpectation = new Expectation(this, invocation, nonStrictInvocation);
        if (this.argMatchers != null) {
            invocation.arguments.setMatchers(this.argMatchers);
            this.argMatchers = null;
        }
        this.recordAndReplay.executionState.addExpectation(this.currentExpectation);
        return invocation.getDefaultValueForReturnType();
    }

    @Nullable
    private Object configureMatchingOnMockInstanceIfSpecified(@Nullable Object mock) {
        this.matchInstance = false;
        if (mock == null) {
            return null;
        }
        Map<Object, Object> replacementMap = this.getReplacementMap();
        Object replacementInstance = replacementMap.get(mock);
        this.matchInstance = mock == replacementInstance || RecordPhase.isEnumElement(mock);
        return mock;
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        if (this.currentExpectation != null) {
            this.currentExpectation.constraints.setLimits(minInvocations, maxInvocations);
        }
    }
}

