/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.types;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.types.ReferenceType;

public final class ObjectType
extends ReferenceType {
    @Nonnull
    public static ObjectType create(@Nonnull String internalName) {
        return new ObjectType(internalName.toCharArray());
    }

    @Nonnull
    static ObjectType create(@Nonnull char[] typeDesc, @Nonnegative int off) {
        int len = ObjectType.findTypeNameLength(typeDesc, off, 0);
        return new ObjectType(typeDesc, off + 1, len - 1);
    }

    private ObjectType(@Nonnull char[] typeDesc, @Nonnegative int off, @Nonnegative int len) {
        super(typeDesc, off, len);
    }

    ObjectType(@Nonnull char[] internalName) {
        super(internalName);
    }

    @Override
    void getDescriptor(@Nonnull StringBuilder typeDesc) {
        typeDesc.append('L');
        super.getDescriptor(typeDesc);
        typeDesc.append(';');
    }

    @Override
    @Nonnull
    public String getClassName() {
        return this.getInternalName().replace('/', '.');
    }
}

