/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.util.TestMethod;

public final class ParameterTypeRedefinitions
extends TypeRedefinitions {
    @Nonnull
    private final TestMethod testMethod;
    @Nonnull
    private final MockedType[] mockParameters;
    @Nonnull
    private final List<MockedType> injectableParameters;

    public ParameterTypeRedefinitions(@Nonnull TestMethod testMethod, @Nonnull Object[] parameterValues) {
        this.testMethod = testMethod;
        int n = testMethod.getParameterCount();
        this.mockParameters = new MockedType[n];
        this.injectableParameters = new ArrayList<MockedType>(n);
        for (int i = 0; i < n; ++i) {
            Object mock = parameterValues[i];
            this.createMockedTypeFromMockParameterDeclaration(i, mock);
        }
        InstanceFactory[] instanceFactories = this.redefineMockedTypes();
        this.instantiateMockedTypes(instanceFactories);
    }

    private void createMockedTypeFromMockParameterDeclaration(@Nonnegative int parameterIndex, @Nullable Object mock) {
        Class<?> parameterImplementationClass;
        Annotation[] annotationsOnParameter;
        Type parameterType = this.testMethod.getParameterType(parameterIndex);
        MockedType mockedType = new MockedType(this.testMethod, parameterIndex, parameterType, annotationsOnParameter = this.testMethod.getParameterAnnotations(parameterIndex), parameterImplementationClass = mock == null ? null : mock.getClass());
        if (mockedType.isMockableType()) {
            this.mockParameters[parameterIndex] = mockedType;
        }
        if (mockedType.injectable) {
            this.injectableParameters.add(mockedType);
            this.testMethod.setParameterValue(parameterIndex, mockedType.providedValue);
        }
    }

    @Nonnull
    private InstanceFactory[] redefineMockedTypes() {
        int n = this.mockParameters.length;
        InstanceFactory[] instanceFactories = new InstanceFactory[n];
        for (int i = 0; i < n; ++i) {
            MockedType mockedType = this.mockParameters[i];
            if (mockedType == null) continue;
            instanceFactories[i] = this.redefineMockedType(mockedType);
        }
        return instanceFactories;
    }

    @Nullable
    private InstanceFactory redefineMockedType(@Nonnull MockedType mockedType) {
        TypeRedefinition typeRedefinition = new TypeRedefinition(mockedType);
        InstanceFactory instanceFactory = typeRedefinition.redefineType();
        if (instanceFactory != null) {
            this.addTargetClass(mockedType);
        }
        return instanceFactory;
    }

    private void registerCaptureOfNewInstances(@Nonnull MockedType mockedType) {
        if (this.captureOfNewInstances == null) {
            this.captureOfNewInstances = new CaptureOfNewInstances();
        }
        this.captureOfNewInstances.registerCaptureOfNewInstances(mockedType);
        this.captureOfNewInstances.makeSureAllSubtypesAreModified(mockedType);
    }

    private void instantiateMockedTypes(@Nonnull InstanceFactory[] instanceFactories) {
        for (int paramIndex = 0; paramIndex < instanceFactories.length; ++paramIndex) {
            InstanceFactory instanceFactory = instanceFactories[paramIndex];
            if (instanceFactory == null) continue;
            MockedType mockedType = this.mockParameters[paramIndex];
            Object mockedInstance = this.instantiateMockedType(mockedType, instanceFactory, paramIndex);
            this.testMethod.setParameterValue(paramIndex, mockedInstance);
            mockedType.providedValue = mockedInstance;
        }
    }

    @Nonnull
    private Object instantiateMockedType(@Nonnull MockedType mockedType, @Nonnull InstanceFactory instanceFactory, @Nonnegative int paramIndex) {
        Object mock = this.testMethod.getParameterValue(paramIndex);
        if (mock == null) {
            mock = instanceFactory.create();
        }
        ParameterTypeRedefinitions.registerMock(mockedType, mock);
        if (mockedType.withInstancesToCapture()) {
            this.registerCaptureOfNewInstances(mockedType);
        }
        return mock;
    }

    @Nonnull
    public List<MockedType> getInjectableParameters() {
        return this.injectableParameters;
    }
}

