/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.faking.FakeState;
import mockit.internal.util.ClassLoad;

public final class FakeStates {
    private static final Pattern SPACE = Pattern.compile(" ");
    @Nonnull
    private final Map<Object, List<FakeState>> fakesToFakeStates;
    @Nonnull
    private final Map<Object, List<FakeState>> startupFakesToFakeStates = new IdentityHashMap<Object, List<FakeState>>(2);

    FakeStates() {
        this.fakesToFakeStates = new IdentityHashMap<Object, List<FakeState>>(8);
    }

    void addStartupFakeAndItsFakeStates(@Nonnull Object fake, @Nonnull List<FakeState> fakeStates) {
        this.startupFakesToFakeStates.put(fake, fakeStates);
    }

    void addFakeAndItsFakeStates(@Nonnull Object fake, @Nonnull List<FakeState> fakeStates) {
        this.fakesToFakeStates.put(fake, fakeStates);
    }

    public void removeClassState(@Nonnull Class<?> redefinedClass, @Nullable String internalNameForOneOrMoreFakeClasses) {
        this.removeFakeStates(redefinedClass);
        if (internalNameForOneOrMoreFakeClasses != null) {
            if (internalNameForOneOrMoreFakeClasses.indexOf(32) < 0) {
                this.removeFakeStates(internalNameForOneOrMoreFakeClasses);
            } else {
                String[] fakeClassesInternalNames;
                for (String fakeClassInternalName : fakeClassesInternalNames = SPACE.split(internalNameForOneOrMoreFakeClasses)) {
                    this.removeFakeStates(fakeClassInternalName);
                }
            }
        }
    }

    private void removeFakeStates(@Nonnull Class<?> redefinedClass) {
        Iterator<List<FakeState>> itr = this.fakesToFakeStates.values().iterator();
        while (itr.hasNext()) {
            List<FakeState> fakeStates = itr.next();
            FakeState fakeState = fakeStates.get(0);
            if (fakeState.getRealClass() != redefinedClass) continue;
            fakeStates.clear();
            itr.remove();
        }
    }

    private void removeFakeStates(@Nonnull String fakeClassInternalName) {
        Class fakeClass = ClassLoad.loadClass(fakeClassInternalName.replace('/', '.'));
        Iterator<Map.Entry<Object, List<FakeState>>> itr = this.fakesToFakeStates.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, List<FakeState>> fakeAndFakeStates = itr.next();
            Object fake = fakeAndFakeStates.getKey();
            if (fake.getClass() != fakeClass) continue;
            itr.remove();
        }
    }

    public boolean updateFakeState(@Nonnull Object fake, @Nonnegative int fakeStateIndex) {
        FakeState fakeState = this.getFakeState(fake, fakeStateIndex);
        return fakeState.update();
    }

    @Nonnull
    FakeState getFakeState(@Nonnull Object fake, @Nonnegative int fakeStateIndex) {
        List<FakeState> fakeStates = this.startupFakesToFakeStates.get(fake);
        if (fakeStates == null) {
            fakeStates = this.fakesToFakeStates.get(fake);
        }
        FakeState fakeState = fakeStates.get(fakeStateIndex);
        assert (fakeState != null);
        return fakeState;
    }
}

