// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestFunction_MoveTo(t *testing.T) {
	ms := generateTestFunction()
	dest := NewFunction()
	ms.MoveTo(dest)
	assert.Equal(t, NewFunction(), ms)
	assert.Equal(t, generateTestFunction(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestFunction(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newFunction(internal.NewFunction(), sharedState)) })
	assert.Panics(t, func() { newFunction(internal.NewFunction(), sharedState).MoveTo(dest) })
}

func TestFunction_CopyTo(t *testing.T) {
	ms := NewFunction()
	orig := NewFunction()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestFunction()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newFunction(internal.NewFunction(), sharedState)) })
}

func TestFunction_NameStrindex(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int32(0), ms.NameStrindex())
	ms.SetNameStrindex(int32(13))
	assert.Equal(t, int32(13), ms.NameStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newFunction(internal.NewFunction(), sharedState).SetNameStrindex(int32(13)) })
}

func TestFunction_SystemNameStrindex(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int32(0), ms.SystemNameStrindex())
	ms.SetSystemNameStrindex(int32(13))
	assert.Equal(t, int32(13), ms.SystemNameStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newFunction(internal.NewFunction(), sharedState).SetSystemNameStrindex(int32(13)) })
}

func TestFunction_FilenameStrindex(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int32(0), ms.FilenameStrindex())
	ms.SetFilenameStrindex(int32(13))
	assert.Equal(t, int32(13), ms.FilenameStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newFunction(internal.NewFunction(), sharedState).SetFilenameStrindex(int32(13)) })
}

func TestFunction_StartLine(t *testing.T) {
	ms := NewFunction()
	assert.Equal(t, int64(0), ms.StartLine())
	ms.SetStartLine(int64(13))
	assert.Equal(t, int64(13), ms.StartLine())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newFunction(internal.NewFunction(), sharedState).SetStartLine(int64(13)) })
}

func generateTestFunction() Function {
	return newFunction(internal.GenTestFunction(), internal.NewState())
}
