/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package autoscaling

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/client-go/1.5/pkg/api"
	pkg1_unversioned "k8s.io/client-go/1.5/pkg/api/unversioned"
	pkg3_types "k8s.io/client-go/1.5/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.ObjectMeta
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.Spec
					yy13.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy14 := &x.Spec
					yy14.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.Status
					yy16.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym18 := z.DecBinary()
	_ = yym18
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct19 := r.ContainerType()
		if yyct19 == codecSelferValueTypeMap1234 {
			yyl19 := r.ReadMapStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl19, d)
			}
		} else if yyct19 == codecSelferValueTypeArray1234 {
			yyl19 := r.ReadArrayStart()
			if yyl19 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl19, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys20Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys20Slc
	var yyhl20 bool = l >= 0
	for yyj20 := 0; ; yyj20++ {
		if yyhl20 {
			if yyj20 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys20Slc = r.DecodeBytes(yys20Slc, true, true)
		yys20 := string(yys20Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys20 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv23 := &x.ObjectMeta
				yyv23.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv24 := &x.Spec
				yyv24.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv25 := &x.Status
				yyv25.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys20)
		} // end switch yys20
	} // end for yyj20
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv29 := &x.ObjectMeta
		yyv29.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv30 := &x.Spec
		yyv30.CodecDecodeSelf(d)
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv31 := &x.Status
		yyv31.CodecDecodeSelf(d)
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym32 := z.EncBinary()
		_ = yym32
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep33 := !z.EncBinary()
			yy2arr33 := z.EncBasicHandle().StructToArray
			var yyq33 [1]bool
			_, _, _ = yysep33, yyq33, yy2arr33
			const yyr33 bool = false
			yyq33[0] = x.Replicas != 0
			var yynn33 int
			if yyr33 || yy2arr33 {
				r.EncodeArrayStart(1)
			} else {
				yynn33 = 0
				for _, b := range yyq33 {
					if b {
						yynn33++
					}
				}
				r.EncodeMapStart(yynn33)
				yynn33 = 0
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq33[0] {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq33[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr33 || yy2arr33 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym37 := z.DecBinary()
	_ = yym37
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct38 := r.ContainerType()
		if yyct38 == codecSelferValueTypeMap1234 {
			yyl38 := r.ReadMapStart()
			if yyl38 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl38, d)
			}
		} else if yyct38 == codecSelferValueTypeArray1234 {
			yyl38 := r.ReadArrayStart()
			if yyl38 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl38, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys39Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys39Slc
	var yyhl39 bool = l >= 0
	for yyj39 := 0; ; yyj39++ {
		if yyhl39 {
			if yyj39 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys39Slc = r.DecodeBytes(yys39Slc, true, true)
		yys39 := string(yys39Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys39 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys39)
		} // end switch yys39
	} // end for yyj39
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj41 int
	var yyb41 bool
	var yyhl41 bool = l >= 0
	yyj41++
	if yyhl41 {
		yyb41 = yyj41 > l
	} else {
		yyb41 = r.CheckBreak()
	}
	if yyb41 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj41++
		if yyhl41 {
			yyb41 = yyj41 > l
		} else {
			yyb41 = r.CheckBreak()
		}
		if yyb41 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj41-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym43 := z.EncBinary()
		_ = yym43
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep44 := !z.EncBinary()
			yy2arr44 := z.EncBasicHandle().StructToArray
			var yyq44 [2]bool
			_, _, _ = yysep44, yyq44, yy2arr44
			const yyr44 bool = false
			yyq44[1] = x.Selector != ""
			var yynn44 int
			if yyr44 || yy2arr44 {
				r.EncodeArrayStart(2)
			} else {
				yynn44 = 1
				for _, b := range yyq44 {
					if b {
						yynn44++
					}
				}
				r.EncodeMapStart(yynn44)
				yynn44 = 0
			}
			if yyr44 || yy2arr44 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym47 := z.EncBinary()
				_ = yym47
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr44 || yy2arr44 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq44[1] {
					yym49 := z.EncBinary()
					_ = yym49
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Selector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq44[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Selector))
					}
				}
			}
			if yyr44 || yy2arr44 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym51 := z.DecBinary()
	_ = yym51
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct52 := r.ContainerType()
		if yyct52 == codecSelferValueTypeMap1234 {
			yyl52 := r.ReadMapStart()
			if yyl52 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl52, d)
			}
		} else if yyct52 == codecSelferValueTypeArray1234 {
			yyl52 := r.ReadArrayStart()
			if yyl52 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl52, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys53Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys53Slc
	var yyhl53 bool = l >= 0
	for yyj53 := 0; ; yyj53++ {
		if yyhl53 {
			if yyj53 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys53Slc = r.DecodeBytes(yys53Slc, true, true)
		yys53 := string(yys53Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys53 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = ""
			} else {
				x.Selector = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys53)
		} // end switch yys53
	} // end for yyj53
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj56 int
	var yyb56 bool
	var yyhl56 bool = l >= 0
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj56++
	if yyhl56 {
		yyb56 = yyj56 > l
	} else {
		yyb56 = r.CheckBreak()
	}
	if yyb56 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = ""
	} else {
		x.Selector = string(r.DecodeString())
	}
	for {
		yyj56++
		if yyhl56 {
			yyb56 = yyj56 > l
		} else {
			yyb56 = r.CheckBreak()
		}
		if yyb56 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj56-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CrossVersionObjectReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym59 := z.EncBinary()
		_ = yym59
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep60 := !z.EncBinary()
			yy2arr60 := z.EncBasicHandle().StructToArray
			var yyq60 [3]bool
			_, _, _ = yysep60, yyq60, yy2arr60
			const yyr60 bool = false
			yyq60[2] = x.APIVersion != ""
			var yynn60 int
			if yyr60 || yy2arr60 {
				r.EncodeArrayStart(3)
			} else {
				yynn60 = 2
				for _, b := range yyq60 {
					if b {
						yynn60++
					}
				}
				r.EncodeMapStart(yynn60)
				yynn60 = 0
			}
			if yyr60 || yy2arr60 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kind"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym63 := z.EncBinary()
				_ = yym63
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			}
			if yyr60 || yy2arr60 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym66 := z.EncBinary()
				_ = yym66
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr60 || yy2arr60 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq60[2] {
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq60[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym69 := z.EncBinary()
					_ = yym69
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr60 || yy2arr60 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CrossVersionObjectReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym70 := z.DecBinary()
	_ = yym70
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct71 := r.ContainerType()
		if yyct71 == codecSelferValueTypeMap1234 {
			yyl71 := r.ReadMapStart()
			if yyl71 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl71, d)
			}
		} else if yyct71 == codecSelferValueTypeArray1234 {
			yyl71 := r.ReadArrayStart()
			if yyl71 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl71, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CrossVersionObjectReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys72Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys72Slc
	var yyhl72 bool = l >= 0
	for yyj72 := 0; ; yyj72++ {
		if yyhl72 {
			if yyj72 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys72Slc = r.DecodeBytes(yys72Slc, true, true)
		yys72 := string(yys72Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys72 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys72)
		} // end switch yys72
	} // end for yyj72
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CrossVersionObjectReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj76 int
	var yyb76 bool
	var yyhl76 bool = l >= 0
	yyj76++
	if yyhl76 {
		yyb76 = yyj76 > l
	} else {
		yyb76 = r.CheckBreak()
	}
	if yyb76 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj76++
	if yyhl76 {
		yyb76 = yyj76 > l
	} else {
		yyb76 = r.CheckBreak()
	}
	if yyb76 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj76++
	if yyhl76 {
		yyb76 = yyj76 > l
	} else {
		yyb76 = r.CheckBreak()
	}
	if yyb76 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj76++
		if yyhl76 {
			yyb76 = yyj76 > l
		} else {
			yyb76 = r.CheckBreak()
		}
		if yyb76 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj76-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym80 := z.EncBinary()
		_ = yym80
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep81 := !z.EncBinary()
			yy2arr81 := z.EncBasicHandle().StructToArray
			var yyq81 [4]bool
			_, _, _ = yysep81, yyq81, yy2arr81
			const yyr81 bool = false
			yyq81[1] = x.MinReplicas != nil
			yyq81[3] = x.TargetCPUUtilizationPercentage != nil
			var yynn81 int
			if yyr81 || yy2arr81 {
				r.EncodeArrayStart(4)
			} else {
				yynn81 = 2
				for _, b := range yyq81 {
					if b {
						yynn81++
					}
				}
				r.EncodeMapStart(yynn81)
				yynn81 = 0
			}
			if yyr81 || yy2arr81 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy83 := &x.ScaleTargetRef
				yy83.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("scaleTargetRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy84 := &x.ScaleTargetRef
				yy84.CodecEncodeSelf(e)
			}
			if yyr81 || yy2arr81 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq81[1] {
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy86 := *x.MinReplicas
						yym87 := z.EncBinary()
						_ = yym87
						if false {
						} else {
							r.EncodeInt(int64(yy86))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq81[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy88 := *x.MinReplicas
						yym89 := z.EncBinary()
						_ = yym89
						if false {
						} else {
							r.EncodeInt(int64(yy88))
						}
					}
				}
			}
			if yyr81 || yy2arr81 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym91 := z.EncBinary()
				_ = yym91
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym92 := z.EncBinary()
				_ = yym92
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			}
			if yyr81 || yy2arr81 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq81[3] {
					if x.TargetCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy94 := *x.TargetCPUUtilizationPercentage
						yym95 := z.EncBinary()
						_ = yym95
						if false {
						} else {
							r.EncodeInt(int64(yy94))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq81[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TargetCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy96 := *x.TargetCPUUtilizationPercentage
						yym97 := z.EncBinary()
						_ = yym97
						if false {
						} else {
							r.EncodeInt(int64(yy96))
						}
					}
				}
			}
			if yyr81 || yy2arr81 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym98 := z.DecBinary()
	_ = yym98
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct99 := r.ContainerType()
		if yyct99 == codecSelferValueTypeMap1234 {
			yyl99 := r.ReadMapStart()
			if yyl99 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl99, d)
			}
		} else if yyct99 == codecSelferValueTypeArray1234 {
			yyl99 := r.ReadArrayStart()
			if yyl99 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl99, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys100Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys100Slc
	var yyhl100 bool = l >= 0
	for yyj100 := 0; ; yyj100++ {
		if yyhl100 {
			if yyj100 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys100Slc = r.DecodeBytes(yys100Slc, true, true)
		yys100 := string(yys100Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys100 {
		case "scaleTargetRef":
			if r.TryDecodeAsNil() {
				x.ScaleTargetRef = CrossVersionObjectReference{}
			} else {
				yyv101 := &x.ScaleTargetRef
				yyv101.CodecDecodeSelf(d)
			}
		case "minReplicas":
			if r.TryDecodeAsNil() {
				if x.MinReplicas != nil {
					x.MinReplicas = nil
				}
			} else {
				if x.MinReplicas == nil {
					x.MinReplicas = new(int32)
				}
				yym103 := z.DecBinary()
				_ = yym103
				if false {
				} else {
					*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
				}
			}
		case "maxReplicas":
			if r.TryDecodeAsNil() {
				x.MaxReplicas = 0
			} else {
				x.MaxReplicas = int32(r.DecodeInt(32))
			}
		case "targetCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.TargetCPUUtilizationPercentage != nil {
					x.TargetCPUUtilizationPercentage = nil
				}
			} else {
				if x.TargetCPUUtilizationPercentage == nil {
					x.TargetCPUUtilizationPercentage = new(int32)
				}
				yym106 := z.DecBinary()
				_ = yym106
				if false {
				} else {
					*((*int32)(x.TargetCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys100)
		} // end switch yys100
	} // end for yyj100
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj107 int
	var yyb107 bool
	var yyhl107 bool = l >= 0
	yyj107++
	if yyhl107 {
		yyb107 = yyj107 > l
	} else {
		yyb107 = r.CheckBreak()
	}
	if yyb107 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ScaleTargetRef = CrossVersionObjectReference{}
	} else {
		yyv108 := &x.ScaleTargetRef
		yyv108.CodecDecodeSelf(d)
	}
	yyj107++
	if yyhl107 {
		yyb107 = yyj107 > l
	} else {
		yyb107 = r.CheckBreak()
	}
	if yyb107 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MinReplicas != nil {
			x.MinReplicas = nil
		}
	} else {
		if x.MinReplicas == nil {
			x.MinReplicas = new(int32)
		}
		yym110 := z.DecBinary()
		_ = yym110
		if false {
		} else {
			*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj107++
	if yyhl107 {
		yyb107 = yyj107 > l
	} else {
		yyb107 = r.CheckBreak()
	}
	if yyb107 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxReplicas = 0
	} else {
		x.MaxReplicas = int32(r.DecodeInt(32))
	}
	yyj107++
	if yyhl107 {
		yyb107 = yyj107 > l
	} else {
		yyb107 = r.CheckBreak()
	}
	if yyb107 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetCPUUtilizationPercentage != nil {
			x.TargetCPUUtilizationPercentage = nil
		}
	} else {
		if x.TargetCPUUtilizationPercentage == nil {
			x.TargetCPUUtilizationPercentage = new(int32)
		}
		yym113 := z.DecBinary()
		_ = yym113
		if false {
		} else {
			*((*int32)(x.TargetCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj107++
		if yyhl107 {
			yyb107 = yyj107 > l
		} else {
			yyb107 = r.CheckBreak()
		}
		if yyb107 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj107-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym114 := z.EncBinary()
		_ = yym114
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep115 := !z.EncBinary()
			yy2arr115 := z.EncBasicHandle().StructToArray
			var yyq115 [5]bool
			_, _, _ = yysep115, yyq115, yy2arr115
			const yyr115 bool = false
			yyq115[0] = x.ObservedGeneration != nil
			yyq115[1] = x.LastScaleTime != nil
			yyq115[4] = x.CurrentCPUUtilizationPercentage != nil
			var yynn115 int
			if yyr115 || yy2arr115 {
				r.EncodeArrayStart(5)
			} else {
				yynn115 = 2
				for _, b := range yyq115 {
					if b {
						yynn115++
					}
				}
				r.EncodeMapStart(yynn115)
				yynn115 = 0
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[0] {
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy117 := *x.ObservedGeneration
						yym118 := z.EncBinary()
						_ = yym118
						if false {
						} else {
							r.EncodeInt(int64(yy117))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy119 := *x.ObservedGeneration
						yym120 := z.EncBinary()
						_ = yym120
						if false {
						} else {
							r.EncodeInt(int64(yy119))
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[1] {
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym122 := z.EncBinary()
						_ = yym122
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym122 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym122 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScaleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym123 := z.EncBinary()
						_ = yym123
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym123 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym123 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym125 := z.EncBinary()
				_ = yym125
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym126 := z.EncBinary()
				_ = yym126
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym128 := z.EncBinary()
				_ = yym128
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym129 := z.EncBinary()
				_ = yym129
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq115[4] {
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy131 := *x.CurrentCPUUtilizationPercentage
						yym132 := z.EncBinary()
						_ = yym132
						if false {
						} else {
							r.EncodeInt(int64(yy131))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq115[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("currentCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy133 := *x.CurrentCPUUtilizationPercentage
						yym134 := z.EncBinary()
						_ = yym134
						if false {
						} else {
							r.EncodeInt(int64(yy133))
						}
					}
				}
			}
			if yyr115 || yy2arr115 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym135 := z.DecBinary()
	_ = yym135
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct136 := r.ContainerType()
		if yyct136 == codecSelferValueTypeMap1234 {
			yyl136 := r.ReadMapStart()
			if yyl136 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl136, d)
			}
		} else if yyct136 == codecSelferValueTypeArray1234 {
			yyl136 := r.ReadArrayStart()
			if yyl136 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl136, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys137Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys137Slc
	var yyhl137 bool = l >= 0
	for yyj137 := 0; ; yyj137++ {
		if yyhl137 {
			if yyj137 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys137Slc = r.DecodeBytes(yys137Slc, true, true)
		yys137 := string(yys137Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys137 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				if x.ObservedGeneration != nil {
					x.ObservedGeneration = nil
				}
			} else {
				if x.ObservedGeneration == nil {
					x.ObservedGeneration = new(int64)
				}
				yym139 := z.DecBinary()
				_ = yym139
				if false {
				} else {
					*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
				}
			}
		case "lastScaleTime":
			if r.TryDecodeAsNil() {
				if x.LastScaleTime != nil {
					x.LastScaleTime = nil
				}
			} else {
				if x.LastScaleTime == nil {
					x.LastScaleTime = new(pkg1_unversioned.Time)
				}
				yym141 := z.DecBinary()
				_ = yym141
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
				} else if yym141 {
					z.DecBinaryUnmarshal(x.LastScaleTime)
				} else if !yym141 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScaleTime)
				} else {
					z.DecFallback(x.LastScaleTime, false)
				}
			}
		case "currentReplicas":
			if r.TryDecodeAsNil() {
				x.CurrentReplicas = 0
			} else {
				x.CurrentReplicas = int32(r.DecodeInt(32))
			}
		case "desiredReplicas":
			if r.TryDecodeAsNil() {
				x.DesiredReplicas = 0
			} else {
				x.DesiredReplicas = int32(r.DecodeInt(32))
			}
		case "currentCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.CurrentCPUUtilizationPercentage != nil {
					x.CurrentCPUUtilizationPercentage = nil
				}
			} else {
				if x.CurrentCPUUtilizationPercentage == nil {
					x.CurrentCPUUtilizationPercentage = new(int32)
				}
				yym145 := z.DecBinary()
				_ = yym145
				if false {
				} else {
					*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys137)
		} // end switch yys137
	} // end for yyj137
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj146 int
	var yyb146 bool
	var yyhl146 bool = l >= 0
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ObservedGeneration != nil {
			x.ObservedGeneration = nil
		}
	} else {
		if x.ObservedGeneration == nil {
			x.ObservedGeneration = new(int64)
		}
		yym148 := z.DecBinary()
		_ = yym148
		if false {
		} else {
			*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
		}
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScaleTime != nil {
			x.LastScaleTime = nil
		}
	} else {
		if x.LastScaleTime == nil {
			x.LastScaleTime = new(pkg1_unversioned.Time)
		}
		yym150 := z.DecBinary()
		_ = yym150
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
		} else if yym150 {
			z.DecBinaryUnmarshal(x.LastScaleTime)
		} else if !yym150 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScaleTime)
		} else {
			z.DecFallback(x.LastScaleTime, false)
		}
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentReplicas = 0
	} else {
		x.CurrentReplicas = int32(r.DecodeInt(32))
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredReplicas = 0
	} else {
		x.DesiredReplicas = int32(r.DecodeInt(32))
	}
	yyj146++
	if yyhl146 {
		yyb146 = yyj146 > l
	} else {
		yyb146 = r.CheckBreak()
	}
	if yyb146 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CurrentCPUUtilizationPercentage != nil {
			x.CurrentCPUUtilizationPercentage = nil
		}
	} else {
		if x.CurrentCPUUtilizationPercentage == nil {
			x.CurrentCPUUtilizationPercentage = new(int32)
		}
		yym154 := z.DecBinary()
		_ = yym154
		if false {
		} else {
			*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj146++
		if yyhl146 {
			yyb146 = yyj146 > l
		} else {
			yyb146 = r.CheckBreak()
		}
		if yyb146 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj146-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym155 := z.EncBinary()
		_ = yym155
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep156 := !z.EncBinary()
			yy2arr156 := z.EncBasicHandle().StructToArray
			var yyq156 [5]bool
			_, _, _ = yysep156, yyq156, yy2arr156
			const yyr156 bool = false
			yyq156[0] = x.Kind != ""
			yyq156[1] = x.APIVersion != ""
			yyq156[2] = true
			yyq156[3] = true
			yyq156[4] = true
			var yynn156 int
			if yyr156 || yy2arr156 {
				r.EncodeArrayStart(5)
			} else {
				yynn156 = 0
				for _, b := range yyq156 {
					if b {
						yynn156++
					}
				}
				r.EncodeMapStart(yynn156)
				yynn156 = 0
			}
			if yyr156 || yy2arr156 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq156[0] {
					yym158 := z.EncBinary()
					_ = yym158
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq156[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym159 := z.EncBinary()
					_ = yym159
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr156 || yy2arr156 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq156[1] {
					yym161 := z.EncBinary()
					_ = yym161
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq156[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym162 := z.EncBinary()
					_ = yym162
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr156 || yy2arr156 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq156[2] {
					yy164 := &x.ObjectMeta
					yy164.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq156[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy165 := &x.ObjectMeta
					yy165.CodecEncodeSelf(e)
				}
			}
			if yyr156 || yy2arr156 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq156[3] {
					yy167 := &x.Spec
					yy167.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq156[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy168 := &x.Spec
					yy168.CodecEncodeSelf(e)
				}
			}
			if yyr156 || yy2arr156 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq156[4] {
					yy170 := &x.Status
					yy170.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq156[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy171 := &x.Status
					yy171.CodecEncodeSelf(e)
				}
			}
			if yyr156 || yy2arr156 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym172 := z.DecBinary()
	_ = yym172
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct173 := r.ContainerType()
		if yyct173 == codecSelferValueTypeMap1234 {
			yyl173 := r.ReadMapStart()
			if yyl173 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl173, d)
			}
		} else if yyct173 == codecSelferValueTypeArray1234 {
			yyl173 := r.ReadArrayStart()
			if yyl173 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl173, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys174Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys174Slc
	var yyhl174 bool = l >= 0
	for yyj174 := 0; ; yyj174++ {
		if yyhl174 {
			if yyj174 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys174Slc = r.DecodeBytes(yys174Slc, true, true)
		yys174 := string(yys174Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys174 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv177 := &x.ObjectMeta
				yyv177.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = HorizontalPodAutoscalerSpec{}
			} else {
				yyv178 := &x.Spec
				yyv178.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = HorizontalPodAutoscalerStatus{}
			} else {
				yyv179 := &x.Status
				yyv179.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys174)
		} // end switch yys174
	} // end for yyj174
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj180 int
	var yyb180 bool
	var yyhl180 bool = l >= 0
	yyj180++
	if yyhl180 {
		yyb180 = yyj180 > l
	} else {
		yyb180 = r.CheckBreak()
	}
	if yyb180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj180++
	if yyhl180 {
		yyb180 = yyj180 > l
	} else {
		yyb180 = r.CheckBreak()
	}
	if yyb180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj180++
	if yyhl180 {
		yyb180 = yyj180 > l
	} else {
		yyb180 = r.CheckBreak()
	}
	if yyb180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv183 := &x.ObjectMeta
		yyv183.CodecDecodeSelf(d)
	}
	yyj180++
	if yyhl180 {
		yyb180 = yyj180 > l
	} else {
		yyb180 = r.CheckBreak()
	}
	if yyb180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = HorizontalPodAutoscalerSpec{}
	} else {
		yyv184 := &x.Spec
		yyv184.CodecDecodeSelf(d)
	}
	yyj180++
	if yyhl180 {
		yyb180 = yyj180 > l
	} else {
		yyb180 = r.CheckBreak()
	}
	if yyb180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = HorizontalPodAutoscalerStatus{}
	} else {
		yyv185 := &x.Status
		yyv185.CodecDecodeSelf(d)
	}
	for {
		yyj180++
		if yyhl180 {
			yyb180 = yyj180 > l
		} else {
			yyb180 = r.CheckBreak()
		}
		if yyb180 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj180-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym186 := z.EncBinary()
		_ = yym186
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep187 := !z.EncBinary()
			yy2arr187 := z.EncBasicHandle().StructToArray
			var yyq187 [4]bool
			_, _, _ = yysep187, yyq187, yy2arr187
			const yyr187 bool = false
			yyq187[0] = x.Kind != ""
			yyq187[1] = x.APIVersion != ""
			yyq187[2] = true
			var yynn187 int
			if yyr187 || yy2arr187 {
				r.EncodeArrayStart(4)
			} else {
				yynn187 = 1
				for _, b := range yyq187 {
					if b {
						yynn187++
					}
				}
				r.EncodeMapStart(yynn187)
				yynn187 = 0
			}
			if yyr187 || yy2arr187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq187[0] {
					yym189 := z.EncBinary()
					_ = yym189
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq187[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym190 := z.EncBinary()
					_ = yym190
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr187 || yy2arr187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq187[1] {
					yym192 := z.EncBinary()
					_ = yym192
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq187[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym193 := z.EncBinary()
					_ = yym193
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr187 || yy2arr187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq187[2] {
					yy195 := &x.ListMeta
					yym196 := z.EncBinary()
					_ = yym196
					if false {
					} else if z.HasExtensions() && z.EncExt(yy195) {
					} else {
						z.EncFallback(yy195)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq187[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy197 := &x.ListMeta
					yym198 := z.EncBinary()
					_ = yym198
					if false {
					} else if z.HasExtensions() && z.EncExt(yy197) {
					} else {
						z.EncFallback(yy197)
					}
				}
			}
			if yyr187 || yy2arr187 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym200 := z.EncBinary()
					_ = yym200
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym201 := z.EncBinary()
					_ = yym201
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr187 || yy2arr187 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym202 := z.DecBinary()
	_ = yym202
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct203 := r.ContainerType()
		if yyct203 == codecSelferValueTypeMap1234 {
			yyl203 := r.ReadMapStart()
			if yyl203 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl203, d)
			}
		} else if yyct203 == codecSelferValueTypeArray1234 {
			yyl203 := r.ReadArrayStart()
			if yyl203 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl203, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys204Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys204Slc
	var yyhl204 bool = l >= 0
	for yyj204 := 0; ; yyj204++ {
		if yyhl204 {
			if yyj204 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys204Slc = r.DecodeBytes(yys204Slc, true, true)
		yys204 := string(yys204Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys204 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv207 := &x.ListMeta
				yym208 := z.DecBinary()
				_ = yym208
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv207) {
				} else {
					z.DecFallback(yyv207, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv209 := &x.Items
				yym210 := z.DecBinary()
				_ = yym210
				if false {
				} else {
					h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv209), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys204)
		} // end switch yys204
	} // end for yyj204
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj211 int
	var yyb211 bool
	var yyhl211 bool = l >= 0
	yyj211++
	if yyhl211 {
		yyb211 = yyj211 > l
	} else {
		yyb211 = r.CheckBreak()
	}
	if yyb211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj211++
	if yyhl211 {
		yyb211 = yyj211 > l
	} else {
		yyb211 = r.CheckBreak()
	}
	if yyb211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj211++
	if yyhl211 {
		yyb211 = yyj211 > l
	} else {
		yyb211 = r.CheckBreak()
	}
	if yyb211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv214 := &x.ListMeta
		yym215 := z.DecBinary()
		_ = yym215
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv214) {
		} else {
			z.DecFallback(yyv214, false)
		}
	}
	yyj211++
	if yyhl211 {
		yyb211 = yyj211 > l
	} else {
		yyb211 = r.CheckBreak()
	}
	if yyb211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv216 := &x.Items
		yym217 := z.DecBinary()
		_ = yym217
		if false {
		} else {
			h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv216), d)
		}
	}
	for {
		yyj211++
		if yyhl211 {
			yyb211 = yyj211 > l
		} else {
			yyb211 = r.CheckBreak()
		}
		if yyb211 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj211-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceHorizontalPodAutoscaler(v []HorizontalPodAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv218 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy219 := &yyv218
		yy219.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHorizontalPodAutoscaler(v *[]HorizontalPodAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv220 := *v
	yyh220, yyl220 := z.DecSliceHelperStart()
	var yyc220 bool
	if yyl220 == 0 {
		if yyv220 == nil {
			yyv220 = []HorizontalPodAutoscaler{}
			yyc220 = true
		} else if len(yyv220) != 0 {
			yyv220 = yyv220[:0]
			yyc220 = true
		}
	} else if yyl220 > 0 {
		var yyrr220, yyrl220 int
		var yyrt220 bool
		if yyl220 > cap(yyv220) {

			yyrg220 := len(yyv220) > 0
			yyv2220 := yyv220
			yyrl220, yyrt220 = z.DecInferLen(yyl220, z.DecBasicHandle().MaxInitLen, 360)
			if yyrt220 {
				if yyrl220 <= cap(yyv220) {
					yyv220 = yyv220[:yyrl220]
				} else {
					yyv220 = make([]HorizontalPodAutoscaler, yyrl220)
				}
			} else {
				yyv220 = make([]HorizontalPodAutoscaler, yyrl220)
			}
			yyc220 = true
			yyrr220 = len(yyv220)
			if yyrg220 {
				copy(yyv220, yyv2220)
			}
		} else if yyl220 != len(yyv220) {
			yyv220 = yyv220[:yyl220]
			yyc220 = true
		}
		yyj220 := 0
		for ; yyj220 < yyrr220; yyj220++ {
			yyh220.ElemContainerState(yyj220)
			if r.TryDecodeAsNil() {
				yyv220[yyj220] = HorizontalPodAutoscaler{}
			} else {
				yyv221 := &yyv220[yyj220]
				yyv221.CodecDecodeSelf(d)
			}

		}
		if yyrt220 {
			for ; yyj220 < yyl220; yyj220++ {
				yyv220 = append(yyv220, HorizontalPodAutoscaler{})
				yyh220.ElemContainerState(yyj220)
				if r.TryDecodeAsNil() {
					yyv220[yyj220] = HorizontalPodAutoscaler{}
				} else {
					yyv222 := &yyv220[yyj220]
					yyv222.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj220 := 0
		for ; !r.CheckBreak(); yyj220++ {

			if yyj220 >= len(yyv220) {
				yyv220 = append(yyv220, HorizontalPodAutoscaler{}) // var yyz220 HorizontalPodAutoscaler
				yyc220 = true
			}
			yyh220.ElemContainerState(yyj220)
			if yyj220 < len(yyv220) {
				if r.TryDecodeAsNil() {
					yyv220[yyj220] = HorizontalPodAutoscaler{}
				} else {
					yyv223 := &yyv220[yyj220]
					yyv223.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj220 < len(yyv220) {
			yyv220 = yyv220[:yyj220]
			yyc220 = true
		} else if yyj220 == 0 && yyv220 == nil {
			yyv220 = []HorizontalPodAutoscaler{}
			yyc220 = true
		}
	}
	yyh220.End()
	if yyc220 {
		*v = yyv220
	}
}
