/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/client-go/1.5/pkg/api/unversioned"
	pkg2_config "k8s.io/client-go/1.5/pkg/util/config"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 pkg2_config.ConfigurationMap
		var v2 time.Duration
		_, _, _ = v0, v1, v2
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [21]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(21)
			} else {
				yynn2 = 19
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy25 := *x.IPTablesMasqueradeBit
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(yy25))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy27 := *x.IPTablesMasqueradeBit
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(yy27))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy30 := &x.IPTablesSyncPeriod
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else if z.HasExtensions() && z.EncExt(yy30) {
				} else if !yym31 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy30)
				} else {
					z.EncFallback(yy30)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy32 := &x.IPTablesSyncPeriod
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else if z.HasExtensions() && z.EncExt(yy32) {
				} else if !yym33 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy32)
				} else {
					z.EncFallback(yy32)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym35 := z.EncBinary()
				_ = yym35
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym39 := z.EncBinary()
				_ = yym39
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym42 := z.EncBinary()
				_ = yym42
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy44 := *x.OOMScoreAdj
					yym45 := z.EncBinary()
					_ = yym45
					if false {
					} else {
						r.EncodeInt(int64(yy44))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy46 := *x.OOMScoreAdj
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						r.EncodeInt(int64(yy46))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym50 := z.EncBinary()
				_ = yym50
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym51 := z.EncBinary()
				_ = yym51
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym53 := z.EncBinary()
				_ = yym53
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym54 := z.EncBinary()
				_ = yym54
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy56 := &x.UDPIdleTimeout
				yym57 := z.EncBinary()
				_ = yym57
				if false {
				} else if z.HasExtensions() && z.EncExt(yy56) {
				} else if !yym57 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy56)
				} else {
					z.EncFallback(yy56)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy58 := &x.UDPIdleTimeout
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else if z.HasExtensions() && z.EncExt(yy58) {
				} else if !yym59 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy58)
				} else {
					z.EncFallback(yy58)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMaxPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym65 := z.EncBinary()
				_ = yym65
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym67 := z.EncBinary()
				_ = yym67
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMin"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy70 := &x.ConntrackTCPEstablishedTimeout
				yym71 := z.EncBinary()
				_ = yym71
				if false {
				} else if z.HasExtensions() && z.EncExt(yy70) {
				} else if !yym71 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy70)
				} else {
					z.EncFallback(yy70)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy72 := &x.ConntrackTCPEstablishedTimeout
				yym73 := z.EncBinary()
				_ = yym73
				if false {
				} else if z.HasExtensions() && z.EncExt(yy72) {
				} else if !yym73 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy72)
				} else {
					z.EncFallback(yy72)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym74 := z.DecBinary()
	_ = yym74
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct75 := r.ContainerType()
		if yyct75 == codecSelferValueTypeMap1234 {
			yyl75 := r.ReadMapStart()
			if yyl75 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl75, d)
			}
		} else if yyct75 == codecSelferValueTypeArray1234 {
			yyl75 := r.ReadArrayStart()
			if yyl75 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl75, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys76Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys76Slc
	var yyhl76 bool = l >= 0
	for yyj76 := 0; ; yyj76++ {
		if yyhl76 {
			if yyj76 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys76Slc = r.DecodeBytes(yys76Slc, true, true)
		yys76 := string(yys76Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys76 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int32)
				}
				yym85 := z.DecBinary()
				_ = yym85
				if false {
				} else {
					*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv86 := &x.IPTablesSyncPeriod
				yym87 := z.DecBinary()
				_ = yym87
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv86) {
				} else if !yym87 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv86)
				} else {
					z.DecFallback(yyv86, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int32)
				}
				yym92 := z.DecBinary()
				_ = yym92
				if false {
				} else {
					*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv96 := &x.UDPIdleTimeout
				yym97 := z.DecBinary()
				_ = yym97
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv96) {
				} else if !yym97 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv96)
				} else {
					z.DecFallback(yyv96, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int32(r.DecodeInt(32))
			}
		case "conntrackMaxPerCore":
			if r.TryDecodeAsNil() {
				x.ConntrackMaxPerCore = 0
			} else {
				x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
			}
		case "conntrackMin":
			if r.TryDecodeAsNil() {
				x.ConntrackMin = 0
			} else {
				x.ConntrackMin = int32(r.DecodeInt(32))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv101 := &x.ConntrackTCPEstablishedTimeout
				yym102 := z.DecBinary()
				_ = yym102
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv101) {
				} else if !yym102 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv101)
				} else {
					z.DecFallback(yyv101, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys76)
		} // end switch yys76
	} // end for yyj76
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj103 int
	var yyb103 bool
	var yyhl103 bool = l >= 0
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int32)
		}
		yym112 := z.DecBinary()
		_ = yym112
		if false {
		} else {
			*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv113 := &x.IPTablesSyncPeriod
		yym114 := z.DecBinary()
		_ = yym114
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv113) {
		} else if !yym114 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv113)
		} else {
			z.DecFallback(yyv113, false)
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int32)
		}
		yym119 := z.DecBinary()
		_ = yym119
		if false {
		} else {
			*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv123 := &x.UDPIdleTimeout
		yym124 := z.DecBinary()
		_ = yym124
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv123) {
		} else if !yym124 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv123)
		} else {
			z.DecFallback(yyv123, false)
		}
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int32(r.DecodeInt(32))
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMaxPerCore = 0
	} else {
		x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMin = 0
	} else {
		x.ConntrackMin = int32(r.DecodeInt(32))
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv128 := &x.ConntrackTCPEstablishedTimeout
		yym129 := z.DecBinary()
		_ = yym129
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv128) {
		} else if !yym129 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv128)
		} else {
			z.DecFallback(yyv128, false)
		}
	}
	for {
		yyj103++
		if yyhl103 {
			yyb103 = yyj103 > l
		} else {
			yyb103 = r.CheckBreak()
		}
		if yyb103 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj103-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym130 := z.EncBinary()
	_ = yym130
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym131 := z.DecBinary()
	_ = yym131
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym132 := z.EncBinary()
	_ = yym132
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym133 := z.DecBinary()
	_ = yym133
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym134 := z.EncBinary()
		_ = yym134
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep135 := !z.EncBinary()
			yy2arr135 := z.EncBasicHandle().StructToArray
			var yyq135 [108]bool
			_, _, _ = yysep135, yyq135, yy2arr135
			const yyr135 bool = false
			yyq135[0] = x.Kind != ""
			yyq135[1] = x.APIVersion != ""
			yyq135[53] = x.CloudProvider != ""
			yyq135[54] = x.CloudConfigFile != ""
			yyq135[55] = x.KubeletCgroups != ""
			yyq135[56] = x.CgroupsPerQOS != false
			yyq135[57] = x.RuntimeCgroups != ""
			yyq135[58] = x.SystemCgroups != ""
			yyq135[59] = x.CgroupRoot != ""
			yyq135[63] = true
			yyq135[64] = x.RktPath != ""
			yyq135[65] = x.RktAPIEndpoint != ""
			yyq135[66] = x.RktStage1Image != ""
			yyq135[87] = true
			yyq135[88] = x.NodeIP != ""
			yyq135[92] = x.EvictionHard != ""
			yyq135[93] = x.EvictionSoft != ""
			yyq135[94] = x.EvictionSoftGracePeriod != ""
			yyq135[95] = true
			yyq135[96] = x.EvictionMaxPodGracePeriod != 0
			yyq135[97] = x.EvictionMinimumReclaim != ""
			yyq135[106] = len(x.AllowedUnsafeSysctls) != 0
			yyq135[107] = x.ExperimentalRuntimeIntegrationType != ""
			var yynn135 int
			if yyr135 || yy2arr135 {
				r.EncodeArrayStart(108)
			} else {
				yynn135 = 85
				for _, b := range yyq135 {
					if b {
						yynn135++
					}
				}
				r.EncodeMapStart(yynn135)
				yynn135 = 0
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[0] {
					yym137 := z.EncBinary()
					_ = yym137
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym138 := z.EncBinary()
					_ = yym138
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[1] {
					yym140 := z.EncBinary()
					_ = yym140
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym141 := z.EncBinary()
					_ = yym141
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym143 := z.EncBinary()
				_ = yym143
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podManifestPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym144 := z.EncBinary()
				_ = yym144
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy146 := &x.SyncFrequency
				yym147 := z.EncBinary()
				_ = yym147
				if false {
				} else if z.HasExtensions() && z.EncExt(yy146) {
				} else if !yym147 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy146)
				} else {
					z.EncFallback(yy146)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy148 := &x.SyncFrequency
				yym149 := z.EncBinary()
				_ = yym149
				if false {
				} else if z.HasExtensions() && z.EncExt(yy148) {
				} else if !yym149 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy148)
				} else {
					z.EncFallback(yy148)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy151 := &x.FileCheckFrequency
				yym152 := z.EncBinary()
				_ = yym152
				if false {
				} else if z.HasExtensions() && z.EncExt(yy151) {
				} else if !yym152 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy151)
				} else {
					z.EncFallback(yy151)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy153 := &x.FileCheckFrequency
				yym154 := z.EncBinary()
				_ = yym154
				if false {
				} else if z.HasExtensions() && z.EncExt(yy153) {
				} else if !yym154 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy153)
				} else {
					z.EncFallback(yy153)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy156 := &x.HTTPCheckFrequency
				yym157 := z.EncBinary()
				_ = yym157
				if false {
				} else if z.HasExtensions() && z.EncExt(yy156) {
				} else if !yym157 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy156)
				} else {
					z.EncFallback(yy156)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy158 := &x.HTTPCheckFrequency
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else if z.HasExtensions() && z.EncExt(yy158) {
				} else if !yym159 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy158)
				} else {
					z.EncFallback(yy158)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym161 := z.EncBinary()
				_ = yym161
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym164 := z.EncBinary()
				_ = yym164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym165 := z.EncBinary()
				_ = yym165
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym167 := z.EncBinary()
				_ = yym167
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym168 := z.EncBinary()
				_ = yym168
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym170 := z.EncBinary()
				_ = yym170
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym171 := z.EncBinary()
				_ = yym171
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym173 := z.EncBinary()
				_ = yym173
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym174 := z.EncBinary()
				_ = yym174
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym176 := z.EncBinary()
				_ = yym176
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym177 := z.EncBinary()
				_ = yym177
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym179 := z.EncBinary()
				_ = yym179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym182 := z.EncBinary()
				_ = yym182
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym183 := z.EncBinary()
				_ = yym183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym185 := z.EncBinary()
				_ = yym185
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym188 := z.EncBinary()
				_ = yym188
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym189 := z.EncBinary()
				_ = yym189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym191 := z.EncBinary()
				_ = yym191
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym194 := z.EncBinary()
				_ = yym194
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym200 := z.EncBinary()
				_ = yym200
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seccompProfileRoot"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym201 := z.EncBinary()
				_ = yym201
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym203 := z.EncBinary()
				_ = yym203
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym206 := z.EncBinary()
					_ = yym206
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym207 := z.EncBinary()
					_ = yym207
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym209 := z.EncBinary()
					_ = yym209
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym210 := z.EncBinary()
					_ = yym210
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym212 := z.EncBinary()
					_ = yym212
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym213 := z.EncBinary()
					_ = yym213
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym215 := z.EncBinary()
				_ = yym215
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym218 := z.EncBinary()
				_ = yym218
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym221 := z.EncBinary()
				_ = yym221
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy230 := &x.MinimumGCAge
				yym231 := z.EncBinary()
				_ = yym231
				if false {
				} else if z.HasExtensions() && z.EncExt(yy230) {
				} else if !yym231 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy230)
				} else {
					z.EncFallback(yy230)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy232 := &x.MinimumGCAge
				yym233 := z.EncBinary()
				_ = yym233
				if false {
				} else if z.HasExtensions() && z.EncExt(yy232) {
				} else if !yym233 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy232)
				} else {
					z.EncFallback(yy232)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym235 := z.EncBinary()
				_ = yym235
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym236 := z.EncBinary()
				_ = yym236
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym238 := z.EncBinary()
				_ = yym238
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym239 := z.EncBinary()
				_ = yym239
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym241 := z.EncBinary()
				_ = yym241
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym242 := z.EncBinary()
				_ = yym242
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym244 := z.EncBinary()
				_ = yym244
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym247 := z.EncBinary()
				_ = yym247
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym250 := z.EncBinary()
				_ = yym250
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym253 := z.EncBinary()
				_ = yym253
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym254 := z.EncBinary()
				_ = yym254
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym256 := z.EncBinary()
				_ = yym256
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym257 := z.EncBinary()
				_ = yym257
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym259 := z.EncBinary()
				_ = yym259
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym260 := z.EncBinary()
				_ = yym260
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym262 := z.EncBinary()
				_ = yym262
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym263 := z.EncBinary()
				_ = yym263
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy265 := &x.StreamingConnectionIdleTimeout
				yym266 := z.EncBinary()
				_ = yym266
				if false {
				} else if z.HasExtensions() && z.EncExt(yy265) {
				} else if !yym266 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy265)
				} else {
					z.EncFallback(yy265)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy267 := &x.StreamingConnectionIdleTimeout
				yym268 := z.EncBinary()
				_ = yym268
				if false {
				} else if z.HasExtensions() && z.EncExt(yy267) {
				} else if !yym268 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy267)
				} else {
					z.EncFallback(yy267)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy270 := &x.NodeStatusUpdateFrequency
				yym271 := z.EncBinary()
				_ = yym271
				if false {
				} else if z.HasExtensions() && z.EncExt(yy270) {
				} else if !yym271 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy270)
				} else {
					z.EncFallback(yy270)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy272 := &x.NodeStatusUpdateFrequency
				yym273 := z.EncBinary()
				_ = yym273
				if false {
				} else if z.HasExtensions() && z.EncExt(yy272) {
				} else if !yym273 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy272)
				} else {
					z.EncFallback(yy272)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy275 := &x.ImageMinimumGCAge
				yym276 := z.EncBinary()
				_ = yym276
				if false {
				} else if z.HasExtensions() && z.EncExt(yy275) {
				} else if !yym276 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy275)
				} else {
					z.EncFallback(yy275)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy277 := &x.ImageMinimumGCAge
				yym278 := z.EncBinary()
				_ = yym278
				if false {
				} else if z.HasExtensions() && z.EncExt(yy277) {
				} else if !yym278 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy277)
				} else {
					z.EncFallback(yy277)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym280 := z.EncBinary()
				_ = yym280
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym281 := z.EncBinary()
				_ = yym281
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym283 := z.EncBinary()
				_ = yym283
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym284 := z.EncBinary()
				_ = yym284
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym286 := z.EncBinary()
				_ = yym286
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym287 := z.EncBinary()
				_ = yym287
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy289 := &x.VolumeStatsAggPeriod
				yym290 := z.EncBinary()
				_ = yym290
				if false {
				} else if z.HasExtensions() && z.EncExt(yy289) {
				} else if !yym290 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy289)
				} else {
					z.EncFallback(yy289)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy291 := &x.VolumeStatsAggPeriod
				yym292 := z.EncBinary()
				_ = yym292
				if false {
				} else if z.HasExtensions() && z.EncExt(yy291) {
				} else if !yym292 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy291)
				} else {
					z.EncFallback(yy291)
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym294 := z.EncBinary()
				_ = yym294
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym295 := z.EncBinary()
				_ = yym295
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym297 := z.EncBinary()
				_ = yym297
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginMTU"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym298 := z.EncBinary()
				_ = yym298
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym300 := z.EncBinary()
				_ = yym300
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym301 := z.EncBinary()
				_ = yym301
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym303 := z.EncBinary()
				_ = yym303
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniConfDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym304 := z.EncBinary()
				_ = yym304
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym306 := z.EncBinary()
				_ = yym306
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniBinDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym307 := z.EncBinary()
				_ = yym307
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym309 := z.EncBinary()
				_ = yym309
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym310 := z.EncBinary()
				_ = yym310
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[53] {
					yym312 := z.EncBinary()
					_ = yym312
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[53] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym313 := z.EncBinary()
					_ = yym313
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[54] {
					yym315 := z.EncBinary()
					_ = yym315
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[54] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym316 := z.EncBinary()
					_ = yym316
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[55] {
					yym318 := z.EncBinary()
					_ = yym318
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[55] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym319 := z.EncBinary()
					_ = yym319
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[56] {
					yym321 := z.EncBinary()
					_ = yym321
					if false {
					} else {
						r.EncodeBool(bool(x.CgroupsPerQOS))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq135[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("CgroupsPerQOS"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym322 := z.EncBinary()
					_ = yym322
					if false {
					} else {
						r.EncodeBool(bool(x.CgroupsPerQOS))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[57] {
					yym324 := z.EncBinary()
					_ = yym324
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[57] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym325 := z.EncBinary()
					_ = yym325
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[58] {
					yym327 := z.EncBinary()
					_ = yym327
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[58] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym328 := z.EncBinary()
					_ = yym328
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[59] {
					yym330 := z.EncBinary()
					_ = yym330
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[59] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym333 := z.EncBinary()
				_ = yym333
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym334 := z.EncBinary()
				_ = yym334
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym336 := z.EncBinary()
				_ = yym336
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteRuntimeEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym337 := z.EncBinary()
				_ = yym337
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym339 := z.EncBinary()
				_ = yym339
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteImageEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym340 := z.EncBinary()
				_ = yym340
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[63] {
					yy342 := &x.RuntimeRequestTimeout
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else if z.HasExtensions() && z.EncExt(yy342) {
					} else if !yym343 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy342)
					} else {
						z.EncFallback(yy342)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq135[63] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeRequestTimeout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy344 := &x.RuntimeRequestTimeout
					yym345 := z.EncBinary()
					_ = yym345
					if false {
					} else if z.HasExtensions() && z.EncExt(yy344) {
					} else if !yym345 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy344)
					} else {
						z.EncFallback(yy344)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[64] {
					yym347 := z.EncBinary()
					_ = yym347
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[64] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym348 := z.EncBinary()
					_ = yym348
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[65] {
					yym350 := z.EncBinary()
					_ = yym350
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[65] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktAPIEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym351 := z.EncBinary()
					_ = yym351
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[66] {
					yym353 := z.EncBinary()
					_ = yym353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[66] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym356 := z.EncBinary()
				_ = yym356
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym357 := z.EncBinary()
				_ = yym357
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym359 := z.EncBinary()
				_ = yym359
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitOnLockContention"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym360 := z.EncBinary()
				_ = yym360
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym362 := z.EncBinary()
				_ = yym362
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCbr0"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym363 := z.EncBinary()
				_ = yym363
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCBR0))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym365 := z.EncBinary()
				_ = yym365
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym366 := z.EncBinary()
				_ = yym366
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym368 := z.EncBinary()
				_ = yym368
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("babysitDaemons"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym369 := z.EncBinary()
				_ = yym369
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym371 := z.EncBinary()
				_ = yym371
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym372 := z.EncBinary()
				_ = yym372
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym374 := z.EncBinary()
				_ = yym374
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nvidiaGPUs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym375 := z.EncBinary()
				_ = yym375
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym377 := z.EncBinary()
				_ = yym377
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym378 := z.EncBinary()
				_ = yym378
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym380 := z.EncBinary()
				_ = yym380
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym381 := z.EncBinary()
				_ = yym381
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym383 := z.EncBinary()
				_ = yym383
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym384 := z.EncBinary()
				_ = yym384
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym386 := z.EncBinary()
				_ = yym386
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym387 := z.EncBinary()
				_ = yym387
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym389 := z.EncBinary()
				_ = yym389
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym390 := z.EncBinary()
				_ = yym390
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym392 := z.EncBinary()
				_ = yym392
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym393 := z.EncBinary()
				_ = yym393
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym395 := z.EncBinary()
				_ = yym395
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym396 := z.EncBinary()
				_ = yym396
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym398 := z.EncBinary()
				_ = yym398
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym399 := z.EncBinary()
				_ = yym399
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym401 := z.EncBinary()
				_ = yym401
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym402 := z.EncBinary()
				_ = yym402
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym404 := z.EncBinary()
				_ = yym404
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym405 := z.EncBinary()
				_ = yym405
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym407 := z.EncBinary()
				_ = yym407
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym408 := z.EncBinary()
				_ = yym408
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym410 := z.EncBinary()
				_ = yym410
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym411 := z.EncBinary()
				_ = yym411
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym413 := z.EncBinary()
				_ = yym413
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("experimentalFlannelOverlay"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym414 := z.EncBinary()
				_ = yym414
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalFlannelOverlay))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[87] {
					yy416 := &x.OutOfDiskTransitionFrequency
					yym417 := z.EncBinary()
					_ = yym417
					if false {
					} else if z.HasExtensions() && z.EncExt(yy416) {
					} else if !yym417 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy416)
					} else {
						z.EncFallback(yy416)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq135[87] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy418 := &x.OutOfDiskTransitionFrequency
					yym419 := z.EncBinary()
					_ = yym419
					if false {
					} else if z.HasExtensions() && z.EncExt(yy418) {
					} else if !yym419 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy418)
					} else {
						z.EncFallback(yy418)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[88] {
					yym421 := z.EncBinary()
					_ = yym421
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[88] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym422 := z.EncBinary()
					_ = yym422
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym424 := z.EncBinary()
					_ = yym424
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym425 := z.EncBinary()
					_ = yym425
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym427 := z.EncBinary()
				_ = yym427
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym428 := z.EncBinary()
				_ = yym428
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym430 := z.EncBinary()
				_ = yym430
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym431 := z.EncBinary()
				_ = yym431
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[92] {
					yym433 := z.EncBinary()
					_ = yym433
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[92] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionHard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[93] {
					yym436 := z.EncBinary()
					_ = yym436
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[93] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoft"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym437 := z.EncBinary()
					_ = yym437
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[94] {
					yym439 := z.EncBinary()
					_ = yym439
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[94] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoftGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym440 := z.EncBinary()
					_ = yym440
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[95] {
					yy442 := &x.EvictionPressureTransitionPeriod
					yym443 := z.EncBinary()
					_ = yym443
					if false {
					} else if z.HasExtensions() && z.EncExt(yy442) {
					} else if !yym443 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy442)
					} else {
						z.EncFallback(yy442)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq135[95] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionPressureTransitionPeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy444 := &x.EvictionPressureTransitionPeriod
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else if z.HasExtensions() && z.EncExt(yy444) {
					} else if !yym445 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy444)
					} else {
						z.EncFallback(yy444)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[96] {
					yym447 := z.EncBinary()
					_ = yym447
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq135[96] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMaxPodGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[97] {
					yym450 := z.EncBinary()
					_ = yym450
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[97] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMinimumReclaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym453 := z.EncBinary()
				_ = yym453
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podsPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym454 := z.EncBinary()
				_ = yym454
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym456 := z.EncBinary()
				_ = yym456
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableControllerAttachDetach"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym457 := z.EncBinary()
				_ = yym457
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym459 := z.EncBinary()
					_ = yym459
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym460 := z.EncBinary()
					_ = yym460
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym462 := z.EncBinary()
					_ = yym462
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym463 := z.EncBinary()
					_ = yym463
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym465 := z.EncBinary()
				_ = yym465
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protectKernelDefaults"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym466 := z.EncBinary()
				_ = yym466
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym468 := z.EncBinary()
				_ = yym468
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("makeIPTablesUtilChains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym469 := z.EncBinary()
				_ = yym469
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym471 := z.EncBinary()
				_ = yym471
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym472 := z.EncBinary()
				_ = yym472
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym474 := z.EncBinary()
				_ = yym474
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesDropBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym475 := z.EncBinary()
				_ = yym475
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[106] {
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym477 := z.EncBinary()
						_ = yym477
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq135[106] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalAllowedUnsafeSysctls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym478 := z.EncBinary()
						_ = yym478
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq135[107] {
					yym480 := z.EncBinary()
					_ = yym480
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalRuntimeIntegrationType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq135[107] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalRuntimeIntegrationType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym481 := z.EncBinary()
					_ = yym481
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalRuntimeIntegrationType))
					}
				}
			}
			if yyr135 || yy2arr135 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym482 := z.DecBinary()
	_ = yym482
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct483 := r.ContainerType()
		if yyct483 == codecSelferValueTypeMap1234 {
			yyl483 := r.ReadMapStart()
			if yyl483 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl483, d)
			}
		} else if yyct483 == codecSelferValueTypeArray1234 {
			yyl483 := r.ReadArrayStart()
			if yyl483 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl483, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys484Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys484Slc
	var yyhl484 bool = l >= 0
	for yyj484 := 0; ; yyj484++ {
		if yyhl484 {
			if yyj484 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys484Slc = r.DecodeBytes(yys484Slc, true, true)
		yys484 := string(yys484Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys484 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "podManifestPath":
			if r.TryDecodeAsNil() {
				x.PodManifestPath = ""
			} else {
				x.PodManifestPath = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv488 := &x.SyncFrequency
				yym489 := z.DecBinary()
				_ = yym489
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv488) {
				} else if !yym489 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv488)
				} else {
					z.DecFallback(yyv488, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv490 := &x.FileCheckFrequency
				yym491 := z.DecBinary()
				_ = yym491
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv490) {
				} else if !yym491 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv490)
				} else {
					z.DecFallback(yyv490, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv492 := &x.HTTPCheckFrequency
				yym493 := z.DecBinary()
				_ = yym493
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv492) {
				} else if !yym493 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv492)
				} else {
					z.DecFallback(yyv492, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = int32(r.DecodeInt(32))
			}
		case "tlsCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tlsPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "seccompProfileRoot":
			if r.TryDecodeAsNil() {
				x.SeccompProfileRoot = ""
			} else {
				x.SeccompProfileRoot = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = nil
			} else {
				yyv509 := &x.HostNetworkSources
				yym510 := z.DecBinary()
				_ = yym510
				if false {
				} else {
					z.F.DecSliceStringX(yyv509, false, d)
				}
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = nil
			} else {
				yyv511 := &x.HostPIDSources
				yym512 := z.DecBinary()
				_ = yym512
				if false {
				} else {
					z.F.DecSliceStringX(yyv511, false, d)
				}
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = nil
			} else {
				yyv513 := &x.HostIPCSources
				yym514 := z.DecBinary()
				_ = yym514
				if false {
				} else {
					z.F.DecSliceStringX(yyv513, false, d)
				}
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = int32(r.DecodeInt(32))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int32(r.DecodeInt(32))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = int32(r.DecodeInt(32))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int32(r.DecodeInt(32))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv520 := &x.MinimumGCAge
				yym521 := z.DecBinary()
				_ = yym521
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv520) {
				} else if !yym521 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv520)
				} else {
					z.DecFallback(yyv520, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int32(r.DecodeInt(32))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = int32(r.DecodeInt(32))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int32(r.DecodeInt(32))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv532 := &x.StreamingConnectionIdleTimeout
				yym533 := z.DecBinary()
				_ = yym533
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv532) {
				} else if !yym533 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv532)
				} else {
					z.DecFallback(yyv532, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv534 := &x.NodeStatusUpdateFrequency
				yym535 := z.DecBinary()
				_ = yym535
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv534) {
				} else if !yym535 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv534)
				} else {
					z.DecFallback(yyv534, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv536 := &x.ImageMinimumGCAge
				yym537 := z.DecBinary()
				_ = yym537
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv536) {
				} else if !yym537 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv536)
				} else {
					z.DecFallback(yyv536, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
			}
		case "volumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv541 := &x.VolumeStatsAggPeriod
				yym542 := z.DecBinary()
				_ = yym542
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv541) {
				} else if !yym542 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv541)
				} else {
					z.DecFallback(yyv541, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginMTU":
			if r.TryDecodeAsNil() {
				x.NetworkPluginMTU = 0
			} else {
				x.NetworkPluginMTU = int32(r.DecodeInt(32))
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "cniConfDir":
			if r.TryDecodeAsNil() {
				x.CNIConfDir = ""
			} else {
				x.CNIConfDir = string(r.DecodeString())
			}
		case "cniBinDir":
			if r.TryDecodeAsNil() {
				x.CNIBinDir = ""
			} else {
				x.CNIBinDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "CgroupsPerQOS":
			if r.TryDecodeAsNil() {
				x.CgroupsPerQOS = false
			} else {
				x.CgroupsPerQOS = bool(r.DecodeBool())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemCgroups":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "remoteRuntimeEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteRuntimeEndpoint = ""
			} else {
				x.RemoteRuntimeEndpoint = string(r.DecodeString())
			}
		case "remoteImageEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteImageEndpoint = ""
			} else {
				x.RemoteImageEndpoint = string(r.DecodeString())
			}
		case "runtimeRequestTimeout":
			if r.TryDecodeAsNil() {
				x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv559 := &x.RuntimeRequestTimeout
				yym560 := z.DecBinary()
				_ = yym560
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv559) {
				} else if !yym560 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv559)
				} else {
					z.DecFallback(yyv559, false)
				}
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "rktAPIEndpoint":
			if r.TryDecodeAsNil() {
				x.RktAPIEndpoint = ""
			} else {
				x.RktAPIEndpoint = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "exitOnLockContention":
			if r.TryDecodeAsNil() {
				x.ExitOnLockContention = false
			} else {
				x.ExitOnLockContention = bool(r.DecodeBool())
			}
		case "configureCbr0":
			if r.TryDecodeAsNil() {
				x.ConfigureCBR0 = false
			} else {
				x.ConfigureCBR0 = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "babysitDaemons":
			if r.TryDecodeAsNil() {
				x.BabysitDaemons = false
			} else {
				x.BabysitDaemons = bool(r.DecodeBool())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int32(r.DecodeInt(32))
			}
		case "nvidiaGPUs":
			if r.TryDecodeAsNil() {
				x.NvidiaGPUs = 0
			} else {
				x.NvidiaGPUs = int32(r.DecodeInt(32))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = int64(r.DecodeInt(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int32(r.DecodeInt(32))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "experimentalFlannelOverlay":
			if r.TryDecodeAsNil() {
				x.ExperimentalFlannelOverlay = false
			} else {
				x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv584 := &x.OutOfDiskTransitionFrequency
				yym585 := z.DecBinary()
				_ = yym585
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv584) {
				} else if !yym585 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv584)
				} else {
					z.DecFallback(yyv584, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv587 := &x.NodeLabels
				yym588 := z.DecBinary()
				_ = yym588
				if false {
				} else {
					z.F.DecMapStringStringX(yyv587, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		case "evictionHard":
			if r.TryDecodeAsNil() {
				x.EvictionHard = ""
			} else {
				x.EvictionHard = string(r.DecodeString())
			}
		case "evictionSoft":
			if r.TryDecodeAsNil() {
				x.EvictionSoft = ""
			} else {
				x.EvictionSoft = string(r.DecodeString())
			}
		case "evictionSoftGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionSoftGracePeriod = ""
			} else {
				x.EvictionSoftGracePeriod = string(r.DecodeString())
			}
		case "evictionPressureTransitionPeriod":
			if r.TryDecodeAsNil() {
				x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv594 := &x.EvictionPressureTransitionPeriod
				yym595 := z.DecBinary()
				_ = yym595
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv594) {
				} else if !yym595 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv594)
				} else {
					z.DecFallback(yyv594, false)
				}
			}
		case "evictionMaxPodGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionMaxPodGracePeriod = 0
			} else {
				x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
			}
		case "evictionMinimumReclaim":
			if r.TryDecodeAsNil() {
				x.EvictionMinimumReclaim = ""
			} else {
				x.EvictionMinimumReclaim = string(r.DecodeString())
			}
		case "podsPerCore":
			if r.TryDecodeAsNil() {
				x.PodsPerCore = 0
			} else {
				x.PodsPerCore = int32(r.DecodeInt(32))
			}
		case "enableControllerAttachDetach":
			if r.TryDecodeAsNil() {
				x.EnableControllerAttachDetach = false
			} else {
				x.EnableControllerAttachDetach = bool(r.DecodeBool())
			}
		case "systemReserved":
			if r.TryDecodeAsNil() {
				x.SystemReserved = nil
			} else {
				yyv600 := &x.SystemReserved
				yym601 := z.DecBinary()
				_ = yym601
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv600) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv600), d)
				}
			}
		case "kubeReserved":
			if r.TryDecodeAsNil() {
				x.KubeReserved = nil
			} else {
				yyv602 := &x.KubeReserved
				yym603 := z.DecBinary()
				_ = yym603
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv602) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv602), d)
				}
			}
		case "protectKernelDefaults":
			if r.TryDecodeAsNil() {
				x.ProtectKernelDefaults = false
			} else {
				x.ProtectKernelDefaults = bool(r.DecodeBool())
			}
		case "makeIPTablesUtilChains":
			if r.TryDecodeAsNil() {
				x.MakeIPTablesUtilChains = false
			} else {
				x.MakeIPTablesUtilChains = bool(r.DecodeBool())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				x.IPTablesMasqueradeBit = 0
			} else {
				x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
			}
		case "iptablesDropBit":
			if r.TryDecodeAsNil() {
				x.IPTablesDropBit = 0
			} else {
				x.IPTablesDropBit = int32(r.DecodeInt(32))
			}
		case "experimentalAllowedUnsafeSysctls":
			if r.TryDecodeAsNil() {
				x.AllowedUnsafeSysctls = nil
			} else {
				yyv608 := &x.AllowedUnsafeSysctls
				yym609 := z.DecBinary()
				_ = yym609
				if false {
				} else {
					z.F.DecSliceStringX(yyv608, false, d)
				}
			}
		case "experimentalRuntimeIntegrationType":
			if r.TryDecodeAsNil() {
				x.ExperimentalRuntimeIntegrationType = ""
			} else {
				x.ExperimentalRuntimeIntegrationType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys484)
		} // end switch yys484
	} // end for yyj484
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj611 int
	var yyb611 bool
	var yyhl611 bool = l >= 0
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodManifestPath = ""
	} else {
		x.PodManifestPath = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv615 := &x.SyncFrequency
		yym616 := z.DecBinary()
		_ = yym616
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv615) {
		} else if !yym616 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv615)
		} else {
			z.DecFallback(yyv615, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv617 := &x.FileCheckFrequency
		yym618 := z.DecBinary()
		_ = yym618
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv617) {
		} else if !yym618 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv617)
		} else {
			z.DecFallback(yyv617, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv619 := &x.HTTPCheckFrequency
		yym620 := z.DecBinary()
		_ = yym620
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv619) {
		} else if !yym620 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv619)
		} else {
			z.DecFallback(yyv619, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SeccompProfileRoot = ""
	} else {
		x.SeccompProfileRoot = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = nil
	} else {
		yyv636 := &x.HostNetworkSources
		yym637 := z.DecBinary()
		_ = yym637
		if false {
		} else {
			z.F.DecSliceStringX(yyv636, false, d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = nil
	} else {
		yyv638 := &x.HostPIDSources
		yym639 := z.DecBinary()
		_ = yym639
		if false {
		} else {
			z.F.DecSliceStringX(yyv638, false, d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = nil
	} else {
		yyv640 := &x.HostIPCSources
		yym641 := z.DecBinary()
		_ = yym641
		if false {
		} else {
			z.F.DecSliceStringX(yyv640, false, d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv647 := &x.MinimumGCAge
		yym648 := z.DecBinary()
		_ = yym648
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv647) {
		} else if !yym648 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv647)
		} else {
			z.DecFallback(yyv647, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv659 := &x.StreamingConnectionIdleTimeout
		yym660 := z.DecBinary()
		_ = yym660
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv659) {
		} else if !yym660 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv659)
		} else {
			z.DecFallback(yyv659, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv661 := &x.NodeStatusUpdateFrequency
		yym662 := z.DecBinary()
		_ = yym662
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv661) {
		} else if !yym662 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv661)
		} else {
			z.DecFallback(yyv661, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv663 := &x.ImageMinimumGCAge
		yym664 := z.DecBinary()
		_ = yym664
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv663) {
		} else if !yym664 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv663)
		} else {
			z.DecFallback(yyv663, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv668 := &x.VolumeStatsAggPeriod
		yym669 := z.DecBinary()
		_ = yym669
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv668) {
		} else if !yym669 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv668)
		} else {
			z.DecFallback(yyv668, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginMTU = 0
	} else {
		x.NetworkPluginMTU = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIConfDir = ""
	} else {
		x.CNIConfDir = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIBinDir = ""
	} else {
		x.CNIBinDir = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupsPerQOS = false
	} else {
		x.CgroupsPerQOS = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteRuntimeEndpoint = ""
	} else {
		x.RemoteRuntimeEndpoint = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteImageEndpoint = ""
	} else {
		x.RemoteImageEndpoint = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv686 := &x.RuntimeRequestTimeout
		yym687 := z.DecBinary()
		_ = yym687
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv686) {
		} else if !yym687 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv686)
		} else {
			z.DecFallback(yyv686, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktAPIEndpoint = ""
	} else {
		x.RktAPIEndpoint = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitOnLockContention = false
	} else {
		x.ExitOnLockContention = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCBR0 = false
	} else {
		x.ConfigureCBR0 = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BabysitDaemons = false
	} else {
		x.BabysitDaemons = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NvidiaGPUs = 0
	} else {
		x.NvidiaGPUs = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = int64(r.DecodeInt(64))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFlannelOverlay = false
	} else {
		x.ExperimentalFlannelOverlay = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv711 := &x.OutOfDiskTransitionFrequency
		yym712 := z.DecBinary()
		_ = yym712
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv711) {
		} else if !yym712 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv711)
		} else {
			z.DecFallback(yyv711, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv714 := &x.NodeLabels
		yym715 := z.DecBinary()
		_ = yym715
		if false {
		} else {
			z.F.DecMapStringStringX(yyv714, false, d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionHard = ""
	} else {
		x.EvictionHard = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoft = ""
	} else {
		x.EvictionSoft = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoftGracePeriod = ""
	} else {
		x.EvictionSoftGracePeriod = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv721 := &x.EvictionPressureTransitionPeriod
		yym722 := z.DecBinary()
		_ = yym722
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv721) {
		} else if !yym722 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv721)
		} else {
			z.DecFallback(yyv721, false)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMaxPodGracePeriod = 0
	} else {
		x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMinimumReclaim = ""
	} else {
		x.EvictionMinimumReclaim = string(r.DecodeString())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodsPerCore = 0
	} else {
		x.PodsPerCore = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableControllerAttachDetach = false
	} else {
		x.EnableControllerAttachDetach = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemReserved = nil
	} else {
		yyv727 := &x.SystemReserved
		yym728 := z.DecBinary()
		_ = yym728
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv727) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv727), d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeReserved = nil
	} else {
		yyv729 := &x.KubeReserved
		yym730 := z.DecBinary()
		_ = yym730
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv729) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv729), d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectKernelDefaults = false
	} else {
		x.ProtectKernelDefaults = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MakeIPTablesUtilChains = false
	} else {
		x.MakeIPTablesUtilChains = bool(r.DecodeBool())
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMasqueradeBit = 0
	} else {
		x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesDropBit = 0
	} else {
		x.IPTablesDropBit = int32(r.DecodeInt(32))
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedUnsafeSysctls = nil
	} else {
		yyv735 := &x.AllowedUnsafeSysctls
		yym736 := z.DecBinary()
		_ = yym736
		if false {
		} else {
			z.F.DecSliceStringX(yyv735, false, d)
		}
	}
	yyj611++
	if yyhl611 {
		yyb611 = yyj611 > l
	} else {
		yyb611 = r.CheckBreak()
	}
	if yyb611 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalRuntimeIntegrationType = ""
	} else {
		x.ExperimentalRuntimeIntegrationType = string(r.DecodeString())
	}
	for {
		yyj611++
		if yyhl611 {
			yyb611 = yyj611 > l
		} else {
			yyb611 = r.CheckBreak()
		}
		if yyb611 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj611-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym738 := z.EncBinary()
		_ = yym738
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep739 := !z.EncBinary()
			yy2arr739 := z.EncBasicHandle().StructToArray
			var yyq739 [14]bool
			_, _, _ = yysep739, yyq739, yy2arr739
			const yyr739 bool = false
			yyq739[0] = x.Kind != ""
			yyq739[1] = x.APIVersion != ""
			var yynn739 int
			if yyr739 || yy2arr739 {
				r.EncodeArrayStart(14)
			} else {
				yynn739 = 12
				for _, b := range yyq739 {
					if b {
						yynn739++
					}
				}
				r.EncodeMapStart(yynn739)
				yynn739 = 0
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq739[0] {
					yym741 := z.EncBinary()
					_ = yym741
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq739[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym742 := z.EncBinary()
					_ = yym742
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq739[1] {
					yym744 := z.EncBinary()
					_ = yym744
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq739[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym745 := z.EncBinary()
					_ = yym745
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym747 := z.EncBinary()
				_ = yym747
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym748 := z.EncBinary()
				_ = yym748
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym750 := z.EncBinary()
				_ = yym750
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym751 := z.EncBinary()
				_ = yym751
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym753 := z.EncBinary()
				_ = yym753
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym754 := z.EncBinary()
				_ = yym754
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym756 := z.EncBinary()
				_ = yym756
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym757 := z.EncBinary()
				_ = yym757
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym759 := z.EncBinary()
				_ = yym759
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym760 := z.EncBinary()
				_ = yym760
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym762 := z.EncBinary()
				_ = yym762
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym763 := z.EncBinary()
				_ = yym763
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym765 := z.EncBinary()
				_ = yym765
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym766 := z.EncBinary()
				_ = yym766
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym768 := z.EncBinary()
				_ = yym768
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym769 := z.EncBinary()
				_ = yym769
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym771 := z.EncBinary()
				_ = yym771
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym772 := z.EncBinary()
				_ = yym772
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym774 := z.EncBinary()
				_ = yym774
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hardPodAffinitySymmetricWeight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym775 := z.EncBinary()
				_ = yym775
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym777 := z.EncBinary()
				_ = yym777
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("failureDomains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym778 := z.EncBinary()
				_ = yym778
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy780 := &x.LeaderElection
				yy780.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy781 := &x.LeaderElection
				yy781.CodecEncodeSelf(e)
			}
			if yyr739 || yy2arr739 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym782 := z.DecBinary()
	_ = yym782
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct783 := r.ContainerType()
		if yyct783 == codecSelferValueTypeMap1234 {
			yyl783 := r.ReadMapStart()
			if yyl783 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl783, d)
			}
		} else if yyct783 == codecSelferValueTypeArray1234 {
			yyl783 := r.ReadArrayStart()
			if yyl783 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl783, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys784Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys784Slc
	var yyhl784 bool = l >= 0
	for yyj784 := 0; ; yyj784++ {
		if yyhl784 {
			if yyj784 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys784Slc = r.DecodeBytes(yys784Slc, true, true)
		yys784 := string(yys784Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys784 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "hardPodAffinitySymmetricWeight":
			if r.TryDecodeAsNil() {
				x.HardPodAffinitySymmetricWeight = 0
			} else {
				x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureDomains":
			if r.TryDecodeAsNil() {
				x.FailureDomains = ""
			} else {
				x.FailureDomains = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv798 := &x.LeaderElection
				yyv798.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys784)
		} // end switch yys784
	} // end for yyj784
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj799 int
	var yyb799 bool
	var yyhl799 bool = l >= 0
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HardPodAffinitySymmetricWeight = 0
	} else {
		x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureDomains = ""
	} else {
		x.FailureDomains = string(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv813 := &x.LeaderElection
		yyv813.CodecDecodeSelf(d)
	}
	for {
		yyj799++
		if yyhl799 {
			yyb799 = yyj799 > l
		} else {
			yyb799 = r.CheckBreak()
		}
		if yyb799 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj799-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym814 := z.EncBinary()
		_ = yym814
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep815 := !z.EncBinary()
			yy2arr815 := z.EncBasicHandle().StructToArray
			var yyq815 [4]bool
			_, _, _ = yysep815, yyq815, yy2arr815
			const yyr815 bool = false
			var yynn815 int
			if yyr815 || yy2arr815 {
				r.EncodeArrayStart(4)
			} else {
				yynn815 = 4
				for _, b := range yyq815 {
					if b {
						yynn815++
					}
				}
				r.EncodeMapStart(yynn815)
				yynn815 = 0
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym817 := z.EncBinary()
				_ = yym817
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym818 := z.EncBinary()
				_ = yym818
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy820 := &x.LeaseDuration
				yym821 := z.EncBinary()
				_ = yym821
				if false {
				} else if z.HasExtensions() && z.EncExt(yy820) {
				} else if !yym821 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy820)
				} else {
					z.EncFallback(yy820)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy822 := &x.LeaseDuration
				yym823 := z.EncBinary()
				_ = yym823
				if false {
				} else if z.HasExtensions() && z.EncExt(yy822) {
				} else if !yym823 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy822)
				} else {
					z.EncFallback(yy822)
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy825 := &x.RenewDeadline
				yym826 := z.EncBinary()
				_ = yym826
				if false {
				} else if z.HasExtensions() && z.EncExt(yy825) {
				} else if !yym826 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy825)
				} else {
					z.EncFallback(yy825)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy827 := &x.RenewDeadline
				yym828 := z.EncBinary()
				_ = yym828
				if false {
				} else if z.HasExtensions() && z.EncExt(yy827) {
				} else if !yym828 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy827)
				} else {
					z.EncFallback(yy827)
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy830 := &x.RetryPeriod
				yym831 := z.EncBinary()
				_ = yym831
				if false {
				} else if z.HasExtensions() && z.EncExt(yy830) {
				} else if !yym831 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy830)
				} else {
					z.EncFallback(yy830)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy832 := &x.RetryPeriod
				yym833 := z.EncBinary()
				_ = yym833
				if false {
				} else if z.HasExtensions() && z.EncExt(yy832) {
				} else if !yym833 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy832)
				} else {
					z.EncFallback(yy832)
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym834 := z.DecBinary()
	_ = yym834
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct835 := r.ContainerType()
		if yyct835 == codecSelferValueTypeMap1234 {
			yyl835 := r.ReadMapStart()
			if yyl835 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl835, d)
			}
		} else if yyct835 == codecSelferValueTypeArray1234 {
			yyl835 := r.ReadArrayStart()
			if yyl835 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl835, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys836Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys836Slc
	var yyhl836 bool = l >= 0
	for yyj836 := 0; ; yyj836++ {
		if yyhl836 {
			if yyj836 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys836Slc = r.DecodeBytes(yys836Slc, true, true)
		yys836 := string(yys836Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys836 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv838 := &x.LeaseDuration
				yym839 := z.DecBinary()
				_ = yym839
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv838) {
				} else if !yym839 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv838)
				} else {
					z.DecFallback(yyv838, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv840 := &x.RenewDeadline
				yym841 := z.DecBinary()
				_ = yym841
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv840) {
				} else if !yym841 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv840)
				} else {
					z.DecFallback(yyv840, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv842 := &x.RetryPeriod
				yym843 := z.DecBinary()
				_ = yym843
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv842) {
				} else if !yym843 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv842)
				} else {
					z.DecFallback(yyv842, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys836)
		} // end switch yys836
	} // end for yyj836
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj844 int
	var yyb844 bool
	var yyhl844 bool = l >= 0
	yyj844++
	if yyhl844 {
		yyb844 = yyj844 > l
	} else {
		yyb844 = r.CheckBreak()
	}
	if yyb844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj844++
	if yyhl844 {
		yyb844 = yyj844 > l
	} else {
		yyb844 = r.CheckBreak()
	}
	if yyb844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv846 := &x.LeaseDuration
		yym847 := z.DecBinary()
		_ = yym847
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv846) {
		} else if !yym847 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv846)
		} else {
			z.DecFallback(yyv846, false)
		}
	}
	yyj844++
	if yyhl844 {
		yyb844 = yyj844 > l
	} else {
		yyb844 = r.CheckBreak()
	}
	if yyb844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv848 := &x.RenewDeadline
		yym849 := z.DecBinary()
		_ = yym849
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv848) {
		} else if !yym849 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv848)
		} else {
			z.DecFallback(yyv848, false)
		}
	}
	yyj844++
	if yyhl844 {
		yyb844 = yyj844 > l
	} else {
		yyb844 = r.CheckBreak()
	}
	if yyb844 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv850 := &x.RetryPeriod
		yym851 := z.DecBinary()
		_ = yym851
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv850) {
		} else if !yym851 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv850)
		} else {
			z.DecFallback(yyv850, false)
		}
	}
	for {
		yyj844++
		if yyhl844 {
			yyb844 = yyj844 > l
		} else {
			yyb844 = r.CheckBreak()
		}
		if yyb844 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj844-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym852 := z.EncBinary()
		_ = yym852
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep853 := !z.EncBinary()
			yy2arr853 := z.EncBasicHandle().StructToArray
			var yyq853 [60]bool
			_, _, _ = yysep853, yyq853, yy2arr853
			const yyr853 bool = false
			yyq853[0] = x.Kind != ""
			yyq853[1] = x.APIVersion != ""
			var yynn853 int
			if yyr853 || yy2arr853 {
				r.EncodeArrayStart(60)
			} else {
				yynn853 = 58
				for _, b := range yyq853 {
					if b {
						yynn853++
					}
				}
				r.EncodeMapStart(yynn853)
				yynn853 = 0
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq853[0] {
					yym855 := z.EncBinary()
					_ = yym855
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq853[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym856 := z.EncBinary()
					_ = yym856
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq853[1] {
					yym858 := z.EncBinary()
					_ = yym858
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq853[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym859 := z.EncBinary()
					_ = yym859
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym861 := z.EncBinary()
				_ = yym861
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym862 := z.EncBinary()
				_ = yym862
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym864 := z.EncBinary()
				_ = yym864
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym865 := z.EncBinary()
				_ = yym865
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym867 := z.EncBinary()
				_ = yym867
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym868 := z.EncBinary()
				_ = yym868
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym870 := z.EncBinary()
				_ = yym870
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym871 := z.EncBinary()
				_ = yym871
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym873 := z.EncBinary()
				_ = yym873
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym874 := z.EncBinary()
				_ = yym874
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym876 := z.EncBinary()
				_ = yym876
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym877 := z.EncBinary()
				_ = yym877
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym879 := z.EncBinary()
				_ = yym879
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym880 := z.EncBinary()
				_ = yym880
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym882 := z.EncBinary()
				_ = yym882
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentServiceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym883 := z.EncBinary()
				_ = yym883
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym885 := z.EncBinary()
				_ = yym885
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym886 := z.EncBinary()
				_ = yym886
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym888 := z.EncBinary()
				_ = yym888
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym889 := z.EncBinary()
				_ = yym889
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym891 := z.EncBinary()
				_ = yym891
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym892 := z.EncBinary()
				_ = yym892
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym894 := z.EncBinary()
				_ = yym894
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym895 := z.EncBinary()
				_ = yym895
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym897 := z.EncBinary()
				_ = yym897
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym898 := z.EncBinary()
				_ = yym898
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym900 := z.EncBinary()
				_ = yym900
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentSATokenSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym901 := z.EncBinary()
				_ = yym901
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym903 := z.EncBinary()
				_ = yym903
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRC"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym904 := z.EncBinary()
				_ = yym904
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym906 := z.EncBinary()
				_ = yym906
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym907 := z.EncBinary()
				_ = yym907
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym909 := z.EncBinary()
				_ = yym909
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForDaemonSet"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym910 := z.EncBinary()
				_ = yym910
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy912 := &x.ServiceSyncPeriod
				yym913 := z.EncBinary()
				_ = yym913
				if false {
				} else if z.HasExtensions() && z.EncExt(yy912) {
				} else if !yym913 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy912)
				} else {
					z.EncFallback(yy912)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy914 := &x.ServiceSyncPeriod
				yym915 := z.EncBinary()
				_ = yym915
				if false {
				} else if z.HasExtensions() && z.EncExt(yy914) {
				} else if !yym915 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy914)
				} else {
					z.EncFallback(yy914)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy917 := &x.NodeSyncPeriod
				yym918 := z.EncBinary()
				_ = yym918
				if false {
				} else if z.HasExtensions() && z.EncExt(yy917) {
				} else if !yym918 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy917)
				} else {
					z.EncFallback(yy917)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy919 := &x.NodeSyncPeriod
				yym920 := z.EncBinary()
				_ = yym920
				if false {
				} else if z.HasExtensions() && z.EncExt(yy919) {
				} else if !yym920 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy919)
				} else {
					z.EncFallback(yy919)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy922 := &x.RouteReconciliationPeriod
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else if z.HasExtensions() && z.EncExt(yy922) {
				} else if !yym923 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy922)
				} else {
					z.EncFallback(yy922)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("routeReconciliationPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy924 := &x.RouteReconciliationPeriod
				yym925 := z.EncBinary()
				_ = yym925
				if false {
				} else if z.HasExtensions() && z.EncExt(yy924) {
				} else if !yym925 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy924)
				} else {
					z.EncFallback(yy924)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy927 := &x.ResourceQuotaSyncPeriod
				yym928 := z.EncBinary()
				_ = yym928
				if false {
				} else if z.HasExtensions() && z.EncExt(yy927) {
				} else if !yym928 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy927)
				} else {
					z.EncFallback(yy927)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy929 := &x.ResourceQuotaSyncPeriod
				yym930 := z.EncBinary()
				_ = yym930
				if false {
				} else if z.HasExtensions() && z.EncExt(yy929) {
				} else if !yym930 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy929)
				} else {
					z.EncFallback(yy929)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy932 := &x.NamespaceSyncPeriod
				yym933 := z.EncBinary()
				_ = yym933
				if false {
				} else if z.HasExtensions() && z.EncExt(yy932) {
				} else if !yym933 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy932)
				} else {
					z.EncFallback(yy932)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy934 := &x.NamespaceSyncPeriod
				yym935 := z.EncBinary()
				_ = yym935
				if false {
				} else if z.HasExtensions() && z.EncExt(yy934) {
				} else if !yym935 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy934)
				} else {
					z.EncFallback(yy934)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy937 := &x.PVClaimBinderSyncPeriod
				yym938 := z.EncBinary()
				_ = yym938
				if false {
				} else if z.HasExtensions() && z.EncExt(yy937) {
				} else if !yym938 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy937)
				} else {
					z.EncFallback(yy937)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy939 := &x.PVClaimBinderSyncPeriod
				yym940 := z.EncBinary()
				_ = yym940
				if false {
				} else if z.HasExtensions() && z.EncExt(yy939) {
				} else if !yym940 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy939)
				} else {
					z.EncFallback(yy939)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy942 := &x.MinResyncPeriod
				yym943 := z.EncBinary()
				_ = yym943
				if false {
				} else if z.HasExtensions() && z.EncExt(yy942) {
				} else if !yym943 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy942)
				} else {
					z.EncFallback(yy942)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy944 := &x.MinResyncPeriod
				yym945 := z.EncBinary()
				_ = yym945
				if false {
				} else if z.HasExtensions() && z.EncExt(yy944) {
				} else if !yym945 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy944)
				} else {
					z.EncFallback(yy944)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym947 := z.EncBinary()
				_ = yym947
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym948 := z.EncBinary()
				_ = yym948
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy950 := &x.HorizontalPodAutoscalerSyncPeriod
				yym951 := z.EncBinary()
				_ = yym951
				if false {
				} else if z.HasExtensions() && z.EncExt(yy950) {
				} else if !yym951 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy950)
				} else {
					z.EncFallback(yy950)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy952 := &x.HorizontalPodAutoscalerSyncPeriod
				yym953 := z.EncBinary()
				_ = yym953
				if false {
				} else if z.HasExtensions() && z.EncExt(yy952) {
				} else if !yym953 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy952)
				} else {
					z.EncFallback(yy952)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy955 := &x.DeploymentControllerSyncPeriod
				yym956 := z.EncBinary()
				_ = yym956
				if false {
				} else if z.HasExtensions() && z.EncExt(yy955) {
				} else if !yym956 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy955)
				} else {
					z.EncFallback(yy955)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy957 := &x.DeploymentControllerSyncPeriod
				yym958 := z.EncBinary()
				_ = yym958
				if false {
				} else if z.HasExtensions() && z.EncExt(yy957) {
				} else if !yym958 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy957)
				} else {
					z.EncFallback(yy957)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy960 := &x.PodEvictionTimeout
				yym961 := z.EncBinary()
				_ = yym961
				if false {
				} else if z.HasExtensions() && z.EncExt(yy960) {
				} else if !yym961 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy960)
				} else {
					z.EncFallback(yy960)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy962 := &x.PodEvictionTimeout
				yym963 := z.EncBinary()
				_ = yym963
				if false {
				} else if z.HasExtensions() && z.EncExt(yy962) {
				} else if !yym963 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy962)
				} else {
					z.EncFallback(yy962)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym965 := z.EncBinary()
				_ = yym965
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym966 := z.EncBinary()
				_ = yym966
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym968 := z.EncBinary()
				_ = yym968
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym969 := z.EncBinary()
				_ = yym969
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy971 := &x.NodeMonitorGracePeriod
				yym972 := z.EncBinary()
				_ = yym972
				if false {
				} else if z.HasExtensions() && z.EncExt(yy971) {
				} else if !yym972 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy971)
				} else {
					z.EncFallback(yy971)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy973 := &x.NodeMonitorGracePeriod
				yym974 := z.EncBinary()
				_ = yym974
				if false {
				} else if z.HasExtensions() && z.EncExt(yy973) {
				} else if !yym974 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy973)
				} else {
					z.EncFallback(yy973)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym976 := z.EncBinary()
				_ = yym976
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy979 := &x.NodeStartupGracePeriod
				yym980 := z.EncBinary()
				_ = yym980
				if false {
				} else if z.HasExtensions() && z.EncExt(yy979) {
				} else if !yym980 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy979)
				} else {
					z.EncFallback(yy979)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy981 := &x.NodeStartupGracePeriod
				yym982 := z.EncBinary()
				_ = yym982
				if false {
				} else if z.HasExtensions() && z.EncExt(yy981) {
				} else if !yym982 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy981)
				} else {
					z.EncFallback(yy981)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy984 := &x.NodeMonitorPeriod
				yym985 := z.EncBinary()
				_ = yym985
				if false {
				} else if z.HasExtensions() && z.EncExt(yy984) {
				} else if !yym985 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy984)
				} else {
					z.EncFallback(yy984)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy986 := &x.NodeMonitorPeriod
				yym987 := z.EncBinary()
				_ = yym987
				if false {
				} else if z.HasExtensions() && z.EncExt(yy986) {
				} else if !yym987 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy986)
				} else {
					z.EncFallback(yy986)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym989 := z.EncBinary()
				_ = yym989
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym990 := z.EncBinary()
				_ = yym990
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym992 := z.EncBinary()
				_ = yym992
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym993 := z.EncBinary()
				_ = yym993
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym995 := z.EncBinary()
				_ = yym995
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym996 := z.EncBinary()
				_ = yym996
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym998 := z.EncBinary()
				_ = yym998
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("approveAllKubeletCSRsForGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym999 := z.EncBinary()
				_ = yym999
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1001 := z.EncBinary()
				_ = yym1001
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1002 := z.EncBinary()
				_ = yym1002
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1004 := z.EncBinary()
				_ = yym1004
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1005 := z.EncBinary()
				_ = yym1005
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1007 := z.EncBinary()
				_ = yym1007
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1008 := z.EncBinary()
				_ = yym1008
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1010 := z.EncBinary()
				_ = yym1010
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1011 := z.EncBinary()
				_ = yym1011
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1013 := z.EncBinary()
				_ = yym1013
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeCIDRMaskSize"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1014 := z.EncBinary()
				_ = yym1014
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1016 := z.EncBinary()
				_ = yym1016
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1017 := z.EncBinary()
				_ = yym1017
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1019 := z.EncBinary()
				_ = yym1019
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCloudRoutes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1020 := z.EncBinary()
				_ = yym1020
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1022 := z.EncBinary()
				_ = yym1022
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1023 := z.EncBinary()
				_ = yym1023
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1025 := z.EncBinary()
				_ = yym1025
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1026 := z.EncBinary()
				_ = yym1026
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1028 := z.EncBinary()
				_ = yym1028
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1029 := z.EncBinary()
				_ = yym1029
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1031 := z.EncBinary()
				_ = yym1031
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1032 := z.EncBinary()
				_ = yym1032
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1034 := &x.LeaderElection
				yy1034.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1035 := &x.LeaderElection
				yy1035.CodecEncodeSelf(e)
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1037 := &x.VolumeConfiguration
				yy1037.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1038 := &x.VolumeConfiguration
				yy1038.CodecEncodeSelf(e)
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1040 := &x.ControllerStartInterval
				yym1041 := z.EncBinary()
				_ = yym1041
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1040) {
				} else if !yym1041 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1040)
				} else {
					z.EncFallback(yy1040)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("controllerStartInterval"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1042 := &x.ControllerStartInterval
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1042) {
				} else if !yym1043 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1042)
				} else {
					z.EncFallback(yy1042)
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1045 := z.EncBinary()
				_ = yym1045
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableGarbageCollector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1046 := z.EncBinary()
				_ = yym1046
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1048 := z.EncBinary()
				_ = yym1048
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentGCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1049 := z.EncBinary()
				_ = yym1049
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1051 := z.EncBinary()
				_ = yym1051
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1052 := z.EncBinary()
				_ = yym1052
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1054 := z.EncBinary()
				_ = yym1054
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secondaryNodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1055 := z.EncBinary()
				_ = yym1055
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1057 := z.EncBinary()
				_ = yym1057
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("largeClusterSizeThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1058 := z.EncBinary()
				_ = yym1058
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1060 := z.EncBinary()
				_ = yym1060
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("unhealthyZoneThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1061 := z.EncBinary()
				_ = yym1061
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			}
			if yyr853 || yy2arr853 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1062 := z.DecBinary()
	_ = yym1062
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1063 := r.ContainerType()
		if yyct1063 == codecSelferValueTypeMap1234 {
			yyl1063 := r.ReadMapStart()
			if yyl1063 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1063, d)
			}
		} else if yyct1063 == codecSelferValueTypeArray1234 {
			yyl1063 := r.ReadArrayStart()
			if yyl1063 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1063, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1064Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1064Slc
	var yyhl1064 bool = l >= 0
	for yyj1064 := 0; ; yyj1064++ {
		if yyhl1064 {
			if yyj1064 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1064Slc = r.DecodeBytes(yys1064Slc, true, true)
		yys1064 := string(yys1064Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1064 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentServiceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentServiceSyncs = 0
			} else {
				x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentSATokenSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentSATokenSyncs = 0
			} else {
				x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRC":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRC = 0
			} else {
				x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRS":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRS = 0
			} else {
				x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForDaemonSet":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForDaemonSet = 0
			} else {
				x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1084 := &x.ServiceSyncPeriod
				yym1085 := z.DecBinary()
				_ = yym1085
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1084) {
				} else if !yym1085 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1084)
				} else {
					z.DecFallback(yyv1084, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1086 := &x.NodeSyncPeriod
				yym1087 := z.DecBinary()
				_ = yym1087
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1086) {
				} else if !yym1087 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1086)
				} else {
					z.DecFallback(yyv1086, false)
				}
			}
		case "routeReconciliationPeriod":
			if r.TryDecodeAsNil() {
				x.RouteReconciliationPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1088 := &x.RouteReconciliationPeriod
				yym1089 := z.DecBinary()
				_ = yym1089
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1088) {
				} else if !yym1089 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1088)
				} else {
					z.DecFallback(yyv1088, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1090 := &x.ResourceQuotaSyncPeriod
				yym1091 := z.DecBinary()
				_ = yym1091
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1090) {
				} else if !yym1091 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1090)
				} else {
					z.DecFallback(yyv1090, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1092 := &x.NamespaceSyncPeriod
				yym1093 := z.DecBinary()
				_ = yym1093
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1092) {
				} else if !yym1093 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1092)
				} else {
					z.DecFallback(yyv1092, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1094 := &x.PVClaimBinderSyncPeriod
				yym1095 := z.DecBinary()
				_ = yym1095
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1094) {
				} else if !yym1095 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1094)
				} else {
					z.DecFallback(yyv1094, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1096 := &x.MinResyncPeriod
				yym1097 := z.DecBinary()
				_ = yym1097
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1096) {
				} else if !yym1097 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1096)
				} else {
					z.DecFallback(yyv1096, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1099 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1100 := z.DecBinary()
				_ = yym1100
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1099) {
				} else if !yym1100 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1099)
				} else {
					z.DecFallback(yyv1099, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1101 := &x.DeploymentControllerSyncPeriod
				yym1102 := z.DecBinary()
				_ = yym1102
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1101) {
				} else if !yym1102 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1101)
				} else {
					z.DecFallback(yyv1101, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv1103 := &x.PodEvictionTimeout
				yym1104 := z.DecBinary()
				_ = yym1104
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1103) {
				} else if !yym1104 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1103)
				} else {
					z.DecFallback(yyv1103, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int32(r.DecodeInt(32))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1107 := &x.NodeMonitorGracePeriod
				yym1108 := z.DecBinary()
				_ = yym1108
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1107) {
				} else if !yym1108 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1107)
				} else {
					z.DecFallback(yyv1107, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int32(r.DecodeInt(32))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1110 := &x.NodeStartupGracePeriod
				yym1111 := z.DecBinary()
				_ = yym1111
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1110) {
				} else if !yym1111 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1110)
				} else {
					z.DecFallback(yyv1110, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1112 := &x.NodeMonitorPeriod
				yym1113 := z.DecBinary()
				_ = yym1113
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1112) {
				} else if !yym1113 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1112)
				} else {
					z.DecFallback(yyv1112, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "clusterSigningCertFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningCertFile = ""
			} else {
				x.ClusterSigningCertFile = string(r.DecodeString())
			}
		case "clusterSigningKeyFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningKeyFile = ""
			} else {
				x.ClusterSigningKeyFile = string(r.DecodeString())
			}
		case "approveAllKubeletCSRsForGroup":
			if r.TryDecodeAsNil() {
				x.ApproveAllKubeletCSRsForGroup = ""
			} else {
				x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "serviceCIDR":
			if r.TryDecodeAsNil() {
				x.ServiceCIDR = ""
			} else {
				x.ServiceCIDR = string(r.DecodeString())
			}
		case "nodeCIDRMaskSize":
			if r.TryDecodeAsNil() {
				x.NodeCIDRMaskSize = 0
			} else {
				x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "configureCloudRoutes":
			if r.TryDecodeAsNil() {
				x.ConfigureCloudRoutes = false
			} else {
				x.ConfigureCloudRoutes = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv1129 := &x.LeaderElection
				yyv1129.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv1130 := &x.VolumeConfiguration
				yyv1130.CodecDecodeSelf(d)
			}
		case "controllerStartInterval":
			if r.TryDecodeAsNil() {
				x.ControllerStartInterval = pkg1_unversioned.Duration{}
			} else {
				yyv1131 := &x.ControllerStartInterval
				yym1132 := z.DecBinary()
				_ = yym1132
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1131) {
				} else if !yym1132 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1131)
				} else {
					z.DecFallback(yyv1131, false)
				}
			}
		case "enableGarbageCollector":
			if r.TryDecodeAsNil() {
				x.EnableGarbageCollector = false
			} else {
				x.EnableGarbageCollector = bool(r.DecodeBool())
			}
		case "concurrentGCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentGCSyncs = 0
			} else {
				x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
			}
		case "nodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.NodeEvictionRate = 0
			} else {
				x.NodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "secondaryNodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.SecondaryNodeEvictionRate = 0
			} else {
				x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "largeClusterSizeThreshold":
			if r.TryDecodeAsNil() {
				x.LargeClusterSizeThreshold = 0
			} else {
				x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
			}
		case "unhealthyZoneThreshold":
			if r.TryDecodeAsNil() {
				x.UnhealthyZoneThreshold = 0
			} else {
				x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1064)
		} // end switch yys1064
	} // end for yyj1064
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1139 int
	var yyb1139 bool
	var yyhl1139 bool = l >= 0
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentServiceSyncs = 0
	} else {
		x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentSATokenSyncs = 0
	} else {
		x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRC = 0
	} else {
		x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRS = 0
	} else {
		x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForDaemonSet = 0
	} else {
		x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1159 := &x.ServiceSyncPeriod
		yym1160 := z.DecBinary()
		_ = yym1160
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1159) {
		} else if !yym1160 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1159)
		} else {
			z.DecFallback(yyv1159, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1161 := &x.NodeSyncPeriod
		yym1162 := z.DecBinary()
		_ = yym1162
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1161) {
		} else if !yym1162 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1161)
		} else {
			z.DecFallback(yyv1161, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RouteReconciliationPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1163 := &x.RouteReconciliationPeriod
		yym1164 := z.DecBinary()
		_ = yym1164
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1163) {
		} else if !yym1164 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1163)
		} else {
			z.DecFallback(yyv1163, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1165 := &x.ResourceQuotaSyncPeriod
		yym1166 := z.DecBinary()
		_ = yym1166
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1165) {
		} else if !yym1166 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1165)
		} else {
			z.DecFallback(yyv1165, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1167 := &x.NamespaceSyncPeriod
		yym1168 := z.DecBinary()
		_ = yym1168
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1167) {
		} else if !yym1168 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1167)
		} else {
			z.DecFallback(yyv1167, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1169 := &x.PVClaimBinderSyncPeriod
		yym1170 := z.DecBinary()
		_ = yym1170
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1169) {
		} else if !yym1170 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1169)
		} else {
			z.DecFallback(yyv1169, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1171 := &x.MinResyncPeriod
		yym1172 := z.DecBinary()
		_ = yym1172
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1171) {
		} else if !yym1172 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1171)
		} else {
			z.DecFallback(yyv1171, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1174 := &x.HorizontalPodAutoscalerSyncPeriod
		yym1175 := z.DecBinary()
		_ = yym1175
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1174) {
		} else if !yym1175 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1174)
		} else {
			z.DecFallback(yyv1174, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1176 := &x.DeploymentControllerSyncPeriod
		yym1177 := z.DecBinary()
		_ = yym1177
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1176) {
		} else if !yym1177 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1176)
		} else {
			z.DecFallback(yyv1176, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv1178 := &x.PodEvictionTimeout
		yym1179 := z.DecBinary()
		_ = yym1179
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1178) {
		} else if !yym1179 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1178)
		} else {
			z.DecFallback(yyv1178, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1182 := &x.NodeMonitorGracePeriod
		yym1183 := z.DecBinary()
		_ = yym1183
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1182) {
		} else if !yym1183 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1182)
		} else {
			z.DecFallback(yyv1182, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1185 := &x.NodeStartupGracePeriod
		yym1186 := z.DecBinary()
		_ = yym1186
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1185) {
		} else if !yym1186 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1185)
		} else {
			z.DecFallback(yyv1185, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1187 := &x.NodeMonitorPeriod
		yym1188 := z.DecBinary()
		_ = yym1188
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1187) {
		} else if !yym1188 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1187)
		} else {
			z.DecFallback(yyv1187, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningCertFile = ""
	} else {
		x.ClusterSigningCertFile = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningKeyFile = ""
	} else {
		x.ClusterSigningKeyFile = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ApproveAllKubeletCSRsForGroup = ""
	} else {
		x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceCIDR = ""
	} else {
		x.ServiceCIDR = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeCIDRMaskSize = 0
	} else {
		x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCloudRoutes = false
	} else {
		x.ConfigureCloudRoutes = bool(r.DecodeBool())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv1204 := &x.LeaderElection
		yyv1204.CodecDecodeSelf(d)
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv1205 := &x.VolumeConfiguration
		yyv1205.CodecDecodeSelf(d)
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ControllerStartInterval = pkg1_unversioned.Duration{}
	} else {
		yyv1206 := &x.ControllerStartInterval
		yym1207 := z.DecBinary()
		_ = yym1207
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1206) {
		} else if !yym1207 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1206)
		} else {
			z.DecFallback(yyv1206, false)
		}
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableGarbageCollector = false
	} else {
		x.EnableGarbageCollector = bool(r.DecodeBool())
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentGCSyncs = 0
	} else {
		x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeEvictionRate = 0
	} else {
		x.NodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecondaryNodeEvictionRate = 0
	} else {
		x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LargeClusterSizeThreshold = 0
	} else {
		x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
	}
	yyj1139++
	if yyhl1139 {
		yyb1139 = yyj1139 > l
	} else {
		yyb1139 = r.CheckBreak()
	}
	if yyb1139 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnhealthyZoneThreshold = 0
	} else {
		x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
	}
	for {
		yyj1139++
		if yyhl1139 {
			yyb1139 = yyj1139 > l
		} else {
			yyb1139 = r.CheckBreak()
		}
		if yyb1139 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1139-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1214 := z.EncBinary()
		_ = yym1214
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1215 := !z.EncBinary()
			yy2arr1215 := z.EncBasicHandle().StructToArray
			var yyq1215 [4]bool
			_, _, _ = yysep1215, yyq1215, yy2arr1215
			const yyr1215 bool = false
			var yynn1215 int
			if yyr1215 || yy2arr1215 {
				r.EncodeArrayStart(4)
			} else {
				yynn1215 = 4
				for _, b := range yyq1215 {
					if b {
						yynn1215++
					}
				}
				r.EncodeMapStart(yynn1215)
				yynn1215 = 0
			}
			if yyr1215 || yy2arr1215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1217 := z.EncBinary()
				_ = yym1217
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1218 := z.EncBinary()
				_ = yym1218
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr1215 || yy2arr1215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1220 := z.EncBinary()
				_ = yym1220
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDynamicProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1221 := z.EncBinary()
				_ = yym1221
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			}
			if yyr1215 || yy2arr1215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1223 := &x.PersistentVolumeRecyclerConfiguration
				yy1223.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1224 := &x.PersistentVolumeRecyclerConfiguration
				yy1224.CodecEncodeSelf(e)
			}
			if yyr1215 || yy2arr1215 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1226 := z.EncBinary()
				_ = yym1226
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("flexVolumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1227 := z.EncBinary()
				_ = yym1227
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			}
			if yyr1215 || yy2arr1215 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1228 := z.DecBinary()
	_ = yym1228
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1229 := r.ContainerType()
		if yyct1229 == codecSelferValueTypeMap1234 {
			yyl1229 := r.ReadMapStart()
			if yyl1229 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1229, d)
			}
		} else if yyct1229 == codecSelferValueTypeArray1234 {
			yyl1229 := r.ReadArrayStart()
			if yyl1229 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1229, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1230Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1230Slc
	var yyhl1230 bool = l >= 0
	for yyj1230 := 0; ; yyj1230++ {
		if yyhl1230 {
			if yyj1230 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1230Slc = r.DecodeBytes(yys1230Slc, true, true)
		yys1230 := string(yys1230Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1230 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "enableDynamicProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableDynamicProvisioning = false
			} else {
				x.EnableDynamicProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv1233 := &x.PersistentVolumeRecyclerConfiguration
				yyv1233.CodecDecodeSelf(d)
			}
		case "flexVolumePluginDir":
			if r.TryDecodeAsNil() {
				x.FlexVolumePluginDir = ""
			} else {
				x.FlexVolumePluginDir = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1230)
		} // end switch yys1230
	} // end for yyj1230
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1235 int
	var yyb1235 bool
	var yyhl1235 bool = l >= 0
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDynamicProvisioning = false
	} else {
		x.EnableDynamicProvisioning = bool(r.DecodeBool())
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv1238 := &x.PersistentVolumeRecyclerConfiguration
		yyv1238.CodecDecodeSelf(d)
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FlexVolumePluginDir = ""
	} else {
		x.FlexVolumePluginDir = string(r.DecodeString())
	}
	for {
		yyj1235++
		if yyhl1235 {
			yyb1235 = yyj1235 > l
		} else {
			yyb1235 = r.CheckBreak()
		}
		if yyb1235 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1235-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1240 := z.EncBinary()
		_ = yym1240
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1241 := !z.EncBinary()
			yy2arr1241 := z.EncBasicHandle().StructToArray
			var yyq1241 [7]bool
			_, _, _ = yysep1241, yyq1241, yy2arr1241
			const yyr1241 bool = false
			var yynn1241 int
			if yyr1241 || yy2arr1241 {
				r.EncodeArrayStart(7)
			} else {
				yynn1241 = 7
				for _, b := range yyq1241 {
					if b {
						yynn1241++
					}
				}
				r.EncodeMapStart(yynn1241)
				yynn1241 = 0
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1243 := z.EncBinary()
				_ = yym1243
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1244 := z.EncBinary()
				_ = yym1244
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1246 := z.EncBinary()
				_ = yym1246
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1247 := z.EncBinary()
				_ = yym1247
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1249 := z.EncBinary()
				_ = yym1249
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1250 := z.EncBinary()
				_ = yym1250
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1252 := z.EncBinary()
				_ = yym1252
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1253 := z.EncBinary()
				_ = yym1253
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1255 := z.EncBinary()
				_ = yym1255
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1256 := z.EncBinary()
				_ = yym1256
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1258 := z.EncBinary()
				_ = yym1258
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1259 := z.EncBinary()
				_ = yym1259
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1261 := z.EncBinary()
				_ = yym1261
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1262 := z.EncBinary()
				_ = yym1262
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1263 := z.DecBinary()
	_ = yym1263
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1264 := r.ContainerType()
		if yyct1264 == codecSelferValueTypeMap1234 {
			yyl1264 := r.ReadMapStart()
			if yyl1264 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1264, d)
			}
		} else if yyct1264 == codecSelferValueTypeArray1234 {
			yyl1264 := r.ReadArrayStart()
			if yyl1264 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1264, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1265Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1265Slc
	var yyhl1265 bool = l >= 0
	for yyj1265 := 0; ; yyj1265++ {
		if yyhl1265 {
			if yyj1265 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1265Slc = r.DecodeBytes(yys1265Slc, true, true)
		yys1265 := string(yys1265Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1265 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int32(r.DecodeInt(32))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1265)
		} // end switch yys1265
	} // end for yyj1265
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1273 int
	var yyb1273 bool
	var yyhl1273 bool = l >= 0
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int32(r.DecodeInt(32))
	}
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
	}
	yyj1273++
	if yyhl1273 {
		yyb1273 = yyj1273 > l
	} else {
		yyb1273 = r.CheckBreak()
	}
	if yyb1273 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
	}
	for {
		yyj1273++
		if yyhl1273 {
			yyb1273 = yyj1273 > l
		} else {
			yyb1273 = r.CheckBreak()
		}
		if yyb1273 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1273-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encconfig_ConfigurationMap(v pkg2_config.ConfigurationMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1281, yyv1281 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym1282 := z.EncBinary()
		_ = yym1282
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk1281))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yym1283 := z.EncBinary()
		_ = yym1283
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1281))
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decconfig_ConfigurationMap(v *pkg2_config.ConfigurationMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1284 := *v
	yyl1284 := r.ReadMapStart()
	yybh1284 := z.DecBasicHandle()
	if yyv1284 == nil {
		yyrl1284, _ := z.DecInferLen(yyl1284, yybh1284.MaxInitLen, 32)
		yyv1284 = make(map[string]string, yyrl1284)
		*v = yyv1284
	}
	var yymk1284 string
	var yymv1284 string
	var yymg1284 bool
	if yybh1284.MapValueReset {
	}
	if yyl1284 > 0 {
		for yyj1284 := 0; yyj1284 < yyl1284; yyj1284++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1284 = ""
			} else {
				yymk1284 = string(r.DecodeString())
			}

			if yymg1284 {
				yymv1284 = yyv1284[yymk1284]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1284 = ""
			} else {
				yymv1284 = string(r.DecodeString())
			}

			if yyv1284 != nil {
				yyv1284[yymk1284] = yymv1284
			}
		}
	} else if yyl1284 < 0 {
		for yyj1284 := 0; !r.CheckBreak(); yyj1284++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1284 = ""
			} else {
				yymk1284 = string(r.DecodeString())
			}

			if yymg1284 {
				yymv1284 = yyv1284[yymk1284]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1284 = ""
			} else {
				yymv1284 = string(r.DecodeString())
			}

			if yyv1284 != nil {
				yyv1284[yymk1284] = yymv1284
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
