/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.RestrictedApi;
import com.google.errorprone.fixes.Fix;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class Description {
    public static final Description NO_MATCH = new Description(null, "<no match>", "<no match>", "<no match>", (List<Fix>)ImmutableList.of(), Optional.of(BugPattern.SeverityLevel.SUGGESTION));
    public final JCDiagnostic.DiagnosticPosition position;
    public final String checkName;
    private final String rawMessage;
    @Nullable
    private final String linkUrl;
    public final ImmutableList<Fix> fixes;
    private final Optional<BugPattern.SeverityLevel> severity;

    public BugPattern.SeverityLevel severity() {
        return this.severity.get();
    }

    public String getMessage() {
        return String.format("[%s] %s", this.checkName, this.getMessageWithoutCheckName());
    }

    @Nullable
    public String getLink() {
        return this.linkUrl;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public String getMessageWithoutCheckName() {
        return this.linkUrl != null ? String.format("%s\n%s", this.rawMessage, Description.linkTextForDiagnostic(this.linkUrl)) : String.format("%s", this.rawMessage);
    }

    private Description(JCDiagnostic.DiagnosticPosition position, String checkName, String rawMessage, @Nullable String linkUrl, List<Fix> fixes, Optional<BugPattern.SeverityLevel> severity) {
        this.position = position;
        this.checkName = checkName;
        this.rawMessage = rawMessage;
        this.linkUrl = linkUrl;
        this.fixes = ImmutableList.copyOf(fixes);
        this.severity = severity;
    }

    @CheckReturnValue
    public Description applySeverityOverride(BugPattern.SeverityLevel severity) {
        return new Description(this.position, this.checkName, this.rawMessage, this.linkUrl, (List<Fix>)this.fixes, Optional.of(this.severity.orElse(severity)));
    }

    @Nullable
    private static String linkTextForDiagnostic(String linkUrl) {
        return Strings.isNullOrEmpty((String)linkUrl) ? null : "  (see " + linkUrl + ")";
    }

    @RestrictedApi(explanation="Use describeMatch or buildDescription on BugChecker instead.", link="", allowedOnPath=".*/java/com/google/devtools/staticanalysis/errorprone/pluggabletype/LatticeAdapter.java|.*/java/com/google/devtools/staticanalysis/errorprone/pluggabletype/LatticeInfo.java|.*/third_party/java_src/error_prone/project/check_api/src/main/java/com/google/errorprone/bugpatterns/BugChecker.java")
    public static Builder builder(Tree node, String name, @Nullable String link, String message) {
        return new Builder((JCDiagnostic.DiagnosticPosition)((Object)node), name, link, message);
    }

    @RestrictedApi(explanation="Use describeMatch or buildDescription on BugChecker instead.", link="", allowedOnPath=".*/third_party/java_src/error_prone/project/check_api/src/main/java/com/google/errorprone/bugpatterns/BugChecker.java")
    public static Builder builder(JCDiagnostic.DiagnosticPosition position, String name, @Nullable String link, String message) {
        return new Builder(position, name, link, message);
    }

    @RestrictedApi(explanation="Use describeMatch or buildDescription on BugChecker instead.", link="", allowedOnPath=".*/third_party/java_src/error_prone/project/check_api/src/main/java/com/google/errorprone/bugpatterns/BugChecker.java|.*/third_party/java_src/error_prone/project/core/src/main/java/com/google/errorprone/refaster/RefasterScanner.java")
    public static Builder builder(JCTree tree, String name, @Nullable String link, String message) {
        return new Builder(tree, name, link, message);
    }

    public static class Builder {
        private final JCDiagnostic.DiagnosticPosition position;
        private final String name;
        private String linkUrl;
        private Optional<BugPattern.SeverityLevel> severity = Optional.empty();
        private final ImmutableList.Builder<Fix> fixListBuilder = ImmutableList.builder();
        private String rawMessage;

        private Builder(JCDiagnostic.DiagnosticPosition position, String name, @Nullable String linkUrl, String rawMessage) {
            this.position = (JCDiagnostic.DiagnosticPosition)Preconditions.checkNotNull((Object)position);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.linkUrl = linkUrl;
            this.rawMessage = (String)Preconditions.checkNotNull((Object)rawMessage);
        }

        @CanIgnoreReturnValue
        public Builder addFix(Fix fix) {
            Preconditions.checkNotNull((Object)fix, (Object)"fix must not be null");
            if (!fix.isEmpty()) {
                this.fixListBuilder.add((Object)fix);
            }
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addFix(Optional<? extends Fix> fix) {
            Preconditions.checkNotNull(fix, (Object)"fix must not be null");
            fix.ifPresent(this::addFix);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFixes(List<? extends Fix> fixes) {
            Preconditions.checkNotNull(fixes, (Object)"fixes must not be null");
            for (Fix fix : fixes) {
                this.addFix(fix);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMessage(String message) {
            Preconditions.checkNotNull((Object)message, (Object)"message must not be null");
            this.rawMessage = message;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLinkUrl(String linkUrl) {
            Preconditions.checkNotNull((Object)linkUrl, (Object)"linkUrl must not be null");
            this.linkUrl = linkUrl;
            return this;
        }

        @RestrictedApi(explanation="Prefer to set a single default severity using @BugPattern. Overriding the severity for individual Descriptions causes any command line options to be ignored, which is potentially very confusing.", link="", allowedOnPath=".*/third_party/java_src/error_prone/project/check_api/src/main/java/com/google/errorprone/matchers/Description.java$|.*/java/com/google/devtools/javatools/staticanalysis/xlang/java/BugCheckerUsingXlang.java$|.*/java/com/google/devtools/staticanalysis/errorprone/RestrictedInheritanceChecker.java$|.*/java/com/google/devtools/staticanalysis/errorprone/pluggabletype/LatticeAdapter.java$|.*/third_party/java_src/error_prone/project/core/src/main/java/com/google/errorprone/bugpatterns/RestrictedApiChecker.java$|.*/third_party/java_src/error_prone/project/core/src/main/java/com/google/errorprone/refaster/RefasterScanner.java$")
        @CanIgnoreReturnValue
        public Builder overrideSeverity(BugPattern.SeverityLevel severity) {
            Preconditions.checkNotNull((Object)severity, (Object)"severity must not be null");
            this.severity = Optional.of(severity);
            return this;
        }

        public Description build() {
            return new Description(this.position, this.name, this.rawMessage, this.linkUrl, (List<Fix>)this.fixListBuilder.build(), this.severity);
        }
    }
}

