/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class Selector {
    public static final String SELECTOR_LOCAL_NAME = "selector";
    private final String mPackageName;

    public Selector(String packageName) {
        this.mPackageName = (String)Preconditions.checkNotNull((Object)packageName);
    }

    boolean appliesTo(XmlElement element) {
        Optional<XmlAttribute> packageName = element.getDocument().getPackage();
        return packageName.isPresent() && this.mPackageName.equals(((XmlAttribute)packageName.get()).getValue());
    }

    boolean isResolvable(KeyResolver<String> resolver) {
        return resolver.resolve(this.mPackageName) != null;
    }

    public String toString() {
        return this.mPackageName;
    }
}

