/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;

@BugPattern(summary="An implementation of Object.toString() should never return null.", severity=BugPattern.SeverityLevel.WARNING)
public class ToStringReturnsNull
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!Matchers.toStringMethodDeclaration().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return tree.accept(new FindReturnNullLiteralScanner(), null) != false ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static class FindReturnNullLiteralScanner
    extends BooleanScanner {
        private FindReturnNullLiteralScanner() {
        }

        @Override
        public Boolean visitLambdaExpression(LambdaExpressionTree node, Void unused) {
            return false;
        }

        @Override
        public Boolean visitClass(ClassTree node, Void unused) {
            return false;
        }

        @Override
        public Boolean visitReturn(ReturnTree node, Void unused) {
            ExpressionTree expression = node.getExpression();
            return expression != null && new ReturnExpressionScanner().scan((Tree)expression, null) != false;
        }

        private static class ReturnExpressionScanner
        extends BooleanScanner {
            private ReturnExpressionScanner() {
            }

            @Override
            public Boolean scan(Tree tree, Void unused) {
                switch (tree.getKind()) {
                    case NULL_LITERAL: {
                        return true;
                    }
                    case PARENTHESIZED: 
                    case CONDITIONAL_EXPRESSION: {
                        return super.scan(tree, unused);
                    }
                }
                return false;
            }
        }
    }

    private static abstract class BooleanScanner
    extends TreeScanner<Boolean, Void> {
        private BooleanScanner() {
        }

        @Override
        public Boolean scan(Tree tree, Void unused) {
            return Boolean.TRUE.equals(super.scan(tree, unused));
        }

        @Override
        public final Boolean reduce(Boolean a, Boolean b) {
            return Boolean.TRUE.equals(a) || Boolean.TRUE.equals(b);
        }
    }
}

