/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ErrorProneVersion {
    private static final String PROPERTIES_RESOURCE = "/META-INF/maven/com.google.errorprone/error_prone_core/pom.properties";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> loadVersionFromPom() {
        try (InputStream stream = ErrorProneVersion.class.getResourceAsStream(PROPERTIES_RESOURCE);){
            if (stream == null) {
                Optional optional2 = Optional.absent();
                return optional2;
            }
            Properties mavenProperties = new Properties();
            mavenProperties.load(stream);
            Optional optional = Optional.of((Object)mavenProperties.getProperty("version"));
            return optional;
        }
        catch (IOException expected) {
            return Optional.absent();
        }
    }

    private ErrorProneVersion() {
    }
}

