// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/shell/v1/cloudshell.proto

package shellpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudShellService_GetEnvironment_FullMethodName       = "/google.cloud.shell.v1.CloudShellService/GetEnvironment"
	CloudShellService_StartEnvironment_FullMethodName     = "/google.cloud.shell.v1.CloudShellService/StartEnvironment"
	CloudShellService_AuthorizeEnvironment_FullMethodName = "/google.cloud.shell.v1.CloudShellService/AuthorizeEnvironment"
	CloudShellService_AddPublicKey_FullMethodName         = "/google.cloud.shell.v1.CloudShellService/AddPublicKey"
	CloudShellService_RemovePublicKey_FullMethodName      = "/google.cloud.shell.v1.CloudShellService/RemovePublicKey"
)

// CloudShellServiceClient is the client API for CloudShellService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudShellServiceClient interface {
	// Gets an environment. Returns NOT_FOUND if the environment does not exist.
	GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error)
	// Starts an existing environment, allowing clients to connect to it. The
	// returned operation will contain an instance of StartEnvironmentMetadata in
	// its metadata field. Users can wait for the environment to start by polling
	// this operation via GetOperation. Once the environment has finished starting
	// and is ready to accept connections, the operation will contain a
	// StartEnvironmentResponse in its response field.
	StartEnvironment(ctx context.Context, in *StartEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Sends OAuth credentials to a running environment on behalf of a user. When
	// this completes, the environment will be authorized to run various Google
	// Cloud command line tools without requiring the user to manually
	// authenticate.
	AuthorizeEnvironment(ctx context.Context, in *AuthorizeEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds a public SSH key to an environment, allowing clients with the
	// corresponding private key to connect to that environment via SSH. If a key
	// with the same content already exists, this will error with ALREADY_EXISTS.
	AddPublicKey(ctx context.Context, in *AddPublicKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes a public SSH key from an environment. Clients will no longer be
	// able to connect to the environment using the corresponding private key.
	// If a key with the same content is not present, this will error with
	// NOT_FOUND.
	RemovePublicKey(ctx context.Context, in *RemovePublicKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type cloudShellServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudShellServiceClient(cc grpc.ClientConnInterface) CloudShellServiceClient {
	return &cloudShellServiceClient{cc}
}

func (c *cloudShellServiceClient) GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error) {
	out := new(Environment)
	err := c.cc.Invoke(ctx, CloudShellService_GetEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudShellServiceClient) StartEnvironment(ctx context.Context, in *StartEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudShellService_StartEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudShellServiceClient) AuthorizeEnvironment(ctx context.Context, in *AuthorizeEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudShellService_AuthorizeEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudShellServiceClient) AddPublicKey(ctx context.Context, in *AddPublicKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudShellService_AddPublicKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudShellServiceClient) RemovePublicKey(ctx context.Context, in *RemovePublicKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudShellService_RemovePublicKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudShellServiceServer is the server API for CloudShellService service.
// All implementations should embed UnimplementedCloudShellServiceServer
// for forward compatibility
type CloudShellServiceServer interface {
	// Gets an environment. Returns NOT_FOUND if the environment does not exist.
	GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error)
	// Starts an existing environment, allowing clients to connect to it. The
	// returned operation will contain an instance of StartEnvironmentMetadata in
	// its metadata field. Users can wait for the environment to start by polling
	// this operation via GetOperation. Once the environment has finished starting
	// and is ready to accept connections, the operation will contain a
	// StartEnvironmentResponse in its response field.
	StartEnvironment(context.Context, *StartEnvironmentRequest) (*longrunningpb.Operation, error)
	// Sends OAuth credentials to a running environment on behalf of a user. When
	// this completes, the environment will be authorized to run various Google
	// Cloud command line tools without requiring the user to manually
	// authenticate.
	AuthorizeEnvironment(context.Context, *AuthorizeEnvironmentRequest) (*longrunningpb.Operation, error)
	// Adds a public SSH key to an environment, allowing clients with the
	// corresponding private key to connect to that environment via SSH. If a key
	// with the same content already exists, this will error with ALREADY_EXISTS.
	AddPublicKey(context.Context, *AddPublicKeyRequest) (*longrunningpb.Operation, error)
	// Removes a public SSH key from an environment. Clients will no longer be
	// able to connect to the environment using the corresponding private key.
	// If a key with the same content is not present, this will error with
	// NOT_FOUND.
	RemovePublicKey(context.Context, *RemovePublicKeyRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCloudShellServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCloudShellServiceServer struct {
}

func (UnimplementedCloudShellServiceServer) GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnvironment not implemented")
}
func (UnimplementedCloudShellServiceServer) StartEnvironment(context.Context, *StartEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartEnvironment not implemented")
}
func (UnimplementedCloudShellServiceServer) AuthorizeEnvironment(context.Context, *AuthorizeEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuthorizeEnvironment not implemented")
}
func (UnimplementedCloudShellServiceServer) AddPublicKey(context.Context, *AddPublicKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPublicKey not implemented")
}
func (UnimplementedCloudShellServiceServer) RemovePublicKey(context.Context, *RemovePublicKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemovePublicKey not implemented")
}

// UnsafeCloudShellServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudShellServiceServer will
// result in compilation errors.
type UnsafeCloudShellServiceServer interface {
	mustEmbedUnimplementedCloudShellServiceServer()
}

func RegisterCloudShellServiceServer(s grpc.ServiceRegistrar, srv CloudShellServiceServer) {
	s.RegisterService(&CloudShellService_ServiceDesc, srv)
}

func _CloudShellService_GetEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudShellServiceServer).GetEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudShellService_GetEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudShellServiceServer).GetEnvironment(ctx, req.(*GetEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudShellService_StartEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudShellServiceServer).StartEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudShellService_StartEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudShellServiceServer).StartEnvironment(ctx, req.(*StartEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudShellService_AuthorizeEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthorizeEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudShellServiceServer).AuthorizeEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudShellService_AuthorizeEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudShellServiceServer).AuthorizeEnvironment(ctx, req.(*AuthorizeEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudShellService_AddPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudShellServiceServer).AddPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudShellService_AddPublicKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudShellServiceServer).AddPublicKey(ctx, req.(*AddPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudShellService_RemovePublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudShellServiceServer).RemovePublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudShellService_RemovePublicKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudShellServiceServer).RemovePublicKey(ctx, req.(*RemovePublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudShellService_ServiceDesc is the grpc.ServiceDesc for CloudShellService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudShellService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.shell.v1.CloudShellService",
	HandlerType: (*CloudShellServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetEnvironment",
			Handler:    _CloudShellService_GetEnvironment_Handler,
		},
		{
			MethodName: "StartEnvironment",
			Handler:    _CloudShellService_StartEnvironment_Handler,
		},
		{
			MethodName: "AuthorizeEnvironment",
			Handler:    _CloudShellService_AuthorizeEnvironment_Handler,
		},
		{
			MethodName: "AddPublicKey",
			Handler:    _CloudShellService_AddPublicKey_Handler,
		},
		{
			MethodName: "RemovePublicKey",
			Handler:    _CloudShellService_RemovePublicKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/shell/v1/cloudshell.proto",
}
