// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the invalidations for a distribution tenant.
func (c *Client) ListInvalidationsForDistributionTenant(ctx context.Context, params *ListInvalidationsForDistributionTenantInput, optFns ...func(*Options)) (*ListInvalidationsForDistributionTenantOutput, error) {
	if params == nil {
		params = &ListInvalidationsForDistributionTenantInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInvalidationsForDistributionTenant", params, optFns, c.addOperationListInvalidationsForDistributionTenantMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInvalidationsForDistributionTenantOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInvalidationsForDistributionTenantInput struct {

	// The ID of the distribution tenant.
	//
	// This member is required.
	Id *string

	// Use this parameter when paginating results to indicate where to begin in your
	// list of invalidation batches. Because the results are returned in decreasing
	// order from most recent to oldest, the most recent results are on the first page,
	// the second page will contain earlier results, and so on. To get the next page of
	// results, set Marker to the value of the NextMarker from the current page's
	// response. This value is the same as the ID of the last invalidation batch on
	// that page.
	Marker *string

	// The maximum number of invalidations to return for the distribution tenant.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListInvalidationsForDistributionTenantOutput struct {

	// The InvalidationList complex type describes the list of invalidation objects.
	// For more information about invalidation, see [Invalidating Objects (Web Distributions Only)]in the Amazon CloudFront Developer
	// Guide.
	//
	// [Invalidating Objects (Web Distributions Only)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html
	InvalidationList *types.InvalidationList

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInvalidationsForDistributionTenantMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListInvalidationsForDistributionTenant{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListInvalidationsForDistributionTenant{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInvalidationsForDistributionTenant"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListInvalidationsForDistributionTenantValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInvalidationsForDistributionTenant(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInvalidationsForDistributionTenantPaginatorOptions is the paginator options
// for ListInvalidationsForDistributionTenant
type ListInvalidationsForDistributionTenantPaginatorOptions struct {
	// The maximum number of invalidations to return for the distribution tenant.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInvalidationsForDistributionTenantPaginator is a paginator for
// ListInvalidationsForDistributionTenant
type ListInvalidationsForDistributionTenantPaginator struct {
	options   ListInvalidationsForDistributionTenantPaginatorOptions
	client    ListInvalidationsForDistributionTenantAPIClient
	params    *ListInvalidationsForDistributionTenantInput
	nextToken *string
	firstPage bool
}

// NewListInvalidationsForDistributionTenantPaginator returns a new
// ListInvalidationsForDistributionTenantPaginator
func NewListInvalidationsForDistributionTenantPaginator(client ListInvalidationsForDistributionTenantAPIClient, params *ListInvalidationsForDistributionTenantInput, optFns ...func(*ListInvalidationsForDistributionTenantPaginatorOptions)) *ListInvalidationsForDistributionTenantPaginator {
	if params == nil {
		params = &ListInvalidationsForDistributionTenantInput{}
	}

	options := ListInvalidationsForDistributionTenantPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInvalidationsForDistributionTenantPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInvalidationsForDistributionTenantPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInvalidationsForDistributionTenant page.
func (p *ListInvalidationsForDistributionTenantPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInvalidationsForDistributionTenantOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInvalidationsForDistributionTenant(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = nil
	if result.InvalidationList != nil {
		p.nextToken = result.InvalidationList.NextMarker
	}

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInvalidationsForDistributionTenantAPIClient is a client that implements the
// ListInvalidationsForDistributionTenant operation.
type ListInvalidationsForDistributionTenantAPIClient interface {
	ListInvalidationsForDistributionTenant(context.Context, *ListInvalidationsForDistributionTenantInput, ...func(*Options)) (*ListInvalidationsForDistributionTenantOutput, error)
}

var _ ListInvalidationsForDistributionTenantAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInvalidationsForDistributionTenant(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInvalidationsForDistributionTenant",
	}
}
