---
title: Mentorship
type: docs
menu: contributing
---

# Thanos / Prometheus Open Source Mentorship

Both Thanos and Prometheus projects participate in various, periodic mentoring programs.

[Follow us on Twitter](https://thanos.io/tip/contributing/community.md/#twitter) to be up-to-date with application process and announcements.

Programs we participated / are participating:

- [CommunityBridge](https://github.com/cncf/mentoring/tree/master/communitybridge)
- [Google Summer of Code](https://github.com/cncf/mentoring/tree/master/summerofcode)
- [Red Hat Beyond](https://research.redhat.com/blog/2020/05/24/open-source-development-course-and-devops-methodology/)

## For Mentees

You have been selected for mentorship with Prometheus or Thanos? Congratulations! Here is some short quick information for a quick start!

### Onboarding Check List

- [x] Please see and acknowledge our [Code of Conduct](https://thanos.io/tip/contributing/code_of_conduct.md/). A similar one is for the Prometheus project. TL;DR: Be nice and friendly!
- [x] Create an account on the [CNCF Slack](https://slack.cncf.io/). Please add any profile photo to make it unique. (: This is Thanos's main
      chat provider. You can reach any of the mentors there.
- [x] If you are a Prometheus mentee OR if your task will involve collaborating with the Prometheus project, it's also recommended to set up an IRC account e.g by [joining Element](https://prometheus.io/community/). This
      the main channel Prometheus Team is using currently.
- [x] Send your mentors your slack account handle, so we can join you to private channels. We have one with just you and your main mentors, and second with all mentees, ex-mentees and mentors.
- [x] Join main [Thanos channels](https://thanos.io/tip/contributing/community.md/#slack) and write a few sentences to about yourself, say hello! 💜
- [x] You are welcome to join Twitter, start following others and gather your own followers! Who knows maybe you will get addicted? (: Feel free to post any
      related content around Thanos while mentioning `@ThanosMetrics`.
- [x] Ask maintainers to set up some weekly 2:1 meeting (highly recommended).
- [x] Read our [contributing guides](https://thanos.io/tip/contributing/contributing.md/)
- [x] Read carefully your main GitHub issue and start thinking about it, but don't stress out! It's better to start slowly with a smaller task to get things going. 🚀

### Suggestions

There are certain rules you can follow to make the MOST from your time with us!

- Blocked on the PR, looking for someone to review your contribution, or have some quick question around failed CI? Prefer `public` communication channels.
  Both Prometheus and Thanos have a large community that can quickly help you with any issues. There also other mentees who might have had similar questions already! (:
- Say hello to fellow mentees and ex-mentees. We even created a special channel for that goal, so you can team up and build something bigger together: Relation, maybe a future project together or just helping each other out!
  Take an example from Summer 2020. Previous Thanos mentees started [Friday fun hangouts](https://twitter.com/bwplotka/status/1270016551664488451) without mentors knowledge and it went pretty awesome! Want to start something similar? Ask fellow ex-mentees for their tips. 🤗
- Think out of the box. Do you feel like something is really painful in project development, functionality or community? Help us improve things and suggest improvements!
- Participate in the Project life cycles. We are active in many conferences e.g. KubeCon, PromCon, FOSDEM, GoDays. We participate in the CNCF SIGs, many side initiatives,
  blog posts and videos. Please help us! You are welcome to boost your social media visibility, start blog posting, or even start talking at conferences.
  Feel free to ask your mentors for guidance on whatever you are passionate with! We would love to help.
- You are **welcome** or even encouraged to contribute to anything you want during your internship. It's common to wait for a review of your PR some time (it's open source after all!),
  so it's not uncommon to drive 2 or 3 things at the time. You don't need to limit contributions to Thanos project as well.
  It's totally ok to contribute to some other project we depend on or relate (e.g [Yash](https://twitter.com/yashrsharma44) was heavily contributing to [go-grpc-middleware](https://github.com/grpc-ecosystem/go-grpc-middleware)).
  It's also encouraged for Thanos mentee to contribute to Prometheus or Cortex and vice versa. This is because we are part of a bigger **Prometheus Ecosystem Family**.
- Try to be independent and responsible for the feature you want to deliver. The sooner you start to lead your task, the better for you! It's hard in the beginning but try to think about the user experience.
  Is it hard or easy to make mistake using it? How difficult is it to migrate to this feature? Is there anything we can do to reduce data loss errors?
- Try to help others by **reviewing** other contributors, mentees or mentors' Pull Requests! It sounds scary, but this is actually the best way to learn about coding practices, patterns and how to maintain high quality codebase! (GIFs on PRs are welcome as well!)
- Try using an [iterative process for development](https://en.wikipedia.org/wiki/Iterative_and_incremental_development). Start with small and simple assumptions, and once you have a working example ready, keep improving and discusing with the mentors. Small changes are easy to review and easy to accept 😄.
- Try working out a [proof of concept](https://en.wikipedia.org/wiki/Proof_of_concept), which can be used as a baseline, and can be improved upon. These are real-world projects, so it's not possible to have a deterministic solution everytime, and proof of concepts are quick way to determine feasibility.

### Thanos Mentoring Office Hours

All current and past mentees are welcome to join our special weekly Mentoring Office Hours. See [this](https://www.bwplotka.dev/2020/thanos-mentoring-office-hours/) for details.
Ask your mentor to be invited!
