// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: store/storepb/rpc.proto

package storepb

import (
	context "context"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	github_com_thanos_io_thanos_pkg_store_labelpb "github.com/thanos-io/thanos/pkg/store/labelpb"
	labelpb "github.com/thanos-io/thanos/pkg/store/labelpb"
	prompb "github.com/thanos-io/thanos/pkg/store/storepb/prompb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type StoreType int32

const (
	StoreType_UNKNOWN StoreType = 0
	StoreType_QUERY   StoreType = 1
	StoreType_RULE    StoreType = 2
	StoreType_SIDECAR StoreType = 3
	StoreType_STORE   StoreType = 4
	StoreType_RECEIVE StoreType = 5
	// DEBUG represents some debug StoreAPI components e.g. thanos tools store-api-serve.
	StoreType_DEBUG StoreType = 6
)

var StoreType_name = map[int32]string{
	0: "UNKNOWN",
	1: "QUERY",
	2: "RULE",
	3: "SIDECAR",
	4: "STORE",
	5: "RECEIVE",
	6: "DEBUG",
}

var StoreType_value = map[string]int32{
	"UNKNOWN": 0,
	"QUERY":   1,
	"RULE":    2,
	"SIDECAR": 3,
	"STORE":   4,
	"RECEIVE": 5,
	"DEBUG":   6,
}

func (x StoreType) String() string {
	return proto.EnumName(StoreType_name, int32(x))
}

func (StoreType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{0}
}

type Aggr int32

const (
	Aggr_RAW     Aggr = 0
	Aggr_COUNT   Aggr = 1
	Aggr_SUM     Aggr = 2
	Aggr_MIN     Aggr = 3
	Aggr_MAX     Aggr = 4
	Aggr_COUNTER Aggr = 5
)

var Aggr_name = map[int32]string{
	0: "RAW",
	1: "COUNT",
	2: "SUM",
	3: "MIN",
	4: "MAX",
	5: "COUNTER",
}

var Aggr_value = map[string]int32{
	"RAW":     0,
	"COUNT":   1,
	"SUM":     2,
	"MIN":     3,
	"MAX":     4,
	"COUNTER": 5,
}

func (x Aggr) String() string {
	return proto.EnumName(Aggr_name, int32(x))
}

func (Aggr) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{1}
}

type WriteResponse struct {
}

func (m *WriteResponse) Reset()         { *m = WriteResponse{} }
func (m *WriteResponse) String() string { return proto.CompactTextString(m) }
func (*WriteResponse) ProtoMessage()    {}
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{0}
}
func (m *WriteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteResponse.Merge(m, src)
}
func (m *WriteResponse) XXX_Size() int {
	return m.Size()
}
func (m *WriteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteResponse proto.InternalMessageInfo

type WriteRequest struct {
	Timeseries []prompb.TimeSeries `protobuf:"bytes,1,rep,name=timeseries,proto3" json:"timeseries"`
	Tenant     string              `protobuf:"bytes,2,opt,name=tenant,proto3" json:"tenant,omitempty"`
	Replica    int64               `protobuf:"varint,3,opt,name=replica,proto3" json:"replica,omitempty"`
}

func (m *WriteRequest) Reset()         { *m = WriteRequest{} }
func (m *WriteRequest) String() string { return proto.CompactTextString(m) }
func (*WriteRequest) ProtoMessage()    {}
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{1}
}
func (m *WriteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteRequest.Merge(m, src)
}
func (m *WriteRequest) XXX_Size() int {
	return m.Size()
}
func (m *WriteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteRequest proto.InternalMessageInfo

type InfoRequest struct {
}

func (m *InfoRequest) Reset()         { *m = InfoRequest{} }
func (m *InfoRequest) String() string { return proto.CompactTextString(m) }
func (*InfoRequest) ProtoMessage()    {}
func (*InfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{2}
}
func (m *InfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoRequest.Merge(m, src)
}
func (m *InfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *InfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InfoRequest proto.InternalMessageInfo

type InfoResponse struct {
	// Deprecated. Use label_sets instead.
	Labels    []github_com_thanos_io_thanos_pkg_store_labelpb.ZLabel `protobuf:"bytes,1,rep,name=labels,proto3,customtype=github.com/thanos-io/thanos/pkg/store/labelpb.ZLabel" json:"labels"`
	MinTime   int64                                                  `protobuf:"varint,2,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime   int64                                                  `protobuf:"varint,3,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
	StoreType StoreType                                              `protobuf:"varint,4,opt,name=storeType,proto3,enum=thanos.StoreType" json:"storeType,omitempty"`
	// label_sets is an unsorted list of `ZLabelSet`s.
	LabelSets []labelpb.ZLabelSet `protobuf:"bytes,5,rep,name=label_sets,json=labelSets,proto3" json:"label_sets"`
}

func (m *InfoResponse) Reset()         { *m = InfoResponse{} }
func (m *InfoResponse) String() string { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()    {}
func (*InfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{3}
}
func (m *InfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoResponse.Merge(m, src)
}
func (m *InfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *InfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InfoResponse proto.InternalMessageInfo

type SeriesRequest struct {
	MinTime             int64          `protobuf:"varint,1,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime             int64          `protobuf:"varint,2,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
	Matchers            []LabelMatcher `protobuf:"bytes,3,rep,name=matchers,proto3" json:"matchers"`
	MaxResolutionWindow int64          `protobuf:"varint,4,opt,name=max_resolution_window,json=maxResolutionWindow,proto3" json:"max_resolution_window,omitempty"`
	Aggregates          []Aggr         `protobuf:"varint,5,rep,packed,name=aggregates,proto3,enum=thanos.Aggr" json:"aggregates,omitempty"`
	// Deprecated. Use partial_response_strategy instead.
	PartialResponseDisabled bool `protobuf:"varint,6,opt,name=partial_response_disabled,json=partialResponseDisabled,proto3" json:"partial_response_disabled,omitempty"`
	// TODO(bwplotka): Move Thanos components to use strategy instead. Including QueryAPI.
	PartialResponseStrategy PartialResponseStrategy `protobuf:"varint,7,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
	// skip_chunks controls whether sending chunks or not in series responses.
	SkipChunks bool `protobuf:"varint,8,opt,name=skip_chunks,json=skipChunks,proto3" json:"skip_chunks,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,9,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *SeriesRequest) Reset()         { *m = SeriesRequest{} }
func (m *SeriesRequest) String() string { return proto.CompactTextString(m) }
func (*SeriesRequest) ProtoMessage()    {}
func (*SeriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{4}
}
func (m *SeriesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SeriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SeriesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SeriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeriesRequest.Merge(m, src)
}
func (m *SeriesRequest) XXX_Size() int {
	return m.Size()
}
func (m *SeriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SeriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SeriesRequest proto.InternalMessageInfo

type SeriesResponse struct {
	// Types that are valid to be assigned to Result:
	//	*SeriesResponse_Series
	//	*SeriesResponse_Warning
	//	*SeriesResponse_Hints
	Result isSeriesResponse_Result `protobuf_oneof:"result"`
}

func (m *SeriesResponse) Reset()         { *m = SeriesResponse{} }
func (m *SeriesResponse) String() string { return proto.CompactTextString(m) }
func (*SeriesResponse) ProtoMessage()    {}
func (*SeriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{5}
}
func (m *SeriesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SeriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SeriesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SeriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeriesResponse.Merge(m, src)
}
func (m *SeriesResponse) XXX_Size() int {
	return m.Size()
}
func (m *SeriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SeriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SeriesResponse proto.InternalMessageInfo

type isSeriesResponse_Result interface {
	isSeriesResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SeriesResponse_Series struct {
	Series *Series `protobuf:"bytes,1,opt,name=series,proto3,oneof" json:"series,omitempty"`
}
type SeriesResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}
type SeriesResponse_Hints struct {
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3,oneof" json:"hints,omitempty"`
}

func (*SeriesResponse_Series) isSeriesResponse_Result()  {}
func (*SeriesResponse_Warning) isSeriesResponse_Result() {}
func (*SeriesResponse_Hints) isSeriesResponse_Result()   {}

func (m *SeriesResponse) GetResult() isSeriesResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SeriesResponse) GetSeries() *Series {
	if x, ok := m.GetResult().(*SeriesResponse_Series); ok {
		return x.Series
	}
	return nil
}

func (m *SeriesResponse) GetWarning() string {
	if x, ok := m.GetResult().(*SeriesResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

func (m *SeriesResponse) GetHints() *types.Any {
	if x, ok := m.GetResult().(*SeriesResponse_Hints); ok {
		return x.Hints
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SeriesResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SeriesResponse_Series)(nil),
		(*SeriesResponse_Warning)(nil),
		(*SeriesResponse_Hints)(nil),
	}
}

type LabelNamesRequest struct {
	PartialResponseDisabled bool `protobuf:"varint,1,opt,name=partial_response_disabled,json=partialResponseDisabled,proto3" json:"partial_response_disabled,omitempty"`
	// TODO(bwplotka): Move Thanos components to use strategy instead. Including QueryAPI.
	PartialResponseStrategy PartialResponseStrategy `protobuf:"varint,2,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
	Start                   int64                   `protobuf:"varint,3,opt,name=start,proto3" json:"start,omitempty"`
	End                     int64                   `protobuf:"varint,4,opt,name=end,proto3" json:"end,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,5,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *LabelNamesRequest) Reset()         { *m = LabelNamesRequest{} }
func (m *LabelNamesRequest) String() string { return proto.CompactTextString(m) }
func (*LabelNamesRequest) ProtoMessage()    {}
func (*LabelNamesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{6}
}
func (m *LabelNamesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelNamesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelNamesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelNamesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelNamesRequest.Merge(m, src)
}
func (m *LabelNamesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LabelNamesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelNamesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelNamesRequest proto.InternalMessageInfo

type LabelNamesResponse struct {
	Names    []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	/// hints is an opaque data structure that can be used to carry additional information from
	/// the store. The content of this field and whether it's supported depends on the
	/// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *LabelNamesResponse) Reset()         { *m = LabelNamesResponse{} }
func (m *LabelNamesResponse) String() string { return proto.CompactTextString(m) }
func (*LabelNamesResponse) ProtoMessage()    {}
func (*LabelNamesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{7}
}
func (m *LabelNamesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelNamesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelNamesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelNamesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelNamesResponse.Merge(m, src)
}
func (m *LabelNamesResponse) XXX_Size() int {
	return m.Size()
}
func (m *LabelNamesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelNamesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LabelNamesResponse proto.InternalMessageInfo

type LabelValuesRequest struct {
	Label                   string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	PartialResponseDisabled bool   `protobuf:"varint,2,opt,name=partial_response_disabled,json=partialResponseDisabled,proto3" json:"partial_response_disabled,omitempty"`
	// TODO(bwplotka): Move Thanos components to use strategy instead. Including QueryAPI.
	PartialResponseStrategy PartialResponseStrategy `protobuf:"varint,3,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
	Start                   int64                   `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	End                     int64                   `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints    *types.Any     `protobuf:"bytes,6,opt,name=hints,proto3" json:"hints,omitempty"`
	Matchers []LabelMatcher `protobuf:"bytes,7,rep,name=matchers,proto3" json:"matchers"`
}

func (m *LabelValuesRequest) Reset()         { *m = LabelValuesRequest{} }
func (m *LabelValuesRequest) String() string { return proto.CompactTextString(m) }
func (*LabelValuesRequest) ProtoMessage()    {}
func (*LabelValuesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{8}
}
func (m *LabelValuesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelValuesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelValuesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelValuesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelValuesRequest.Merge(m, src)
}
func (m *LabelValuesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LabelValuesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelValuesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelValuesRequest proto.InternalMessageInfo

type LabelValuesResponse struct {
	Values   []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	/// hints is an opaque data structure that can be used to carry additional information from
	/// the store. The content of this field and whether it's supported depends on the
	/// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *LabelValuesResponse) Reset()         { *m = LabelValuesResponse{} }
func (m *LabelValuesResponse) String() string { return proto.CompactTextString(m) }
func (*LabelValuesResponse) ProtoMessage()    {}
func (*LabelValuesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{9}
}
func (m *LabelValuesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelValuesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelValuesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelValuesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelValuesResponse.Merge(m, src)
}
func (m *LabelValuesResponse) XXX_Size() int {
	return m.Size()
}
func (m *LabelValuesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelValuesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LabelValuesResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("thanos.StoreType", StoreType_name, StoreType_value)
	proto.RegisterEnum("thanos.Aggr", Aggr_name, Aggr_value)
	proto.RegisterType((*WriteResponse)(nil), "thanos.WriteResponse")
	proto.RegisterType((*WriteRequest)(nil), "thanos.WriteRequest")
	proto.RegisterType((*InfoRequest)(nil), "thanos.InfoRequest")
	proto.RegisterType((*InfoResponse)(nil), "thanos.InfoResponse")
	proto.RegisterType((*SeriesRequest)(nil), "thanos.SeriesRequest")
	proto.RegisterType((*SeriesResponse)(nil), "thanos.SeriesResponse")
	proto.RegisterType((*LabelNamesRequest)(nil), "thanos.LabelNamesRequest")
	proto.RegisterType((*LabelNamesResponse)(nil), "thanos.LabelNamesResponse")
	proto.RegisterType((*LabelValuesRequest)(nil), "thanos.LabelValuesRequest")
	proto.RegisterType((*LabelValuesResponse)(nil), "thanos.LabelValuesResponse")
}

func init() { proto.RegisterFile("store/storepb/rpc.proto", fileDescriptor_a938d55a388af629) }

var fileDescriptor_a938d55a388af629 = []byte{
	// 1054 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x5d, 0x6f, 0x1b, 0x45,
	0x17, 0xf6, 0x7a, 0xfd, 0x79, 0x9c, 0xe4, 0xdd, 0x4e, 0x9c, 0x74, 0xe3, 0x4a, 0x8e, 0x65, 0xe9,
	0x95, 0xac, 0xa8, 0xd8, 0x60, 0x50, 0x25, 0x50, 0x6f, 0xec, 0xc4, 0x90, 0x88, 0xc6, 0x81, 0x71,
	0xdc, 0x40, 0x11, 0xb2, 0xd6, 0xce, 0x74, 0xbd, 0x8a, 0xf7, 0x83, 0x9d, 0x31, 0x89, 0xef, 0x10,
	0xdc, 0x23, 0xc4, 0x7f, 0x42, 0xca, 0x1d, 0xbd, 0x44, 0x5c, 0x54, 0x90, 0xfc, 0x11, 0x34, 0x1f,
	0x6b, 0x7b, 0x43, 0xda, 0x20, 0xa5, 0x37, 0xd6, 0x9c, 0xf3, 0x9c, 0x33, 0xe7, 0x99, 0xf3, 0xcc,
	0x19, 0x2f, 0x3c, 0xa4, 0xcc, 0x0f, 0x49, 0x43, 0xfc, 0x06, 0xc3, 0x46, 0x18, 0x8c, 0xea, 0x41,
	0xe8, 0x33, 0x1f, 0x65, 0xd8, 0xd8, 0xf2, 0x7c, 0x5a, 0xda, 0x8a, 0x07, 0xb0, 0x59, 0x40, 0xa8,
	0x0c, 0x29, 0x15, 0x6d, 0xdf, 0xf6, 0xc5, 0xb2, 0xc1, 0x57, 0xca, 0x5b, 0x89, 0x27, 0x04, 0xa1,
	0xef, 0xde, 0xc8, 0x53, 0x5b, 0x4e, 0xac, 0x21, 0x99, 0xdc, 0x84, 0x6c, 0xdf, 0xb7, 0x27, 0xa4,
	0x21, 0xac, 0xe1, 0xf4, 0x65, 0xc3, 0xf2, 0x66, 0x12, 0xaa, 0xfe, 0x0f, 0x56, 0x4f, 0x42, 0x87,
	0x11, 0x4c, 0x68, 0xe0, 0x7b, 0x94, 0x54, 0x7f, 0xd2, 0x60, 0x45, 0x79, 0xbe, 0x9b, 0x12, 0xca,
	0x50, 0x0b, 0x80, 0x39, 0x2e, 0xa1, 0x24, 0x74, 0x08, 0x35, 0xb5, 0x8a, 0x5e, 0x2b, 0x34, 0x1f,
	0xf1, 0x6c, 0x97, 0xb0, 0x31, 0x99, 0xd2, 0xc1, 0xc8, 0x0f, 0x66, 0xf5, 0x63, 0xc7, 0x25, 0x3d,
	0x11, 0xd2, 0x4e, 0x5d, 0xbe, 0xde, 0x4e, 0xe0, 0xa5, 0x24, 0xb4, 0x09, 0x19, 0x46, 0x3c, 0xcb,
	0x63, 0x66, 0xb2, 0xa2, 0xd5, 0xf2, 0x58, 0x59, 0xc8, 0x84, 0x6c, 0x48, 0x82, 0x89, 0x33, 0xb2,
	0x4c, 0xbd, 0xa2, 0xd5, 0x74, 0x1c, 0x99, 0xd5, 0x55, 0x28, 0x1c, 0x78, 0x2f, 0x7d, 0xc5, 0xa1,
	0xfa, 0x6b, 0x12, 0x56, 0xa4, 0x2d, 0x59, 0xa2, 0x11, 0x64, 0xc4, 0x41, 0x23, 0x42, 0xab, 0x75,
	0xd9, 0xd8, 0xfa, 0x33, 0xee, 0x6d, 0x3f, 0xe5, 0x14, 0xfe, 0x7c, 0xbd, 0xfd, 0x91, 0xed, 0xb0,
	0xf1, 0x74, 0x58, 0x1f, 0xf9, 0x6e, 0x43, 0x06, 0xbc, 0xe7, 0xf8, 0x6a, 0xd5, 0x08, 0xce, 0xec,
	0x46, 0xac, 0x67, 0xf5, 0x17, 0x22, 0x1b, 0xab, 0xad, 0xd1, 0x16, 0xe4, 0x5c, 0xc7, 0x1b, 0xf0,
	0x83, 0x08, 0xe2, 0x3a, 0xce, 0xba, 0x8e, 0xc7, 0x4f, 0x2a, 0x20, 0xeb, 0x42, 0x42, 0x8a, 0xba,
	0x6b, 0x5d, 0x08, 0xa8, 0x01, 0x79, 0xb1, 0xeb, 0xf1, 0x2c, 0x20, 0x66, 0xaa, 0xa2, 0xd5, 0xd6,
	0x9a, 0x0f, 0x22, 0x76, 0xbd, 0x08, 0xc0, 0x8b, 0x18, 0xf4, 0x04, 0x40, 0x14, 0x1c, 0x50, 0xc2,
	0xa8, 0x99, 0x16, 0xe7, 0x99, 0x67, 0x48, 0x4a, 0x3d, 0xc2, 0x54, 0x5b, 0xf3, 0x13, 0x65, 0xd3,
	0xea, 0x6f, 0x3a, 0xac, 0xca, 0x96, 0x47, 0x52, 0x2d, 0x13, 0xd6, 0xde, 0x4c, 0x38, 0x19, 0x27,
	0xfc, 0x84, 0x43, 0x6c, 0x34, 0x26, 0x21, 0x35, 0x75, 0x51, 0xbd, 0x18, 0xeb, 0xe6, 0xa1, 0x04,
	0x15, 0x81, 0x79, 0x2c, 0x6a, 0xc2, 0x06, 0xdf, 0x32, 0x24, 0xd4, 0x9f, 0x4c, 0x99, 0xe3, 0x7b,
	0x83, 0x73, 0xc7, 0x3b, 0xf5, 0xcf, 0xc5, 0xa1, 0x75, 0xbc, 0xee, 0x5a, 0x17, 0x78, 0x8e, 0x9d,
	0x08, 0x08, 0x3d, 0x06, 0xb0, 0x6c, 0x3b, 0x24, 0xb6, 0xc5, 0x88, 0x3c, 0xeb, 0x5a, 0x73, 0x25,
	0xaa, 0xd6, 0xb2, 0xed, 0x10, 0x2f, 0xe1, 0xe8, 0x13, 0xd8, 0x0a, 0xac, 0x90, 0x39, 0xd6, 0x84,
	0x57, 0x11, 0xca, 0x0f, 0x4e, 0x1d, 0x6a, 0x0d, 0x27, 0xe4, 0xd4, 0xcc, 0x54, 0xb4, 0x5a, 0x0e,
	0x3f, 0x54, 0x01, 0xd1, 0xcd, 0xd8, 0x53, 0x30, 0xfa, 0xe6, 0x96, 0x5c, 0xca, 0x42, 0x8b, 0x11,
	0x7b, 0x66, 0x66, 0x85, 0x2c, 0xdb, 0x51, 0xe1, 0x2f, 0xe2, 0x7b, 0xf4, 0x54, 0xd8, 0xbf, 0x36,
	0x8f, 0x00, 0xb4, 0x0d, 0x05, 0x7a, 0xe6, 0x04, 0x83, 0xd1, 0x78, 0xea, 0x9d, 0x51, 0x33, 0x27,
	0xa8, 0x00, 0x77, 0xed, 0x0a, 0x0f, 0xda, 0x81, 0xf4, 0xd8, 0xf1, 0x18, 0x35, 0xf3, 0x15, 0x4d,
	0x34, 0x54, 0x4e, 0x60, 0x3d, 0x9a, 0xc0, 0x7a, 0xcb, 0x9b, 0x61, 0x19, 0x52, 0xfd, 0x59, 0x83,
	0xb5, 0x48, 0x47, 0x75, 0xbd, 0x6b, 0x90, 0x99, 0xcf, 0x1b, 0xcf, 0x5f, 0x9b, 0x5f, 0x20, 0xe1,
	0xdd, 0x4f, 0x60, 0x85, 0xa3, 0x12, 0x64, 0xcf, 0xad, 0xd0, 0x73, 0x3c, 0x5b, 0xce, 0xd6, 0x7e,
	0x02, 0x47, 0x0e, 0xf4, 0x38, 0x22, 0xa1, 0xbf, 0x99, 0xc4, 0x7e, 0x42, 0xd1, 0x68, 0xe7, 0x20,
	0x13, 0x12, 0x3a, 0x9d, 0xb0, 0xea, 0x0f, 0x49, 0x78, 0x20, 0x94, 0xef, 0x5a, 0xee, 0xe2, 0x72,
	0xbd, 0x55, 0x0c, 0xed, 0x1e, 0x62, 0x24, 0xef, 0x29, 0x46, 0x11, 0xd2, 0x94, 0x59, 0x21, 0x53,
	0x83, 0x28, 0x0d, 0x64, 0x80, 0x4e, 0xbc, 0x53, 0x75, 0x17, 0xf9, 0x72, 0xa1, 0x49, 0xfa, 0x6e,
	0x4d, 0x42, 0x40, 0xcb, 0x1d, 0x50, 0xb2, 0x14, 0x21, 0xed, 0x71, 0x87, 0x78, 0x74, 0xf2, 0x58,
	0x1a, 0xa8, 0x04, 0x39, 0xd5, 0x71, 0x6a, 0x26, 0x05, 0x30, 0xb7, 0x17, 0x35, 0xf5, 0xbb, 0x6b,
	0xfe, 0x9e, 0x54, 0x45, 0x9f, 0x5b, 0x93, 0xe9, 0xa2, 0xef, 0x45, 0x48, 0x8b, 0x99, 0x17, 0x3d,
	0xce, 0x63, 0x69, 0xbc, 0x5d, 0x8d, 0xe4, 0x3d, 0xd4, 0xd0, 0xdf, 0x95, 0x1a, 0xa9, 0x5b, 0xd4,
	0x48, 0xdf, 0xa2, 0x46, 0xe6, 0xce, 0xce, 0xc4, 0x5e, 0xa8, 0xec, 0x7f, 0x7f, 0xa1, 0xaa, 0x53,
	0x58, 0x8f, 0x35, 0x54, 0xc9, 0xb8, 0x09, 0x99, 0xef, 0x85, 0x47, 0xe9, 0xa8, 0xac, 0x77, 0x25,
	0xe4, 0xce, 0xb7, 0x90, 0x9f, 0x3f, 0xf4, 0xa8, 0x00, 0xd9, 0x7e, 0xf7, 0xf3, 0xee, 0xd1, 0x49,
	0xd7, 0x48, 0xa0, 0x3c, 0xa4, 0xbf, 0xec, 0x77, 0xf0, 0xd7, 0x86, 0x86, 0x72, 0x90, 0xc2, 0xfd,
	0x67, 0x1d, 0x23, 0xc9, 0x23, 0x7a, 0x07, 0x7b, 0x9d, 0xdd, 0x16, 0x36, 0x74, 0x1e, 0xd1, 0x3b,
	0x3e, 0xc2, 0x1d, 0x23, 0xc5, 0xfd, 0xb8, 0xb3, 0xdb, 0x39, 0x78, 0xde, 0x31, 0xd2, 0xdc, 0xbf,
	0xd7, 0x69, 0xf7, 0x3f, 0x33, 0x32, 0x3b, 0x6d, 0x48, 0xf1, 0x97, 0x12, 0x65, 0x41, 0xc7, 0xad,
	0x13, 0xb9, 0xeb, 0xee, 0x51, 0xbf, 0x7b, 0x6c, 0x68, 0xdc, 0xd7, 0xeb, 0x1f, 0x1a, 0x49, 0xbe,
	0x38, 0x3c, 0xe8, 0x1a, 0xba, 0x58, 0xb4, 0xbe, 0x92, 0xdb, 0x89, 0xa8, 0x0e, 0x36, 0xd2, 0xcd,
	0x1f, 0x93, 0x90, 0x16, 0x1c, 0xd1, 0x07, 0x90, 0xe2, 0xff, 0xac, 0x68, 0x3d, 0xea, 0xe8, 0xd2,
	0xff, 0x6e, 0xa9, 0x18, 0x77, 0xaa, 0xfe, 0x7d, 0x0c, 0x19, 0xf9, 0x0e, 0xa1, 0x8d, 0xf8, 0xbb,
	0x14, 0xa5, 0x6d, 0xde, 0x74, 0xcb, 0xc4, 0xf7, 0x35, 0xb4, 0x0b, 0xb0, 0x98, 0x2b, 0xb4, 0x15,
	0x53, 0x71, 0xf9, 0xb5, 0x29, 0x95, 0x6e, 0x83, 0x54, 0xfd, 0x4f, 0xa1, 0xb0, 0x24, 0x2b, 0x8a,
	0x87, 0xc6, 0x86, 0xa7, 0xf4, 0xe8, 0x56, 0x4c, 0xee, 0xd3, 0xec, 0xc2, 0x9a, 0xf8, 0xd2, 0xe1,
	0x53, 0x21, 0x9b, 0xf1, 0x14, 0x0a, 0x98, 0xb8, 0x3e, 0x23, 0xc2, 0x8f, 0xe6, 0xc7, 0x5f, 0xfe,
	0x20, 0x2a, 0x6d, 0xdc, 0xf0, 0xaa, 0x0f, 0xa7, 0x44, 0xfb, 0xff, 0x97, 0x7f, 0x97, 0x13, 0x97,
	0x57, 0x65, 0xed, 0xd5, 0x55, 0x59, 0xfb, 0xeb, 0xaa, 0xac, 0xfd, 0x72, 0x5d, 0x4e, 0xbc, 0xba,
	0x2e, 0x27, 0xfe, 0xb8, 0x2e, 0x27, 0x5e, 0x64, 0xd5, 0xb7, 0xdb, 0x30, 0x23, 0xee, 0xcc, 0x87,
	0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xfd, 0xe5, 0x37, 0xcd, 0x25, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// StoreClient is the client API for Store service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StoreClient interface {
	/// Info returns meta information about a store e.g labels that makes that store unique as well as time range that is
	/// available.
	Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error)
	/// Series streams each Series (Labels and chunk/downsampling chunk) for given label matchers and time range.
	///
	/// Series should strictly stream full series after series, optionally split by time. This means that a single frame can contain
	/// partition of the single series, but once a new series is started to be streamed it means that no more data will
	/// be sent for previous one.
	/// Series has to be sorted.
	///
	/// There is no requirements on chunk sorting, however it is recommended to have chunk sorted by chunk min time.
	/// This heavily optimizes the resource usage on Querier / Federated Queries.
	Series(ctx context.Context, in *SeriesRequest, opts ...grpc.CallOption) (Store_SeriesClient, error)
	/// LabelNames returns all label names that is available.
	/// Currently unimplemented in all Thanos implementations, because Query API does not implement this either.
	LabelNames(ctx context.Context, in *LabelNamesRequest, opts ...grpc.CallOption) (*LabelNamesResponse, error)
	/// LabelValues returns all label values for given label name.
	LabelValues(ctx context.Context, in *LabelValuesRequest, opts ...grpc.CallOption) (*LabelValuesResponse, error)
}

type storeClient struct {
	cc *grpc.ClientConn
}

func NewStoreClient(cc *grpc.ClientConn) StoreClient {
	return &storeClient{cc}
}

func (c *storeClient) Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error) {
	out := new(InfoResponse)
	err := c.cc.Invoke(ctx, "/thanos.Store/Info", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storeClient) Series(ctx context.Context, in *SeriesRequest, opts ...grpc.CallOption) (Store_SeriesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Store_serviceDesc.Streams[0], "/thanos.Store/Series", opts...)
	if err != nil {
		return nil, err
	}
	x := &storeSeriesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Store_SeriesClient interface {
	Recv() (*SeriesResponse, error)
	grpc.ClientStream
}

type storeSeriesClient struct {
	grpc.ClientStream
}

func (x *storeSeriesClient) Recv() (*SeriesResponse, error) {
	m := new(SeriesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storeClient) LabelNames(ctx context.Context, in *LabelNamesRequest, opts ...grpc.CallOption) (*LabelNamesResponse, error) {
	out := new(LabelNamesResponse)
	err := c.cc.Invoke(ctx, "/thanos.Store/LabelNames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storeClient) LabelValues(ctx context.Context, in *LabelValuesRequest, opts ...grpc.CallOption) (*LabelValuesResponse, error) {
	out := new(LabelValuesResponse)
	err := c.cc.Invoke(ctx, "/thanos.Store/LabelValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StoreServer is the server API for Store service.
type StoreServer interface {
	/// Info returns meta information about a store e.g labels that makes that store unique as well as time range that is
	/// available.
	Info(context.Context, *InfoRequest) (*InfoResponse, error)
	/// Series streams each Series (Labels and chunk/downsampling chunk) for given label matchers and time range.
	///
	/// Series should strictly stream full series after series, optionally split by time. This means that a single frame can contain
	/// partition of the single series, but once a new series is started to be streamed it means that no more data will
	/// be sent for previous one.
	/// Series has to be sorted.
	///
	/// There is no requirements on chunk sorting, however it is recommended to have chunk sorted by chunk min time.
	/// This heavily optimizes the resource usage on Querier / Federated Queries.
	Series(*SeriesRequest, Store_SeriesServer) error
	/// LabelNames returns all label names that is available.
	/// Currently unimplemented in all Thanos implementations, because Query API does not implement this either.
	LabelNames(context.Context, *LabelNamesRequest) (*LabelNamesResponse, error)
	/// LabelValues returns all label values for given label name.
	LabelValues(context.Context, *LabelValuesRequest) (*LabelValuesResponse, error)
}

// UnimplementedStoreServer can be embedded to have forward compatible implementations.
type UnimplementedStoreServer struct {
}

func (*UnimplementedStoreServer) Info(ctx context.Context, req *InfoRequest) (*InfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Info not implemented")
}
func (*UnimplementedStoreServer) Series(req *SeriesRequest, srv Store_SeriesServer) error {
	return status.Errorf(codes.Unimplemented, "method Series not implemented")
}
func (*UnimplementedStoreServer) LabelNames(ctx context.Context, req *LabelNamesRequest) (*LabelNamesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelNames not implemented")
}
func (*UnimplementedStoreServer) LabelValues(ctx context.Context, req *LabelValuesRequest) (*LabelValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelValues not implemented")
}

func RegisterStoreServer(s *grpc.Server, srv StoreServer) {
	s.RegisterService(&_Store_serviceDesc, srv)
}

func _Store_Info_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).Info(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/Info",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).Info(ctx, req.(*InfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Store_Series_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SeriesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StoreServer).Series(m, &storeSeriesServer{stream})
}

type Store_SeriesServer interface {
	Send(*SeriesResponse) error
	grpc.ServerStream
}

type storeSeriesServer struct {
	grpc.ServerStream
}

func (x *storeSeriesServer) Send(m *SeriesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Store_LabelNames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelNamesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).LabelNames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/LabelNames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).LabelNames(ctx, req.(*LabelNamesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Store_LabelValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).LabelValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/LabelValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).LabelValues(ctx, req.(*LabelValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Store_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Store",
	HandlerType: (*StoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Info",
			Handler:    _Store_Info_Handler,
		},
		{
			MethodName: "LabelNames",
			Handler:    _Store_LabelNames_Handler,
		},
		{
			MethodName: "LabelValues",
			Handler:    _Store_LabelValues_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Series",
			Handler:       _Store_Series_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "store/storepb/rpc.proto",
}

// WriteableStoreClient is the client API for WriteableStore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WriteableStoreClient interface {
	// WriteRequest allows you to write metrics to this store via remote write
	RemoteWrite(ctx context.Context, in *WriteRequest, opts ...grpc.CallOption) (*WriteResponse, error)
}

type writeableStoreClient struct {
	cc *grpc.ClientConn
}

func NewWriteableStoreClient(cc *grpc.ClientConn) WriteableStoreClient {
	return &writeableStoreClient{cc}
}

func (c *writeableStoreClient) RemoteWrite(ctx context.Context, in *WriteRequest, opts ...grpc.CallOption) (*WriteResponse, error) {
	out := new(WriteResponse)
	err := c.cc.Invoke(ctx, "/thanos.WriteableStore/RemoteWrite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WriteableStoreServer is the server API for WriteableStore service.
type WriteableStoreServer interface {
	// WriteRequest allows you to write metrics to this store via remote write
	RemoteWrite(context.Context, *WriteRequest) (*WriteResponse, error)
}

// UnimplementedWriteableStoreServer can be embedded to have forward compatible implementations.
type UnimplementedWriteableStoreServer struct {
}

func (*UnimplementedWriteableStoreServer) RemoteWrite(ctx context.Context, req *WriteRequest) (*WriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoteWrite not implemented")
}

func RegisterWriteableStoreServer(s *grpc.Server, srv WriteableStoreServer) {
	s.RegisterService(&_WriteableStore_serviceDesc, srv)
}

func _WriteableStore_RemoteWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WriteableStoreServer).RemoteWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.WriteableStore/RemoteWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WriteableStoreServer).RemoteWrite(ctx, req.(*WriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WriteableStore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.WriteableStore",
	HandlerType: (*WriteableStoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RemoteWrite",
			Handler:    _WriteableStore_RemoteWrite_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "store/storepb/rpc.proto",
}

func (m *WriteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *WriteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Replica != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Replica))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Tenant) > 0 {
		i -= len(m.Tenant)
		copy(dAtA[i:], m.Tenant)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Tenant)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Timeseries) > 0 {
		for iNdEx := len(m.Timeseries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Timeseries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *InfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSets) > 0 {
		for iNdEx := len(m.LabelSets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LabelSets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.StoreType != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StoreType))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
		i--
		dAtA[i] = 0x18
	}
	if m.MinTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size := m.Labels[iNdEx].Size()
				i -= size
				if _, err := m.Labels[iNdEx].MarshalTo(dAtA[i:]); err != nil {
					return 0, err
				}
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SeriesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.SkipChunks {
		i--
		if m.SkipChunks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x38
	}
	if m.PartialResponseDisabled {
		i--
		if m.PartialResponseDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Aggregates) > 0 {
		dAtA3 := make([]byte, len(m.Aggregates)*10)
		var j2 int
		for _, num := range m.Aggregates {
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		i -= j2
		copy(dAtA[i:], dAtA3[:j2])
		i = encodeVarintRpc(dAtA, i, uint64(j2))
		i--
		dAtA[i] = 0x2a
	}
	if m.MaxResolutionWindow != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxResolutionWindow))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Matchers) > 0 {
		for iNdEx := len(m.Matchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Matchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.MaxTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
		i--
		dAtA[i] = 0x10
	}
	if m.MinTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SeriesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *SeriesResponse_Series) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Series) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Series != nil {
		{
			size, err := m.Series.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Warning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warning)
	copy(dAtA[i:], m.Warning)
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Hints) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Hints) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *LabelNamesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelNamesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x20
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x18
	}
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x10
	}
	if m.PartialResponseDisabled {
		i--
		if m.PartialResponseDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LabelNamesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelNamesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LabelValuesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelValuesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Matchers) > 0 {
		for iNdEx := len(m.Matchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Matchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x28
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x20
	}
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x18
	}
	if m.PartialResponseDisabled {
		i--
		if m.PartialResponseDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Label) > 0 {
		i -= len(m.Label)
		copy(dAtA[i:], m.Label)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Label)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LabelValuesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelValuesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *WriteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *WriteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Timeseries) > 0 {
		for _, e := range m.Timeseries {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	l = len(m.Tenant)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Replica != 0 {
		n += 1 + sovRpc(uint64(m.Replica))
	}
	return n
}

func (m *InfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *InfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	if m.StoreType != 0 {
		n += 1 + sovRpc(uint64(m.StoreType))
	}
	if len(m.LabelSets) > 0 {
		for _, e := range m.LabelSets {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *SeriesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.MaxResolutionWindow != 0 {
		n += 1 + sovRpc(uint64(m.MaxResolutionWindow))
	}
	if len(m.Aggregates) > 0 {
		l = 0
		for _, e := range m.Aggregates {
			l += sovRpc(uint64(e))
		}
		n += 1 + sovRpc(uint64(l)) + l
	}
	if m.PartialResponseDisabled {
		n += 2
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	if m.SkipChunks {
		n += 2
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func (m *SeriesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *SeriesResponse_Series) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_Warning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *SeriesResponse_Hints) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *LabelNamesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PartialResponseDisabled {
		n += 2
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func (m *LabelNamesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func (m *LabelValuesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.PartialResponseDisabled {
		n += 2
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *LabelValuesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *WriteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeseries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timeseries = append(m.Timeseries, prompb.TimeSeries{})
			if err := m.Timeseries[len(m.Timeseries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenant", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tenant = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			m.Replica = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Replica |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, github_com_thanos_io_thanos_pkg_store_labelpb.ZLabel{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreType", wireType)
			}
			m.StoreType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreType |= StoreType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelSets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelSets = append(m.LabelSets, labelpb.ZLabelSet{})
			if err := m.LabelSets[len(m.LabelSets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResolutionWindow", wireType)
			}
			m.MaxResolutionWindow = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxResolutionWindow |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v Aggr
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= Aggr(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Aggregates = append(m.Aggregates, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRpc
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRpc
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Aggregates) == 0 {
					m.Aggregates = make([]Aggr, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v Aggr
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRpc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= Aggr(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Aggregates = append(m.Aggregates, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregates", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialResponseDisabled = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipChunks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipChunks = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Series{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Series{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &SeriesResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Hints{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialResponseDisabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialResponseDisabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
