# CycloneDX use cases

## Canonical use case examples

Canonical (CycloneDX v1.4, JSON format) use cases with sample code:

- https://cyclonedx.org/use-cases

| CDX Version | Use case | Test file (JSON) | Description |
| :-- | :-- | :-- | :-- |
| 1.4| Inventory | [cdx-use-case-inventory.json](cdx-use-case-inventory.json) | Includes all supported component `type` values |
| 1.4 | Known vulnerabilities | [cdx-use-case-component-known-vulnerabilities.json](cdx-use-case-component-known-vulnerabilities.json) | Includes all supported component `type` values |
| 1.4 | Integrity verification | c[cdx-use-case-integrity-verification.json](cdx-use-case-integrity-verification.json) |  |
| 1.4 | Authenticity (JSF) | [cdx-use-case-authenticty-jsf.json](cdx-use-case-authenticty-jsf.json) |  |
| 1.4 | Package evaluation | [cdx-use-case-package-evaluation.json](cdx-use-case-package-evaluation.json) |  |
| 1.4 | License compliance | [cdx-use-case-license-compliance.json](cdx-use-case-license-compliance.json) |  |
| 1.4 | Assembly | [cdx-use-case-assembly.json](cdx-use-case-assembly.json) | |
| 1.4 | Dependency graph | [cdx-use-case-dependency-graph.json](cdx-use-case-dependency-graph.json) |  |
| 1.4 | Provenance| [cdx-use-case-provenance.json](cdx-use-case-provenance.json) |  |
| 1.4 | Pedigree | [cdx-use-case-pedigree.json](cdx-use-case-pedigree.json) |  |
| 1.4 | Service definition | [cdx-use-case-service-defn.json](cdx-use-case-service-defn.json) | A complete v1.4 "service" definition |
| 1.4 | Properties | [cdx-use-case-provenance.json](cdx-use-case-provenance.json) | name-value store |
| 1.4 | Packaging and distribution| [cdx-use-case-packaging-and-distribution.json](cdx-use-case-packaging-and-distribution.json) |  |
| 1.4 | Composition completeness | [cdx-use-case-composition-and-completeness.json](cdx-use-case-composition-and-completeness.json) |  |
| 1.4 | OpenChain conformance | [cdx-use-case-openchain-conformance.json](cdx-use-case-openchain-conformance.json) |  |
| 1.4 | Vulnerability remediation | [cdx-use-case-vulnerability-remediation.json](cdx-use-case-vulnerability-remediation.json) |  |
| 1.4 | Vulnerability exploitability | [cdx-use-case-vulnerability-exploitability.json](cdx-use-case-vulnerability-exploitability.json) |  |
| 1.4 | Security advisories| [cdx-use-case-security-advisories.json](cdx-use-case-security-advisories.json) |  |
| 1.4 | External references| [cdx-use-case-external-references.json](cdx-use-case-external-references.json) | |

### Use case ideas

- bom-link (VEX, SaaSBOM)
- Service "known vuln." use case **
