// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package certificatemanagerpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CertificateManager_ListCertificates_FullMethodName                = "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificates"
	CertificateManager_GetCertificate_FullMethodName                  = "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificate"
	CertificateManager_CreateCertificate_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificate"
	CertificateManager_UpdateCertificate_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificate"
	CertificateManager_DeleteCertificate_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificate"
	CertificateManager_ListCertificateMaps_FullMethodName             = "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateMaps"
	CertificateManager_GetCertificateMap_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateMap"
	CertificateManager_CreateCertificateMap_FullMethodName            = "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateMap"
	CertificateManager_UpdateCertificateMap_FullMethodName            = "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificateMap"
	CertificateManager_DeleteCertificateMap_FullMethodName            = "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateMap"
	CertificateManager_ListCertificateMapEntries_FullMethodName       = "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateMapEntries"
	CertificateManager_GetCertificateMapEntry_FullMethodName          = "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateMapEntry"
	CertificateManager_CreateCertificateMapEntry_FullMethodName       = "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateMapEntry"
	CertificateManager_UpdateCertificateMapEntry_FullMethodName       = "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificateMapEntry"
	CertificateManager_DeleteCertificateMapEntry_FullMethodName       = "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateMapEntry"
	CertificateManager_ListDnsAuthorizations_FullMethodName           = "/google.cloud.certificatemanager.v1.CertificateManager/ListDnsAuthorizations"
	CertificateManager_GetDnsAuthorization_FullMethodName             = "/google.cloud.certificatemanager.v1.CertificateManager/GetDnsAuthorization"
	CertificateManager_CreateDnsAuthorization_FullMethodName          = "/google.cloud.certificatemanager.v1.CertificateManager/CreateDnsAuthorization"
	CertificateManager_UpdateDnsAuthorization_FullMethodName          = "/google.cloud.certificatemanager.v1.CertificateManager/UpdateDnsAuthorization"
	CertificateManager_DeleteDnsAuthorization_FullMethodName          = "/google.cloud.certificatemanager.v1.CertificateManager/DeleteDnsAuthorization"
	CertificateManager_ListCertificateIssuanceConfigs_FullMethodName  = "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateIssuanceConfigs"
	CertificateManager_GetCertificateIssuanceConfig_FullMethodName    = "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateIssuanceConfig"
	CertificateManager_CreateCertificateIssuanceConfig_FullMethodName = "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateIssuanceConfig"
	CertificateManager_DeleteCertificateIssuanceConfig_FullMethodName = "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateIssuanceConfig"
	CertificateManager_ListTrustConfigs_FullMethodName                = "/google.cloud.certificatemanager.v1.CertificateManager/ListTrustConfigs"
	CertificateManager_GetTrustConfig_FullMethodName                  = "/google.cloud.certificatemanager.v1.CertificateManager/GetTrustConfig"
	CertificateManager_CreateTrustConfig_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/CreateTrustConfig"
	CertificateManager_UpdateTrustConfig_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/UpdateTrustConfig"
	CertificateManager_DeleteTrustConfig_FullMethodName               = "/google.cloud.certificatemanager.v1.CertificateManager/DeleteTrustConfig"
)

// CertificateManagerClient is the client API for CertificateManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CertificateManagerClient interface {
	// Lists Certificates in a given project and location.
	ListCertificates(ctx context.Context, in *ListCertificatesRequest, opts ...grpc.CallOption) (*ListCertificatesResponse, error)
	// Gets details of a single Certificate.
	GetCertificate(ctx context.Context, in *GetCertificateRequest, opts ...grpc.CallOption) (*Certificate, error)
	// Creates a new Certificate in a given project and location.
	CreateCertificate(ctx context.Context, in *CreateCertificateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a Certificate.
	UpdateCertificate(ctx context.Context, in *UpdateCertificateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Certificate.
	DeleteCertificate(ctx context.Context, in *DeleteCertificateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CertificateMaps in a given project and location.
	ListCertificateMaps(ctx context.Context, in *ListCertificateMapsRequest, opts ...grpc.CallOption) (*ListCertificateMapsResponse, error)
	// Gets details of a single CertificateMap.
	GetCertificateMap(ctx context.Context, in *GetCertificateMapRequest, opts ...grpc.CallOption) (*CertificateMap, error)
	// Creates a new CertificateMap in a given project and location.
	CreateCertificateMap(ctx context.Context, in *CreateCertificateMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a CertificateMap.
	UpdateCertificateMap(ctx context.Context, in *UpdateCertificateMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single CertificateMap. A Certificate Map can't be deleted
	// if it contains Certificate Map Entries. Remove all the entries from
	// the map before calling this method.
	DeleteCertificateMap(ctx context.Context, in *DeleteCertificateMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CertificateMapEntries in a given project and location.
	ListCertificateMapEntries(ctx context.Context, in *ListCertificateMapEntriesRequest, opts ...grpc.CallOption) (*ListCertificateMapEntriesResponse, error)
	// Gets details of a single CertificateMapEntry.
	GetCertificateMapEntry(ctx context.Context, in *GetCertificateMapEntryRequest, opts ...grpc.CallOption) (*CertificateMapEntry, error)
	// Creates a new CertificateMapEntry in a given project and location.
	CreateCertificateMapEntry(ctx context.Context, in *CreateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a CertificateMapEntry.
	UpdateCertificateMapEntry(ctx context.Context, in *UpdateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single CertificateMapEntry.
	DeleteCertificateMapEntry(ctx context.Context, in *DeleteCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DnsAuthorizations in a given project and location.
	ListDnsAuthorizations(ctx context.Context, in *ListDnsAuthorizationsRequest, opts ...grpc.CallOption) (*ListDnsAuthorizationsResponse, error)
	// Gets details of a single DnsAuthorization.
	GetDnsAuthorization(ctx context.Context, in *GetDnsAuthorizationRequest, opts ...grpc.CallOption) (*DnsAuthorization, error)
	// Creates a new DnsAuthorization in a given project and location.
	CreateDnsAuthorization(ctx context.Context, in *CreateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a DnsAuthorization.
	UpdateDnsAuthorization(ctx context.Context, in *UpdateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DnsAuthorization.
	DeleteDnsAuthorization(ctx context.Context, in *DeleteDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CertificateIssuanceConfigs in a given project and location.
	ListCertificateIssuanceConfigs(ctx context.Context, in *ListCertificateIssuanceConfigsRequest, opts ...grpc.CallOption) (*ListCertificateIssuanceConfigsResponse, error)
	// Gets details of a single CertificateIssuanceConfig.
	GetCertificateIssuanceConfig(ctx context.Context, in *GetCertificateIssuanceConfigRequest, opts ...grpc.CallOption) (*CertificateIssuanceConfig, error)
	// Creates a new CertificateIssuanceConfig in a given project and location.
	CreateCertificateIssuanceConfig(ctx context.Context, in *CreateCertificateIssuanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single CertificateIssuanceConfig.
	DeleteCertificateIssuanceConfig(ctx context.Context, in *DeleteCertificateIssuanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists TrustConfigs in a given project and location.
	ListTrustConfigs(ctx context.Context, in *ListTrustConfigsRequest, opts ...grpc.CallOption) (*ListTrustConfigsResponse, error)
	// Gets details of a single TrustConfig.
	GetTrustConfig(ctx context.Context, in *GetTrustConfigRequest, opts ...grpc.CallOption) (*TrustConfig, error)
	// Creates a new TrustConfig in a given project and location.
	CreateTrustConfig(ctx context.Context, in *CreateTrustConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a TrustConfig.
	UpdateTrustConfig(ctx context.Context, in *UpdateTrustConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single TrustConfig.
	DeleteTrustConfig(ctx context.Context, in *DeleteTrustConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type certificateManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewCertificateManagerClient(cc grpc.ClientConnInterface) CertificateManagerClient {
	return &certificateManagerClient{cc}
}

func (c *certificateManagerClient) ListCertificates(ctx context.Context, in *ListCertificatesRequest, opts ...grpc.CallOption) (*ListCertificatesResponse, error) {
	out := new(ListCertificatesResponse)
	err := c.cc.Invoke(ctx, CertificateManager_ListCertificates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificate(ctx context.Context, in *GetCertificateRequest, opts ...grpc.CallOption) (*Certificate, error) {
	out := new(Certificate)
	err := c.cc.Invoke(ctx, CertificateManager_GetCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificate(ctx context.Context, in *CreateCertificateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_CreateCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateCertificate(ctx context.Context, in *UpdateCertificateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_UpdateCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificate(ctx context.Context, in *DeleteCertificateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_DeleteCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListCertificateMaps(ctx context.Context, in *ListCertificateMapsRequest, opts ...grpc.CallOption) (*ListCertificateMapsResponse, error) {
	out := new(ListCertificateMapsResponse)
	err := c.cc.Invoke(ctx, CertificateManager_ListCertificateMaps_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificateMap(ctx context.Context, in *GetCertificateMapRequest, opts ...grpc.CallOption) (*CertificateMap, error) {
	out := new(CertificateMap)
	err := c.cc.Invoke(ctx, CertificateManager_GetCertificateMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificateMap(ctx context.Context, in *CreateCertificateMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_CreateCertificateMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateCertificateMap(ctx context.Context, in *UpdateCertificateMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_UpdateCertificateMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificateMap(ctx context.Context, in *DeleteCertificateMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_DeleteCertificateMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListCertificateMapEntries(ctx context.Context, in *ListCertificateMapEntriesRequest, opts ...grpc.CallOption) (*ListCertificateMapEntriesResponse, error) {
	out := new(ListCertificateMapEntriesResponse)
	err := c.cc.Invoke(ctx, CertificateManager_ListCertificateMapEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificateMapEntry(ctx context.Context, in *GetCertificateMapEntryRequest, opts ...grpc.CallOption) (*CertificateMapEntry, error) {
	out := new(CertificateMapEntry)
	err := c.cc.Invoke(ctx, CertificateManager_GetCertificateMapEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificateMapEntry(ctx context.Context, in *CreateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_CreateCertificateMapEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateCertificateMapEntry(ctx context.Context, in *UpdateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_UpdateCertificateMapEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificateMapEntry(ctx context.Context, in *DeleteCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_DeleteCertificateMapEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListDnsAuthorizations(ctx context.Context, in *ListDnsAuthorizationsRequest, opts ...grpc.CallOption) (*ListDnsAuthorizationsResponse, error) {
	out := new(ListDnsAuthorizationsResponse)
	err := c.cc.Invoke(ctx, CertificateManager_ListDnsAuthorizations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetDnsAuthorization(ctx context.Context, in *GetDnsAuthorizationRequest, opts ...grpc.CallOption) (*DnsAuthorization, error) {
	out := new(DnsAuthorization)
	err := c.cc.Invoke(ctx, CertificateManager_GetDnsAuthorization_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateDnsAuthorization(ctx context.Context, in *CreateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_CreateDnsAuthorization_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateDnsAuthorization(ctx context.Context, in *UpdateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_UpdateDnsAuthorization_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteDnsAuthorization(ctx context.Context, in *DeleteDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_DeleteDnsAuthorization_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListCertificateIssuanceConfigs(ctx context.Context, in *ListCertificateIssuanceConfigsRequest, opts ...grpc.CallOption) (*ListCertificateIssuanceConfigsResponse, error) {
	out := new(ListCertificateIssuanceConfigsResponse)
	err := c.cc.Invoke(ctx, CertificateManager_ListCertificateIssuanceConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificateIssuanceConfig(ctx context.Context, in *GetCertificateIssuanceConfigRequest, opts ...grpc.CallOption) (*CertificateIssuanceConfig, error) {
	out := new(CertificateIssuanceConfig)
	err := c.cc.Invoke(ctx, CertificateManager_GetCertificateIssuanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificateIssuanceConfig(ctx context.Context, in *CreateCertificateIssuanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_CreateCertificateIssuanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificateIssuanceConfig(ctx context.Context, in *DeleteCertificateIssuanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_DeleteCertificateIssuanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListTrustConfigs(ctx context.Context, in *ListTrustConfigsRequest, opts ...grpc.CallOption) (*ListTrustConfigsResponse, error) {
	out := new(ListTrustConfigsResponse)
	err := c.cc.Invoke(ctx, CertificateManager_ListTrustConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetTrustConfig(ctx context.Context, in *GetTrustConfigRequest, opts ...grpc.CallOption) (*TrustConfig, error) {
	out := new(TrustConfig)
	err := c.cc.Invoke(ctx, CertificateManager_GetTrustConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateTrustConfig(ctx context.Context, in *CreateTrustConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_CreateTrustConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateTrustConfig(ctx context.Context, in *UpdateTrustConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_UpdateTrustConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteTrustConfig(ctx context.Context, in *DeleteTrustConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateManager_DeleteTrustConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CertificateManagerServer is the server API for CertificateManager service.
// All implementations should embed UnimplementedCertificateManagerServer
// for forward compatibility
type CertificateManagerServer interface {
	// Lists Certificates in a given project and location.
	ListCertificates(context.Context, *ListCertificatesRequest) (*ListCertificatesResponse, error)
	// Gets details of a single Certificate.
	GetCertificate(context.Context, *GetCertificateRequest) (*Certificate, error)
	// Creates a new Certificate in a given project and location.
	CreateCertificate(context.Context, *CreateCertificateRequest) (*longrunningpb.Operation, error)
	// Updates a Certificate.
	UpdateCertificate(context.Context, *UpdateCertificateRequest) (*longrunningpb.Operation, error)
	// Deletes a single Certificate.
	DeleteCertificate(context.Context, *DeleteCertificateRequest) (*longrunningpb.Operation, error)
	// Lists CertificateMaps in a given project and location.
	ListCertificateMaps(context.Context, *ListCertificateMapsRequest) (*ListCertificateMapsResponse, error)
	// Gets details of a single CertificateMap.
	GetCertificateMap(context.Context, *GetCertificateMapRequest) (*CertificateMap, error)
	// Creates a new CertificateMap in a given project and location.
	CreateCertificateMap(context.Context, *CreateCertificateMapRequest) (*longrunningpb.Operation, error)
	// Updates a CertificateMap.
	UpdateCertificateMap(context.Context, *UpdateCertificateMapRequest) (*longrunningpb.Operation, error)
	// Deletes a single CertificateMap. A Certificate Map can't be deleted
	// if it contains Certificate Map Entries. Remove all the entries from
	// the map before calling this method.
	DeleteCertificateMap(context.Context, *DeleteCertificateMapRequest) (*longrunningpb.Operation, error)
	// Lists CertificateMapEntries in a given project and location.
	ListCertificateMapEntries(context.Context, *ListCertificateMapEntriesRequest) (*ListCertificateMapEntriesResponse, error)
	// Gets details of a single CertificateMapEntry.
	GetCertificateMapEntry(context.Context, *GetCertificateMapEntryRequest) (*CertificateMapEntry, error)
	// Creates a new CertificateMapEntry in a given project and location.
	CreateCertificateMapEntry(context.Context, *CreateCertificateMapEntryRequest) (*longrunningpb.Operation, error)
	// Updates a CertificateMapEntry.
	UpdateCertificateMapEntry(context.Context, *UpdateCertificateMapEntryRequest) (*longrunningpb.Operation, error)
	// Deletes a single CertificateMapEntry.
	DeleteCertificateMapEntry(context.Context, *DeleteCertificateMapEntryRequest) (*longrunningpb.Operation, error)
	// Lists DnsAuthorizations in a given project and location.
	ListDnsAuthorizations(context.Context, *ListDnsAuthorizationsRequest) (*ListDnsAuthorizationsResponse, error)
	// Gets details of a single DnsAuthorization.
	GetDnsAuthorization(context.Context, *GetDnsAuthorizationRequest) (*DnsAuthorization, error)
	// Creates a new DnsAuthorization in a given project and location.
	CreateDnsAuthorization(context.Context, *CreateDnsAuthorizationRequest) (*longrunningpb.Operation, error)
	// Updates a DnsAuthorization.
	UpdateDnsAuthorization(context.Context, *UpdateDnsAuthorizationRequest) (*longrunningpb.Operation, error)
	// Deletes a single DnsAuthorization.
	DeleteDnsAuthorization(context.Context, *DeleteDnsAuthorizationRequest) (*longrunningpb.Operation, error)
	// Lists CertificateIssuanceConfigs in a given project and location.
	ListCertificateIssuanceConfigs(context.Context, *ListCertificateIssuanceConfigsRequest) (*ListCertificateIssuanceConfigsResponse, error)
	// Gets details of a single CertificateIssuanceConfig.
	GetCertificateIssuanceConfig(context.Context, *GetCertificateIssuanceConfigRequest) (*CertificateIssuanceConfig, error)
	// Creates a new CertificateIssuanceConfig in a given project and location.
	CreateCertificateIssuanceConfig(context.Context, *CreateCertificateIssuanceConfigRequest) (*longrunningpb.Operation, error)
	// Deletes a single CertificateIssuanceConfig.
	DeleteCertificateIssuanceConfig(context.Context, *DeleteCertificateIssuanceConfigRequest) (*longrunningpb.Operation, error)
	// Lists TrustConfigs in a given project and location.
	ListTrustConfigs(context.Context, *ListTrustConfigsRequest) (*ListTrustConfigsResponse, error)
	// Gets details of a single TrustConfig.
	GetTrustConfig(context.Context, *GetTrustConfigRequest) (*TrustConfig, error)
	// Creates a new TrustConfig in a given project and location.
	CreateTrustConfig(context.Context, *CreateTrustConfigRequest) (*longrunningpb.Operation, error)
	// Updates a TrustConfig.
	UpdateTrustConfig(context.Context, *UpdateTrustConfigRequest) (*longrunningpb.Operation, error)
	// Deletes a single TrustConfig.
	DeleteTrustConfig(context.Context, *DeleteTrustConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCertificateManagerServer should be embedded to have forward compatible implementations.
type UnimplementedCertificateManagerServer struct {
}

func (UnimplementedCertificateManagerServer) ListCertificates(context.Context, *ListCertificatesRequest) (*ListCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificates not implemented")
}
func (UnimplementedCertificateManagerServer) GetCertificate(context.Context, *GetCertificateRequest) (*Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificate not implemented")
}
func (UnimplementedCertificateManagerServer) CreateCertificate(context.Context, *CreateCertificateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificate not implemented")
}
func (UnimplementedCertificateManagerServer) UpdateCertificate(context.Context, *UpdateCertificateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificate not implemented")
}
func (UnimplementedCertificateManagerServer) DeleteCertificate(context.Context, *DeleteCertificateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificate not implemented")
}
func (UnimplementedCertificateManagerServer) ListCertificateMaps(context.Context, *ListCertificateMapsRequest) (*ListCertificateMapsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateMaps not implemented")
}
func (UnimplementedCertificateManagerServer) GetCertificateMap(context.Context, *GetCertificateMapRequest) (*CertificateMap, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateMap not implemented")
}
func (UnimplementedCertificateManagerServer) CreateCertificateMap(context.Context, *CreateCertificateMapRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateMap not implemented")
}
func (UnimplementedCertificateManagerServer) UpdateCertificateMap(context.Context, *UpdateCertificateMapRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateMap not implemented")
}
func (UnimplementedCertificateManagerServer) DeleteCertificateMap(context.Context, *DeleteCertificateMapRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateMap not implemented")
}
func (UnimplementedCertificateManagerServer) ListCertificateMapEntries(context.Context, *ListCertificateMapEntriesRequest) (*ListCertificateMapEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateMapEntries not implemented")
}
func (UnimplementedCertificateManagerServer) GetCertificateMapEntry(context.Context, *GetCertificateMapEntryRequest) (*CertificateMapEntry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateMapEntry not implemented")
}
func (UnimplementedCertificateManagerServer) CreateCertificateMapEntry(context.Context, *CreateCertificateMapEntryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateMapEntry not implemented")
}
func (UnimplementedCertificateManagerServer) UpdateCertificateMapEntry(context.Context, *UpdateCertificateMapEntryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateMapEntry not implemented")
}
func (UnimplementedCertificateManagerServer) DeleteCertificateMapEntry(context.Context, *DeleteCertificateMapEntryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateMapEntry not implemented")
}
func (UnimplementedCertificateManagerServer) ListDnsAuthorizations(context.Context, *ListDnsAuthorizationsRequest) (*ListDnsAuthorizationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDnsAuthorizations not implemented")
}
func (UnimplementedCertificateManagerServer) GetDnsAuthorization(context.Context, *GetDnsAuthorizationRequest) (*DnsAuthorization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDnsAuthorization not implemented")
}
func (UnimplementedCertificateManagerServer) CreateDnsAuthorization(context.Context, *CreateDnsAuthorizationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDnsAuthorization not implemented")
}
func (UnimplementedCertificateManagerServer) UpdateDnsAuthorization(context.Context, *UpdateDnsAuthorizationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDnsAuthorization not implemented")
}
func (UnimplementedCertificateManagerServer) DeleteDnsAuthorization(context.Context, *DeleteDnsAuthorizationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDnsAuthorization not implemented")
}
func (UnimplementedCertificateManagerServer) ListCertificateIssuanceConfigs(context.Context, *ListCertificateIssuanceConfigsRequest) (*ListCertificateIssuanceConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateIssuanceConfigs not implemented")
}
func (UnimplementedCertificateManagerServer) GetCertificateIssuanceConfig(context.Context, *GetCertificateIssuanceConfigRequest) (*CertificateIssuanceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateIssuanceConfig not implemented")
}
func (UnimplementedCertificateManagerServer) CreateCertificateIssuanceConfig(context.Context, *CreateCertificateIssuanceConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateIssuanceConfig not implemented")
}
func (UnimplementedCertificateManagerServer) DeleteCertificateIssuanceConfig(context.Context, *DeleteCertificateIssuanceConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateIssuanceConfig not implemented")
}
func (UnimplementedCertificateManagerServer) ListTrustConfigs(context.Context, *ListTrustConfigsRequest) (*ListTrustConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTrustConfigs not implemented")
}
func (UnimplementedCertificateManagerServer) GetTrustConfig(context.Context, *GetTrustConfigRequest) (*TrustConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrustConfig not implemented")
}
func (UnimplementedCertificateManagerServer) CreateTrustConfig(context.Context, *CreateTrustConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTrustConfig not implemented")
}
func (UnimplementedCertificateManagerServer) UpdateTrustConfig(context.Context, *UpdateTrustConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTrustConfig not implemented")
}
func (UnimplementedCertificateManagerServer) DeleteTrustConfig(context.Context, *DeleteTrustConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrustConfig not implemented")
}

// UnsafeCertificateManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CertificateManagerServer will
// result in compilation errors.
type UnsafeCertificateManagerServer interface {
	mustEmbedUnimplementedCertificateManagerServer()
}

func RegisterCertificateManagerServer(s grpc.ServiceRegistrar, srv CertificateManagerServer) {
	s.RegisterService(&CertificateManager_ServiceDesc, srv)
}

func _CertificateManager_ListCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_ListCertificates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificates(ctx, req.(*ListCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_GetCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificate(ctx, req.(*GetCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_CreateCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificate(ctx, req.(*CreateCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_UpdateCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateCertificate(ctx, req.(*UpdateCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_DeleteCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificate(ctx, req.(*DeleteCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListCertificateMaps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateMapsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificateMaps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_ListCertificateMaps_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificateMaps(ctx, req.(*ListCertificateMapsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_GetCertificateMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificateMap(ctx, req.(*GetCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_CreateCertificateMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificateMap(ctx, req.(*CreateCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_UpdateCertificateMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateCertificateMap(ctx, req.(*UpdateCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_DeleteCertificateMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificateMap(ctx, req.(*DeleteCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListCertificateMapEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateMapEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificateMapEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_ListCertificateMapEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificateMapEntries(ctx, req.(*ListCertificateMapEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_GetCertificateMapEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificateMapEntry(ctx, req.(*GetCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_CreateCertificateMapEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificateMapEntry(ctx, req.(*CreateCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_UpdateCertificateMapEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateCertificateMapEntry(ctx, req.(*UpdateCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_DeleteCertificateMapEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificateMapEntry(ctx, req.(*DeleteCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListDnsAuthorizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDnsAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListDnsAuthorizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_ListDnsAuthorizations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListDnsAuthorizations(ctx, req.(*ListDnsAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_GetDnsAuthorization_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetDnsAuthorization(ctx, req.(*GetDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_CreateDnsAuthorization_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateDnsAuthorization(ctx, req.(*CreateDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_UpdateDnsAuthorization_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateDnsAuthorization(ctx, req.(*UpdateDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_DeleteDnsAuthorization_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteDnsAuthorization(ctx, req.(*DeleteDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListCertificateIssuanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateIssuanceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificateIssuanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_ListCertificateIssuanceConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificateIssuanceConfigs(ctx, req.(*ListCertificateIssuanceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificateIssuanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateIssuanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificateIssuanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_GetCertificateIssuanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificateIssuanceConfig(ctx, req.(*GetCertificateIssuanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificateIssuanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateIssuanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificateIssuanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_CreateCertificateIssuanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificateIssuanceConfig(ctx, req.(*CreateCertificateIssuanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificateIssuanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateIssuanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificateIssuanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_DeleteCertificateIssuanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificateIssuanceConfig(ctx, req.(*DeleteCertificateIssuanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListTrustConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTrustConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListTrustConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_ListTrustConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListTrustConfigs(ctx, req.(*ListTrustConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetTrustConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTrustConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetTrustConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_GetTrustConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetTrustConfig(ctx, req.(*GetTrustConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateTrustConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTrustConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateTrustConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_CreateTrustConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateTrustConfig(ctx, req.(*CreateTrustConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateTrustConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTrustConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateTrustConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_UpdateTrustConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateTrustConfig(ctx, req.(*UpdateTrustConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteTrustConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTrustConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteTrustConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateManager_DeleteTrustConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteTrustConfig(ctx, req.(*DeleteTrustConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CertificateManager_ServiceDesc is the grpc.ServiceDesc for CertificateManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CertificateManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.certificatemanager.v1.CertificateManager",
	HandlerType: (*CertificateManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCertificates",
			Handler:    _CertificateManager_ListCertificates_Handler,
		},
		{
			MethodName: "GetCertificate",
			Handler:    _CertificateManager_GetCertificate_Handler,
		},
		{
			MethodName: "CreateCertificate",
			Handler:    _CertificateManager_CreateCertificate_Handler,
		},
		{
			MethodName: "UpdateCertificate",
			Handler:    _CertificateManager_UpdateCertificate_Handler,
		},
		{
			MethodName: "DeleteCertificate",
			Handler:    _CertificateManager_DeleteCertificate_Handler,
		},
		{
			MethodName: "ListCertificateMaps",
			Handler:    _CertificateManager_ListCertificateMaps_Handler,
		},
		{
			MethodName: "GetCertificateMap",
			Handler:    _CertificateManager_GetCertificateMap_Handler,
		},
		{
			MethodName: "CreateCertificateMap",
			Handler:    _CertificateManager_CreateCertificateMap_Handler,
		},
		{
			MethodName: "UpdateCertificateMap",
			Handler:    _CertificateManager_UpdateCertificateMap_Handler,
		},
		{
			MethodName: "DeleteCertificateMap",
			Handler:    _CertificateManager_DeleteCertificateMap_Handler,
		},
		{
			MethodName: "ListCertificateMapEntries",
			Handler:    _CertificateManager_ListCertificateMapEntries_Handler,
		},
		{
			MethodName: "GetCertificateMapEntry",
			Handler:    _CertificateManager_GetCertificateMapEntry_Handler,
		},
		{
			MethodName: "CreateCertificateMapEntry",
			Handler:    _CertificateManager_CreateCertificateMapEntry_Handler,
		},
		{
			MethodName: "UpdateCertificateMapEntry",
			Handler:    _CertificateManager_UpdateCertificateMapEntry_Handler,
		},
		{
			MethodName: "DeleteCertificateMapEntry",
			Handler:    _CertificateManager_DeleteCertificateMapEntry_Handler,
		},
		{
			MethodName: "ListDnsAuthorizations",
			Handler:    _CertificateManager_ListDnsAuthorizations_Handler,
		},
		{
			MethodName: "GetDnsAuthorization",
			Handler:    _CertificateManager_GetDnsAuthorization_Handler,
		},
		{
			MethodName: "CreateDnsAuthorization",
			Handler:    _CertificateManager_CreateDnsAuthorization_Handler,
		},
		{
			MethodName: "UpdateDnsAuthorization",
			Handler:    _CertificateManager_UpdateDnsAuthorization_Handler,
		},
		{
			MethodName: "DeleteDnsAuthorization",
			Handler:    _CertificateManager_DeleteDnsAuthorization_Handler,
		},
		{
			MethodName: "ListCertificateIssuanceConfigs",
			Handler:    _CertificateManager_ListCertificateIssuanceConfigs_Handler,
		},
		{
			MethodName: "GetCertificateIssuanceConfig",
			Handler:    _CertificateManager_GetCertificateIssuanceConfig_Handler,
		},
		{
			MethodName: "CreateCertificateIssuanceConfig",
			Handler:    _CertificateManager_CreateCertificateIssuanceConfig_Handler,
		},
		{
			MethodName: "DeleteCertificateIssuanceConfig",
			Handler:    _CertificateManager_DeleteCertificateIssuanceConfig_Handler,
		},
		{
			MethodName: "ListTrustConfigs",
			Handler:    _CertificateManager_ListTrustConfigs_Handler,
		},
		{
			MethodName: "GetTrustConfig",
			Handler:    _CertificateManager_GetTrustConfig_Handler,
		},
		{
			MethodName: "CreateTrustConfig",
			Handler:    _CertificateManager_CreateTrustConfig_Handler,
		},
		{
			MethodName: "UpdateTrustConfig",
			Handler:    _CertificateManager_UpdateTrustConfig_Handler,
		},
		{
			MethodName: "DeleteTrustConfig",
			Handler:    _CertificateManager_DeleteTrustConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/certificatemanager/v1/certificate_manager.proto",
}
