// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/assuredworkloads/v1beta1/assuredworkloads.proto

package assuredworkloads

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported Compliance Regimes.
type Workload_ComplianceRegime int32

const (
	// Unknown compliance regime.
	Workload_COMPLIANCE_REGIME_UNSPECIFIED Workload_ComplianceRegime = 0
	// Information protection as per DoD IL4 requirements.
	Workload_IL4 Workload_ComplianceRegime = 1
	// Criminal Justice Information Services (CJIS) Security policies.
	Workload_CJIS Workload_ComplianceRegime = 2
	// FedRAMP High data protection controls
	Workload_FEDRAMP_HIGH Workload_ComplianceRegime = 3
	// FedRAMP Moderate data protection controls
	Workload_FEDRAMP_MODERATE Workload_ComplianceRegime = 4
	// Assured Workloads For US Regions data protection controls
	Workload_US_REGIONAL_ACCESS Workload_ComplianceRegime = 5
	// Health Insurance Portability and Accountability Act controls
	Workload_HIPAA Workload_ComplianceRegime = 6
	// Health Information Trust Alliance controls
	Workload_HITRUST Workload_ComplianceRegime = 7
	// Assured Workloads For EU Regions and Support controls
	Workload_EU_REGIONS_AND_SUPPORT Workload_ComplianceRegime = 8
	// Assured Workloads For Canada Regions and Support controls
	Workload_CA_REGIONS_AND_SUPPORT Workload_ComplianceRegime = 9
	// International Traffic in Arms Regulations
	Workload_ITAR Workload_ComplianceRegime = 10
)

// Enum value maps for Workload_ComplianceRegime.
var (
	Workload_ComplianceRegime_name = map[int32]string{
		0:  "COMPLIANCE_REGIME_UNSPECIFIED",
		1:  "IL4",
		2:  "CJIS",
		3:  "FEDRAMP_HIGH",
		4:  "FEDRAMP_MODERATE",
		5:  "US_REGIONAL_ACCESS",
		6:  "HIPAA",
		7:  "HITRUST",
		8:  "EU_REGIONS_AND_SUPPORT",
		9:  "CA_REGIONS_AND_SUPPORT",
		10: "ITAR",
	}
	Workload_ComplianceRegime_value = map[string]int32{
		"COMPLIANCE_REGIME_UNSPECIFIED": 0,
		"IL4":                           1,
		"CJIS":                          2,
		"FEDRAMP_HIGH":                  3,
		"FEDRAMP_MODERATE":              4,
		"US_REGIONAL_ACCESS":            5,
		"HIPAA":                         6,
		"HITRUST":                       7,
		"EU_REGIONS_AND_SUPPORT":        8,
		"CA_REGIONS_AND_SUPPORT":        9,
		"ITAR":                          10,
	}
)

func (x Workload_ComplianceRegime) Enum() *Workload_ComplianceRegime {
	p := new(Workload_ComplianceRegime)
	*p = x
	return p
}

func (x Workload_ComplianceRegime) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_ComplianceRegime) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[0].Descriptor()
}

func (Workload_ComplianceRegime) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[0]
}

func (x Workload_ComplianceRegime) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_ComplianceRegime.Descriptor instead.
func (Workload_ComplianceRegime) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 0}
}

// Key Access Justifications(KAJ) Enrollment State.
type Workload_KajEnrollmentState int32

const (
	// Default State for KAJ Enrollment.
	Workload_KAJ_ENROLLMENT_STATE_UNSPECIFIED Workload_KajEnrollmentState = 0
	// Pending State for KAJ Enrollment.
	Workload_KAJ_ENROLLMENT_STATE_PENDING Workload_KajEnrollmentState = 1
	// Complete State for KAJ Enrollment.
	Workload_KAJ_ENROLLMENT_STATE_COMPLETE Workload_KajEnrollmentState = 2
)

// Enum value maps for Workload_KajEnrollmentState.
var (
	Workload_KajEnrollmentState_name = map[int32]string{
		0: "KAJ_ENROLLMENT_STATE_UNSPECIFIED",
		1: "KAJ_ENROLLMENT_STATE_PENDING",
		2: "KAJ_ENROLLMENT_STATE_COMPLETE",
	}
	Workload_KajEnrollmentState_value = map[string]int32{
		"KAJ_ENROLLMENT_STATE_UNSPECIFIED": 0,
		"KAJ_ENROLLMENT_STATE_PENDING":     1,
		"KAJ_ENROLLMENT_STATE_COMPLETE":    2,
	}
)

func (x Workload_KajEnrollmentState) Enum() *Workload_KajEnrollmentState {
	p := new(Workload_KajEnrollmentState)
	*p = x
	return p
}

func (x Workload_KajEnrollmentState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_KajEnrollmentState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[1].Descriptor()
}

func (Workload_KajEnrollmentState) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[1]
}

func (x Workload_KajEnrollmentState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_KajEnrollmentState.Descriptor instead.
func (Workload_KajEnrollmentState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 1}
}

// The type of resource.
type Workload_ResourceInfo_ResourceType int32

const (
	// Unknown resource type.
	Workload_ResourceInfo_RESOURCE_TYPE_UNSPECIFIED Workload_ResourceInfo_ResourceType = 0
	// Deprecated. Existing workloads will continue to support this, but new
	// CreateWorkloadRequests should not specify this as an input value.
	//
	// Deprecated: Do not use.
	Workload_ResourceInfo_CONSUMER_PROJECT Workload_ResourceInfo_ResourceType = 1
	// Consumer Folder.
	Workload_ResourceInfo_CONSUMER_FOLDER Workload_ResourceInfo_ResourceType = 4
	// Consumer project containing encryption keys.
	Workload_ResourceInfo_ENCRYPTION_KEYS_PROJECT Workload_ResourceInfo_ResourceType = 2
	// Keyring resource that hosts encryption keys.
	Workload_ResourceInfo_KEYRING Workload_ResourceInfo_ResourceType = 3
)

// Enum value maps for Workload_ResourceInfo_ResourceType.
var (
	Workload_ResourceInfo_ResourceType_name = map[int32]string{
		0: "RESOURCE_TYPE_UNSPECIFIED",
		1: "CONSUMER_PROJECT",
		4: "CONSUMER_FOLDER",
		2: "ENCRYPTION_KEYS_PROJECT",
		3: "KEYRING",
	}
	Workload_ResourceInfo_ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED": 0,
		"CONSUMER_PROJECT":          1,
		"CONSUMER_FOLDER":           4,
		"ENCRYPTION_KEYS_PROJECT":   2,
		"KEYRING":                   3,
	}
)

func (x Workload_ResourceInfo_ResourceType) Enum() *Workload_ResourceInfo_ResourceType {
	p := new(Workload_ResourceInfo_ResourceType)
	*p = x
	return p
}

func (x Workload_ResourceInfo_ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_ResourceInfo_ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[2].Descriptor()
}

func (Workload_ResourceInfo_ResourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[2]
}

func (x Workload_ResourceInfo_ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_ResourceInfo_ResourceType.Descriptor instead.
func (Workload_ResourceInfo_ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 0, 0}
}

// Setup state of SAA enrollment.
type Workload_SaaEnrollmentResponse_SetupState int32

const (
	// Unspecified.
	Workload_SaaEnrollmentResponse_SETUP_STATE_UNSPECIFIED Workload_SaaEnrollmentResponse_SetupState = 0
	// SAA enrollment pending.
	Workload_SaaEnrollmentResponse_STATUS_PENDING Workload_SaaEnrollmentResponse_SetupState = 1
	// SAA enrollment comopleted.
	Workload_SaaEnrollmentResponse_STATUS_COMPLETE Workload_SaaEnrollmentResponse_SetupState = 2
)

// Enum value maps for Workload_SaaEnrollmentResponse_SetupState.
var (
	Workload_SaaEnrollmentResponse_SetupState_name = map[int32]string{
		0: "SETUP_STATE_UNSPECIFIED",
		1: "STATUS_PENDING",
		2: "STATUS_COMPLETE",
	}
	Workload_SaaEnrollmentResponse_SetupState_value = map[string]int32{
		"SETUP_STATE_UNSPECIFIED": 0,
		"STATUS_PENDING":          1,
		"STATUS_COMPLETE":         2,
	}
)

func (x Workload_SaaEnrollmentResponse_SetupState) Enum() *Workload_SaaEnrollmentResponse_SetupState {
	p := new(Workload_SaaEnrollmentResponse_SetupState)
	*p = x
	return p
}

func (x Workload_SaaEnrollmentResponse_SetupState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_SaaEnrollmentResponse_SetupState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[3].Descriptor()
}

func (Workload_SaaEnrollmentResponse_SetupState) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[3]
}

func (x Workload_SaaEnrollmentResponse_SetupState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_SaaEnrollmentResponse_SetupState.Descriptor instead.
func (Workload_SaaEnrollmentResponse_SetupState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 7, 0}
}

// Setup error of SAA enrollment.
type Workload_SaaEnrollmentResponse_SetupError int32

const (
	// Unspecified.
	Workload_SaaEnrollmentResponse_SETUP_ERROR_UNSPECIFIED Workload_SaaEnrollmentResponse_SetupError = 0
	// Invalid states for all customers, to be redirected to AA UI for
	// additional details.
	Workload_SaaEnrollmentResponse_ERROR_INVALID_BASE_SETUP Workload_SaaEnrollmentResponse_SetupError = 1
	// Returned when there is not an EKM key configured.
	Workload_SaaEnrollmentResponse_ERROR_MISSING_EXTERNAL_SIGNING_KEY Workload_SaaEnrollmentResponse_SetupError = 2
	// Returned when there are no enrolled services or the customer is
	// enrolled in CAA only for a subset of services.
	Workload_SaaEnrollmentResponse_ERROR_NOT_ALL_SERVICES_ENROLLED Workload_SaaEnrollmentResponse_SetupError = 3
	// Returned when exception was encountered during evaluation of other
	// criteria.
	Workload_SaaEnrollmentResponse_ERROR_SETUP_CHECK_FAILED Workload_SaaEnrollmentResponse_SetupError = 4
)

// Enum value maps for Workload_SaaEnrollmentResponse_SetupError.
var (
	Workload_SaaEnrollmentResponse_SetupError_name = map[int32]string{
		0: "SETUP_ERROR_UNSPECIFIED",
		1: "ERROR_INVALID_BASE_SETUP",
		2: "ERROR_MISSING_EXTERNAL_SIGNING_KEY",
		3: "ERROR_NOT_ALL_SERVICES_ENROLLED",
		4: "ERROR_SETUP_CHECK_FAILED",
	}
	Workload_SaaEnrollmentResponse_SetupError_value = map[string]int32{
		"SETUP_ERROR_UNSPECIFIED":            0,
		"ERROR_INVALID_BASE_SETUP":           1,
		"ERROR_MISSING_EXTERNAL_SIGNING_KEY": 2,
		"ERROR_NOT_ALL_SERVICES_ENROLLED":    3,
		"ERROR_SETUP_CHECK_FAILED":           4,
	}
)

func (x Workload_SaaEnrollmentResponse_SetupError) Enum() *Workload_SaaEnrollmentResponse_SetupError {
	p := new(Workload_SaaEnrollmentResponse_SetupError)
	*p = x
	return p
}

func (x Workload_SaaEnrollmentResponse_SetupError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_SaaEnrollmentResponse_SetupError) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[4].Descriptor()
}

func (Workload_SaaEnrollmentResponse_SetupError) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes[4]
}

func (x Workload_SaaEnrollmentResponse_SetupError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_SaaEnrollmentResponse_SetupError.Descriptor instead.
func (Workload_SaaEnrollmentResponse_SetupError) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 7, 1}
}

// Request for creating a workload.
type CreateWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the new Workload's parent.
	// Must be of the form `organizations/{org_id}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Assured Workload to create
	Workload *Workload `protobuf:"bytes,2,opt,name=workload,proto3" json:"workload,omitempty"`
	// Optional. A identifier associated with the workload and underlying projects
	// which allows for the break down of billing costs for a workload. The value
	// provided for the identifier will add a label to the workload and contained
	// projects with the identifier as the value.
	ExternalId string `protobuf:"bytes,3,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
}

func (x *CreateWorkloadRequest) Reset() {
	*x = CreateWorkloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkloadRequest) ProtoMessage() {}

func (x *CreateWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkloadRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{0}
}

func (x *CreateWorkloadRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkloadRequest) GetWorkload() *Workload {
	if x != nil {
		return x.Workload
	}
	return nil
}

func (x *CreateWorkloadRequest) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

// Request for Updating a workload.
type UpdateWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workload to update.
	// The workload’s `name` field is used to identify the workload to be updated.
	// Format:
	// organizations/{org_id}/locations/{location_id}/workloads/{workload_id}
	Workload *Workload `protobuf:"bytes,1,opt,name=workload,proto3" json:"workload,omitempty"`
	// Required. The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWorkloadRequest) Reset() {
	*x = UpdateWorkloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkloadRequest) ProtoMessage() {}

func (x *UpdateWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkloadRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateWorkloadRequest) GetWorkload() *Workload {
	if x != nil {
		return x.Workload
	}
	return nil
}

func (x *UpdateWorkloadRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for deleting a Workload.
type DeleteWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` field is used to identify the workload.
	// Format:
	// organizations/{org_id}/locations/{location_id}/workloads/{workload_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag of the workload.
	// If this is provided, it must match the server's etag.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteWorkloadRequest) Reset() {
	*x = DeleteWorkloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkloadRequest) ProtoMessage() {}

func (x *DeleteWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkloadRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteWorkloadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteWorkloadRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request for fetching a workload.
type GetWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Workload to fetch. This is the
	// workloads's relative path in the API, formatted as
	// "organizations/{organization_id}/locations/{location_id}/workloads/{workload_id}".
	// For example,
	// "organizations/123/locations/us-east1/workloads/assured-workload-1".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkloadRequest) Reset() {
	*x = GetWorkloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkloadRequest) ProtoMessage() {}

func (x *GetWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkloadRequest.ProtoReflect.Descriptor instead.
func (*GetWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{3}
}

func (x *GetWorkloadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for fetching workloads in an organization.
type ListWorkloadsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent Resource to list workloads from.
	// Must be of the form `organizations/{org_id}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token returned from previous request. Page token contains context from
	// previous request. Page token needs to be passed in the second and following
	// requests.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A custom filter for filtering by properties of a workload. At this time,
	// only filtering by labels is supported.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListWorkloadsRequest) Reset() {
	*x = ListWorkloadsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadsRequest) ProtoMessage() {}

func (x *ListWorkloadsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkloadsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{4}
}

func (x *ListWorkloadsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkloadsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkloadsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkloadsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response of ListWorkloads endpoint.
type ListWorkloadsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Workloads under a given parent.
	Workloads []*Workload `protobuf:"bytes,1,rep,name=workloads,proto3" json:"workloads,omitempty"`
	// The next page token. Return empty if reached the last page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWorkloadsResponse) Reset() {
	*x = ListWorkloadsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadsResponse) ProtoMessage() {}

func (x *ListWorkloadsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkloadsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{5}
}

func (x *ListWorkloadsResponse) GetWorkloads() []*Workload {
	if x != nil {
		return x.Workloads
	}
	return nil
}

func (x *ListWorkloadsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// An Workload object for managing highly regulated workloads of cloud
// customers.
type Workload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resource name of the workload.
	// Format:
	// organizations/{organization}/locations/{location}/workloads/{workload}
	//
	// Read-only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-assigned display name of the Workload.
	// When present it must be between 4 to 30 characters.
	// Allowed characters are: lowercase and uppercase letters, numbers,
	// hyphen, and spaces.
	//
	// Example: My Workload
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The resources associated with this workload.
	// These resources will be created when creating the workload.
	// If any of the projects already exist, the workload creation will fail.
	// Always read only.
	Resources []*Workload_ResourceInfo `protobuf:"bytes,3,rep,name=resources,proto3" json:"resources,omitempty"`
	// Required. Immutable. Compliance Regime associated with this workload.
	ComplianceRegime Workload_ComplianceRegime `protobuf:"varint,4,opt,name=compliance_regime,json=complianceRegime,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_ComplianceRegime" json:"compliance_regime,omitempty"`
	// Output only. Immutable. The Workload creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Input only. The billing account used for the resources which are
	// direct children of workload. This billing account is initially associated
	// with the resources created as part of Workload creation.
	// After the initial creation of these resources, the customer can change
	// the assigned billing account.
	// The resource name has the form
	// `billingAccounts/{billing_account_id}`. For example,
	// `billingAccounts/012345-567890-ABCDEF`.
	BillingAccount string `protobuf:"bytes,6,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
	// Settings specific to the selected [compliance_regime]
	//
	// Types that are assignable to ComplianceRegimeSettings:
	//	*Workload_Il4Settings
	//	*Workload_CjisSettings
	//	*Workload_FedrampHighSettings_
	//	*Workload_FedrampModerateSettings_
	ComplianceRegimeSettings isWorkload_ComplianceRegimeSettings `protobuf_oneof:"compliance_regime_settings"`
	// Optional. ETag of the workload, it is calculated on the basis
	// of the Workload contents. It will be used in Update & Delete operations.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Labels applied to the workload.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Input only. The parent resource for the resources managed by this Assured
	// Workload. May be either empty or a folder resource which is a child of the
	// Workload parent. If not specified all resources are created under the
	// parent organization.
	// Format:
	// folders/{folder_id}
	ProvisionedResourcesParent string `protobuf:"bytes,13,opt,name=provisioned_resources_parent,json=provisionedResourcesParent,proto3" json:"provisioned_resources_parent,omitempty"`
	// Input only. Settings used to create a CMEK crypto key. When set a project
	// with a KMS CMEK key is provisioned. This field is mandatory for a subset of
	// Compliance Regimes.
	KmsSettings *Workload_KMSSettings `protobuf:"bytes,14,opt,name=kms_settings,json=kmsSettings,proto3" json:"kms_settings,omitempty"`
	// Input only. Resource properties that are used to customize workload
	// resources. These properties (such as custom project id) will be used to
	// create workload resources if possible. This field is optional.
	ResourceSettings []*Workload_ResourceSettings `protobuf:"bytes,15,rep,name=resource_settings,json=resourceSettings,proto3" json:"resource_settings,omitempty"`
	// Output only. Represents the KAJ enrollment state of the given workload.
	KajEnrollmentState Workload_KajEnrollmentState `protobuf:"varint,17,opt,name=kaj_enrollment_state,json=kajEnrollmentState,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_KajEnrollmentState" json:"kaj_enrollment_state,omitempty"`
	// Optional. Indicates the sovereignty status of the given workload.
	// Currently meant to be used by Europe/Canada customers.
	EnableSovereignControls bool `protobuf:"varint,18,opt,name=enable_sovereign_controls,json=enableSovereignControls,proto3" json:"enable_sovereign_controls,omitempty"`
	// Output only. Represents the SAA enrollment response of the given workload.
	// SAA enrollment response is queried during GetWorkload call.
	// In failure cases, user friendly error message is shown in SAA details page.
	SaaEnrollmentResponse *Workload_SaaEnrollmentResponse `protobuf:"bytes,20,opt,name=saa_enrollment_response,json=saaEnrollmentResponse,proto3" json:"saa_enrollment_response,omitempty"`
}

func (x *Workload) Reset() {
	*x = Workload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload) ProtoMessage() {}

func (x *Workload) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload.ProtoReflect.Descriptor instead.
func (*Workload) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6}
}

func (x *Workload) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Workload) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Workload) GetResources() []*Workload_ResourceInfo {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Workload) GetComplianceRegime() Workload_ComplianceRegime {
	if x != nil {
		return x.ComplianceRegime
	}
	return Workload_COMPLIANCE_REGIME_UNSPECIFIED
}

func (x *Workload) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Workload) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

func (m *Workload) GetComplianceRegimeSettings() isWorkload_ComplianceRegimeSettings {
	if m != nil {
		return m.ComplianceRegimeSettings
	}
	return nil
}

// Deprecated: Do not use.
func (x *Workload) GetIl4Settings() *Workload_IL4Settings {
	if x, ok := x.GetComplianceRegimeSettings().(*Workload_Il4Settings); ok {
		return x.Il4Settings
	}
	return nil
}

// Deprecated: Do not use.
func (x *Workload) GetCjisSettings() *Workload_CJISSettings {
	if x, ok := x.GetComplianceRegimeSettings().(*Workload_CjisSettings); ok {
		return x.CjisSettings
	}
	return nil
}

// Deprecated: Do not use.
func (x *Workload) GetFedrampHighSettings() *Workload_FedrampHighSettings {
	if x, ok := x.GetComplianceRegimeSettings().(*Workload_FedrampHighSettings_); ok {
		return x.FedrampHighSettings
	}
	return nil
}

// Deprecated: Do not use.
func (x *Workload) GetFedrampModerateSettings() *Workload_FedrampModerateSettings {
	if x, ok := x.GetComplianceRegimeSettings().(*Workload_FedrampModerateSettings_); ok {
		return x.FedrampModerateSettings
	}
	return nil
}

func (x *Workload) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Workload) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Workload) GetProvisionedResourcesParent() string {
	if x != nil {
		return x.ProvisionedResourcesParent
	}
	return ""
}

func (x *Workload) GetKmsSettings() *Workload_KMSSettings {
	if x != nil {
		return x.KmsSettings
	}
	return nil
}

func (x *Workload) GetResourceSettings() []*Workload_ResourceSettings {
	if x != nil {
		return x.ResourceSettings
	}
	return nil
}

func (x *Workload) GetKajEnrollmentState() Workload_KajEnrollmentState {
	if x != nil {
		return x.KajEnrollmentState
	}
	return Workload_KAJ_ENROLLMENT_STATE_UNSPECIFIED
}

func (x *Workload) GetEnableSovereignControls() bool {
	if x != nil {
		return x.EnableSovereignControls
	}
	return false
}

func (x *Workload) GetSaaEnrollmentResponse() *Workload_SaaEnrollmentResponse {
	if x != nil {
		return x.SaaEnrollmentResponse
	}
	return nil
}

type isWorkload_ComplianceRegimeSettings interface {
	isWorkload_ComplianceRegimeSettings()
}

type Workload_Il4Settings struct {
	// Required. Input only. Immutable. Settings specific to resources needed
	// for IL4.
	//
	// Deprecated: Do not use.
	Il4Settings *Workload_IL4Settings `protobuf:"bytes,7,opt,name=il4_settings,json=il4Settings,proto3,oneof"`
}

type Workload_CjisSettings struct {
	// Required. Input only. Immutable. Settings specific to resources needed
	// for CJIS.
	//
	// Deprecated: Do not use.
	CjisSettings *Workload_CJISSettings `protobuf:"bytes,8,opt,name=cjis_settings,json=cjisSettings,proto3,oneof"`
}

type Workload_FedrampHighSettings_ struct {
	// Required. Input only. Immutable. Settings specific to resources needed
	// for FedRAMP High.
	//
	// Deprecated: Do not use.
	FedrampHighSettings *Workload_FedrampHighSettings `protobuf:"bytes,11,opt,name=fedramp_high_settings,json=fedrampHighSettings,proto3,oneof"`
}

type Workload_FedrampModerateSettings_ struct {
	// Required. Input only. Immutable. Settings specific to resources needed
	// for FedRAMP Moderate.
	//
	// Deprecated: Do not use.
	FedrampModerateSettings *Workload_FedrampModerateSettings `protobuf:"bytes,12,opt,name=fedramp_moderate_settings,json=fedrampModerateSettings,proto3,oneof"`
}

func (*Workload_Il4Settings) isWorkload_ComplianceRegimeSettings() {}

func (*Workload_CjisSettings) isWorkload_ComplianceRegimeSettings() {}

func (*Workload_FedrampHighSettings_) isWorkload_ComplianceRegimeSettings() {}

func (*Workload_FedrampModerateSettings_) isWorkload_ComplianceRegimeSettings() {}

// Operation metadata to give request details of CreateWorkload.
type CreateWorkloadOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Time when the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The display name of the workload.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The parent of the workload.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Compliance controls that should be applied to the resources
	// managed by the workload.
	ComplianceRegime Workload_ComplianceRegime `protobuf:"varint,4,opt,name=compliance_regime,json=complianceRegime,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_ComplianceRegime" json:"compliance_regime,omitempty"`
	// Optional. Resource properties in the input that are used for
	// creating/customizing workload resources.
	ResourceSettings []*Workload_ResourceSettings `protobuf:"bytes,5,rep,name=resource_settings,json=resourceSettings,proto3" json:"resource_settings,omitempty"`
}

func (x *CreateWorkloadOperationMetadata) Reset() {
	*x = CreateWorkloadOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkloadOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkloadOperationMetadata) ProtoMessage() {}

func (x *CreateWorkloadOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkloadOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateWorkloadOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{7}
}

func (x *CreateWorkloadOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateWorkloadOperationMetadata) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CreateWorkloadOperationMetadata) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkloadOperationMetadata) GetComplianceRegime() Workload_ComplianceRegime {
	if x != nil {
		return x.ComplianceRegime
	}
	return Workload_COMPLIANCE_REGIME_UNSPECIFIED
}

func (x *CreateWorkloadOperationMetadata) GetResourceSettings() []*Workload_ResourceSettings {
	if x != nil {
		return x.ResourceSettings
	}
	return nil
}

// Represent the resources that are children of this Workload.
type Workload_ResourceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource identifier.
	// For a project this represents project_number.
	ResourceId int64 `protobuf:"varint,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Indicates the type of resource.
	ResourceType Workload_ResourceInfo_ResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_ResourceInfo_ResourceType" json:"resource_type,omitempty"`
}

func (x *Workload_ResourceInfo) Reset() {
	*x = Workload_ResourceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_ResourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_ResourceInfo) ProtoMessage() {}

func (x *Workload_ResourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_ResourceInfo.ProtoReflect.Descriptor instead.
func (*Workload_ResourceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Workload_ResourceInfo) GetResourceId() int64 {
	if x != nil {
		return x.ResourceId
	}
	return 0
}

func (x *Workload_ResourceInfo) GetResourceType() Workload_ResourceInfo_ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return Workload_ResourceInfo_RESOURCE_TYPE_UNSPECIFIED
}

// Settings specific to the Key Management Service.
type Workload_KMSSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input only. Immutable. The time at which the Key Management
	// Service will automatically create a new version of the crypto key and
	// mark it as the primary.
	NextRotationTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=next_rotation_time,json=nextRotationTime,proto3" json:"next_rotation_time,omitempty"`
	// Required. Input only. Immutable. [next_rotation_time] will be advanced by
	// this period when the Key Management Service automatically rotates a key.
	// Must be at least 24 hours and at most 876,000 hours.
	RotationPeriod *durationpb.Duration `protobuf:"bytes,2,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
}

func (x *Workload_KMSSettings) Reset() {
	*x = Workload_KMSSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_KMSSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_KMSSettings) ProtoMessage() {}

func (x *Workload_KMSSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_KMSSettings.ProtoReflect.Descriptor instead.
func (*Workload_KMSSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Workload_KMSSettings) GetNextRotationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextRotationTime
	}
	return nil
}

func (x *Workload_KMSSettings) GetRotationPeriod() *durationpb.Duration {
	if x != nil {
		return x.RotationPeriod
	}
	return nil
}

// Settings specific to resources needed for IL4.
//
// Deprecated: Do not use.
type Workload_IL4Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input only. Immutable. Settings used to create a CMEK crypto
	// key.
	KmsSettings *Workload_KMSSettings `protobuf:"bytes,1,opt,name=kms_settings,json=kmsSettings,proto3" json:"kms_settings,omitempty"`
}

func (x *Workload_IL4Settings) Reset() {
	*x = Workload_IL4Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_IL4Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_IL4Settings) ProtoMessage() {}

func (x *Workload_IL4Settings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_IL4Settings.ProtoReflect.Descriptor instead.
func (*Workload_IL4Settings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Workload_IL4Settings) GetKmsSettings() *Workload_KMSSettings {
	if x != nil {
		return x.KmsSettings
	}
	return nil
}

// Settings specific to resources needed for CJIS.
//
// Deprecated: Do not use.
type Workload_CJISSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input only. Immutable. Settings used to create a CMEK crypto
	// key.
	KmsSettings *Workload_KMSSettings `protobuf:"bytes,1,opt,name=kms_settings,json=kmsSettings,proto3" json:"kms_settings,omitempty"`
}

func (x *Workload_CJISSettings) Reset() {
	*x = Workload_CJISSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_CJISSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_CJISSettings) ProtoMessage() {}

func (x *Workload_CJISSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_CJISSettings.ProtoReflect.Descriptor instead.
func (*Workload_CJISSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Workload_CJISSettings) GetKmsSettings() *Workload_KMSSettings {
	if x != nil {
		return x.KmsSettings
	}
	return nil
}

// Settings specific to resources needed for FedRAMP High.
//
// Deprecated: Do not use.
type Workload_FedrampHighSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input only. Immutable. Settings used to create a CMEK crypto
	// key.
	KmsSettings *Workload_KMSSettings `protobuf:"bytes,1,opt,name=kms_settings,json=kmsSettings,proto3" json:"kms_settings,omitempty"`
}

func (x *Workload_FedrampHighSettings) Reset() {
	*x = Workload_FedrampHighSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_FedrampHighSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_FedrampHighSettings) ProtoMessage() {}

func (x *Workload_FedrampHighSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_FedrampHighSettings.ProtoReflect.Descriptor instead.
func (*Workload_FedrampHighSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 4}
}

func (x *Workload_FedrampHighSettings) GetKmsSettings() *Workload_KMSSettings {
	if x != nil {
		return x.KmsSettings
	}
	return nil
}

// Settings specific to resources needed for FedRAMP Moderate.
//
// Deprecated: Do not use.
type Workload_FedrampModerateSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input only. Immutable. Settings used to create a CMEK crypto
	// key.
	KmsSettings *Workload_KMSSettings `protobuf:"bytes,1,opt,name=kms_settings,json=kmsSettings,proto3" json:"kms_settings,omitempty"`
}

func (x *Workload_FedrampModerateSettings) Reset() {
	*x = Workload_FedrampModerateSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_FedrampModerateSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_FedrampModerateSettings) ProtoMessage() {}

func (x *Workload_FedrampModerateSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_FedrampModerateSettings.ProtoReflect.Descriptor instead.
func (*Workload_FedrampModerateSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 5}
}

func (x *Workload_FedrampModerateSettings) GetKmsSettings() *Workload_KMSSettings {
	if x != nil {
		return x.KmsSettings
	}
	return nil
}

// Represent the custom settings for the resources to be created.
type Workload_ResourceSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource identifier.
	// For a project this represents project_id. If the project is already
	// taken, the workload creation will fail.
	ResourceId string `protobuf:"bytes,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Indicates the type of resource. This field should be specified to
	// correspond the id to the right project type (CONSUMER_PROJECT or
	// ENCRYPTION_KEYS_PROJECT)
	ResourceType Workload_ResourceInfo_ResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_ResourceInfo_ResourceType" json:"resource_type,omitempty"`
	// User-assigned resource display name.
	// If not empty it will be used to create a resource with the specified
	// name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *Workload_ResourceSettings) Reset() {
	*x = Workload_ResourceSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_ResourceSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_ResourceSettings) ProtoMessage() {}

func (x *Workload_ResourceSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_ResourceSettings.ProtoReflect.Descriptor instead.
func (*Workload_ResourceSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 6}
}

func (x *Workload_ResourceSettings) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *Workload_ResourceSettings) GetResourceType() Workload_ResourceInfo_ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return Workload_ResourceInfo_RESOURCE_TYPE_UNSPECIFIED
}

func (x *Workload_ResourceSettings) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Signed Access Approvals (SAA) enrollment response.
type Workload_SaaEnrollmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates SAA enrollment status of a given workload.
	SetupStatus *Workload_SaaEnrollmentResponse_SetupState `protobuf:"varint,1,opt,name=setup_status,json=setupStatus,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_SaaEnrollmentResponse_SetupState,oneof" json:"setup_status,omitempty"`
	// Indicates SAA enrollment setup error if any.
	SetupErrors []Workload_SaaEnrollmentResponse_SetupError `protobuf:"varint,2,rep,packed,name=setup_errors,json=setupErrors,proto3,enum=google.cloud.assuredworkloads.v1beta1.Workload_SaaEnrollmentResponse_SetupError" json:"setup_errors,omitempty"`
}

func (x *Workload_SaaEnrollmentResponse) Reset() {
	*x = Workload_SaaEnrollmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload_SaaEnrollmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_SaaEnrollmentResponse) ProtoMessage() {}

func (x *Workload_SaaEnrollmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_SaaEnrollmentResponse.ProtoReflect.Descriptor instead.
func (*Workload_SaaEnrollmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP(), []int{6, 7}
}

func (x *Workload_SaaEnrollmentResponse) GetSetupStatus() Workload_SaaEnrollmentResponse_SetupState {
	if x != nil && x.SetupStatus != nil {
		return *x.SetupStatus
	}
	return Workload_SaaEnrollmentResponse_SETUP_STATE_UNSPECIFIED
}

func (x *Workload_SaaEnrollmentResponse) GetSetupErrors() []Workload_SaaEnrollmentResponse_SetupError {
	if x != nil {
		return x.SetupErrors
	}
	return nil
}

var File_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto protoreflect.FileDescriptor

var file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd9, 0x01,
	0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12,
	0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x50, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x76, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22,
	0x5a, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x73,
	0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0x8e, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x09,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xf9, 0x1e, 0x0a, 0x08, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x5f, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x75, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x42,
	0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x0c,
	0x69, 0x6c, 0x34, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x49, 0x4c, 0x34, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x0b, 0x18, 0x01, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0b,
	0x69, 0x6c, 0x34, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x70, 0x0a, 0x0d, 0x63,
	0x6a, 0x69, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x43, 0x4a, 0x49, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x42, 0x0b, 0x18, 0x01, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52,
	0x0c, 0x63, 0x6a, 0x69, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x86, 0x01,
	0x0a, 0x15, 0x66, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x70, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x46,
	0x65, 0x64, 0x72, 0x61, 0x6d, 0x70, 0x48, 0x69, 0x67, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x42, 0x0b, 0x18, 0x01, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x48,
	0x00, 0x52, 0x13, 0x66, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x70, 0x48, 0x69, 0x67, 0x68, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x19, 0x66, 0x65, 0x64, 0x72, 0x61,
	0x6d, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x46, 0x65, 0x64, 0x72,
	0x61, 0x6d, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x0b, 0x18, 0x01, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05,
	0x48, 0x00, 0x52, 0x17, 0x66, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x45,
	0x0a, 0x1c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x1a, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x4d, 0x53,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0b, 0x6b,
	0x6d, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x72, 0x0a, 0x11, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x10, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x79,
	0x0a, 0x14, 0x6b, 0x61, 0x6a, 0x5f, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x61,
	0x6a, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6b, 0x61, 0x6a, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x19, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x69, 0x67, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x69,
	0x67, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x12, 0x82, 0x01, 0x0a, 0x17, 0x73,
	0x61, 0x61, 0x5f, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x61,
	0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x73, 0x61, 0x61, 0x45, 0x6e, 0x72,
	0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a,
	0xa8, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x6e, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x86, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x18, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x50, 0x52,
	0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x43,
	0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x04,
	0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4b,
	0x45, 0x59, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a,
	0x07, 0x4b, 0x45, 0x59, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x1a, 0xb1, 0x01, 0x0a, 0x0b, 0x4b,
	0x4d, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x53, 0x0a, 0x12, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x6e,
	0x65, 0x78, 0x74, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4d, 0x0a, 0x0f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x52, 0x0e,
	0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0x7c,
	0x0a, 0x0b, 0x49, 0x4c, 0x34, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x69, 0x0a,
	0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x4d, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x6b, 0x6d, 0x73,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x7d, 0x0a, 0x0c,
	0x43, 0x4a, 0x49, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x69, 0x0a, 0x0c,
	0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x4d, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x84, 0x01, 0x0a, 0x13,
	0x46, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x70, 0x48, 0x69, 0x67, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x69, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x4d, 0x53, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41,
	0x05, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x02,
	0x18, 0x01, 0x1a, 0x88, 0x01, 0x0a, 0x17, 0x46, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x70, 0x4d, 0x6f,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x69,
	0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x4d, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x6b, 0x6d,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0xc6, 0x01,
	0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x6e, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xa0, 0x04, 0x0a, 0x15, 0x53, 0x61, 0x61, 0x45, 0x6e,
	0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x78, 0x0a, 0x0c, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x61, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65,
	0x74, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x74, 0x75,
	0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12, 0x73, 0x0a, 0x0c, 0x73, 0x65,
	0x74, 0x75, 0x70, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x2e, 0x53, 0x61, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x52, 0x0b, 0x73, 0x65, 0x74, 0x75, 0x70, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22,
	0x52, 0x0a, 0x0a, 0x53, 0x65, 0x74, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x53, 0x45, 0x54, 0x55, 0x50, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54,
	0x45, 0x10, 0x02, 0x22, 0xb2, 0x01, 0x0a, 0x0a, 0x53, 0x65, 0x74, 0x75, 0x70, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x54, 0x55, 0x50, 0x5f, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1c, 0x0a, 0x18, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x5f, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x01, 0x12, 0x26, 0x0a,
	0x22, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x49, 0x4e, 0x47, 0x5f,
	0x4b, 0x45, 0x59, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f,
	0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xe2, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4d,
	0x50, 0x4c, 0x49, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4d, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x49, 0x4c, 0x34, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4a, 0x49, 0x53, 0x10, 0x02, 0x12,
	0x10, 0x0a, 0x0c, 0x46, 0x45, 0x44, 0x52, 0x41, 0x4d, 0x50, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10,
	0x03, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x45, 0x44, 0x52, 0x41, 0x4d, 0x50, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x52, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x53, 0x5f, 0x52, 0x45,
	0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x05, 0x12,
	0x09, 0x0a, 0x05, 0x48, 0x49, 0x50, 0x41, 0x41, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49,
	0x54, 0x52, 0x55, 0x53, 0x54, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x55, 0x5f, 0x52, 0x45,
	0x47, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x10, 0x08, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x41, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e,
	0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x09, 0x12,
	0x08, 0x0a, 0x04, 0x49, 0x54, 0x41, 0x52, 0x10, 0x0a, 0x22, 0x7f, 0x0a, 0x12, 0x4b, 0x61, 0x6a,
	0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x24, 0x0a, 0x20, 0x4b, 0x41, 0x4a, 0x5f, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x4b, 0x41, 0x4a, 0x5f, 0x45, 0x4e, 0x52,
	0x4f, 0x4c, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x4b, 0x41, 0x4a, 0x5f, 0x45,
	0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x02, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a,
	0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x46, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x7d, 0x42, 0x1c, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0x90, 0x03, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x72, 0x0a, 0x11, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x12, 0x72,
	0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x32, 0xa3, 0x09, 0x0a, 0x17, 0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf9,
	0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x3a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0xca, 0x41, 0x2b, 0x0a,
	0x08, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xea, 0x01, 0x0a, 0x0e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x69, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4c, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0xda, 0x41, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xae, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc1, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd4, 0x01, 0x0a,
	0x0d, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x1a, 0x53, 0xca, 0x41, 0x1f, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf6, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x15, 0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x55, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73,
	0x73, 0x75, 0x72, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x41, 0x5d, 0x0a, 0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescOnce sync.Once
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescData = file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDesc
)

func file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescGZIP() []byte {
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescOnce.Do(func() {
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescData)
	})
	return file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDescData
}

var file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_goTypes = []interface{}{
	(Workload_ComplianceRegime)(0),                 // 0: google.cloud.assuredworkloads.v1beta1.Workload.ComplianceRegime
	(Workload_KajEnrollmentState)(0),               // 1: google.cloud.assuredworkloads.v1beta1.Workload.KajEnrollmentState
	(Workload_ResourceInfo_ResourceType)(0),        // 2: google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo.ResourceType
	(Workload_SaaEnrollmentResponse_SetupState)(0), // 3: google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse.SetupState
	(Workload_SaaEnrollmentResponse_SetupError)(0), // 4: google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse.SetupError
	(*CreateWorkloadRequest)(nil),                  // 5: google.cloud.assuredworkloads.v1beta1.CreateWorkloadRequest
	(*UpdateWorkloadRequest)(nil),                  // 6: google.cloud.assuredworkloads.v1beta1.UpdateWorkloadRequest
	(*DeleteWorkloadRequest)(nil),                  // 7: google.cloud.assuredworkloads.v1beta1.DeleteWorkloadRequest
	(*GetWorkloadRequest)(nil),                     // 8: google.cloud.assuredworkloads.v1beta1.GetWorkloadRequest
	(*ListWorkloadsRequest)(nil),                   // 9: google.cloud.assuredworkloads.v1beta1.ListWorkloadsRequest
	(*ListWorkloadsResponse)(nil),                  // 10: google.cloud.assuredworkloads.v1beta1.ListWorkloadsResponse
	(*Workload)(nil),                               // 11: google.cloud.assuredworkloads.v1beta1.Workload
	(*CreateWorkloadOperationMetadata)(nil),        // 12: google.cloud.assuredworkloads.v1beta1.CreateWorkloadOperationMetadata
	(*Workload_ResourceInfo)(nil),                  // 13: google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo
	(*Workload_KMSSettings)(nil),                   // 14: google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings
	(*Workload_IL4Settings)(nil),                   // 15: google.cloud.assuredworkloads.v1beta1.Workload.IL4Settings
	(*Workload_CJISSettings)(nil),                  // 16: google.cloud.assuredworkloads.v1beta1.Workload.CJISSettings
	(*Workload_FedrampHighSettings)(nil),           // 17: google.cloud.assuredworkloads.v1beta1.Workload.FedrampHighSettings
	(*Workload_FedrampModerateSettings)(nil),       // 18: google.cloud.assuredworkloads.v1beta1.Workload.FedrampModerateSettings
	(*Workload_ResourceSettings)(nil),              // 19: google.cloud.assuredworkloads.v1beta1.Workload.ResourceSettings
	(*Workload_SaaEnrollmentResponse)(nil),         // 20: google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse
	nil,                                            // 21: google.cloud.assuredworkloads.v1beta1.Workload.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),                  // 22: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                  // 23: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                    // 24: google.protobuf.Duration
	(*longrunning.Operation)(nil),                  // 25: google.longrunning.Operation
	(*emptypb.Empty)(nil),                          // 26: google.protobuf.Empty
}
var file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_depIdxs = []int32{
	11, // 0: google.cloud.assuredworkloads.v1beta1.CreateWorkloadRequest.workload:type_name -> google.cloud.assuredworkloads.v1beta1.Workload
	11, // 1: google.cloud.assuredworkloads.v1beta1.UpdateWorkloadRequest.workload:type_name -> google.cloud.assuredworkloads.v1beta1.Workload
	22, // 2: google.cloud.assuredworkloads.v1beta1.UpdateWorkloadRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 3: google.cloud.assuredworkloads.v1beta1.ListWorkloadsResponse.workloads:type_name -> google.cloud.assuredworkloads.v1beta1.Workload
	13, // 4: google.cloud.assuredworkloads.v1beta1.Workload.resources:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo
	0,  // 5: google.cloud.assuredworkloads.v1beta1.Workload.compliance_regime:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ComplianceRegime
	23, // 6: google.cloud.assuredworkloads.v1beta1.Workload.create_time:type_name -> google.protobuf.Timestamp
	15, // 7: google.cloud.assuredworkloads.v1beta1.Workload.il4_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.IL4Settings
	16, // 8: google.cloud.assuredworkloads.v1beta1.Workload.cjis_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.CJISSettings
	17, // 9: google.cloud.assuredworkloads.v1beta1.Workload.fedramp_high_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.FedrampHighSettings
	18, // 10: google.cloud.assuredworkloads.v1beta1.Workload.fedramp_moderate_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.FedrampModerateSettings
	21, // 11: google.cloud.assuredworkloads.v1beta1.Workload.labels:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.LabelsEntry
	14, // 12: google.cloud.assuredworkloads.v1beta1.Workload.kms_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings
	19, // 13: google.cloud.assuredworkloads.v1beta1.Workload.resource_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ResourceSettings
	1,  // 14: google.cloud.assuredworkloads.v1beta1.Workload.kaj_enrollment_state:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.KajEnrollmentState
	20, // 15: google.cloud.assuredworkloads.v1beta1.Workload.saa_enrollment_response:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse
	23, // 16: google.cloud.assuredworkloads.v1beta1.CreateWorkloadOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	0,  // 17: google.cloud.assuredworkloads.v1beta1.CreateWorkloadOperationMetadata.compliance_regime:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ComplianceRegime
	19, // 18: google.cloud.assuredworkloads.v1beta1.CreateWorkloadOperationMetadata.resource_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ResourceSettings
	2,  // 19: google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo.resource_type:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo.ResourceType
	23, // 20: google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings.next_rotation_time:type_name -> google.protobuf.Timestamp
	24, // 21: google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings.rotation_period:type_name -> google.protobuf.Duration
	14, // 22: google.cloud.assuredworkloads.v1beta1.Workload.IL4Settings.kms_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings
	14, // 23: google.cloud.assuredworkloads.v1beta1.Workload.CJISSettings.kms_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings
	14, // 24: google.cloud.assuredworkloads.v1beta1.Workload.FedrampHighSettings.kms_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings
	14, // 25: google.cloud.assuredworkloads.v1beta1.Workload.FedrampModerateSettings.kms_settings:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.KMSSettings
	2,  // 26: google.cloud.assuredworkloads.v1beta1.Workload.ResourceSettings.resource_type:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.ResourceInfo.ResourceType
	3,  // 27: google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse.setup_status:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse.SetupState
	4,  // 28: google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse.setup_errors:type_name -> google.cloud.assuredworkloads.v1beta1.Workload.SaaEnrollmentResponse.SetupError
	5,  // 29: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.CreateWorkload:input_type -> google.cloud.assuredworkloads.v1beta1.CreateWorkloadRequest
	6,  // 30: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.UpdateWorkload:input_type -> google.cloud.assuredworkloads.v1beta1.UpdateWorkloadRequest
	7,  // 31: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.DeleteWorkload:input_type -> google.cloud.assuredworkloads.v1beta1.DeleteWorkloadRequest
	8,  // 32: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.GetWorkload:input_type -> google.cloud.assuredworkloads.v1beta1.GetWorkloadRequest
	9,  // 33: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.ListWorkloads:input_type -> google.cloud.assuredworkloads.v1beta1.ListWorkloadsRequest
	25, // 34: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.CreateWorkload:output_type -> google.longrunning.Operation
	11, // 35: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.UpdateWorkload:output_type -> google.cloud.assuredworkloads.v1beta1.Workload
	26, // 36: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.DeleteWorkload:output_type -> google.protobuf.Empty
	11, // 37: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.GetWorkload:output_type -> google.cloud.assuredworkloads.v1beta1.Workload
	10, // 38: google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService.ListWorkloads:output_type -> google.cloud.assuredworkloads.v1beta1.ListWorkloadsResponse
	34, // [34:39] is the sub-list for method output_type
	29, // [29:34] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_init() }
func file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_init() {
	if File_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkloadOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_ResourceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_KMSSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_IL4Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_CJISSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_FedrampHighSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_FedrampModerateSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_ResourceSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload_SaaEnrollmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Workload_Il4Settings)(nil),
		(*Workload_CjisSettings)(nil),
		(*Workload_FedrampHighSettings_)(nil),
		(*Workload_FedrampModerateSettings_)(nil),
	}
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes[15].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_goTypes,
		DependencyIndexes: file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_depIdxs,
		EnumInfos:         file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_enumTypes,
		MessageInfos:      file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_msgTypes,
	}.Build()
	File_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto = out.File
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_rawDesc = nil
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_goTypes = nil
	file_google_cloud_assuredworkloads_v1beta1_assuredworkloads_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssuredWorkloadsServiceClient is the client API for AssuredWorkloadsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssuredWorkloadsServiceClient interface {
	// Creates Assured Workload.
	CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error)
}

type assuredWorkloadsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssuredWorkloadsServiceClient(cc grpc.ClientConnInterface) AssuredWorkloadsServiceClient {
	return &assuredWorkloadsServiceClient{cc}
}

func (c *assuredWorkloadsServiceClient) CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/CreateWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/UpdateWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/DeleteWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/GetWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error) {
	out := new(ListWorkloadsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/ListWorkloads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssuredWorkloadsServiceServer is the server API for AssuredWorkloadsService service.
type AssuredWorkloadsServiceServer interface {
	// Creates Assured Workload.
	CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunning.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error)
}

// UnimplementedAssuredWorkloadsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssuredWorkloadsServiceServer struct {
}

func (*UnimplementedAssuredWorkloadsServiceServer) CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloads not implemented")
}

func RegisterAssuredWorkloadsServiceServer(s *grpc.Server, srv AssuredWorkloadsServiceServer) {
	s.RegisterService(&_AssuredWorkloadsService_serviceDesc, srv)
}

func _AssuredWorkloadsService_CreateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/CreateWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, req.(*CreateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_UpdateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/UpdateWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, req.(*UpdateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_DeleteWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/DeleteWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, req.(*DeleteWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_GetWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/GetWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, req.(*GetWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_ListWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/ListWorkloads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, req.(*ListWorkloadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssuredWorkloadsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService",
	HandlerType: (*AssuredWorkloadsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkload",
			Handler:    _AssuredWorkloadsService_CreateWorkload_Handler,
		},
		{
			MethodName: "UpdateWorkload",
			Handler:    _AssuredWorkloadsService_UpdateWorkload_Handler,
		},
		{
			MethodName: "DeleteWorkload",
			Handler:    _AssuredWorkloadsService_DeleteWorkload_Handler,
		},
		{
			MethodName: "GetWorkload",
			Handler:    _AssuredWorkloadsService_GetWorkload_Handler,
		},
		{
			MethodName: "ListWorkloads",
			Handler:    _AssuredWorkloadsService_ListWorkloads_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/assuredworkloads/v1beta1/assuredworkloads.proto",
}
