// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/retail/v2alpha/product.proto

package retail

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of this product.
type Product_Type int32

const (
	// Default value. Default to
	// [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
	// if unset.
	Product_TYPE_UNSPECIFIED Product_Type = 0
	// The primary type.
	//
	// As the primary unit for predicting, indexing and search serving, a
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product] is grouped with multiple
	// [Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2alpha.Product]s.
	Product_PRIMARY Product_Type = 1
	// The variant type.
	//
	// [Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2alpha.Product]s usually share some common
	// attributes on the same
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product]s, but they have variant
	// attributes like different colors, sizes and prices, etc.
	Product_VARIANT Product_Type = 2
	// The collection type. Collection products are bundled
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product]s or
	// [Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2alpha.Product]s that are sold together,
	// such as a jewelry set with necklaces, earrings and rings, etc.
	Product_COLLECTION Product_Type = 3
)

// Enum value maps for Product_Type.
var (
	Product_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PRIMARY",
		2: "VARIANT",
		3: "COLLECTION",
	}
	Product_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PRIMARY":          1,
		"VARIANT":          2,
		"COLLECTION":       3,
	}
)

func (x Product_Type) Enum() *Product_Type {
	p := new(Product_Type)
	*p = x
	return p
}

func (x Product_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Product_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2alpha_product_proto_enumTypes[0].Descriptor()
}

func (Product_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2alpha_product_proto_enumTypes[0]
}

func (x Product_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Product_Type.Descriptor instead.
func (Product_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_product_proto_rawDescGZIP(), []int{0, 0}
}

// Product availability. If this field is unspecified, the product is
// assumed to be in stock.
type Product_Availability int32

const (
	// Default product availability. Default to
	// [Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
	// if unset.
	Product_AVAILABILITY_UNSPECIFIED Product_Availability = 0
	// Product in stock.
	Product_IN_STOCK Product_Availability = 1
	// Product out of stock.
	Product_OUT_OF_STOCK Product_Availability = 2
	// Product that is in pre-order state.
	Product_PREORDER Product_Availability = 3
	// Product that is back-ordered (i.e. temporarily out of stock).
	Product_BACKORDER Product_Availability = 4
)

// Enum value maps for Product_Availability.
var (
	Product_Availability_name = map[int32]string{
		0: "AVAILABILITY_UNSPECIFIED",
		1: "IN_STOCK",
		2: "OUT_OF_STOCK",
		3: "PREORDER",
		4: "BACKORDER",
	}
	Product_Availability_value = map[string]int32{
		"AVAILABILITY_UNSPECIFIED": 0,
		"IN_STOCK":                 1,
		"OUT_OF_STOCK":             2,
		"PREORDER":                 3,
		"BACKORDER":                4,
	}
)

func (x Product_Availability) Enum() *Product_Availability {
	p := new(Product_Availability)
	*p = x
	return p
}

func (x Product_Availability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Product_Availability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2alpha_product_proto_enumTypes[1].Descriptor()
}

func (Product_Availability) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2alpha_product_proto_enumTypes[1]
}

func (x Product_Availability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Product_Availability.Descriptor instead.
func (Product_Availability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_product_proto_rawDescGZIP(), []int{0, 1}
}

// Product captures all metadata information of items to be recommended or
// searched.
type Product struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Expiration:
	//	*Product_ExpireTime
	//	*Product_Ttl
	Expiration isProduct_Expiration `protobuf_oneof:"expiration"`
	// Immutable. Full resource name of the product, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. [Product][google.cloud.retail.v2alpha.Product] identifier, which
	// is the final component of [name][google.cloud.retail.v2alpha.Product.name].
	// For example, this field is "id_1", if
	// [name][google.cloud.retail.v2alpha.Product.name] is
	// `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
	//
	// This field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [id](https://support.google.com/merchants/answer/6324405). Schema.org
	// property [Product.sku](https://schema.org/sku).
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Immutable. The type of the product. Default to
	// [Catalog.product_level_config.ingestion_product_type][google.cloud.retail.v2alpha.ProductLevelConfig.ingestion_product_type]
	// if unset.
	Type Product_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.retail.v2alpha.Product_Type" json:"type,omitempty"`
	// Variant group identifier. Must be an
	// [id][google.cloud.retail.v2alpha.Product.id], with the same parent branch
	// with this product. Otherwise, an error is thrown.
	//
	// For [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product]s, this field can only be
	// empty or set to the same value as
	// [id][google.cloud.retail.v2alpha.Product.id].
	//
	// For VARIANT [Product][google.cloud.retail.v2alpha.Product]s, this field
	// cannot be empty. A maximum of 2,000 products are allowed to share the same
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product]. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [item_group_id](https://support.google.com/merchants/answer/6324507).
	// Schema.org property
	// [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
	PrimaryProductId string `protobuf:"bytes,4,opt,name=primary_product_id,json=primaryProductId,proto3" json:"primary_product_id,omitempty"`
	// The [id][google.cloud.retail.v2alpha.Product.id] of the collection members
	// when [type][google.cloud.retail.v2alpha.Product.type] is
	// [Type.COLLECTION][google.cloud.retail.v2alpha.Product.Type.COLLECTION].
	//
	// Non-existent product ids are allowed.
	// The [type][google.cloud.retail.v2alpha.Product.type] of the members must be
	// either [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY] or
	// [Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT] otherwise
	// and INVALID_ARGUMENT error is thrown. Should not set it for other types. A
	// maximum of 1000 values are allowed. Otherwise, an INVALID_ARGUMENT error is
	// return.
	CollectionMemberIds []string `protobuf:"bytes,5,rep,name=collection_member_ids,json=collectionMemberIds,proto3" json:"collection_member_ids,omitempty"`
	// The Global Trade Item Number (GTIN) of the product.
	//
	// This field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// This field must be a Unigram. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [gtin](https://support.google.com/merchants/answer/6324461).
	// Schema.org property
	// [Product.isbn](https://schema.org/isbn),
	// [Product.gtin8](https://schema.org/gtin8),
	// [Product.gtin12](https://schema.org/gtin12),
	// [Product.gtin13](https://schema.org/gtin13), or
	// [Product.gtin14](https://schema.org/gtin14).
	//
	// If the value is not a valid GTIN, an INVALID_ARGUMENT error is returned.
	Gtin string `protobuf:"bytes,6,opt,name=gtin,proto3" json:"gtin,omitempty"`
	// Product categories. This field is repeated for supporting one product
	// belonging to several parallel categories. Strongly recommended using the
	// full path for better search / recommendation quality.
	//
	//
	// To represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, please replace it with
	// other character(s).
	//
	// For example, if a shoes product belongs to both
	// ["Shoes & Accessories" -> "Shoes"] and
	// ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be
	// represented as:
	//
	//      "categories": [
	//        "Shoes & Accessories > Shoes",
	//        "Sports & Fitness > Athletic Clothing > Shoes"
	//      ]
	//
	// Must be set for
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product] otherwise an
	// INVALID_ARGUMENT error is returned.
	//
	// At most 250 values are allowed per
	// [Product][google.cloud.retail.v2alpha.Product]. Empty values are not
	// allowed. Each value must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [google_product_category][mc_google_product_category]. Schema.org property
	// [Product.category] (https://schema.org/category).
	//
	// [mc_google_product_category]:
	// https://support.google.com/merchants/answer/6324436
	Categories []string `protobuf:"bytes,7,rep,name=categories,proto3" json:"categories,omitempty"`
	// Required. Product title.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [title](https://support.google.com/merchants/answer/6324415). Schema.org
	// property [Product.name](https://schema.org/name).
	Title string `protobuf:"bytes,8,opt,name=title,proto3" json:"title,omitempty"`
	// The brands of the product.
	//
	// A maximum of 30 brands are allowed. Each brand must be a UTF-8 encoded
	// string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [brand](https://support.google.com/merchants/answer/6324351). Schema.org
	// property [Product.brand](https://schema.org/brand).
	Brands []string `protobuf:"bytes,9,rep,name=brands,proto3" json:"brands,omitempty"`
	// Product description.
	//
	// This field must be a UTF-8 encoded string with a length limit of 5,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [description](https://support.google.com/merchants/answer/6324468).
	// Schema.org property [Product.description](https://schema.org/description).
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// Language of the title/description and other string attributes. Use language
	// tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	//
	// For product prediction, this field is ignored and the model automatically
	// detects the text language. The
	// [Product][google.cloud.retail.v2alpha.Product] can include text in
	// different languages, but duplicating
	// [Product][google.cloud.retail.v2alpha.Product]s to provide text in multiple
	// languages can result in degraded model performance.
	//
	// For product search this field is in use. It defaults to "en-US" if unset.
	LanguageCode string `protobuf:"bytes,11,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Highly encouraged. Extra product attributes to be included. For example,
	// for products, this could include the store name, vendor, style, color, etc.
	// These are very strong signals for recommendation model, thus we highly
	// recommend providing the attributes here.
	//
	// Features that can take on one of a limited number of possible values. Two
	// types of features can be set are:
	//
	// Textual features. some examples would be the brand/maker of a product, or
	// country of a customer. Numerical features. Some examples would be the
	// height/weight of a product, or age of a customer.
	//
	// For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
	// "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
	// }`.
	//
	// This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
	// error is returned:
	//
	// * Max entries count: 200.
	// * The key must be a UTF-8 encoded string with a length limit of 128
	//   characters.
	// * For indexable attribute, the key must match the pattern:
	//   `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example, `key0LikeThis` or
	//   `KEY_1_LIKE_THIS`.
	// * For text attributes, at most 400 values are allowed. Empty values are not
	//   allowed. Each value must be a non-empty UTF-8 encoded string with a
	//   length limit of 256 characters.
	// * For number attributes, at most 400 values are allowed.
	Attributes map[string]*CustomAttribute `protobuf:"bytes,12,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Custom tags associated with the product.
	//
	// At most 250 values are allowed per
	// [Product][google.cloud.retail.v2alpha.Product]. This value must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// This tag can be used for filtering recommendation results by passing the
	// tag as part of the
	// [PredictRequest.filter][google.cloud.retail.v2alpha.PredictRequest.filter].
	//
	// Corresponding properties: Google Merchant Center property
	// [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
	Tags []string `protobuf:"bytes,13,rep,name=tags,proto3" json:"tags,omitempty"`
	// Product price and cost information.
	//
	// Corresponding properties: Google Merchant Center property
	// [price](https://support.google.com/merchants/answer/6324371).
	PriceInfo *PriceInfo `protobuf:"bytes,14,opt,name=price_info,json=priceInfo,proto3" json:"price_info,omitempty"`
	// The rating of this product.
	Rating *Rating `protobuf:"bytes,15,opt,name=rating,proto3" json:"rating,omitempty"`
	// The timestamp when this [Product][google.cloud.retail.v2alpha.Product]
	// becomes available for
	// [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
	AvailableTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=available_time,json=availableTime,proto3" json:"available_time,omitempty"`
	// The online availability of the
	// [Product][google.cloud.retail.v2alpha.Product]. Default to
	// [Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK].
	//
	// Corresponding properties: Google Merchant Center property
	// [availability](https://support.google.com/merchants/answer/6324448).
	// Schema.org property [Offer.availability](https://schema.org/availability).
	Availability Product_Availability `protobuf:"varint,19,opt,name=availability,proto3,enum=google.cloud.retail.v2alpha.Product_Availability" json:"availability,omitempty"`
	// The available quantity of the item.
	AvailableQuantity *wrapperspb.Int32Value `protobuf:"bytes,20,opt,name=available_quantity,json=availableQuantity,proto3" json:"available_quantity,omitempty"`
	// Fulfillment information, such as the store IDs for in-store pickup or
	// region IDs for different shipping methods.
	//
	// All the elements must have distinct
	// [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type].
	// Otherwise, an INVALID_ARGUMENT error is returned.
	FulfillmentInfo []*FulfillmentInfo `protobuf:"bytes,21,rep,name=fulfillment_info,json=fulfillmentInfo,proto3" json:"fulfillment_info,omitempty"`
	// Canonical URL directly linking to the product detail page.
	//
	// It is strongly recommended to provide a valid uri for the product,
	// otherwise the service performance could be significantly degraded.
	//
	// This field must be a UTF-8 encoded string with a length limit of 5,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [link](https://support.google.com/merchants/answer/6324416). Schema.org
	// property [Offer.url](https://schema.org/url).
	Uri string `protobuf:"bytes,22,opt,name=uri,proto3" json:"uri,omitempty"`
	// Product images for the product. We highly recommend putting the main
	// image first.
	//
	// A maximum of 300 images are allowed.
	//
	// Corresponding properties: Google Merchant Center property
	// [image_link](https://support.google.com/merchants/answer/6324350).
	// Schema.org property [Product.image](https://schema.org/image).
	Images []*Image `protobuf:"bytes,23,rep,name=images,proto3" json:"images,omitempty"`
	// The target group associated with a given audience (e.g. male, veterans,
	// car owners, musicians, etc.) of the product.
	Audience *Audience `protobuf:"bytes,24,opt,name=audience,proto3" json:"audience,omitempty"`
	// The color of the product.
	//
	// Corresponding properties: Google Merchant Center property
	// [color](https://support.google.com/merchants/answer/6324487). Schema.org
	// property [Product.color](https://schema.org/color).
	ColorInfo *ColorInfo `protobuf:"bytes,25,opt,name=color_info,json=colorInfo,proto3" json:"color_info,omitempty"`
	// The size of the product. To represent different size systems or size types,
	// consider using this format: [[[size_system:]size_type:]size_value].
	//
	// For example, in "US:MENS:M", "US" represents size system; "MENS" represents
	// size type; "M" represents size value. In "GIRLS:27", size system is empty;
	// "GIRLS" represents size type; "27" represents size value. In "32 inches",
	// both size system and size type are empty, while size value is "32 inches".
	//
	// A maximum of 20 values are allowed per
	// [Product][google.cloud.retail.v2alpha.Product]. Each value must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [size](https://support.google.com/merchants/answer/6324492),
	// [size_type](https://support.google.com/merchants/answer/6324497), and
	// [size_system](https://support.google.com/merchants/answer/6324502).
	// Schema.org property [Product.size](https://schema.org/size).
	Sizes []string `protobuf:"bytes,26,rep,name=sizes,proto3" json:"sizes,omitempty"`
	// The material of the product. For example, "leather", "wooden".
	//
	// A maximum of 20 values are allowed. Each value must be a UTF-8 encoded
	// string with a length limit of 200 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [material](https://support.google.com/merchants/answer/6324410). Schema.org
	// property [Product.material](https://schema.org/material).
	Materials []string `protobuf:"bytes,27,rep,name=materials,proto3" json:"materials,omitempty"`
	// The pattern or graphic print of the product. For example, "striped", "polka
	// dot", "paisley".
	//
	// A maximum of 20 values are allowed per
	// [Product][google.cloud.retail.v2alpha.Product]. Each value must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [pattern](https://support.google.com/merchants/answer/6324483). Schema.org
	// property [Product.pattern](https://schema.org/pattern).
	Patterns []string `protobuf:"bytes,28,rep,name=patterns,proto3" json:"patterns,omitempty"`
	// The condition of the product. Strongly encouraged to use the standard
	// values: "new", "refurbished", "used".
	//
	// A maximum of 1 value is allowed per
	// [Product][google.cloud.retail.v2alpha.Product]. Each value must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	//
	// Corresponding properties: Google Merchant Center property
	// [condition](https://support.google.com/merchants/answer/6324469).
	// Schema.org property
	// [Offer.itemCondition](https://schema.org/itemCondition).
	Conditions []string `protobuf:"bytes,29,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// The promotions applied to the product. A maximum of 10 values are allowed
	// per [Product][google.cloud.retail.v2alpha.Product]. Only
	// [Promotion.promotion_id][google.cloud.retail.v2alpha.Promotion.promotion_id]
	// will be used, other fields will be ignored if set.
	Promotions []*Promotion `protobuf:"bytes,34,rep,name=promotions,proto3" json:"promotions,omitempty"`
	// The timestamp when the product is published by the retailer for the first
	// time, which indicates the freshness of the products. Note that this field
	// is different from
	// [available_time][google.cloud.retail.v2alpha.Product.available_time], given
	// it purely describes product freshness regardless of when it is available on
	// search and recommendation.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,33,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// Indicates which fields in the
	// [Product][google.cloud.retail.v2alpha.Product]s are returned in
	// [SearchResponse][google.cloud.retail.v2alpha.SearchResponse].
	//
	// Supported fields for all [type][google.cloud.retail.v2alpha.Product.type]s:
	//
	// * [audience][google.cloud.retail.v2alpha.Product.audience]
	// * [availability][google.cloud.retail.v2alpha.Product.availability]
	// * [brands][google.cloud.retail.v2alpha.Product.brands]
	// * [color_info][google.cloud.retail.v2alpha.Product.color_info]
	// * [conditions][google.cloud.retail.v2alpha.Product.conditions]
	// * [gtin][google.cloud.retail.v2alpha.Product.gtin]
	// * [materials][google.cloud.retail.v2alpha.Product.materials]
	// * [name][google.cloud.retail.v2alpha.Product.name]
	// * [patterns][google.cloud.retail.v2alpha.Product.patterns]
	// * [price_info][google.cloud.retail.v2alpha.Product.price_info]
	// * [rating][google.cloud.retail.v2alpha.Product.rating]
	// * [sizes][google.cloud.retail.v2alpha.Product.sizes]
	// * [title][google.cloud.retail.v2alpha.Product.title]
	// * [uri][google.cloud.retail.v2alpha.Product.uri]
	//
	// Supported fields only for
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY] and
	// [Type.COLLECTION][google.cloud.retail.v2alpha.Product.Type.COLLECTION]:
	//
	// * [categories][google.cloud.retail.v2alpha.Product.categories]
	// * [description][google.cloud.retail.v2alpha.Product.description]
	// * [images][google.cloud.retail.v2alpha.Product.images]
	//
	// Supported fields only for
	// [Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]:
	//
	// * Only the first image in
	// [images][google.cloud.retail.v2alpha.Product.images]
	//
	// To mark [attributes][google.cloud.retail.v2alpha.Product.attributes] as
	// retrievable, include paths of the form "attributes.key" where "key" is the
	// key of a custom attribute, as specified in
	// [attributes][google.cloud.retail.v2alpha.Product.attributes].
	//
	// For [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY] and
	// [Type.COLLECTION][google.cloud.retail.v2alpha.Product.Type.COLLECTION], the
	// following fields are always returned in
	// [SearchResponse][google.cloud.retail.v2alpha.SearchResponse] by default:
	//
	// * [name][google.cloud.retail.v2alpha.Product.name]
	//
	// For [Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT], the
	// following fields are always returned in by default:
	//
	// * [name][google.cloud.retail.v2alpha.Product.name]
	// * [color_info][google.cloud.retail.v2alpha.Product.color_info]
	//
	// Maximum number of paths is 30. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	//
	// Note: Returning more fields in
	// [SearchResponse][google.cloud.retail.v2alpha.SearchResponse] may increase
	// response payload size and serving latency.
	RetrievableFields *fieldmaskpb.FieldMask `protobuf:"bytes,30,opt,name=retrievable_fields,json=retrievableFields,proto3" json:"retrievable_fields,omitempty"`
	// Output only. Product variants grouped together on primary product which
	// share similar product attributes. It's automatically grouped by
	// [primary_product_id][google.cloud.retail.v2alpha.Product.primary_product_id]
	// for all the product variants. Only populated for
	// [Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
	// [Product][google.cloud.retail.v2alpha.Product]s.
	//
	// Note: This field is OUTPUT_ONLY for
	// [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct].
	// Do not set this field in API requests.
	Variants []*Product `protobuf:"bytes,31,rep,name=variants,proto3" json:"variants,omitempty"`
}

func (x *Product) Reset() {
	*x = Product{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_product_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Product) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Product) ProtoMessage() {}

func (x *Product) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_product_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Product.ProtoReflect.Descriptor instead.
func (*Product) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_product_proto_rawDescGZIP(), []int{0}
}

func (m *Product) GetExpiration() isProduct_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *Product) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*Product_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *Product) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*Product_Ttl); ok {
		return x.Ttl
	}
	return nil
}

func (x *Product) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Product) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Product) GetType() Product_Type {
	if x != nil {
		return x.Type
	}
	return Product_TYPE_UNSPECIFIED
}

func (x *Product) GetPrimaryProductId() string {
	if x != nil {
		return x.PrimaryProductId
	}
	return ""
}

func (x *Product) GetCollectionMemberIds() []string {
	if x != nil {
		return x.CollectionMemberIds
	}
	return nil
}

func (x *Product) GetGtin() string {
	if x != nil {
		return x.Gtin
	}
	return ""
}

func (x *Product) GetCategories() []string {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *Product) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Product) GetBrands() []string {
	if x != nil {
		return x.Brands
	}
	return nil
}

func (x *Product) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Product) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Product) GetAttributes() map[string]*CustomAttribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Product) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Product) GetPriceInfo() *PriceInfo {
	if x != nil {
		return x.PriceInfo
	}
	return nil
}

func (x *Product) GetRating() *Rating {
	if x != nil {
		return x.Rating
	}
	return nil
}

func (x *Product) GetAvailableTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AvailableTime
	}
	return nil
}

func (x *Product) GetAvailability() Product_Availability {
	if x != nil {
		return x.Availability
	}
	return Product_AVAILABILITY_UNSPECIFIED
}

func (x *Product) GetAvailableQuantity() *wrapperspb.Int32Value {
	if x != nil {
		return x.AvailableQuantity
	}
	return nil
}

func (x *Product) GetFulfillmentInfo() []*FulfillmentInfo {
	if x != nil {
		return x.FulfillmentInfo
	}
	return nil
}

func (x *Product) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Product) GetImages() []*Image {
	if x != nil {
		return x.Images
	}
	return nil
}

func (x *Product) GetAudience() *Audience {
	if x != nil {
		return x.Audience
	}
	return nil
}

func (x *Product) GetColorInfo() *ColorInfo {
	if x != nil {
		return x.ColorInfo
	}
	return nil
}

func (x *Product) GetSizes() []string {
	if x != nil {
		return x.Sizes
	}
	return nil
}

func (x *Product) GetMaterials() []string {
	if x != nil {
		return x.Materials
	}
	return nil
}

func (x *Product) GetPatterns() []string {
	if x != nil {
		return x.Patterns
	}
	return nil
}

func (x *Product) GetConditions() []string {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *Product) GetPromotions() []*Promotion {
	if x != nil {
		return x.Promotions
	}
	return nil
}

func (x *Product) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *Product) GetRetrievableFields() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.RetrievableFields
	}
	return nil
}

func (x *Product) GetVariants() []*Product {
	if x != nil {
		return x.Variants
	}
	return nil
}

type isProduct_Expiration interface {
	isProduct_Expiration()
}

type Product_ExpireTime struct {
	// The timestamp when this product becomes unavailable for
	// [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
	//
	// If it is set, the [Product][google.cloud.retail.v2alpha.Product] is not
	// available for
	// [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
	// after [expire_time][google.cloud.retail.v2alpha.Product.expire_time].
	// However, the product can still be retrieved by
	// [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct]
	// and
	// [ProductService.ListProducts][google.cloud.retail.v2alpha.ProductService.ListProducts].
	//
	// [expire_time][google.cloud.retail.v2alpha.Product.expire_time] must be
	// later than
	// [available_time][google.cloud.retail.v2alpha.Product.available_time] and
	// [publish_time][google.cloud.retail.v2alpha.Product.publish_time],
	// otherwise an INVALID_ARGUMENT error is thrown.
	//
	// Corresponding properties: Google Merchant Center property
	// [expiration_date](https://support.google.com/merchants/answer/6324499).
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type Product_Ttl struct {
	// Input only. The TTL (time to live) of the product.
	//
	// If it is set, it must be a non-negative value, and
	// [expire_time][google.cloud.retail.v2alpha.Product.expire_time] is set as
	// current timestamp plus [ttl][google.cloud.retail.v2alpha.Product.ttl].
	// The derived
	// [expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
	// returned in the output and [ttl][google.cloud.retail.v2alpha.Product.ttl]
	// is left blank when retrieving the
	// [Product][google.cloud.retail.v2alpha.Product].
	//
	// If it is set, the product is not available for
	// [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
	// after current timestamp plus
	// [ttl][google.cloud.retail.v2alpha.Product.ttl]. However, the product can
	// still be retrieved by
	// [ProductService.GetProduct][google.cloud.retail.v2alpha.ProductService.GetProduct]
	// and
	// [ProductService.ListProducts][google.cloud.retail.v2alpha.ProductService.ListProducts].
	Ttl *durationpb.Duration `protobuf:"bytes,17,opt,name=ttl,proto3,oneof"`
}

func (*Product_ExpireTime) isProduct_Expiration() {}

func (*Product_Ttl) isProduct_Expiration() {}

var File_google_cloud_retail_v2alpha_product_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2alpha_product_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1,
	0x10, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x03, 0x74, 0x74, 0x6c,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x42, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x2c, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a,
	0x15, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x64,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x67, 0x74, 0x69, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x54, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x70, 0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x3b, 0x0a, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x41, 0x0a,
	0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0d, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x55, 0x0a, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x4a, 0x0a, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x51, 0x75, 0x61, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x57, 0x0a, 0x10, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6c, 0x66,
	0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x66, 0x75, 0x6c,
	0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x3a,
	0x0a, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x61, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x45, 0x0a,
	0x0a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x18, 0x1a, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x05, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6d,
	0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x73, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x22, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x0c,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x21, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x12, 0x72,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x73, 0x18, 0x1f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x1a, 0x6b, 0x0a,
	0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x46, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d,
	0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x56, 0x41, 0x52, 0x49, 0x41, 0x4e, 0x54,
	0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x03, 0x22, 0x69, 0x0a, 0x0c, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x5f, 0x53, 0x54, 0x4f, 0x43, 0x4b, 0x10, 0x01, 0x12, 0x10,
	0x0a, 0x0c, 0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x54, 0x4f, 0x43, 0x4b, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x45, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x42, 0x41, 0x43, 0x4b, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x10, 0x04, 0x3a, 0x84, 0x01,
	0xea, 0x41, 0x80, 0x01, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x7d, 0x2f,
	0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0xc9, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0c, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41,
	0x49, 0x4c, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea,
	0x41, 0x6c, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x7d, 0x2f, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x7d, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2alpha_product_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2alpha_product_proto_rawDescData = file_google_cloud_retail_v2alpha_product_proto_rawDesc
)

func file_google_cloud_retail_v2alpha_product_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2alpha_product_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2alpha_product_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2alpha_product_proto_rawDescData)
	})
	return file_google_cloud_retail_v2alpha_product_proto_rawDescData
}

var file_google_cloud_retail_v2alpha_product_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_retail_v2alpha_product_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_retail_v2alpha_product_proto_goTypes = []interface{}{
	(Product_Type)(0),             // 0: google.cloud.retail.v2alpha.Product.Type
	(Product_Availability)(0),     // 1: google.cloud.retail.v2alpha.Product.Availability
	(*Product)(nil),               // 2: google.cloud.retail.v2alpha.Product
	nil,                           // 3: google.cloud.retail.v2alpha.Product.AttributesEntry
	(*timestamppb.Timestamp)(nil), // 4: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 5: google.protobuf.Duration
	(*PriceInfo)(nil),             // 6: google.cloud.retail.v2alpha.PriceInfo
	(*Rating)(nil),                // 7: google.cloud.retail.v2alpha.Rating
	(*wrapperspb.Int32Value)(nil), // 8: google.protobuf.Int32Value
	(*FulfillmentInfo)(nil),       // 9: google.cloud.retail.v2alpha.FulfillmentInfo
	(*Image)(nil),                 // 10: google.cloud.retail.v2alpha.Image
	(*Audience)(nil),              // 11: google.cloud.retail.v2alpha.Audience
	(*ColorInfo)(nil),             // 12: google.cloud.retail.v2alpha.ColorInfo
	(*Promotion)(nil),             // 13: google.cloud.retail.v2alpha.Promotion
	(*fieldmaskpb.FieldMask)(nil), // 14: google.protobuf.FieldMask
	(*CustomAttribute)(nil),       // 15: google.cloud.retail.v2alpha.CustomAttribute
}
var file_google_cloud_retail_v2alpha_product_proto_depIdxs = []int32{
	4,  // 0: google.cloud.retail.v2alpha.Product.expire_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.cloud.retail.v2alpha.Product.ttl:type_name -> google.protobuf.Duration
	0,  // 2: google.cloud.retail.v2alpha.Product.type:type_name -> google.cloud.retail.v2alpha.Product.Type
	3,  // 3: google.cloud.retail.v2alpha.Product.attributes:type_name -> google.cloud.retail.v2alpha.Product.AttributesEntry
	6,  // 4: google.cloud.retail.v2alpha.Product.price_info:type_name -> google.cloud.retail.v2alpha.PriceInfo
	7,  // 5: google.cloud.retail.v2alpha.Product.rating:type_name -> google.cloud.retail.v2alpha.Rating
	4,  // 6: google.cloud.retail.v2alpha.Product.available_time:type_name -> google.protobuf.Timestamp
	1,  // 7: google.cloud.retail.v2alpha.Product.availability:type_name -> google.cloud.retail.v2alpha.Product.Availability
	8,  // 8: google.cloud.retail.v2alpha.Product.available_quantity:type_name -> google.protobuf.Int32Value
	9,  // 9: google.cloud.retail.v2alpha.Product.fulfillment_info:type_name -> google.cloud.retail.v2alpha.FulfillmentInfo
	10, // 10: google.cloud.retail.v2alpha.Product.images:type_name -> google.cloud.retail.v2alpha.Image
	11, // 11: google.cloud.retail.v2alpha.Product.audience:type_name -> google.cloud.retail.v2alpha.Audience
	12, // 12: google.cloud.retail.v2alpha.Product.color_info:type_name -> google.cloud.retail.v2alpha.ColorInfo
	13, // 13: google.cloud.retail.v2alpha.Product.promotions:type_name -> google.cloud.retail.v2alpha.Promotion
	4,  // 14: google.cloud.retail.v2alpha.Product.publish_time:type_name -> google.protobuf.Timestamp
	14, // 15: google.cloud.retail.v2alpha.Product.retrievable_fields:type_name -> google.protobuf.FieldMask
	2,  // 16: google.cloud.retail.v2alpha.Product.variants:type_name -> google.cloud.retail.v2alpha.Product
	15, // 17: google.cloud.retail.v2alpha.Product.AttributesEntry.value:type_name -> google.cloud.retail.v2alpha.CustomAttribute
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2alpha_product_proto_init() }
func file_google_cloud_retail_v2alpha_product_proto_init() {
	if File_google_cloud_retail_v2alpha_product_proto != nil {
		return
	}
	file_google_cloud_retail_v2alpha_common_proto_init()
	file_google_cloud_retail_v2alpha_promotion_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2alpha_product_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Product); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_retail_v2alpha_product_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Product_ExpireTime)(nil),
		(*Product_Ttl)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2alpha_product_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2alpha_product_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2alpha_product_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2alpha_product_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2alpha_product_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2alpha_product_proto = out.File
	file_google_cloud_retail_v2alpha_product_proto_rawDesc = nil
	file_google_cloud_retail_v2alpha_product_proto_goTypes = nil
	file_google_cloud_retail_v2alpha_product_proto_depIdxs = nil
}
