// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/solar/v1/solar_service.proto

package solarpb

import (
	context "context"

	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Solar_FindClosestBuildingInsights_FullMethodName = "/google.maps.solar.v1.Solar/FindClosestBuildingInsights"
	Solar_GetDataLayers_FullMethodName               = "/google.maps.solar.v1.Solar/GetDataLayers"
	Solar_GetGeoTiff_FullMethodName                  = "/google.maps.solar.v1.Solar/GetGeoTiff"
)

// SolarClient is the client API for Solar service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SolarClient interface {
	// Locates the building whose centroid is closest to a query point. Returns an
	// error with code `NOT_FOUND` if there are no buildings within approximately
	// 50m of the query point.
	FindClosestBuildingInsights(ctx context.Context, in *FindClosestBuildingInsightsRequest, opts ...grpc.CallOption) (*BuildingInsights, error)
	// Gets solar information for a region surrounding a location.
	// Returns an error with code `NOT_FOUND` if the location is outside
	// the coverage area.
	GetDataLayers(ctx context.Context, in *GetDataLayersRequest, opts ...grpc.CallOption) (*DataLayers, error)
	// Returns an image by its ID.
	GetGeoTiff(ctx context.Context, in *GetGeoTiffRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
}

type solarClient struct {
	cc grpc.ClientConnInterface
}

func NewSolarClient(cc grpc.ClientConnInterface) SolarClient {
	return &solarClient{cc}
}

func (c *solarClient) FindClosestBuildingInsights(ctx context.Context, in *FindClosestBuildingInsightsRequest, opts ...grpc.CallOption) (*BuildingInsights, error) {
	out := new(BuildingInsights)
	err := c.cc.Invoke(ctx, Solar_FindClosestBuildingInsights_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *solarClient) GetDataLayers(ctx context.Context, in *GetDataLayersRequest, opts ...grpc.CallOption) (*DataLayers, error) {
	out := new(DataLayers)
	err := c.cc.Invoke(ctx, Solar_GetDataLayers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *solarClient) GetGeoTiff(ctx context.Context, in *GetGeoTiffRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, Solar_GetGeoTiff_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SolarServer is the server API for Solar service.
// All implementations should embed UnimplementedSolarServer
// for forward compatibility
type SolarServer interface {
	// Locates the building whose centroid is closest to a query point. Returns an
	// error with code `NOT_FOUND` if there are no buildings within approximately
	// 50m of the query point.
	FindClosestBuildingInsights(context.Context, *FindClosestBuildingInsightsRequest) (*BuildingInsights, error)
	// Gets solar information for a region surrounding a location.
	// Returns an error with code `NOT_FOUND` if the location is outside
	// the coverage area.
	GetDataLayers(context.Context, *GetDataLayersRequest) (*DataLayers, error)
	// Returns an image by its ID.
	GetGeoTiff(context.Context, *GetGeoTiffRequest) (*httpbody.HttpBody, error)
}

// UnimplementedSolarServer should be embedded to have forward compatible implementations.
type UnimplementedSolarServer struct {
}

func (UnimplementedSolarServer) FindClosestBuildingInsights(context.Context, *FindClosestBuildingInsightsRequest) (*BuildingInsights, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindClosestBuildingInsights not implemented")
}
func (UnimplementedSolarServer) GetDataLayers(context.Context, *GetDataLayersRequest) (*DataLayers, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataLayers not implemented")
}
func (UnimplementedSolarServer) GetGeoTiff(context.Context, *GetGeoTiffRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGeoTiff not implemented")
}

// UnsafeSolarServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SolarServer will
// result in compilation errors.
type UnsafeSolarServer interface {
	mustEmbedUnimplementedSolarServer()
}

func RegisterSolarServer(s grpc.ServiceRegistrar, srv SolarServer) {
	s.RegisterService(&Solar_ServiceDesc, srv)
}

func _Solar_FindClosestBuildingInsights_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindClosestBuildingInsightsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SolarServer).FindClosestBuildingInsights(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Solar_FindClosestBuildingInsights_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SolarServer).FindClosestBuildingInsights(ctx, req.(*FindClosestBuildingInsightsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Solar_GetDataLayers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataLayersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SolarServer).GetDataLayers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Solar_GetDataLayers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SolarServer).GetDataLayers(ctx, req.(*GetDataLayersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Solar_GetGeoTiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGeoTiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SolarServer).GetGeoTiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Solar_GetGeoTiff_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SolarServer).GetGeoTiff(ctx, req.(*GetGeoTiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Solar_ServiceDesc is the grpc.ServiceDesc for Solar service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Solar_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.solar.v1.Solar",
	HandlerType: (*SolarServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindClosestBuildingInsights",
			Handler:    _Solar_FindClosestBuildingInsights_Handler,
		},
		{
			MethodName: "GetDataLayers",
			Handler:    _Solar_GetDataLayers_Handler,
		},
		{
			MethodName: "GetGeoTiff",
			Handler:    _Solar_GetGeoTiff_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/solar/v1/solar_service.proto",
}
