// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plog

import (
	"go.opentelemetry.io/collector/pdata/internal"
)

// Logs is the top-level struct that is propagated through the logs pipeline.
// Use NewLogs to create new instance, zero-initialized instance is not valid for use.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewLogs function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Logs internal.LogsWrapper

func newLogs(orig *internal.ExportLogsServiceRequest, state *internal.State) Logs {
	return Logs(internal.NewLogsWrapper(orig, state))
}

// NewLogs creates a new empty Logs.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewLogs() Logs {
	return newLogs(internal.NewExportLogsServiceRequest(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Logs) MoveTo(dest Logs) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.getOrig() == dest.getOrig() {
		return
	}
	internal.DeleteExportLogsServiceRequest(dest.getOrig(), false)
	*dest.getOrig(), *ms.getOrig() = *ms.getOrig(), *dest.getOrig()
}

// ResourceLogs returns the ResourceLogs associated with this Logs.
func (ms Logs) ResourceLogs() ResourceLogsSlice {
	return newResourceLogsSlice(&ms.getOrig().ResourceLogs, ms.getState())
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Logs) CopyTo(dest Logs) {
	dest.getState().AssertMutable()
	internal.CopyExportLogsServiceRequest(dest.getOrig(), ms.getOrig())
}

func (ms Logs) getOrig() *internal.ExportLogsServiceRequest {
	return internal.GetLogsOrig(internal.LogsWrapper(ms))
}

func (ms Logs) getState() *internal.State {
	return internal.GetLogsState(internal.LogsWrapper(ms))
}
