package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserWorkspace invokes the ahas_openapi.GetUserWorkspace API synchronously
func (client *Client) GetUserWorkspace(request *GetUserWorkspaceRequest) (response *GetUserWorkspaceResponse, err error) {
	response = CreateGetUserWorkspaceResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserWorkspaceWithChan invokes the ahas_openapi.GetUserWorkspace API asynchronously
func (client *Client) GetUserWorkspaceWithChan(request *GetUserWorkspaceRequest) (<-chan *GetUserWorkspaceResponse, <-chan error) {
	responseChan := make(chan *GetUserWorkspaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserWorkspace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserWorkspaceWithCallback invokes the ahas_openapi.GetUserWorkspace API asynchronously
func (client *Client) GetUserWorkspaceWithCallback(request *GetUserWorkspaceRequest, callback func(response *GetUserWorkspaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserWorkspaceResponse
		var err error
		defer close(result)
		response, err = client.GetUserWorkspace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserWorkspaceRequest is the request struct for api GetUserWorkspace
type GetUserWorkspaceRequest struct {
	*requests.RpcRequest
	AhasRegionId string `position:"Query" name:"AhasRegionId"`
	Namespace    string `position:"Query" name:"Namespace"`
}

// GetUserWorkspaceResponse is the response struct for api GetUserWorkspace
type GetUserWorkspaceResponse struct {
	*responses.BaseResponse
	Message        string          `json:"Message" xml:"Message"`
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string          `json:"Code" xml:"Code"`
	Success        bool            `json:"Success" xml:"Success"`
	WorkspaceList  []WorkspaceInfo `json:"WorkspaceList" xml:"WorkspaceList"`
}

// CreateGetUserWorkspaceRequest creates a request to invoke GetUserWorkspace API
func CreateGetUserWorkspaceRequest() (request *GetUserWorkspaceRequest) {
	request = &GetUserWorkspaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "GetUserWorkspace", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserWorkspaceResponse creates a response to parse from GetUserWorkspace response
func CreateGetUserWorkspaceResponse() (response *GetUserWorkspaceResponse) {
	response = &GetUserWorkspaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
