package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRule invokes the airec.DescribeRule API synchronously
func (client *Client) DescribeRule(request *DescribeRuleRequest) (response *DescribeRuleResponse, err error) {
	response = CreateDescribeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRuleWithChan invokes the airec.DescribeRule API asynchronously
func (client *Client) DescribeRuleWithChan(request *DescribeRuleRequest) (<-chan *DescribeRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRuleWithCallback invokes the airec.DescribeRule API asynchronously
func (client *Client) DescribeRuleWithCallback(request *DescribeRuleRequest, callback func(response *DescribeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRuleRequest is the request struct for api DescribeRule
type DescribeRuleRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	RuleType   string `position:"Query" name:"ruleType"`
	SceneId    string `position:"Query" name:"sceneId"`
	RuleId     string `position:"Path" name:"ruleId"`
}

// DescribeRuleResponse is the response struct for api DescribeRule
type DescribeRuleResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"requestId" xml:"requestId"`
	Code      string               `json:"code" xml:"code"`
	Message   string               `json:"message" xml:"message"`
	Result    ResultInDescribeRule `json:"result" xml:"result"`
}

// CreateDescribeRuleRequest creates a request to invoke DescribeRule API
func CreateDescribeRuleRequest() (request *DescribeRuleRequest) {
	request = &DescribeRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DescribeRule", "/v2/openapi/instances/[instanceId]/rules/[ruleId]", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeRuleResponse creates a response to parse from DescribeRule response
func CreateDescribeRuleResponse() (response *DescribeRuleResponse) {
	response = &DescribeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
