package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAScripts invokes the alb.CreateAScripts API synchronously
func (client *Client) CreateAScripts(request *CreateAScriptsRequest) (response *CreateAScriptsResponse, err error) {
	response = CreateCreateAScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAScriptsWithChan invokes the alb.CreateAScripts API asynchronously
func (client *Client) CreateAScriptsWithChan(request *CreateAScriptsRequest) (<-chan *CreateAScriptsResponse, <-chan error) {
	responseChan := make(chan *CreateAScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAScriptsWithCallback invokes the alb.CreateAScripts API asynchronously
func (client *Client) CreateAScriptsWithCallback(request *CreateAScriptsRequest, callback func(response *CreateAScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAScriptsResponse
		var err error
		defer close(result)
		response, err = client.CreateAScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAScriptsRequest is the request struct for api CreateAScripts
type CreateAScriptsRequest struct {
	*requests.RpcRequest
	ClientToken string                    `position:"Query" name:"ClientToken"`
	ListenerId  string                    `position:"Query" name:"ListenerId"`
	AScripts    *[]CreateAScriptsAScripts `position:"Query" name:"AScripts"  type:"Repeated"`
	DryRun      requests.Boolean          `position:"Query" name:"DryRun"`
}

// CreateAScriptsAScripts is a repeated param struct in CreateAScriptsRequest
type CreateAScriptsAScripts struct {
	AScriptName         string                                     `name:"AScriptName"`
	ExtAttributeEnabled string                                     `name:"ExtAttributeEnabled"`
	Position            string                                     `name:"Position"`
	ScriptContent       string                                     `name:"ScriptContent"`
	ExtAttributes       *[]CreateAScriptsAScriptsExtAttributesItem `name:"ExtAttributes" type:"Repeated"`
	Enabled             string                                     `name:"Enabled"`
}

// CreateAScriptsAScriptsExtAttributesItem is a repeated param struct in CreateAScriptsRequest
type CreateAScriptsAScriptsExtAttributesItem struct {
	AttributeValue string `name:"AttributeValue"`
	AttributeKey   string `name:"AttributeKey"`
}

// CreateAScriptsResponse is the response struct for api CreateAScripts
type CreateAScriptsResponse struct {
	*responses.BaseResponse
	JobId      string      `json:"JobId" xml:"JobId"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	AScriptIds []AScriptId `json:"AScriptIds" xml:"AScriptIds"`
}

// CreateCreateAScriptsRequest creates a request to invoke CreateAScripts API
func CreateCreateAScriptsRequest() (request *CreateAScriptsRequest) {
	request = &CreateAScriptsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "CreateAScripts", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAScriptsResponse creates a response to parse from CreateAScripts response
func CreateCreateAScriptsResponse() (response *CreateAScriptsResponse) {
	response = &CreateAScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
