package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertUnbeianIpCheckType invokes the beian.InsertUnbeianIpCheckType API synchronously
func (client *Client) InsertUnbeianIpCheckType(request *InsertUnbeianIpCheckTypeRequest) (response *InsertUnbeianIpCheckTypeResponse, err error) {
	response = CreateInsertUnbeianIpCheckTypeResponse()
	err = client.DoAction(request, response)
	return
}

// InsertUnbeianIpCheckTypeWithChan invokes the beian.InsertUnbeianIpCheckType API asynchronously
func (client *Client) InsertUnbeianIpCheckTypeWithChan(request *InsertUnbeianIpCheckTypeRequest) (<-chan *InsertUnbeianIpCheckTypeResponse, <-chan error) {
	responseChan := make(chan *InsertUnbeianIpCheckTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertUnbeianIpCheckType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertUnbeianIpCheckTypeWithCallback invokes the beian.InsertUnbeianIpCheckType API asynchronously
func (client *Client) InsertUnbeianIpCheckTypeWithCallback(request *InsertUnbeianIpCheckTypeRequest, callback func(response *InsertUnbeianIpCheckTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertUnbeianIpCheckTypeResponse
		var err error
		defer close(result)
		response, err = client.InsertUnbeianIpCheckType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertUnbeianIpCheckTypeRequest is the request struct for api InsertUnbeianIpCheckType
type InsertUnbeianIpCheckTypeRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	Remark    string           `position:"Query" name:"Remark"`
	CheckType requests.Integer `position:"Query" name:"CheckType"`
	Caller    string           `position:"Query" name:"Caller"`
}

// InsertUnbeianIpCheckTypeResponse is the response struct for api InsertUnbeianIpCheckType
type InsertUnbeianIpCheckTypeResponse struct {
	*responses.BaseResponse
	ErrorMessage                string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId                   string                      `json:"RequestId" xml:"RequestId"`
	Success                     bool                        `json:"Success" xml:"Success"`
	ErrorCode                   int                         `json:"ErrorCode" xml:"ErrorCode"`
	HuntressIpCheckTypeResultDO HuntressIpCheckTypeResultDO `json:"HuntressIpCheckTypeResultDO" xml:"HuntressIpCheckTypeResultDO"`
}

// CreateInsertUnbeianIpCheckTypeRequest creates a request to invoke InsertUnbeianIpCheckType API
func CreateInsertUnbeianIpCheckTypeRequest() (request *InsertUnbeianIpCheckTypeRequest) {
	request = &InsertUnbeianIpCheckTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "InsertUnbeianIpCheckType", "", "")
	request.Method = requests.POST
	return
}

// CreateInsertUnbeianIpCheckTypeResponse creates a response to parse from InsertUnbeianIpCheckType response
func CreateInsertUnbeianIpCheckTypeResponse() (response *InsertUnbeianIpCheckTypeResponse) {
	response = &InsertUnbeianIpCheckTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
