package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBatchOperateCardsTasks invokes the cc5g.ListBatchOperateCardsTasks API synchronously
func (client *Client) ListBatchOperateCardsTasks(request *ListBatchOperateCardsTasksRequest) (response *ListBatchOperateCardsTasksResponse, err error) {
	response = CreateListBatchOperateCardsTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListBatchOperateCardsTasksWithChan invokes the cc5g.ListBatchOperateCardsTasks API asynchronously
func (client *Client) ListBatchOperateCardsTasksWithChan(request *ListBatchOperateCardsTasksRequest) (<-chan *ListBatchOperateCardsTasksResponse, <-chan error) {
	responseChan := make(chan *ListBatchOperateCardsTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBatchOperateCardsTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBatchOperateCardsTasksWithCallback invokes the cc5g.ListBatchOperateCardsTasks API asynchronously
func (client *Client) ListBatchOperateCardsTasksWithCallback(request *ListBatchOperateCardsTasksRequest, callback func(response *ListBatchOperateCardsTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBatchOperateCardsTasksResponse
		var err error
		defer close(result)
		response, err = client.ListBatchOperateCardsTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBatchOperateCardsTasksRequest is the request struct for api ListBatchOperateCardsTasks
type ListBatchOperateCardsTasksRequest struct {
	*requests.RpcRequest
	NextToken                string           `position:"Query" name:"NextToken"`
	BatchOperateCardsTaskIds *[]string        `position:"Query" name:"BatchOperateCardsTaskIds"  type:"Repeated"`
	Names                    *[]string        `position:"Query" name:"Names"  type:"Repeated"`
	MaxResults               requests.Integer `position:"Query" name:"MaxResults"`
	Statuses                 *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
}

// ListBatchOperateCardsTasksResponse is the response struct for api ListBatchOperateCardsTasks
type ListBatchOperateCardsTasksResponse struct {
	*responses.BaseResponse
	RequestId              string                  `json:"RequestId" xml:"RequestId"`
	NextToken              string                  `json:"NextToken" xml:"NextToken"`
	MaxResults             string                  `json:"MaxResults" xml:"MaxResults"`
	TotalCount             string                  `json:"TotalCount" xml:"TotalCount"`
	BatchOperateCardsTasks []BatchOperateCardsTask `json:"BatchOperateCardsTasks" xml:"BatchOperateCardsTasks"`
}

// CreateListBatchOperateCardsTasksRequest creates a request to invoke ListBatchOperateCardsTasks API
func CreateListBatchOperateCardsTasksRequest() (request *ListBatchOperateCardsTasksRequest) {
	request = &ListBatchOperateCardsTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListBatchOperateCardsTasks", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListBatchOperateCardsTasksResponse creates a response to parse from ListBatchOperateCardsTasks response
func CreateListBatchOperateCardsTasksResponse() (response *ListBatchOperateCardsTasksResponse) {
	response = &ListBatchOperateCardsTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
