package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCardDayUsages invokes the cc5g.ListCardDayUsages API synchronously
func (client *Client) ListCardDayUsages(request *ListCardDayUsagesRequest) (response *ListCardDayUsagesResponse, err error) {
	response = CreateListCardDayUsagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCardDayUsagesWithChan invokes the cc5g.ListCardDayUsages API asynchronously
func (client *Client) ListCardDayUsagesWithChan(request *ListCardDayUsagesRequest) (<-chan *ListCardDayUsagesResponse, <-chan error) {
	responseChan := make(chan *ListCardDayUsagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCardDayUsages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCardDayUsagesWithCallback invokes the cc5g.ListCardDayUsages API asynchronously
func (client *Client) ListCardDayUsagesWithCallback(request *ListCardDayUsagesRequest, callback func(response *ListCardDayUsagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCardDayUsagesResponse
		var err error
		defer close(result)
		response, err = client.ListCardDayUsages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCardDayUsagesRequest is the request struct for api ListCardDayUsages
type ListCardDayUsagesRequest struct {
	*requests.RpcRequest
	LatestMonthNum           requests.Integer `position:"Query" name:"LatestMonthNum"`
	Iccids                   *[]string        `position:"Query" name:"Iccids"  type:"Repeated"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// ListCardDayUsagesResponse is the response struct for api ListCardDayUsages
type ListCardDayUsagesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Cards     []Card `json:"Cards" xml:"Cards"`
}

// CreateListCardDayUsagesRequest creates a request to invoke ListCardDayUsages API
func CreateListCardDayUsagesRequest() (request *ListCardDayUsagesRequest) {
	request = &ListCardDayUsagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListCardDayUsages", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListCardDayUsagesResponse creates a response to parse from ListCardDayUsages response
func CreateListCardDayUsagesResponse() (response *ListCardDayUsagesResponse) {
	response = &ListCardDayUsagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
