package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDiagnoseInfoForSingleCard invokes the cc5g.ListDiagnoseInfoForSingleCard API synchronously
func (client *Client) ListDiagnoseInfoForSingleCard(request *ListDiagnoseInfoForSingleCardRequest) (response *ListDiagnoseInfoForSingleCardResponse, err error) {
	response = CreateListDiagnoseInfoForSingleCardResponse()
	err = client.DoAction(request, response)
	return
}

// ListDiagnoseInfoForSingleCardWithChan invokes the cc5g.ListDiagnoseInfoForSingleCard API asynchronously
func (client *Client) ListDiagnoseInfoForSingleCardWithChan(request *ListDiagnoseInfoForSingleCardRequest) (<-chan *ListDiagnoseInfoForSingleCardResponse, <-chan error) {
	responseChan := make(chan *ListDiagnoseInfoForSingleCardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDiagnoseInfoForSingleCard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDiagnoseInfoForSingleCardWithCallback invokes the cc5g.ListDiagnoseInfoForSingleCard API asynchronously
func (client *Client) ListDiagnoseInfoForSingleCardWithCallback(request *ListDiagnoseInfoForSingleCardRequest, callback func(response *ListDiagnoseInfoForSingleCardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDiagnoseInfoForSingleCardResponse
		var err error
		defer close(result)
		response, err = client.ListDiagnoseInfoForSingleCard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDiagnoseInfoForSingleCardRequest is the request struct for api ListDiagnoseInfoForSingleCard
type ListDiagnoseInfoForSingleCardRequest struct {
	*requests.RpcRequest
	Source                   string           `position:"Query" name:"Source"`
	NextToken                string           `position:"Query" name:"NextToken"`
	SourceType               string           `position:"Query" name:"SourceType"`
	RegionNo                 string           `position:"Query" name:"RegionNo"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	MaxResults               requests.Integer `position:"Query" name:"MaxResults"`
	Status                   string           `position:"Query" name:"Status"`
}

// ListDiagnoseInfoForSingleCardResponse is the response struct for api ListDiagnoseInfoForSingleCard
type ListDiagnoseInfoForSingleCardResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	NextToken    string             `json:"NextToken" xml:"NextToken"`
	MaxResults   int64              `json:"MaxResults" xml:"MaxResults"`
	TotalCount   int64              `json:"TotalCount" xml:"TotalCount"`
	DiagnoseInfo []DiagnoseInfoItem `json:"DiagnoseInfo" xml:"DiagnoseInfo"`
}

// CreateListDiagnoseInfoForSingleCardRequest creates a request to invoke ListDiagnoseInfoForSingleCard API
func CreateListDiagnoseInfoForSingleCardRequest() (request *ListDiagnoseInfoForSingleCardRequest) {
	request = &ListDiagnoseInfoForSingleCardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListDiagnoseInfoForSingleCard", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDiagnoseInfoForSingleCardResponse creates a response to parse from ListDiagnoseInfoForSingleCard response
func CreateListDiagnoseInfoForSingleCardResponse() (response *ListDiagnoseInfoForSingleCardResponse) {
	response = &ListDiagnoseInfoForSingleCardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
