package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportDoNotCallNumbers invokes the ccc.ExportDoNotCallNumbers API synchronously
func (client *Client) ExportDoNotCallNumbers(request *ExportDoNotCallNumbersRequest) (response *ExportDoNotCallNumbersResponse, err error) {
	response = CreateExportDoNotCallNumbersResponse()
	err = client.DoAction(request, response)
	return
}

// ExportDoNotCallNumbersWithChan invokes the ccc.ExportDoNotCallNumbers API asynchronously
func (client *Client) ExportDoNotCallNumbersWithChan(request *ExportDoNotCallNumbersRequest) (<-chan *ExportDoNotCallNumbersResponse, <-chan error) {
	responseChan := make(chan *ExportDoNotCallNumbersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportDoNotCallNumbers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportDoNotCallNumbersWithCallback invokes the ccc.ExportDoNotCallNumbers API asynchronously
func (client *Client) ExportDoNotCallNumbersWithCallback(request *ExportDoNotCallNumbersRequest, callback func(response *ExportDoNotCallNumbersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportDoNotCallNumbersResponse
		var err error
		defer close(result)
		response, err = client.ExportDoNotCallNumbers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportDoNotCallNumbersRequest is the request struct for api ExportDoNotCallNumbers
type ExportDoNotCallNumbersRequest struct {
	*requests.RpcRequest
	SearchPattern string `position:"Query" name:"SearchPattern"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	Scope         string `position:"Query" name:"Scope"`
}

// ExportDoNotCallNumbersResponse is the response struct for api ExportDoNotCallNumbers
type ExportDoNotCallNumbersResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateExportDoNotCallNumbersRequest creates a request to invoke ExportDoNotCallNumbers API
func CreateExportDoNotCallNumbersRequest() (request *ExportDoNotCallNumbersRequest) {
	request = &ExportDoNotCallNumbersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ExportDoNotCallNumbers", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportDoNotCallNumbersResponse creates a response to parse from ExportDoNotCallNumbers response
func CreateExportDoNotCallNumbersResponse() (response *ExportDoNotCallNumbersResponse) {
	response = &ExportDoNotCallNumbersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
