package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePluginSchemas invokes the cloudapi.DescribePluginSchemas API synchronously
func (client *Client) DescribePluginSchemas(request *DescribePluginSchemasRequest) (response *DescribePluginSchemasResponse, err error) {
	response = CreateDescribePluginSchemasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePluginSchemasWithChan invokes the cloudapi.DescribePluginSchemas API asynchronously
func (client *Client) DescribePluginSchemasWithChan(request *DescribePluginSchemasRequest) (<-chan *DescribePluginSchemasResponse, <-chan error) {
	responseChan := make(chan *DescribePluginSchemasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePluginSchemas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePluginSchemasWithCallback invokes the cloudapi.DescribePluginSchemas API asynchronously
func (client *Client) DescribePluginSchemasWithCallback(request *DescribePluginSchemasRequest, callback func(response *DescribePluginSchemasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePluginSchemasResponse
		var err error
		defer close(result)
		response, err = client.DescribePluginSchemas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePluginSchemasRequest is the request struct for api DescribePluginSchemas
type DescribePluginSchemasRequest struct {
	*requests.RpcRequest
	Language      string `position:"Query" name:"Language"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribePluginSchemasResponse is the response struct for api DescribePluginSchemas
type DescribePluginSchemasResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	PluginSchemas PluginSchemas `json:"PluginSchemas" xml:"PluginSchemas"`
}

// CreateDescribePluginSchemasRequest creates a request to invoke DescribePluginSchemas API
func CreateDescribePluginSchemasRequest() (request *DescribePluginSchemasRequest) {
	request = &DescribePluginSchemasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribePluginSchemas", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePluginSchemasResponse creates a response to parse from DescribePluginSchemas response
func CreateDescribePluginSchemasResponse() (response *DescribePluginSchemasResponse) {
	response = &DescribePluginSchemasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
