package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBackendModel invokes the cloudapi.ModifyBackendModel API synchronously
func (client *Client) ModifyBackendModel(request *ModifyBackendModelRequest) (response *ModifyBackendModelResponse, err error) {
	response = CreateModifyBackendModelResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBackendModelWithChan invokes the cloudapi.ModifyBackendModel API asynchronously
func (client *Client) ModifyBackendModelWithChan(request *ModifyBackendModelRequest) (<-chan *ModifyBackendModelResponse, <-chan error) {
	responseChan := make(chan *ModifyBackendModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBackendModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBackendModelWithCallback invokes the cloudapi.ModifyBackendModel API asynchronously
func (client *Client) ModifyBackendModelWithCallback(request *ModifyBackendModelRequest, callback func(response *ModifyBackendModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBackendModelResponse
		var err error
		defer close(result)
		response, err = client.ModifyBackendModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBackendModelRequest is the request struct for api ModifyBackendModel
type ModifyBackendModelRequest struct {
	*requests.RpcRequest
	StageName        string `position:"Query" name:"StageName"`
	BackendModelData string `position:"Query" name:"BackendModelData"`
	BackendId        string `position:"Query" name:"BackendId"`
	Description      string `position:"Query" name:"Description"`
	SecurityToken    string `position:"Query" name:"SecurityToken"`
	BackendType      string `position:"Query" name:"BackendType"`
	BackendModelId   string `position:"Query" name:"BackendModelId"`
}

// ModifyBackendModelResponse is the response struct for api ModifyBackendModel
type ModifyBackendModelResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	OperationId string `json:"OperationId" xml:"OperationId"`
}

// CreateModifyBackendModelRequest creates a request to invoke ModifyBackendModel API
func CreateModifyBackendModelRequest() (request *ModifyBackendModelRequest) {
	request = &ModifyBackendModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyBackendModel", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyBackendModelResponse creates a response to parse from ModifyBackendModel response
func CreateModifyBackendModelResponse() (response *ModifyBackendModelResponse) {
	response = &ModifyBackendModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
