package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveApisAuthorities invokes the cloudapi.RemoveApisAuthorities API synchronously
func (client *Client) RemoveApisAuthorities(request *RemoveApisAuthoritiesRequest) (response *RemoveApisAuthoritiesResponse, err error) {
	response = CreateRemoveApisAuthoritiesResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveApisAuthoritiesWithChan invokes the cloudapi.RemoveApisAuthorities API asynchronously
func (client *Client) RemoveApisAuthoritiesWithChan(request *RemoveApisAuthoritiesRequest) (<-chan *RemoveApisAuthoritiesResponse, <-chan error) {
	responseChan := make(chan *RemoveApisAuthoritiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveApisAuthorities(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveApisAuthoritiesWithCallback invokes the cloudapi.RemoveApisAuthorities API asynchronously
func (client *Client) RemoveApisAuthoritiesWithCallback(request *RemoveApisAuthoritiesRequest, callback func(response *RemoveApisAuthoritiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveApisAuthoritiesResponse
		var err error
		defer close(result)
		response, err = client.RemoveApisAuthorities(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveApisAuthoritiesRequest is the request struct for api RemoveApisAuthorities
type RemoveApisAuthoritiesRequest struct {
	*requests.RpcRequest
	StageName     string           `position:"Query" name:"StageName"`
	GroupId       string           `position:"Query" name:"GroupId"`
	Description   string           `position:"Query" name:"Description"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
	ApiIds        string           `position:"Query" name:"ApiIds"`
}

// RemoveApisAuthoritiesResponse is the response struct for api RemoveApisAuthorities
type RemoveApisAuthoritiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveApisAuthoritiesRequest creates a request to invoke RemoveApisAuthorities API
func CreateRemoveApisAuthoritiesRequest() (request *RemoveApisAuthoritiesRequest) {
	request = &RemoveApisAuthoritiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "RemoveApisAuthorities", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveApisAuthoritiesResponse creates a response to parse from RemoveApisAuthorities response
func CreateRemoveApisAuthoritiesResponse() (response *RemoveApisAuthoritiesResponse) {
	response = &RemoveApisAuthoritiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
