package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDynamicTagGroup invokes the cms.DeleteDynamicTagGroup API synchronously
func (client *Client) DeleteDynamicTagGroup(request *DeleteDynamicTagGroupRequest) (response *DeleteDynamicTagGroupResponse, err error) {
	response = CreateDeleteDynamicTagGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDynamicTagGroupWithChan invokes the cms.DeleteDynamicTagGroup API asynchronously
func (client *Client) DeleteDynamicTagGroupWithChan(request *DeleteDynamicTagGroupRequest) (<-chan *DeleteDynamicTagGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteDynamicTagGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDynamicTagGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDynamicTagGroupWithCallback invokes the cms.DeleteDynamicTagGroup API asynchronously
func (client *Client) DeleteDynamicTagGroupWithCallback(request *DeleteDynamicTagGroupRequest, callback func(response *DeleteDynamicTagGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDynamicTagGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteDynamicTagGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDynamicTagGroupRequest is the request struct for api DeleteDynamicTagGroup
type DeleteDynamicTagGroupRequest struct {
	*requests.RpcRequest
	DynamicTagRuleId string `position:"Query" name:"DynamicTagRuleId"`
}

// DeleteDynamicTagGroupResponse is the response struct for api DeleteDynamicTagGroup
type DeleteDynamicTagGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteDynamicTagGroupRequest creates a request to invoke DeleteDynamicTagGroup API
func CreateDeleteDynamicTagGroupRequest() (request *DeleteDynamicTagGroupRequest) {
	request = &DeleteDynamicTagGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteDynamicTagGroup", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDynamicTagGroupResponse creates a response to parse from DeleteDynamicTagGroup response
func CreateDeleteDynamicTagGroupResponse() (response *DeleteDynamicTagGroupResponse) {
	response = &DeleteDynamicTagGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
