package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyServiceInstanceResources invokes the computenestsupplier.ModifyServiceInstanceResources API synchronously
func (client *Client) ModifyServiceInstanceResources(request *ModifyServiceInstanceResourcesRequest) (response *ModifyServiceInstanceResourcesResponse, err error) {
	response = CreateModifyServiceInstanceResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyServiceInstanceResourcesWithChan invokes the computenestsupplier.ModifyServiceInstanceResources API asynchronously
func (client *Client) ModifyServiceInstanceResourcesWithChan(request *ModifyServiceInstanceResourcesRequest) (<-chan *ModifyServiceInstanceResourcesResponse, <-chan error) {
	responseChan := make(chan *ModifyServiceInstanceResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyServiceInstanceResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyServiceInstanceResourcesWithCallback invokes the computenestsupplier.ModifyServiceInstanceResources API asynchronously
func (client *Client) ModifyServiceInstanceResourcesWithCallback(request *ModifyServiceInstanceResourcesRequest, callback func(response *ModifyServiceInstanceResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyServiceInstanceResourcesResponse
		var err error
		defer close(result)
		response, err = client.ModifyServiceInstanceResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyServiceInstanceResourcesRequest is the request struct for api ModifyServiceInstanceResources
type ModifyServiceInstanceResourcesRequest struct {
	*requests.RpcRequest
	ServiceInstanceResourcesAction string `position:"Query" name:"ServiceInstanceResourcesAction"`
	ServiceInstanceId              string `position:"Query" name:"ServiceInstanceId"`
	Resources                      string `position:"Query" name:"Resources"`
}

// ModifyServiceInstanceResourcesResponse is the response struct for api ModifyServiceInstanceResources
type ModifyServiceInstanceResourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyServiceInstanceResourcesRequest creates a request to invoke ModifyServiceInstanceResources API
func CreateModifyServiceInstanceResourcesRequest() (request *ModifyServiceInstanceResourcesRequest) {
	request = &ModifyServiceInstanceResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "ModifyServiceInstanceResources", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyServiceInstanceResourcesResponse creates a response to parse from ModifyServiceInstanceResources response
func CreateModifyServiceInstanceResourcesResponse() (response *ModifyServiceInstanceResourcesResponse) {
	response = &ModifyServiceInstanceResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
