package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigDeliveryChannels invokes the config.ListConfigDeliveryChannels API synchronously
func (client *Client) ListConfigDeliveryChannels(request *ListConfigDeliveryChannelsRequest) (response *ListConfigDeliveryChannelsResponse, err error) {
	response = CreateListConfigDeliveryChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigDeliveryChannelsWithChan invokes the config.ListConfigDeliveryChannels API asynchronously
func (client *Client) ListConfigDeliveryChannelsWithChan(request *ListConfigDeliveryChannelsRequest) (<-chan *ListConfigDeliveryChannelsResponse, <-chan error) {
	responseChan := make(chan *ListConfigDeliveryChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigDeliveryChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigDeliveryChannelsWithCallback invokes the config.ListConfigDeliveryChannels API asynchronously
func (client *Client) ListConfigDeliveryChannelsWithCallback(request *ListConfigDeliveryChannelsRequest, callback func(response *ListConfigDeliveryChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigDeliveryChannelsResponse
		var err error
		defer close(result)
		response, err = client.ListConfigDeliveryChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigDeliveryChannelsRequest is the request struct for api ListConfigDeliveryChannels
type ListConfigDeliveryChannelsRequest struct {
	*requests.RpcRequest
	DeliveryChannelIds string `position:"Query" name:"DeliveryChannelIds"`
}

// ListConfigDeliveryChannelsResponse is the response struct for api ListConfigDeliveryChannels
type ListConfigDeliveryChannelsResponse struct {
	*responses.BaseResponse
	RequestId        string                                        `json:"RequestId" xml:"RequestId"`
	DeliveryChannels []DeliveryChannelInListConfigDeliveryChannels `json:"DeliveryChannels" xml:"DeliveryChannels"`
}

// CreateListConfigDeliveryChannelsRequest creates a request to invoke ListConfigDeliveryChannels API
func CreateListConfigDeliveryChannelsRequest() (request *ListConfigDeliveryChannelsRequest) {
	request = &ListConfigDeliveryChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListConfigDeliveryChannels", "", "")
	request.Method = requests.POST
	return
}

// CreateListConfigDeliveryChannelsResponse creates a response to parse from ListConfigDeliveryChannels response
func CreateListConfigDeliveryChannelsResponse() (response *ListConfigDeliveryChannelsResponse) {
	response = &ListConfigDeliveryChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
