package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceVpcEndpoint invokes the cr.GetInstanceVpcEndpoint API synchronously
// api document: https://help.aliyun.com/api/cr/getinstancevpcendpoint.html
func (client *Client) GetInstanceVpcEndpoint(request *GetInstanceVpcEndpointRequest) (response *GetInstanceVpcEndpointResponse, err error) {
	response = CreateGetInstanceVpcEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceVpcEndpointWithChan invokes the cr.GetInstanceVpcEndpoint API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstancevpcendpoint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceVpcEndpointWithChan(request *GetInstanceVpcEndpointRequest) (<-chan *GetInstanceVpcEndpointResponse, <-chan error) {
	responseChan := make(chan *GetInstanceVpcEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceVpcEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceVpcEndpointWithCallback invokes the cr.GetInstanceVpcEndpoint API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstancevpcendpoint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceVpcEndpointWithCallback(request *GetInstanceVpcEndpointRequest, callback func(response *GetInstanceVpcEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceVpcEndpointResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceVpcEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceVpcEndpointRequest is the request struct for api GetInstanceVpcEndpoint
type GetInstanceVpcEndpointRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ModuleName string `position:"Query" name:"ModuleName"`
}

// GetInstanceVpcEndpointResponse is the response struct for api GetInstanceVpcEndpoint
type GetInstanceVpcEndpointResponse struct {
	*responses.BaseResponse
	GetInstanceVpcEndpointIsSuccess bool             `json:"IsSuccess" xml:"IsSuccess"`
	Code                            string           `json:"Code" xml:"Code"`
	RequestId                       string           `json:"RequestId" xml:"RequestId"`
	Enable                          bool             `json:"Enable" xml:"Enable"`
	Domains                         []string         `json:"Domains" xml:"Domains"`
	LinkedVpcs                      []LinkedVpcsItem `json:"LinkedVpcs" xml:"LinkedVpcs"`
}

// CreateGetInstanceVpcEndpointRequest creates a request to invoke GetInstanceVpcEndpoint API
func CreateGetInstanceVpcEndpointRequest() (request *GetInstanceVpcEndpointRequest) {
	request = &GetInstanceVpcEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetInstanceVpcEndpoint", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceVpcEndpointResponse creates a response to parse from GetInstanceVpcEndpoint response
func CreateGetInstanceVpcEndpointResponse() (response *GetInstanceVpcEndpointResponse) {
	response = &GetInstanceVpcEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
