package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnTagResources invokes the dcdn.DescribeDcdnTagResources API synchronously
func (client *Client) DescribeDcdnTagResources(request *DescribeDcdnTagResourcesRequest) (response *DescribeDcdnTagResourcesResponse, err error) {
	response = CreateDescribeDcdnTagResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnTagResourcesWithChan invokes the dcdn.DescribeDcdnTagResources API asynchronously
func (client *Client) DescribeDcdnTagResourcesWithChan(request *DescribeDcdnTagResourcesRequest) (<-chan *DescribeDcdnTagResourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnTagResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnTagResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnTagResourcesWithCallback invokes the dcdn.DescribeDcdnTagResources API asynchronously
func (client *Client) DescribeDcdnTagResourcesWithCallback(request *DescribeDcdnTagResourcesRequest, callback func(response *DescribeDcdnTagResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnTagResourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnTagResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnTagResourcesRequest is the request struct for api DescribeDcdnTagResources
type DescribeDcdnTagResourcesRequest struct {
	*requests.RpcRequest
	ResourceId   *[]string                      `position:"Query" name:"ResourceId"  type:"Repeated"`
	Scope        string                         `position:"Query" name:"Scope"`
	Tag          *[]DescribeDcdnTagResourcesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceType string                         `position:"Query" name:"ResourceType"`
}

// DescribeDcdnTagResourcesTag is a repeated param struct in DescribeDcdnTagResourcesRequest
type DescribeDcdnTagResourcesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeDcdnTagResourcesResponse is the response struct for api DescribeDcdnTagResources
type DescribeDcdnTagResourcesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	TagResources []TagResource `json:"TagResources" xml:"TagResources"`
}

// CreateDescribeDcdnTagResourcesRequest creates a request to invoke DescribeDcdnTagResources API
func CreateDescribeDcdnTagResourcesRequest() (request *DescribeDcdnTagResourcesRequest) {
	request = &DescribeDcdnTagResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnTagResources", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnTagResourcesResponse creates a response to parse from DescribeDcdnTagResources response
func CreateDescribeDcdnTagResourcesResponse() (response *DescribeDcdnTagResourcesResponse) {
	response = &DescribeDcdnTagResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
