package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshErObjectCaches invokes the dcdn.RefreshErObjectCaches API synchronously
func (client *Client) RefreshErObjectCaches(request *RefreshErObjectCachesRequest) (response *RefreshErObjectCachesResponse, err error) {
	response = CreateRefreshErObjectCachesResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshErObjectCachesWithChan invokes the dcdn.RefreshErObjectCaches API asynchronously
func (client *Client) RefreshErObjectCachesWithChan(request *RefreshErObjectCachesRequest) (<-chan *RefreshErObjectCachesResponse, <-chan error) {
	responseChan := make(chan *RefreshErObjectCachesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshErObjectCaches(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshErObjectCachesWithCallback invokes the dcdn.RefreshErObjectCaches API asynchronously
func (client *Client) RefreshErObjectCachesWithCallback(request *RefreshErObjectCachesRequest, callback func(response *RefreshErObjectCachesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshErObjectCachesResponse
		var err error
		defer close(result)
		response, err = client.RefreshErObjectCaches(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshErObjectCachesRequest is the request struct for api RefreshErObjectCaches
type RefreshErObjectCachesRequest struct {
	*requests.RpcRequest
	MergeDomainName string           `position:"Query" name:"MergeDomainName"`
	ObjectPath      string           `position:"Query" name:"ObjectPath"`
	Force           requests.Boolean `position:"Query" name:"Force"`
	ObjectType      string           `position:"Query" name:"ObjectType"`
	RoutineId       string           `position:"Query" name:"RoutineId"`
}

// RefreshErObjectCachesResponse is the response struct for api RefreshErObjectCaches
type RefreshErObjectCachesResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	RefreshTaskId string `json:"RefreshTaskId" xml:"RefreshTaskId"`
}

// CreateRefreshErObjectCachesRequest creates a request to invoke RefreshErObjectCaches API
func CreateRefreshErObjectCachesRequest() (request *RefreshErObjectCachesRequest) {
	request = &RefreshErObjectCachesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "RefreshErObjectCaches", "", "")
	request.Method = requests.POST
	return
}

// CreateRefreshErObjectCachesResponse creates a response to parse from RefreshErObjectCaches response
func CreateRefreshErObjectCachesResponse() (response *RefreshErObjectCachesResponse) {
	response = &RefreshErObjectCachesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
