package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigNetworkRegionBlock invokes the ddoscoo.ConfigNetworkRegionBlock API synchronously
func (client *Client) ConfigNetworkRegionBlock(request *ConfigNetworkRegionBlockRequest) (response *ConfigNetworkRegionBlockResponse, err error) {
	response = CreateConfigNetworkRegionBlockResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigNetworkRegionBlockWithChan invokes the ddoscoo.ConfigNetworkRegionBlock API asynchronously
func (client *Client) ConfigNetworkRegionBlockWithChan(request *ConfigNetworkRegionBlockRequest) (<-chan *ConfigNetworkRegionBlockResponse, <-chan error) {
	responseChan := make(chan *ConfigNetworkRegionBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigNetworkRegionBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigNetworkRegionBlockWithCallback invokes the ddoscoo.ConfigNetworkRegionBlock API asynchronously
func (client *Client) ConfigNetworkRegionBlockWithCallback(request *ConfigNetworkRegionBlockRequest, callback func(response *ConfigNetworkRegionBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigNetworkRegionBlockResponse
		var err error
		defer close(result)
		response, err = client.ConfigNetworkRegionBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigNetworkRegionBlockRequest is the request struct for api ConfigNetworkRegionBlock
type ConfigNetworkRegionBlockRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Config     string `position:"Query" name:"Config"`
}

// ConfigNetworkRegionBlockResponse is the response struct for api ConfigNetworkRegionBlock
type ConfigNetworkRegionBlockResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigNetworkRegionBlockRequest creates a request to invoke ConfigNetworkRegionBlock API
func CreateConfigNetworkRegionBlockRequest() (request *ConfigNetworkRegionBlockRequest) {
	request = &ConfigNetworkRegionBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ConfigNetworkRegionBlock", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfigNetworkRegionBlockResponse creates a response to parse from ConfigNetworkRegionBlock response
func CreateConfigNetworkRegionBlockResponse() (response *ConfigNetworkRegionBlockResponse) {
	response = &ConfigNetworkRegionBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
