package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebCustomPorts invokes the ddoscoo.DescribeWebCustomPorts API synchronously
func (client *Client) DescribeWebCustomPorts(request *DescribeWebCustomPortsRequest) (response *DescribeWebCustomPortsResponse, err error) {
	response = CreateDescribeWebCustomPortsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebCustomPortsWithChan invokes the ddoscoo.DescribeWebCustomPorts API asynchronously
func (client *Client) DescribeWebCustomPortsWithChan(request *DescribeWebCustomPortsRequest) (<-chan *DescribeWebCustomPortsResponse, <-chan error) {
	responseChan := make(chan *DescribeWebCustomPortsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebCustomPorts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebCustomPortsWithCallback invokes the ddoscoo.DescribeWebCustomPorts API asynchronously
func (client *Client) DescribeWebCustomPortsWithCallback(request *DescribeWebCustomPortsRequest, callback func(response *DescribeWebCustomPortsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebCustomPortsResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebCustomPorts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebCustomPortsRequest is the request struct for api DescribeWebCustomPorts
type DescribeWebCustomPortsRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Lang            string `position:"Query" name:"Lang"`
}

// DescribeWebCustomPortsResponse is the response struct for api DescribeWebCustomPorts
type DescribeWebCustomPortsResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	WebCustomPorts []WebCustomPort `json:"WebCustomPorts" xml:"WebCustomPorts"`
}

// CreateDescribeWebCustomPortsRequest creates a request to invoke DescribeWebCustomPorts API
func CreateDescribeWebCustomPortsRequest() (request *DescribeWebCustomPortsRequest) {
	request = &DescribeWebCustomPortsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeWebCustomPorts", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWebCustomPortsResponse creates a response to parse from DescribeWebCustomPorts response
func CreateDescribeWebCustomPortsResponse() (response *DescribeWebCustomPortsResponse) {
	response = &DescribeWebCustomPortsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
