package documentautoml

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictModel invokes the documentautoml.PredictModel API synchronously
func (client *Client) PredictModel(request *PredictModelRequest) (response *PredictModelResponse, err error) {
	response = CreatePredictModelResponse()
	err = client.DoAction(request, response)
	return
}

// PredictModelWithChan invokes the documentautoml.PredictModel API asynchronously
func (client *Client) PredictModelWithChan(request *PredictModelRequest) (<-chan *PredictModelResponse, <-chan error) {
	responseChan := make(chan *PredictModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictModelWithCallback invokes the documentautoml.PredictModel API asynchronously
func (client *Client) PredictModelWithCallback(request *PredictModelRequest, callback func(response *PredictModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictModelResponse
		var err error
		defer close(result)
		response, err = client.PredictModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictModelRequest is the request struct for api PredictModel
type PredictModelRequest struct {
	*requests.RpcRequest
	Body         string           `position:"Body" name:"body"`
	Content      string           `position:"Query" name:"Content"`
	BinaryToText requests.Boolean `position:"Query" name:"BinaryToText"`
	Product      string           `position:"Query" name:"Product"`
	ModelId      requests.Integer `position:"Query" name:"ModelId"`
	ModelVersion string           `position:"Query" name:"ModelVersion"`
}

// PredictModelResponse is the response struct for api PredictModel
type PredictModelResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      int                    `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
}

// CreatePredictModelRequest creates a request to invoke PredictModel API
func CreatePredictModelRequest() (request *PredictModelRequest) {
	request = &PredictModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("documentAutoml", "2022-12-29", "PredictModel", "documentAutoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePredictModelResponse creates a response to parse from PredictModel response
func CreatePredictModelResponse() (response *PredictModelResponse) {
	response = &PredictModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
